<?php
// Set page title
$page_title = "Data QR Stock Management";

// Include header
include '../template_it/header.php';

// Get filters from URL
$buyer_filter = isset($_GET['buyer_id']) ? (int)$_GET['buyer_id'] : 0;
$search = isset($_GET['search']) ? $conn->real_escape_string($_GET['search']) : '';

// Query untuk mengambil data buyers untuk filter dropdown
$query_buyers = "SELECT id, nama_buyer, kode_buyer FROM buyers ORDER BY nama_buyer ASC";
$result_buyers = $conn->query($query_buyers);
?>

<!-- Data QR Stock Content -->
<div class="container mx-auto">
    <!-- Page Header -->
    <div class="bg-white rounded-lg shadow-md p-6 mb-6">
        <div class="flex items-center justify-between">
            <div>
                <h2 class="text-2xl font-bold text-gray-800">
                    <i class="fas fa-qrcode text-purple-600 mr-2"></i>
                    Data QR Stock Management
                </h2>
                <p class="text-gray-600 mt-1">Generate QR Code untuk Color Stock Items</p>
            </div>
        </div>
    </div>

    <!-- Filter Section -->
    <div class="bg-white rounded-lg shadow-md p-6 mb-6">
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <!-- Filter Buyer -->
            <div>
                <label class="block text-gray-700 font-semibold mb-2">
                    <i class="fas fa-building mr-1"></i> Filter Buyer:
                </label>
                <select id="buyerFilter" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" onchange="applyFilter()">
                    <option value="0">-- Semua Buyer --</option>
                    <?php while($buyer = $result_buyers->fetch_assoc()): ?>
                        <option value="<?php echo $buyer['id']; ?>" <?php echo ($buyer_filter == $buyer['id']) ? 'selected' : ''; ?>>
                            <?php echo htmlspecialchars($buyer['nama_buyer']) . ' (' . htmlspecialchars($buyer['kode_buyer']) . ')'; ?>
                        </option>
                    <?php endwhile; ?>
                </select>
            </div>

            <!-- Search -->
            <div>
                <label class="block text-gray-700 font-semibold mb-2">
                    <i class="fas fa-search mr-1"></i> Search:
                </label>
                <input 
                    type="text" 
                    id="searchInput" 
                    value="<?php echo htmlspecialchars($search); ?>"
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500"
                    placeholder="Cari code color atau nama..."
                    onkeypress="if(event.key === 'Enter') applyFilter()">
            </div>
        </div>

        <div class="flex gap-2 mt-4">
            <button onclick="applyFilter()" class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-2 rounded-lg transition-colors">
                <i class="fas fa-filter mr-2"></i> Filter
            </button>
            <?php if($buyer_filter > 0 || !empty($search)): ?>
                <button onclick="resetFilter()" class="bg-red-500 hover:bg-red-600 text-white px-6 py-2 rounded-lg transition-colors">
                    <i class="fas fa-redo mr-2"></i> Reset
                </button>
            <?php endif; ?>
        </div>
    </div>

    <!-- Master Color List -->
    <div class="bg-white rounded-lg shadow-md p-6">
        <h3 class="text-xl font-bold text-gray-800 mb-4 flex items-center">
            <i class="fas fa-palette text-purple-600 mr-2"></i>
            Data Master Warna
        </h3>

        <?php
        // Query untuk mengambil master color dengan stock items
        $query_master = "
            SELECT 
                mc.id as master_color_id,
                mc.code_color as master_code,
                mc.color_name,
                mc.lemari,
                mc.lemari_number,
                b.nama_buyer,
                b.kode_buyer,
                c.nama_collection,
                COUNT(csi.id) as total_stock_items
            FROM master_color mc
            LEFT JOIN buyers b ON mc.buyer_id = b.id
            LEFT JOIN collections c ON mc.collection_id = c.id
            LEFT JOIN color_stock_items csi ON mc.id = csi.master_color_id
            WHERE 1=1
        ";
        
        if ($buyer_filter > 0) {
            $query_master .= " AND mc.buyer_id = $buyer_filter";
        }
        
        if (!empty($search)) {
            $query_master .= " AND (mc.code_color LIKE '%$search%' OR mc.color_name LIKE '%$search%')";
        }
        
        $query_master .= " GROUP BY mc.id ORDER BY mc.created_at DESC";
        
        $result_master = $conn->query($query_master);
        
        if ($result_master && $result_master->num_rows > 0):
        ?>
            <div class="space-y-4">
                <?php while($master = $result_master->fetch_assoc()): ?>
                    <div class="border border-gray-200 rounded-lg overflow-hidden hover:shadow-lg transition-shadow">
                        <!-- Master Color Header -->
                        <div class="bg-gradient-to-r from-purple-50 to-blue-50 p-4">
                            <div class="flex items-center justify-between">
                                <div class="flex items-center gap-4">
                                    <div class="bg-purple-600 text-white px-4 py-2 rounded-lg font-bold text-lg">
                                        <?php echo htmlspecialchars($master['master_code']); ?>
                                    </div>
                                    <div>
                                        <h4 class="text-lg font-bold text-gray-800">
                                            <?php echo htmlspecialchars($master['color_name']); ?>
                                        </h4>
                                        <p class="text-sm text-gray-600">
                                            <span class="font-semibold"><?php echo htmlspecialchars($master['nama_buyer']); ?></span>
                                            (<?php echo htmlspecialchars($master['kode_buyer']); ?>) - 
                                            <?php echo htmlspecialchars($master['nama_collection']); ?>
                                        </p>
                                        <p class="text-xs text-gray-500 mt-1">
                                            Lemari <?php echo htmlspecialchars($master['lemari']); ?> - 
                                            No. <?php echo htmlspecialchars($master['lemari_number']); ?>
                                        </p>
                                    </div>
                                </div>
                                <div class="flex items-center gap-3">
                                    <span class="bg-blue-100 text-blue-800 px-4 py-2 rounded-full text-sm font-semibold">
                                        <i class="fas fa-boxes mr-1"></i>
                                        <?php echo $master['total_stock_items']; ?> Items
                                    </span>
                                    <button 
                                        onclick="generateQRForMaster(<?php echo $master['master_color_id']; ?>, '<?php echo htmlspecialchars($master['master_code']); ?>', '<?php echo htmlspecialchars($master['color_name']); ?>')"
                                        class="bg-green-600 hover:bg-green-700 text-white px-4 py-2 rounded-lg transition-colors font-semibold">
                                        <i class="fas fa-qrcode mr-2"></i>
                                        Generate QR Stock
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endwhile; ?>
            </div>
        <?php else: ?>
            <div class="text-center py-12">
                <i class="fas fa-inbox text-gray-300 text-6xl mb-4"></i>
                <p class="text-gray-500 text-lg">Tidak ada data master warna</p>
                <?php if($buyer_filter > 0 || !empty($search)): ?>
                    <p class="text-gray-400 text-sm mt-2">Coba ubah filter atau kata kunci pencarian</p>
                <?php endif; ?>
            </div>
        <?php endif; ?>
    </div>
</div>

<!-- Modal: View QR Codes -->
<div id="qrModal" class="hidden fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50">
    <div class="relative top-10 mx-auto p-5 border w-11/12 max-w-6xl shadow-lg rounded-lg bg-white mb-10">
        <div class="flex items-center justify-between mb-4 pb-4 border-b">
            <h3 class="text-2xl font-bold text-gray-800">
                <i class="fas fa-qrcode text-purple-600 mr-2"></i>
                QR Code Stock Items
            </h3>
            <div class="flex gap-2">
                <button onclick="printAllQR()" class="bg-purple-600 hover:bg-purple-700 text-white px-4 py-2 rounded-lg transition-colors">
                    <i class="fas fa-print mr-2"></i>
                    Print All QR
                </button>
                <button onclick="closeQRModal()" class="text-gray-400 hover:text-gray-600 text-2xl">
                    <i class="fas fa-times"></i>
                </button>
            </div>
        </div>
        
        <div id="qrMasterInfo" class="mb-4 p-4 bg-purple-50 rounded-lg"></div>
        
        <div id="qrCodesContainer" class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-4">
            <!-- QR codes akan dimuat disini -->
        </div>
        
        <div class="text-center py-4" id="loadingQR">
            <i class="fas fa-spinner fa-spin text-4xl text-purple-500"></i>
            <p class="mt-2 text-gray-500">Generating QR Codes...</p>
        </div>
    </div>
</div>

<script>
function applyFilter() {
    const buyerId = document.getElementById('buyerFilter').value;
    const search = document.getElementById('searchInput').value;
    
    let url = 'data_qr_stock.php?';
    if (buyerId != 0) url += 'buyer_id=' + buyerId + '&';
    if (search) url += 'search=' + encodeURIComponent(search);
    
    window.location.href = url;
}

function resetFilter() {
    window.location.href = 'data_qr_stock.php';
}

let currentMasterData = {};

function generateQRForMaster(masterColorId, masterCode, colorName) {
    currentMasterData = {
        id: masterColorId,
        code: masterCode,
        name: colorName
    };
    
    document.getElementById('qrModal').classList.remove('hidden');
    document.getElementById('loadingQR').style.display = 'block';
    document.getElementById('qrCodesContainer').innerHTML = '';
    
    // Update info
    document.getElementById('qrMasterInfo').innerHTML = `
        <div class="flex items-center gap-3">
            <span class="bg-purple-600 text-white px-4 py-2 rounded-lg font-bold">${masterCode}</span>
            <div>
                <p class="font-semibold text-gray-800">${colorName}</p>
                <p class="text-sm text-gray-600">Master Warna ID: ${masterColorId}</p>
            </div>
        </div>
    `;
    
    // AJAX request untuk generate QR codes
    fetch('generate_qr_stock.php?master_color_id=' + masterColorId)
        .then(response => response.json())
        .then(data => {
            document.getElementById('loadingQR').style.display = 'none';
            
            if(data.success) {
                displayQRCodes(data.qr_codes);
            } else {
                document.getElementById('qrCodesContainer').innerHTML = `
                    <div class="col-span-full text-center py-8 text-red-500">
                        <i class="fas fa-exclamation-triangle text-4xl mb-2"></i>
                        <p>Error: ${data.message}</p>
                    </div>
                `;
            }
        })
        .catch(error => {
            document.getElementById('loadingQR').style.display = 'none';
            document.getElementById('qrCodesContainer').innerHTML = `
                <div class="col-span-full text-center py-8 text-red-500">
                    <i class="fas fa-exclamation-triangle text-4xl mb-2"></i>
                    <p>Error: ${error}</p>
                </div>
            `;
        });
}

function displayQRCodes(qrCodes) {
    const container = document.getElementById('qrCodesContainer');
    container.innerHTML = '';
    
    qrCodes.forEach(item => {
        const qrCard = `
            <div class="border border-gray-200 rounded-lg p-4 text-center hover:shadow-lg transition-shadow bg-white">
                <div class="mb-2">
                    <img src="${item.qr_image}" alt="QR Code" class="w-full h-auto mx-auto" style="max-width: 200px;">
                </div>
                <p class="text-xs font-semibold text-gray-700 mb-1">Code: ${item.code_color}</p>
                <p class="text-xs text-gray-500">${item.component_name}</p>
                <button 
                    onclick="printSingleQR('${item.code_color}', '${item.qr_image}', '${item.component_name}')"
                    class="mt-2 bg-blue-500 hover:bg-blue-600 text-white px-3 py-1 rounded text-xs transition-colors w-full">
                    <i class="fas fa-print mr-1"></i> Print
                </button>
            </div>
        `;
        container.innerHTML += qrCard;
    });
}

function closeQRModal() {
    document.getElementById('qrModal').classList.add('hidden');
}

function printSingleQR(codeColor, qrImage, componentName) {
    // Fetch detail lengkap dari server
    fetch('get_stock_detail.php?code_color=' + encodeURIComponent(codeColor))
        .then(response => response.json())
        .then(data => {
            if(data.success) {
                const detail = data.detail;
                const printContent = `
                    <!DOCTYPE html>
                    <html>
                    <head>
                        <title>Print QR Code - ${codeColor}</title>
                        <style>
                            @page {
                                size: A4 portrait;
                                margin: 15mm;
                            }
                            * {
                                margin: 0;
                                padding: 0;
                                box-sizing: border-box;
                            }
                            body {
                                font-family: Arial, sans-serif;
                                display: flex;
                                justify-content: center;
                                align-items: center;
                                min-height: 100vh;
                            }
                            .print-container {
                                max-width: 600px;
                                width: 100%;
                            }
                            .header {
                                text-align: center;
                                margin-bottom: 12px;
                            }
                            .copy-panel-btn {
                                border: 2px solid #10b981;
                                color: #10b981;
                                padding: 5px 16px;
                                border-radius: 20px;
                                font-size: 12px;
                                font-weight: bold;
                                display: inline-block;
                                margin-bottom: 8px;
                            }
                            .title {
                                font-size: 22px;
                                font-weight: bold;
                                margin-bottom: 4px;
                            }
                            .subtitle {
                                font-size: 12px;
                                color: #666;
                                margin-bottom: 2px;
                            }
                            .qr-container {
                                text-align: center;
                                margin: 12px auto;
                                padding: 15px;
                                border: 2px solid #ddd;
                                background: white;
                                display: inline-block;
                            }
                            .qr-wrapper {
                                text-align: center;
                                margin: 12px 0;
                            }
                            .qr-image {
                                width: 200px;
                                height: 200px;
                                margin: 0 auto;
                            }
                            .info-grid {
                                display: grid;
                                grid-template-columns: 1fr 1fr;
                                gap: 12px 30px;
                                margin: 15px auto;
                                max-width: 500px;
                            }
                            .info-item {
                                margin-bottom: 8px;
                                text-align: center;
                            }
                            .info-label {
                                font-size: 11px;
                                color: #000;
                                font-weight: bold;
                                margin-bottom: 3px;
                            }
                            .info-value {
                                font-size: 13px;
                                color: #000;
                            }
                            .approval-section {
                                margin-top: 18px;
                                padding-top: 12px;
                            }
                            .approval-grid {
                                display: grid;
                                grid-template-columns: repeat(3, 1fr);
                                gap: 12px;
                                margin-top: 12px;
                            }
                            .approval-item {
                                text-align: center;
                                padding: 8px;
                            }
                            .approval-label {
                                font-size: 10px;
                                font-weight: bold;
                                margin-bottom: 18px;
                            }
                            .approval-signature {
                                height: 35px;
                                border-bottom: 1px solid #000;
                                margin-bottom: 5px;
                            }
                            .approval-name {
                                font-size: 11px;
                                font-weight: bold;
                                color: #000;
                            }
                            .approval-grid-2 {
                                display: grid;
                                grid-template-columns: repeat(2, 1fr);
                                gap: 12px;
                                margin-top: 10px;
                            }
                        </style>
                    </head>
                    <body>
                        <div class="print-container">
                            <div class="header">
                                <div class="copy-panel-btn">📋 COPY PANEL</div>
                                <div class="title">${codeColor} - ${detail.buyer_name}</div>
                                <div class="subtitle">🔗 Master Warna: ${detail.master_code} (${detail.master_name})</div>
                                <div class="subtitle">${componentName} (${detail.code_barang || '-'})</div>
                            </div>
                            
                            <div class="qr-wrapper">
                                <div class="qr-container">
                                    <img src="${qrImage}" alt="QR Code" class="qr-image">
                                </div>
                            </div>
                            
                            <div class="info-grid">
                                <div class="info-item">
                                    <div class="info-label">Buyer:</div>
                                    <div class="info-value">${detail.buyer_name}</div>
                                </div>
                                <div class="info-item">
                                    <div class="info-label">Master Warna:</div>
                                    <div class="info-value">${detail.master_code}</div>
                                </div>
                                <div class="info-item">
                                    <div class="info-label">Component:</div>
                                    <div class="info-value">${componentName}</div>
                                </div>
                                <div class="info-item">
                                    <div class="info-label">Kode Barang:</div>
                                    <div class="info-value">${detail.code_barang || '-'}</div>
                                </div>
                                <div class="info-item">
                                    <div class="info-label">Tipe Barang:</div>
                                    <div class="info-value">Copy Panel</div>
                                </div>
                                <div class="info-item">
                                    <div class="info-label">Lokasi:</div>
                                    <div class="info-value">${detail.lokasi_penyimpanan}</div>
                                </div>
                                <div class="info-item">
                                    <div class="info-label">Lemari:</div>
                                    <div class="info-value">${detail.lemari || '-'}</div>
                                </div>
                                <div class="info-item">
                                    <div class="info-label">Tgl Pembuatan:</div>
                                    <div class="info-value">${detail.manufacturing_date}</div>
                                </div>
                                <div class="info-item">
                                    <div class="info-label">Tgl Kedaluwarsa:</div>
                                    <div class="info-value">${detail.expired_date}</div>
                                </div>
                            </div>
                            
                            <div class="approval-section">
                                <div class="approval-grid">
                                    <div class="approval-item">
                                        <div class="approval-label">K A Unit</div>
                                        <div class="approval-signature"></div>
                                        <div class="approval-name">Sugiyanto</div>
                                    </div>
                                    <div class="approval-item">
                                        <div class="approval-label">Color Room</div>
                                        <div class="approval-signature"></div>
                                        <div class="approval-name">Radhitya</div>
                                    </div>
                                    <div class="approval-item">
                                        <div class="approval-label">Akzonobel</div>
                                        <div class="approval-signature"></div>
                                        <div class="approval-name">Fatchur Roji</div>
                                    </div>
                                </div>
                                <div class="approval-grid-2">
                                    <div class="approval-item">
                                        <div class="approval-label">Approved by</div>
                                        <div class="approval-signature"></div>
                                        <div class="approval-name">-----</div>
                                    </div>
                                    <div class="approval-item">
                                        <div class="approval-label">Approved by QC</div>
                                        <div class="approval-signature"></div>
                                        <div class="approval-name">-----</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </body>
                    </html>
                `;
                
                const printWindow = window.open('', '_blank');
                printWindow.document.write(printContent);
                printWindow.document.close();
                printWindow.focus();
                
                setTimeout(() => {
                    printWindow.print();
                    printWindow.close();
                }, 250);
            } else {
                alert('Error: ' + data.message);
            }
        })
        .catch(error => {
            alert('Error fetching detail: ' + error);
        });
}

function printAllQR() {
    fetch('get_stock_details_all.php?master_color_id=' + currentMasterData.id)
        .then(response => response.json())
        .then(data => {
            if(data.success) {
                let printContent = `
                    <!DOCTYPE html>
                    <html>
                    <head>
                        <title>Print All QR Codes - ${currentMasterData.code}</title>
                        <style>
                            @page {
                                size: A4;
                                margin: 15mm;
                            }
                            body {
                                font-family: Arial, sans-serif;
                            }
                            .page-header {
                                text-align: center;
                                margin-bottom: 20px;
                                padding-bottom: 10px;
                                border-bottom: 2px solid #000;
                            }
                            .master-title {
                                font-size: 24px;
                                font-weight: bold;
                                margin-bottom: 5px;
                            }
                            .grid-container {
                                display: grid;
                                grid-template-columns: 1fr;
                                gap: 30px;
                            }
                            .qr-item {
                                border: 3px solid #000;
                                padding: 20px;
                                page-break-inside: avoid;
                            }
                            .item-header {
                                text-align: center;
                                margin-bottom: 15px;
                            }
                            .title {
                                font-size: 20px;
                                font-weight: bold;
                            }
                            .subtitle {
                                font-size: 12px;
                                color: #666;
                            }
                            .qr-container {
                                text-align: center;
                                margin: 15px 0;
                                padding: 15px;
                                background: #f9fafb;
                            }
                            .qr-image {
                                width: 200px;
                                height: 200px;
                                margin: 0 auto;
                            }
                            .info-grid {
                                display: grid;
                                grid-template-columns: 1fr 1fr;
                                gap: 10px 20px;
                                font-size: 11px;
                            }
                            .info-label {
                                font-weight: bold;
                                color: #666;
                            }
                            .info-value {
                                color: #000;
                            }
                        </style>
                    </head>
                    <body>
                        <div class="page-header">
                            <div class="master-title">${currentMasterData.code} - ${currentMasterData.name}</div>
                            <div style="font-size: 14px; color: #666;">Color Stock Items QR Codes</div>
                        </div>
                        <div class="grid-container">
                `;
                
                data.details.forEach(item => {
                    printContent += `
                        <div class="qr-item">
                            <div class="item-header">
                                <div class="title">${item.code_color} - ${item.buyer_name}</div>
                                <div class="subtitle">Master Warna: ${item.master_code} | ${item.component_name}</div>
                            </div>
                            <div class="qr-container">
                                <img src="${item.qr_image}" alt="QR Code" class="qr-image">
                            </div>
                            <div class="info-grid">
                                <div><span class="info-label">Buyer:</span> <span class="info-value">${item.buyer_name}</span></div>
                                <div><span class="info-label">Master Warna:</span> <span class="info-value">${item.master_code}</span></div>
                                <div><span class="info-label">Component:</span> <span class="info-value">${item.component_name}</span></div>
                                <div><span class="info-label">Kode Barang:</span> <span class="info-value">${item.code_barang || '-'}</span></div>
                                <div><span class="info-label">Tipe Barang:</span> <span class="info-value">Copy Panel</span></div>
                                <div><span class="info-label">Lokasi:</span> <span class="info-value">${item.lokasi_penyimpanan}</span></div>
                                <div><span class="info-label">Lemari:</span> <span class="info-value">${item.lemari || '-'}</span></div>
                                <div><span class="info-label">Tgl Pembuatan:</span> <span class="info-value">${item.manufacturing_date}</span></div>
                                <div><span class="info-label">Tgl Kedaluwarsa:</span> <span class="info-value">${item.expired_date}</span></div>
                            </div>
                        </div>
                    `;
                });
                
                printContent += `
                        </div>
                    </body>
                    </html>
                `;
                
                const printWindow = window.open('', '_blank');
                printWindow.document.write(printContent);
                printWindow.document.close();
                printWindow.focus();
                
                setTimeout(() => {
                    printWindow.print();
                }, 250);
            }
        });
}
</script>

<?php
// Include footer
include '../template_it/footer.php';
?>