<!-- data_qr_master.php -->
<?php
// Set page title
$page_title = "Data QR Master Management";

// Include header
include '../template_it/header.php';

// Get filters from URL
$buyer_filter = isset($_GET['buyer_id']) ? (int)$_GET['buyer_id'] : 0;
$search = isset($_GET['search']) ? $conn->real_escape_string($_GET['search']) : '';

// Query untuk mengambil data buyers untuk filter dropdown
$query_buyers = "SELECT id, nama_buyer, kode_buyer FROM buyers ORDER BY nama_buyer ASC";
$result_buyers = $conn->query($query_buyers);
?>

<!-- Data QR Master Content -->
<div class="container mx-auto">
    <!-- Page Header -->
    <div class="bg-white rounded-lg shadow-md p-6 mb-6">
        <div class="flex items-center justify-between">
            <div>
                <h2 class="text-2xl font-bold text-gray-800">
                    <i class="fas fa-qrcode text-green-600 mr-2"></i>
                    Data QR Master Management
                </h2>
                <p class="text-gray-600 mt-1">Generate QR Code untuk Master Color</p>
            </div>
        </div>
    </div>

    <!-- Filter Section -->
    <div class="bg-white rounded-lg shadow-md p-6 mb-6">
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <!-- Filter Buyer -->
            <div>
                <label class="block text-gray-700 font-semibold mb-2">
                    <i class="fas fa-building mr-1"></i> Filter Buyer:
                </label>
                <select id="buyerFilter" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" onchange="applyFilter()">
                    <option value="0">-- Semua Buyer --</option>
                    <?php 
                    $result_buyers->data_seek(0);
                    while($buyer = $result_buyers->fetch_assoc()): 
                    ?>
                        <option value="<?php echo $buyer['id']; ?>" <?php echo ($buyer_filter == $buyer['id']) ? 'selected' : ''; ?>>
                            <?php echo htmlspecialchars($buyer['nama_buyer']) . ' (' . htmlspecialchars($buyer['kode_buyer']) . ')'; ?>
                        </option>
                    <?php endwhile; ?>
                </select>
            </div>

            <!-- Search -->
            <div>
                <label class="block text-gray-700 font-semibold mb-2">
                    <i class="fas fa-search mr-1"></i> Search:
                </label>
                <input 
                    type="text" 
                    id="searchInput" 
                    value="<?php echo htmlspecialchars($search); ?>"
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500"
                    placeholder="Cari master code atau nama color..."
                    onkeypress="if(event.key === 'Enter') applyFilter()">
            </div>
        </div>

        <div class="flex gap-2 mt-4">
            <button onclick="applyFilter()" class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-2 rounded-lg transition-colors">
                <i class="fas fa-filter mr-2"></i> Filter
            </button>
            <?php if($buyer_filter > 0 || !empty($search)): ?>
                <button onclick="resetFilter()" class="bg-red-500 hover:bg-red-600 text-white px-6 py-2 rounded-lg transition-colors">
                    <i class="fas fa-redo mr-2"></i> Reset
                </button>
            <?php endif; ?>
        </div>
    </div>

    <!-- Master Color List -->
    <div class="bg-white rounded-lg shadow-md p-6">
        <h3 class="text-xl font-bold text-gray-800 mb-4 flex items-center">
            <i class="fas fa-palette text-green-600 mr-2"></i>
            Master Color Data
        </h3>

        <?php
        // Query untuk mengambil master color data
        $query_master = "
            SELECT 
                mc.id as master_color_id,
                mc.code_color as master_code,
                mc.color_name,
                mc.lemari,
                mc.lemari_number,
                mc.qr_code,
                mc.created_at,
                b.nama_buyer,
                b.kode_buyer,
                c.nama_collection,
                mcp.panel_code,
                mcp.rack_number,
                COUNT(csi.id) as total_stock_items,
                COUNT(CASE WHEN csi.status = 'available' THEN 1 END) as available_items,
                COUNT(CASE WHEN csi.status = 'borrowed' THEN 1 END) as borrowed_items,
                COUNT(CASE WHEN csi.status = 'expired' THEN 1 END) as expired_items
            FROM master_color mc
            LEFT JOIN buyers b ON mc.buyer_id = b.id
            LEFT JOIN collections c ON mc.collection_id = c.id
            LEFT JOIN master_color_panel mcp ON mc.id = mcp.master_color_id
            LEFT JOIN color_stock_items csi ON mc.id = csi.master_color_id
            WHERE 1=1
        ";
        
        if ($buyer_filter > 0) {
            $query_master .= " AND mc.buyer_id = $buyer_filter";
        }
        
        if (!empty($search)) {
            $query_master .= " AND (mc.code_color LIKE '%$search%' OR mc.color_name LIKE '%$search%')";
        }
        
        $query_master .= " GROUP BY mc.id ORDER BY mc.created_at DESC";
        
        $result_master = $conn->query($query_master);
        
        if ($result_master && $result_master->num_rows > 0):
        ?>
            <div class="space-y-4">
                <?php while($master = $result_master->fetch_assoc()): ?>
                    <div class="border border-gray-200 rounded-lg overflow-hidden hover:shadow-lg transition-shadow">
                        <!-- Master Color Header -->
                        <div class="bg-gradient-to-r from-green-50 to-teal-50 p-4">
                            <div class="flex items-center justify-between">
                                <div class="flex items-center gap-4">
                                    <div class="bg-green-600 text-white px-4 py-2 rounded-lg font-bold text-lg">
                                        <?php echo htmlspecialchars($master['master_code']); ?>
                                    </div>
                                    <div>
                                        <h4 class="text-lg font-bold text-gray-800">
                                            <?php echo htmlspecialchars($master['color_name']); ?>
                                        </h4>
                                        <p class="text-sm text-gray-600">
                                            <span class="font-semibold"><?php echo htmlspecialchars($master['nama_buyer']); ?></span>
                                            (<?php echo htmlspecialchars($master['kode_buyer']); ?>) - 
                                            <?php echo htmlspecialchars($master['nama_collection']); ?>
                                        </p>
                                        <div class="flex items-center gap-4 text-xs text-gray-500 mt-1">
                                            <span>
                                                <i class="fas fa-archive mr-1"></i>
                                                Lemari <?php echo htmlspecialchars($master['lemari']); ?> - 
                                                No. <?php echo str_pad($master['lemari_number'], 3, '0', STR_PAD_LEFT); ?>
                                            </span>
                                            <?php if(!empty($master['panel_code'])): ?>
                                                <span>
                                                    <i class="fas fa-clipboard mr-1"></i>
                                                    Panel: <?php echo htmlspecialchars($master['panel_code']); ?>
                                                </span>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                                <div class="flex items-center gap-3 flex-col lg:flex-row">
                                    <!-- Stock Summary -->
                                    <div class="grid grid-cols-2 gap-2 text-xs">
                                        <span class="bg-blue-100 text-blue-800 px-2 py-1 rounded-full font-semibold">
                                            <i class="fas fa-boxes mr-1"></i>
                                            Total: <?php echo $master['total_stock_items']; ?>
                                        </span>
                                        <span class="bg-green-100 text-green-800 px-2 py-1 rounded-full font-semibold">
                                            <i class="fas fa-check-circle mr-1"></i>
                                            Tersedia: <?php echo $master['available_items']; ?>
                                        </span>
                                        <span class="bg-yellow-100 text-yellow-800 px-2 py-1 rounded-full font-semibold">
                                            <i class="fas fa-hand-holding mr-1"></i>
                                            Dipinjam: <?php echo $master['borrowed_items']; ?>
                                        </span>
                                        <span class="bg-red-100 text-red-800 px-2 py-1 rounded-full font-semibold">
                                            <i class="fas fa-exclamation-triangle mr-1"></i>
                                            Expired: <?php echo $master['expired_items']; ?>
                                        </span>
                                    </div>
                                    
                                    <!-- Action Buttons -->
                                    <div class="flex gap-2">
                                        <?php if(!empty($master['qr_code'])): ?>
                                            <button 
                                                onclick="viewMasterQR('<?php echo htmlspecialchars($master['master_code']); ?>', '<?php echo htmlspecialchars($master['color_name']); ?>')"
                                                class="bg-blue-600 hover:bg-blue-700 text-white px-3 py-2 rounded-lg transition-colors font-semibold text-sm">
                                                <i class="fas fa-eye mr-1"></i>
                                                View QR
                                            </button>
                                        <?php endif; ?>
                                        <button 
                                            onclick="generateMasterQR(<?php echo $master['master_color_id']; ?>, '<?php echo htmlspecialchars($master['master_code']); ?>', '<?php echo htmlspecialchars($master['color_name']); ?>')"
                                            class="bg-green-600 hover:bg-green-700 text-white px-3 py-2 rounded-lg transition-colors font-semibold text-sm">
                                            <i class="fas fa-qrcode mr-1"></i>
                                            Generate QR Master
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endwhile; ?>
            </div>
        <?php else: ?>
            <div class="text-center py-12">
                <i class="fas fa-inbox text-gray-300 text-6xl mb-4"></i>
                <p class="text-gray-500 text-lg">Tidak ada data master color</p>
            </div>
        <?php endif; ?>
    </div>
</div>

<!-- QR Code Modal -->
<div id="qrModal" class="fixed inset-0 bg-black bg-opacity-50 hidden z-50 flex items-center justify-center p-4">
    <div class="bg-white rounded-lg max-w-4xl w-full max-h-[90vh] overflow-y-auto">
        <div class="flex justify-between items-center p-6 border-b">
            <h3 class="text-xl font-bold" id="modalTitle">QR Code Master Color</h3>
            <button onclick="closeModal()" class="text-gray-500 hover:text-gray-700 text-2xl">&times;</button>
        </div>
        <div id="modalContent" class="p-6">
            <!-- QR content will be loaded here -->
        </div>
        <div class="flex justify-end gap-3 p-6 border-t">
            <button onclick="printMasterQR()" class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-2 rounded-lg transition-colors">
                <i class="fas fa-print mr-2"></i> Print QR
            </button>
            <button onclick="closeModal()" class="bg-gray-500 hover:bg-gray-600 text-white px-6 py-2 rounded-lg transition-colors">
                Close
            </button>
        </div>
    </div>
</div>

<script>
let currentMasterData = {};

function applyFilter() {
    const buyerId = document.getElementById('buyerFilter').value;
    const search = document.getElementById('searchInput').value;
    
    let url = 'data_qr_master.php?';
    if (buyerId && buyerId !== '0') {
        url += 'buyer_id=' + buyerId + '&';
    }
    if (search) {
        url += 'search=' + encodeURIComponent(search) + '&';
    }
    
    window.location.href = url;
}

function resetFilter() {
    window.location.href = 'data_qr_master.php';
}

function generateMasterQR(masterId, masterCode, colorName) {
    currentMasterData = {
        id: masterId,
        code: masterCode,
        name: colorName,
        buyer: '',
        location: 'Color Room'
    };
    
    document.getElementById('modalTitle').textContent = `Generate QR Master - ${masterCode}`;
    document.getElementById('modalContent').innerHTML = `
        <div class="text-center">
            <div class="animate-spin rounded-full h-12 w-12 border-b-2 border-blue-600 mx-auto mb-4"></div>
            <p>Generating QR Code...</p>
        </div>
    `;
    
    document.getElementById('qrModal').classList.remove('hidden');
    
    fetch('generate_qr_master.php?master_color_id=' + masterId)
        .then(response => response.json())
        .then(data => {
            if(data.success) {
                currentMasterData.buyer = data.buyer_name || 'Master';
                
                document.getElementById('modalContent').innerHTML = `
                    <div class="text-center">
                        <div class="bg-gradient-to-r from-green-50 to-teal-50 p-6 rounded-lg mb-6">
                            <h4 class="text-xl font-bold text-gray-800 mb-2">${masterCode}</h4>
                            <p class="text-gray-600">${colorName}</p>
                            <p class="text-sm text-gray-500">${data.buyer_name}</p>
                        </div>
                        
                        <div class="bg-white border-4 border-green-600 rounded-lg p-8 inline-block">
                            <img src="${data.qr_image}" alt="QR Code Master" class="w-64 h-64 mx-auto">
                        </div>
                        
                        <div class="mt-6 text-sm text-gray-600">
                            <p><strong>Master Code:</strong> ${masterCode}</p>
                            <p><strong>Color Name:</strong> ${colorName}</p>
                            <p><strong>Buyer:</strong> ${data.buyer_name}</p>
                            <p class="text-xs text-gray-500 mt-2">Scan QR code ini untuk melihat detail master color</p>
                        </div>
                    </div>
                `;
            } else {
                document.getElementById('modalContent').innerHTML = `
                    <div class="text-center text-red-600">
                        <i class="fas fa-exclamation-triangle text-4xl mb-4"></i>
                        <p>Error: ${data.message}</p>
                    </div>
                `;
            }
        })
        .catch(error => {
            document.getElementById('modalContent').innerHTML = `
                <div class="text-center text-red-600">
                    <i class="fas fa-exclamation-triangle text-4xl mb-4"></i>
                    <p>Error: ${error}</p>
                </div>
            `;
        });
}

function viewMasterQR(masterCode, colorName) {
    currentMasterData = {
        code: masterCode,
        name: colorName
    };
    
    document.getElementById('modalTitle').textContent = `QR Master - ${masterCode}`;
    document.getElementById('modalContent').innerHTML = `
        <div class="text-center">
            <div class="animate-spin rounded-full h-12 w-12 border-b-2 border-blue-600 mx-auto mb-4"></div>
            <p>Loading QR Code...</p>
        </div>
    `;
    
    document.getElementById('qrModal').classList.remove('hidden');
    
    fetch('get_master_qr.php?master_code=' + encodeURIComponent(masterCode))
        .then(response => response.json())
        .then(data => {
            if(data.success && data.qr_image) {
                currentMasterData.buyer = data.buyer_name || 'Brunswick';
                
                document.getElementById('modalContent').innerHTML = `
                    <div class="text-center">
                        <div class="bg-gradient-to-r from-green-50 to-teal-50 p-6 rounded-lg mb-6">
                            <h4 class="text-xl font-bold text-gray-800 mb-2">${masterCode}</h4>
                            <p class="text-gray-600">${colorName}</p>
                        </div>
                        
                        <div class="bg-white border-4 border-green-600 rounded-lg p-8 inline-block">
                            <img src="${data.qr_image}" alt="QR Code Master" class="w-64 h-64 mx-auto">
                        </div>
                        
                        <div class="mt-6 text-sm text-gray-600">
                            <p><strong>Master Code:</strong> ${masterCode}</p>
                            <p><strong>Color Name:</strong> ${colorName}</p>
                            <p class="text-xs text-gray-500 mt-2">Scan QR code ini untuk melihat detail master color</p>
                        </div>
                    </div>
                `;
            } else {
                document.getElementById('modalContent').innerHTML = `
                    <div class="text-center text-red-600">
                        <i class="fas fa-exclamation-triangle text-4xl mb-4"></i>
                        <p>QR Code tidak ditemukan atau belum di-generate</p>
                    </div>
                `;
            }
        });
}

function closeModal() {
    document.getElementById('qrModal').classList.add('hidden');
}

function printMasterQR() {
    const qrImage = document.querySelector('#modalContent img');
    if (!qrImage) {
        alert('QR Code tidak tersedia untuk dicetak');
        return;
    }
    
    let printContent = `
        <!DOCTYPE html>
        <html>
        <head>
            <title>Print QR Master - ${currentMasterData.code}</title>
            <style>
                @page {
                    size: A4;
                    margin: 15mm;
                }
                body {
                    font-family: Arial, sans-serif;
                    margin: 0;
                    padding: 20px;
                }
                .container {
                    max-width: 400px;
                    margin: 0 auto;
                    padding: 20px;
                    background: white;
                    border: 2px solid #000;
                }
                .header {
                    text-align: center;
                    margin-bottom: 15px;
                }
                .master-btn {
                    background: #10B981;
                    color: white;
                    padding: 6px 12px;
                    border: 2px solid #000;
                    border-radius: 15px;
                    font-size: 10px;
                    margin-bottom: 10px;
                    display: inline-block;
                    font-weight: bold;
                }
                .title {
                    font-size: 18px;
                    font-weight: bold;
                    color: #000;
                    margin-bottom: 5px;
                }
                .subtitle {
                    font-size: 12px;
                    color: #666;
                    margin-bottom: 20px;
                }
                .qr-container {
                    text-align: center;
                    margin: 20px 0;
                    padding: 15px;
                    border: 2px solid #ddd;
                    background: #f9f9f9;
                }
                .qr-image {
                    width: 200px;
                    height: 200px;
                }
                .info-grid {
                    display: grid;
                    grid-template-columns: 1fr 1fr;
                    gap: 15px 20px;
                    font-size: 11px;
                    margin: 20px 0;
                }
                .info-item {
                    text-align: center;
                }
                .info-label {
                    font-weight: bold;
                    color: #000;
                    margin-bottom: 3px;
                }
                .info-value {
                    color: #000;
                    word-break: break-word;
                }
                .signatures {
                    margin-top: 30px;
                    padding-top: 20px;
                    border-top: 1px solid #ddd;
                }
                .signature-row {
                    display: grid;
                    grid-template-columns: 1fr 1fr 1fr;
                    gap: 20px;
                    margin-bottom: 50px;
                    text-align: center;
                    font-size: 10px;
                }
                .signature-item {
                    min-height: 60px;
                    display: flex;
                    flex-direction: column;
                    justify-content: space-between;
                }
                .signature-title {
                    font-weight: bold;
                    margin-bottom: 40px;
                }
                .signature-line {
                    border-bottom: 1px solid #000;
                    margin-bottom: 5px;
                    height: 1px;
                }
                .signature-name {
                    font-size: 9px;
                    color: #666;
                }
                .signature-row-2 {
                    display: grid;
                    grid-template-columns: 1fr 1fr;
                    gap: 40px;
                    text-align: center;
                    font-size: 10px;
                }
            </style>
        </head>
        <body>
            <div class="container">
                <div class="header">
                    <div class="master-btn">Master</div>
                    <div class="title">${currentMasterData.code} - ${currentMasterData.buyer || 'Brunswick'}</div>
                    <div class="subtitle">
                        🎨 Master Warna: ${currentMasterData.code}<br>
                        ${currentMasterData.name || ''}
                    </div>
                </div>
                
                <div class="qr-container">
                    <img src="${qrImage.src}" alt="QR Code Master" class="qr-image">
                </div>
                
                <div class="info-grid">
                    <div class="info-item">
                        <div class="info-label">Master Warna:</div>
                        <div class="info-value">${currentMasterData.code}</div>
                    </div>
                    <div class="info-item">
                        <div class="info-label">Buyer:</div>
                        <div class="info-value">${currentMasterData.buyer || 'Brunswick'}</div>
                    </div>
                    <div class="info-item">
                        <div class="info-label">Nama Warna:</div>
                        <div class="info-value">${currentMasterData.name || '203'}</div>
                    </div>
                    <div class="info-item">
                        <div class="info-label">Lokasi:</div>
                        <div class="info-value">Color Room</div>
                    </div>
                    <div class="info-item">
                        <div class="info-label">Tipe:</div>
                        <div class="info-value">Master Color</div>
                    </div>
                    <div class="info-item">
                        <div class="info-label">Tgl Pembuatan:</div>
                        <div class="info-value">${new Date().toLocaleDateString('id-ID')}</div>
                    </div>
                    <div class="info-item">
                        <div class="info-label">Status:</div>
                        <div class="info-value">Active</div>
                    </div>
                </div>
                
                <div class="signatures">
                    <div class="signature-row">
                        <div class="signature-item">
                            <div class="signature-title">K A Unit</div>
                            <div>
                                <div class="signature-line"></div>
                                <div class="signature-name">Sugiyanto</div>
                            </div>
                        </div>
                        <div class="signature-item">
                            <div class="signature-title">Color Room</div>
                            <div>
                                <div class="signature-line"></div>
                                <div class="signature-name">Rachma</div>
                            </div>
                        </div>
                        <div class="signature-item">
                            <div class="signature-title">Akzonobel</div>
                            <div>
                                <div class="signature-line"></div>
                                <div class="signature-name">Fatirha Rizqi</div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="signature-row-2">
                        <div class="signature-item">
                            <div class="signature-title">Approved by</div>
                            <div>
                                <div class="signature-line"></div>
                                <div class="signature-name">-----</div>
                            </div>
                        </div>
                        <div class="signature-item">
                            <div class="signature-title">Approved by QC</div>
                            <div>
                                <div class="signature-line"></div>
                                <div class="signature-name">-----</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </body>
        </html>
    `;
    
    const printWindow = window.open('', '_blank');
    printWindow.document.write(printContent);
    printWindow.document.close();
    printWindow.focus();
    
    setTimeout(() => {
        printWindow.print();
        printWindow.close();
    }, 250);
}
</script>

<?php
include '../template_it/footer.php';
?>