<?php
// Set page title
$page_title = "Kelola Component Stock Items";

// Include header
include '../template_it/header.php';

// Get filters from URL
$buyer_filter = isset($_GET['buyer_id']) ? (int)$_GET['buyer_id'] : 0;
$color_filter = isset($_GET['color_id']) ? (int)$_GET['color_id'] : 0;

// Query untuk mengambil data buyers
$query_buyers = "SELECT id, nama_buyer, kode_buyer FROM buyers ORDER BY nama_buyer ASC";
$result_buyers = $conn->query($query_buyers);

// Query untuk mengambil master colors berdasarkan buyer (jika buyer sudah dipilih)
$colors_options = '';
if ($buyer_filter > 0) {
    $query_colors = "SELECT id, code_color, color_name FROM master_color WHERE buyer_id = $buyer_filter ORDER BY color_name ASC";
    $result_colors = $conn->query($query_colors);
    while($color = $result_colors->fetch_assoc()) {
        $selected = ($color_filter == $color['id']) ? 'selected' : '';
        $colors_options .= '<option value="'.$color['id'].'" '.$selected.'>'.htmlspecialchars($color['code_color']).' - '.htmlspecialchars($color['color_name']).'</option>';
    }
}

// Query untuk mengambil components
$query_components = "SELECT id, component_name FROM color_components ORDER BY component_name ASC";
$result_components = $conn->query($query_components);
?>

<style>
.master-color-section {
    border: 3px solid #e5e7eb;
    border-radius: 12px;
    margin-bottom: 2rem;
    background: linear-gradient(to bottom, #f9fafb, #ffffff);
}

.master-color-header {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    padding: 1.5rem;
    border-radius: 9px 9px 0 0;
    margin-bottom: 1.5rem;
}

.component-group {
    background: #f8f9fa;
    border: 2px solid #e9ecef;
    border-radius: 8px;
    padding: 1rem;
    margin-bottom: 1rem;
    transition: all 0.3s ease;
}

.component-group:hover {
    box-shadow: 0 4px 12px rgba(0,0,0,0.1);
    transform: translateY(-2px);
}

.component-header {
    background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
    color: white;
    padding: 0.75rem 1rem;
    border-radius: 6px;
    margin-bottom: 0.75rem;
}

.stock-item-row {
    background: white;
    border: 1px solid #dee2e6;
    border-radius: 6px;
    padding: 0.75rem;
    margin-bottom: 0.5rem;
    display: flex;
    align-items: center;
    justify-content: space-between;
    transition: all 0.2s ease;
}

.stock-item-row:hover {
    background: #f8f9fa;
    border-color: #adb5bd;
}

.code-barang-input {
    width: 80px;
    padding: 0.25rem 0.5rem;
    border: 1px solid #ced4da;
    border-radius: 4px;
    font-family: 'Courier New', monospace;
    font-weight: bold;
    text-align: center;
}

.code-barang-input.valid {
    border-color: #28a745;
    background-color: #d4edda;
}

.code-barang-input.invalid {
    border-color: #dc3545;
    background-color: #f8d7da;
}

.validation-message {
    font-size: 0.7rem;
    margin-top: 0.25rem;
}
</style>

<!-- Add Component Stock Content -->
<div class="container mx-auto">
    <!-- Page Header -->
    <div class="bg-white rounded-lg shadow-md p-6 mb-6">
        <div class="flex items-center justify-between">
            <div>
                <h2 class="text-2xl font-bold text-gray-800">
                    <i class="fas fa-layer-group text-purple-600 mr-2"></i>
                    Kelola Component Stock Items
                </h2>
                <p class="text-gray-600 mt-1">Tambah, edit, atau hapus component untuk setiap master color</p>
            </div>
        </div>
    </div>

    <!-- Filter Section -->
    <div class="bg-white rounded-lg shadow-md p-6 mb-6">
        <div class="flex items-center justify-between mb-4">
            <h3 class="text-lg font-semibold text-gray-800">
                <i class="fas fa-filter mr-2"></i> Filter Data
            </h3>
            <?php if($buyer_filter > 0 || $color_filter > 0): ?>
                <button onclick="resetFilter()" class="bg-red-500 hover:bg-red-600 text-white px-4 py-2 rounded-lg transition-colors text-sm">
                    <i class="fas fa-redo mr-2"></i> Reset Filter
                </button>
            <?php endif; ?>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <!-- Filter Buyer -->
            <div>
                <label class="block text-gray-700 font-semibold mb-2">
                    <i class="fas fa-building mr-1"></i> Pilih Buyer:
                </label>
                <select id="buyerFilter" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-500" onchange="filterByBuyer()">
                    <option value="0">-- Pilih Buyer --</option>
                    <?php 
                    $result_buyers->data_seek(0);
                    while($buyer = $result_buyers->fetch_assoc()): 
                    ?>
                        <option value="<?php echo $buyer['id']; ?>" <?php echo ($buyer_filter == $buyer['id']) ? 'selected' : ''; ?>>
                            <?php echo htmlspecialchars($buyer['nama_buyer']) . ' (' . htmlspecialchars($buyer['kode_buyer']) . ')'; ?>
                        </option>
                    <?php endwhile; ?>
                </select>
            </div>

            <!-- Filter Master Color -->
            <div>
                <label class="block text-gray-700 font-semibold mb-2">
                    <i class="fas fa-palette mr-1"></i> Pilih Master Color:
                </label>
                <select id="colorFilter" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-500" onchange="filterByColor()" <?php echo ($buyer_filter == 0) ? 'disabled' : ''; ?>>
                    <option value="0">-- Semua Master Color --</option>
                    <?php echo $colors_options; ?>
                </select>
            </div>
        </div>

        <?php if($buyer_filter == 0): ?>
            <div class="mt-4 bg-yellow-50 border-l-4 border-yellow-400 p-4">
                <div class="flex">
                    <div class="flex-shrink-0">
                        <i class="fas fa-exclamation-triangle text-yellow-400"></i>
                    </div>
                    <div class="ml-3">
                        <p class="text-sm text-yellow-700">
                            Silakan pilih <strong>Buyer</strong> terlebih dahulu untuk menampilkan data stock items
                        </p>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>

    <!-- Stock Items by Master Color -->
    <?php if($buyer_filter > 0): ?>
        <?php
        // Query untuk mengambil master colors dengan stock items
        $query_master_colors = "
            SELECT DISTINCT
                mc.id as master_color_id,
                mc.code_color as master_code,
                mc.color_name,
                b.nama_buyer,
                b.kode_buyer,
                col.nama_collection
            FROM master_color mc
            LEFT JOIN buyers b ON mc.buyer_id = b.id
            LEFT JOIN collections col ON mc.collection_id = col.id
            LEFT JOIN color_stock_items csi ON mc.id = csi.master_color_id
            WHERE mc.buyer_id = $buyer_filter
        ";
        
        if ($color_filter > 0) {
            $query_master_colors .= " AND mc.id = $color_filter";
        }
        
        $query_master_colors .= " GROUP BY mc.id ORDER BY mc.color_name ASC";
        
        $result_master_colors = $conn->query($query_master_colors);
        
        if ($result_master_colors && $result_master_colors->num_rows > 0):
            while($master_color = $result_master_colors->fetch_assoc()):
                $master_color_id = $master_color['master_color_id'];
        ?>
            <!-- MASTER COLOR SECTION -->
            <div class="master-color-section">
                <!-- Master Color Header -->
                <div class="master-color-header">
                    <div class="flex items-center justify-between">
                        <div>
                            <div class="flex items-center gap-3 mb-2">
                                <span class="bg-white text-purple-700 px-4 py-2 rounded-lg font-bold text-lg">
                                    <?php echo htmlspecialchars($master_color['master_code']); ?>
                                </span>
                                <h3 class="text-xl font-bold">
                                    <?php echo htmlspecialchars($master_color['color_name']); ?>
                                </h3>
                            </div>
                            <p class="text-purple-100 text-sm">
                                <i class="fas fa-building mr-1"></i>
                                <?php echo htmlspecialchars($master_color['nama_buyer']); ?> 
                                (<?php echo htmlspecialchars($master_color['kode_buyer']); ?>) - 
                                <?php echo htmlspecialchars($master_color['nama_collection']); ?>
                            </p>
                        </div>
                        <button 
                            onclick="showAddComponentModal(<?php echo $master_color_id; ?>, '<?php echo htmlspecialchars($master_color['master_code']); ?>', '<?php echo htmlspecialchars(addslashes($master_color['color_name'])); ?>')"
                            class="bg-white text-purple-700 hover:bg-purple-50 px-4 py-2 rounded-lg font-semibold transition-colors">
                            <i class="fas fa-plus mr-2"></i>Tambah Component Baru
                        </button>
                    </div>
                </div>

                <!-- Components Grouping -->
                <div class="px-6 pb-6">
                    <?php
                    // Query untuk mengambil stock items grouped by component
                    $query_components_group = "
                        SELECT 
                            cc.id as component_id,
                            cc.component_name,
                            COUNT(csi.id) as total_items,
                            SUM(csi.qty) as total_qty
                        FROM color_stock_items csi
                        LEFT JOIN color_components cc ON csi.component_id = cc.id
                        WHERE csi.master_color_id = $master_color_id
                        GROUP BY cc.id
                        ORDER BY cc.component_name ASC
                    ";
                    
                    $result_components_group = $conn->query($query_components_group);
                    
                    if ($result_components_group && $result_components_group->num_rows > 0):
                        while($component_group = $result_components_group->fetch_assoc()):
                            $component_id = $component_group['component_id'];
                    ?>
                        <!-- COMPONENT GROUP -->
                        <div class="component-group">
                            <!-- Component Header -->
                            <div class="component-header">
                                <div class="flex items-center justify-between">
                                    <div>
                                        <span class="font-bold text-lg">
                                            <i class="fas fa-cube mr-2"></i>
                                            <?php echo htmlspecialchars($component_group['component_name']); ?>
                                        </span>
                                        <span class="ml-3 text-sm opacity-90">
                                            (<?php echo $component_group['total_items']; ?> items | Total Qty: <?php echo $component_group['total_qty']; ?>)
                                        </span>
                                    </div>
                                    <button 
                                        onclick="addQtyToComponent(<?php echo $master_color_id; ?>, <?php echo $component_id; ?>, '<?php echo htmlspecialchars($component_group['component_name']); ?>')"
                                        class="bg-white text-pink-600 hover:bg-pink-50 px-3 py-1 rounded-lg font-semibold text-sm transition-colors">
                                        <i class="fas fa-plus mr-1"></i>Tambah Qty
                                    </button>
                                </div>
                            </div>

                            <!-- Stock Items for this Component -->
                            <?php
                            // UPDATE: Tambahkan lemari_number di SELECT
                            $query_stock_items = "
                                SELECT 
                                    csi.id,
                                    csi.code_color,
                                    csi.code_barang_lemari5,
                                    csi.lemari_number,
                                    csi.qty,
                                    csi.lokasi_penyimpanan,
                                    csi.manufacturing_date,
                                    csi.expired_date,
                                    csi.status
                                FROM color_stock_items csi
                                WHERE csi.master_color_id = $master_color_id 
                                AND csi.component_id = $component_id
                                ORDER BY csi.code_barang_lemari5 ASC
                            ";
                            
                            $result_stock_items = $conn->query($query_stock_items);
                            
                            if ($result_stock_items && $result_stock_items->num_rows > 0):
                                while($stock_item = $result_stock_items->fetch_assoc()):
                                    $status_classes = [
                                        'available' => 'bg-green-100 text-green-800',
                                        'borrowed' => 'bg-orange-100 text-orange-800',
                                        'expired' => 'bg-red-100 text-red-800'
                                    ];
                                    $status_text = [
                                        'available' => 'Tersedia',
                                        'borrowed' => 'Dipinjam',
                                        'expired' => 'Kadaluarsa'
                                    ];
                            ?>
                                <div class="stock-item-row">
                                    <div class="flex items-center gap-3 flex-1">
                                        <!-- Code Barang (Editable) -->
                                        <div>
                                            <label class="text-xs text-gray-600 block mb-1">Code Barang Lemari 5</label>
                                            <input 
                                                type="text" 
                                                class="code-barang-input" 
                                                value="<?php echo htmlspecialchars($stock_item['code_barang_lemari5']); ?>"
                                                data-stock-id="<?php echo $stock_item['id']; ?>"
                                                data-original="<?php echo htmlspecialchars($stock_item['code_barang_lemari5']); ?>"
                                                maxlength="3"
                                                onkeypress="return event.charCode >= 48 && event.charCode <= 57"
                                                onblur="validateAndUpdateCodeBarangStock(this)"
                                                oninput="this.value = this.value.replace(/[^0-9]/g, '')">
                                            <div class="validation-message" id="validation-<?php echo $stock_item['id']; ?>"></div>
                                        </div>

                                        <!-- NEW: Nomor Lemari (Display) -->
                                        <div>
                                            <label class="text-xs text-gray-600 block mb-1">Nomor Lemari</label>
                                            <span class="bg-purple-100 text-purple-800 px-3 py-1 rounded font-bold text-sm">
                                                <?php echo htmlspecialchars($stock_item['lemari_number'] ?? '-'); ?>
                                            </span>
                                        </div>

                                        <!-- Code Color -->
                                        <div>
                                            <label class="text-xs text-gray-600 block mb-1">Code Color</label>
                                            <span class="bg-blue-100 text-blue-800 px-3 py-1 rounded font-mono text-sm font-bold">
                                                <?php echo htmlspecialchars($stock_item['code_color']); ?>
                                            </span>
                                        </div>

                                        <!-- Qty -->
                                        <div>
                                            <label class="text-xs text-gray-600 block mb-1">Qty</label>
                                            <span class="bg-gray-100 px-3 py-1 rounded font-bold">
                                                <?php echo $stock_item['qty']; ?>
                                            </span>
                                        </div>

                                        <!-- Lokasi -->
                                        <div class="flex-1">
                                            <label class="text-xs text-gray-600 block mb-1">Lokasi Penyimpanan</label>
                                            <span class="text-sm text-gray-700">
                                                <i class="fas fa-map-marker-alt text-red-500 mr-1"></i>
                                                <?php echo htmlspecialchars($stock_item['lokasi_penyimpanan']); ?>
                                            </span>
                                        </div>

                                        <!-- Dates -->
                                        <div>
                                            <label class="text-xs text-gray-600 block mb-1">Tanggal</label>
                                            <div class="text-xs text-gray-600">
                                                <div>Prod: <?php echo date('d/m/Y', strtotime($stock_item['manufacturing_date'])); ?></div>
                                                <div>Exp: <?php echo date('d/m/Y', strtotime($stock_item['expired_date'])); ?></div>
                                            </div>
                                        </div>

                                        <!-- Status -->
                                        <div>
                                            <label class="text-xs text-gray-600 block mb-1">Status</label>
                                            <span class="<?php echo $status_classes[$stock_item['status']]; ?> px-2 py-1 rounded text-xs font-semibold">
                                                <?php echo $status_text[$stock_item['status']]; ?>
                                            </span>
                                        </div>
                                    </div>

                                    <!-- Actions -->
                                    <div class="flex items-center gap-2">
                                        <button 
                                            onclick="deleteStockItem(<?php echo $stock_item['id']; ?>, '<?php echo htmlspecialchars($stock_item['code_barang_lemari5']); ?>')"
                                            class="bg-red-500 hover:bg-red-600 text-white px-3 py-1 rounded text-sm transition-colors"
                                            title="Hapus">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </div>
                                </div>
                            <?php 
                                endwhile;
                            endif;
                            ?>
                        </div>
                    <?php 
                        endwhile;
                    else:
                    ?>
                        <div class="text-center py-8 text-gray-500">
                            <i class="fas fa-inbox text-4xl mb-2"></i>
                            <p>Belum ada stock items untuk master color ini</p>
                            <button 
                                onclick="showAddComponentModal(<?php echo $master_color_id; ?>, '<?php echo htmlspecialchars($master_color['master_code']); ?>', '<?php echo htmlspecialchars(addslashes($master_color['color_name'])); ?>')"
                                class="mt-3 bg-purple-600 hover:bg-purple-700 text-white px-4 py-2 rounded-lg transition-colors">
                                <i class="fas fa-plus mr-2"></i>Tambah Component Pertama
                            </button>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        <?php 
            endwhile;
        else:
        ?>
            <div class="bg-white rounded-lg shadow-md p-12 text-center">
                <i class="fas fa-inbox text-gray-300 text-6xl mb-4"></i>
                <p class="text-gray-500 text-lg">Tidak ada data master color</p>
            </div>
        <?php endif; ?>
    <?php endif; ?>
</div>

<!-- Modal: Tambah Component Baru -->
<div id="addComponentModal" class="hidden fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50">
    <div class="relative top-20 mx-auto p-5 border w-full max-w-2xl shadow-lg rounded-lg bg-white">
        <div class="flex items-center justify-between mb-4 border-b pb-3">
            <h3 class="text-xl font-bold text-gray-800">
                <i class="fas fa-plus-circle text-purple-600 mr-2"></i>
                Tambah Component Baru
            </h3>
            <button onclick="closeAddComponentModal()" class="text-gray-400 hover:text-gray-600">
                <i class="fas fa-times text-2xl"></i>
            </button>
        </div>

        <div id="masterColorInfo" class="mb-4 p-4 bg-purple-50 rounded-lg border border-purple-200"></div>

        <form id="formAddComponent" onsubmit="submitAddComponent(event)">
            <input type="hidden" id="selectedMasterColorId" name="master_color_id">

            <!-- Pilihan: Component Existing atau Baru -->
            <div class="mb-4">
                <label class="block text-gray-700 font-semibold mb-2">
                    Tipe Component <span class="text-red-500">*</span>
                </label>
                <div class="flex gap-4">
                    <label class="flex items-center cursor-pointer">
                        <input type="radio" name="component_type" value="existing" class="mr-2" checked onchange="toggleComponentType()">
                        <span>Component yang Sudah Ada</span>
                    </label>
                    <label class="flex items-center cursor-pointer">
                        <input type="radio" name="component_type" value="new" class="mr-2" onchange="toggleComponentType()">
                        <span>Component Baru</span>
                    </label>
                </div>
            </div>

            <!-- Pilih Component Existing -->
            <div id="existingComponentSection">
                <div class="mb-4">
                    <label class="block text-gray-700 font-semibold mb-2">
                        Pilih Component <span class="text-red-500">*</span>
                    </label>
                    <select 
                        id="existingComponentId" 
                        name="existing_component_id"
                        class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-500">
                        <option value="">-- Pilih Component --</option>
                        <?php 
                        $result_components->data_seek(0);
                        while($comp = $result_components->fetch_assoc()): 
                        ?>
                            <option value="<?php echo $comp['id']; ?>">
                                <?php echo htmlspecialchars($comp['component_name']); ?>
                            </option>
                        <?php endwhile; ?>
                    </select>
                </div>
            </div>

            <!-- Input Component Baru -->
            <div id="newComponentSection" style="display: none;">
                <div class="mb-4">
                    <label class="block text-gray-700 font-semibold mb-2">
                        Nama Component Baru <span class="text-red-500">*</span>
                    </label>
                    <input 
                        type="text" 
                        id="newComponentName" 
                        name="new_component_name"
                        class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-500"
                        placeholder="Masukkan nama component baru">
                </div>
                <div class="mb-4">
                    <label class="block text-gray-700 font-semibold mb-2">
                        Deskripsi Component
                    </label>
                    <textarea 
                        id="newComponentDescription" 
                        name="new_component_description"
                        class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-500"
                        rows="2"
                        placeholder="Deskripsi component (opsional)"></textarea>
                </div>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mb-4">
                <!-- Quantity -->
                <div>
                    <label class="block text-gray-700 font-semibold mb-2">
                        Quantity <span class="text-red-500">*</span>
                    </label>
                    <input 
                        type="number" 
                        id="componentQty" 
                        name="qty"
                        class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-500"
                        placeholder="Masukkan jumlah qty"
                        min="1"
                        required
                        onchange="updateCodeBarangPreviewModal()">
                    <p class="text-xs text-gray-500 mt-1">Akan generate <span id="qtyPreview">0</span> code barang</p>
                </div>

                <!-- Code Barang Start -->
                <div>
                    <label class="block text-gray-700 font-semibold mb-2">
                        Code Barang Lemari 5 (Start) <span class="text-red-500">*</span>
                    </label>
                    <input 
                        type="text" 
                        id="codeBarangStart" 
                        name="code_barang_start"
                        class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-500 font-mono font-bold"
                        placeholder="001"
                        maxlength="3"
                        required
                        onkeypress="return event.charCode >= 48 && event.charCode <= 57"
                        oninput="this.value = this.value.replace(/[^0-9]/g, ''); updateCodeBarangPreviewModal();"
                        onblur="validateCodeBarangModal(this)">
                    <div id="codeBarangValidation" class="text-xs mt-1"></div>
                </div>

                <!-- NEW: Nomor Lemari -->
                <div>
                    <label class="block text-gray-700 font-semibold mb-2">
                        Nomor Lemari <span class="text-red-500">*</span>
                    </label>
                    <input 
                        type="text" 
                        id="lemariNumber" 
                        name="lemari_number"
                        class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-500 font-bold"
                        placeholder="5, 6, 7, dst"
                        maxlength="10"
                        required>
                    <p class="text-xs text-gray-500 mt-1">Nomor lemari untuk stock ini</p>
                </div>
            </div>

            <!-- Preview Range -->
            <div class="mb-4 p-3 bg-blue-50 border border-blue-200 rounded-lg">
                <p class="text-sm text-blue-800">
                    <i class="fas fa-info-circle mr-1"></i>
                    Preview Range Code Barang: <strong id="codeBarangRange">-</strong>
                </p>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                <!-- Lokasi Penyimpanan -->
                <div>
                    <label class="block text-gray-700 font-semibold mb-2">
                        Lokasi Penyimpanan <span class="text-red-500">*</span>
                    </label>
                    <input 
                        type="text" 
                        id="lokasiPenyimpanan" 
                        name="lokasi_penyimpanan"
                        class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-500"
                        placeholder="Contoh: Color Room, Rack A 001"
                        required>
                </div>

                <!-- Manufacturing Date -->
                <div>
                    <label class="block text-gray-700 font-semibold mb-2">
                        Tanggal Produksi <span class="text-red-500">*</span>
                    </label>
                    <input 
                        type="date" 
                        id="manufacturingDate" 
                        name="manufacturing_date"
                        class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-500"
                        value="<?php echo date('Y-m-d'); ?>"
                        required>
                </div>
            </div>

            <div class="mb-4">
                <label class="block text-gray-700 font-semibold mb-2">
                    Tanggal Kadaluarsa <span class="text-red-500">*</span>
                </label>
                <input 
                    type="date" 
                    id="expiredDate" 
                    name="expired_date"
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-500"
                    value="<?php echo date('Y-m-d', strtotime('+1 year')); ?>"
                    required>
            </div>

            <div class="flex gap-3">
                <button 
                    type="submit" 
                    class="flex-1 bg-purple-600 hover:bg-purple-700 text-white font-bold py-3 px-4 rounded-lg transition-colors">
                    <i class="fas fa-save mr-2"></i> Simpan Component
                </button>
                <button 
                    type="button" 
                    onclick="closeAddComponentModal()"
                    class="flex-1 bg-gray-400 hover:bg-gray-500 text-white font-bold py-3 px-4 rounded-lg transition-colors">
                    <i class="fas fa-times mr-2"></i> Batal
                </button>
            </div>
        </form>
    </div>
</div>

<script>
function resetFilter() {
    window.location.href = 'add_component_stock.php';
}

function filterByBuyer() {
    const buyerId = document.getElementById('buyerFilter').value;
    if (buyerId == 0) {
        window.location.href = 'add_component_stock.php';
    } else {
        window.location.href = 'add_component_stock.php?buyer_id=' + buyerId;
    }
}

function filterByColor() {
    const buyerId = document.getElementById('buyerFilter').value;
    const colorId = document.getElementById('colorFilter').value;
    window.location.href = 'add_component_stock.php?buyer_id=' + buyerId + '&color_id=' + colorId;
}

// Modal Add Component
function showAddComponentModal(masterColorId, masterCode, colorName) {
    document.getElementById('selectedMasterColorId').value = masterColorId;
    document.getElementById('masterColorInfo').innerHTML = `
        <div class="flex items-center gap-3">
            <span class="bg-purple-600 text-white px-4 py-2 rounded font-bold">${masterCode}</span>
            <span class="font-semibold text-gray-800">${colorName}</span>
        </div>
    `;
    
    // Load next available code barang
    loadNextCodeBarangForModal();
    
    document.getElementById('addComponentModal').classList.remove('hidden');
}

function closeAddComponentModal() {
    document.getElementById('addComponentModal').classList.add('hidden');
    document.getElementById('formAddComponent').reset();
}

function toggleComponentType() {
    const componentType = document.querySelector('input[name="component_type"]:checked').value;
    
    if (componentType === 'existing') {
        document.getElementById('existingComponentSection').style.display = 'block';
        document.getElementById('newComponentSection').style.display = 'none';
        document.getElementById('existingComponentId').setAttribute('required', 'required');
        document.getElementById('newComponentName').removeAttribute('required');
    } else {
        document.getElementById('existingComponentSection').style.display = 'none';
        document.getElementById('newComponentSection').style.display = 'block';
        document.getElementById('existingComponentId').removeAttribute('required');
        document.getElementById('newComponentName').setAttribute('required', 'required');
    }
}

function loadNextCodeBarangForModal() {
    fetch('get_next_code_barang.php')
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                document.getElementById('codeBarangStart').value = data.formatted_code;
                updateCodeBarangPreviewModal();
            }
        })
        .catch(error => {
            console.error('Error:', error);
        });
}

function updateCodeBarangPreviewModal() {
    const qty = parseInt(document.getElementById('componentQty').value) || 0;
    const startCode = document.getElementById('codeBarangStart').value.trim();
    
    document.getElementById('qtyPreview').textContent = qty;
    
    if (qty > 0 && startCode && /^\d{1,3}$/.test(startCode)) {
        const start = parseInt(startCode);
        const end = start + qty - 1;
        
        if (end > 999) {
            document.getElementById('codeBarangRange').innerHTML = '<span class="text-red-600">Melebihi batas maksimal 999!</span>';
        } else {
            const rangeText = qty === 1 
                ? String(start).padStart(3, '0')
                : String(start).padStart(3, '0') + ' - ' + String(end).padStart(3, '0');
            document.getElementById('codeBarangRange').textContent = rangeText;
        }
    } else {
        document.getElementById('codeBarangRange').textContent = '-';
    }
}

function validateCodeBarangModal(input) {
    let value = input.value.trim();
    
    if (value === '') {
        return;
    }
    
    const codeNum = parseInt(value);
    if (isNaN(codeNum) || codeNum < 1 || codeNum > 999) {
        input.value = '';
        document.getElementById('codeBarangValidation').innerHTML = '<span class="text-red-600"><i class="fas fa-times-circle mr-1"></i>Code harus antara 001-999</span>';
        return;
    }
    
    input.value = String(codeNum).padStart(3, '0');
    
    // Check if code exists
    fetch('check_code_barang_range.php?code=' + input.value)
        .then(response => response.json())
        .then(data => {
            if (!data.success) {
                document.getElementById('codeBarangValidation').innerHTML = '<span class="text-red-600"><i class="fas fa-exclamation-triangle mr-1"></i>Error validasi</span>';
                return;
            }
            
            if (data.exists) {
                document.getElementById('codeBarangValidation').innerHTML = `
                    <span class="text-red-600">
                        <i class="fas fa-times-circle mr-1"></i>
                        Code sudah ada! Master: ${data.data.master_color}, Component: ${data.data.component}
                    </span>
                `;
                input.classList.add('border-red-500');
                input.classList.remove('border-green-500');
            } else {
                document.getElementById('codeBarangValidation').innerHTML = '<span class="text-green-600"><i class="fas fa-check-circle mr-1"></i>Code tersedia</span>';
                input.classList.remove('border-red-500');
                input.classList.add('border-green-500');
            }
        })
        .catch(error => {
            console.error('Error:', error);
        });
    
    updateCodeBarangPreviewModal();
}

function submitAddComponent(event) {
    event.preventDefault();
    
    const formData = new FormData(event.target);
    
    // Convert FormData to URLSearchParams
    const params = new URLSearchParams();
    for (const pair of formData.entries()) {
        params.append(pair[0], pair[1]);
    }
    params.append('action', 'add_component_to_master');
    
    fetch('process_component.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded',
        },
        body: params.toString()
    })
    .then(response => response.json())
    .then(data => {
        if(data.success) {
            alert('Component berhasil ditambahkan!');
            location.reload();
        } else {
            alert('Error: ' + data.message);
        }
    })
    .catch(error => {
        alert('Error: ' + error);
    });
}

// Tambah Qty ke Component yang sudah ada
function addQtyToComponent(masterColorId, componentId, componentName) {
    const qty = prompt(`Tambah berapa qty untuk component "${componentName}"?`, '1');
    
    if (qty === null || qty.trim() === '') return;
    
    const qtyNum = parseInt(qty);
    if (isNaN(qtyNum) || qtyNum < 1) {
        alert('Quantity harus minimal 1!');
        return;
    }
    
    // Redirect to add component modal with pre-filled data
    showAddComponentModal(masterColorId, '', '');
    
    // Pre-fill component
    setTimeout(() => {
        document.querySelector('input[name="component_type"][value="existing"]').checked = true;
        toggleComponentType();
        document.getElementById('existingComponentId').value = componentId;
        document.getElementById('componentQty').value = qtyNum;
        updateCodeBarangPreviewModal();
    }, 100);
}

// Validate and update code barang in stock item
function validateAndUpdateCodeBarangStock(input) {
    let value = input.value.trim();
    const stockId = input.dataset.stockId;
    const original = input.dataset.original;
    const validationDiv = document.getElementById('validation-' + stockId);
    
    if (value === original) {
        input.classList.remove('valid', 'invalid');
        validationDiv.innerHTML = '';
        return;
    }
    
    if (value === '') {
        input.value = original;
        return;
    }
    
    const codeNum = parseInt(value);
    if (isNaN(codeNum) || codeNum < 1 || codeNum > 999) {
        input.value = original;
        validationDiv.innerHTML = '<span class="text-red-600">Code harus 001-999</span>';
        return;
    }
    
    const formattedCode = String(codeNum).padStart(3, '0');
    input.value = formattedCode;
    
    // Check if code exists
    validationDiv.innerHTML = '<span class="text-gray-500"><i class="fas fa-spinner fa-spin mr-1"></i>Mengecek...</span>';
    
    fetch('check_code_barang_range.php?code=' + formattedCode)
        .then(response => response.json())
        .then(data => {
            if (!data.success) {
                validationDiv.innerHTML = '<span class="text-red-600">Error validasi</span>';
                input.value = original;
                return;
            }
            
            if (data.exists) {
                validationDiv.innerHTML = `<span class="text-red-600"><i class="fas fa-times-circle mr-1"></i>Sudah ada di ${data.data.master_color}</span>`;
                input.classList.remove('valid');
                input.classList.add('invalid');
                input.value = original;
            } else {
                // Update ke database
                updateCodeBarangInDatabase(stockId, formattedCode, input, validationDiv, original);
            }
        })
        .catch(error => {
            console.error('Error:', error);
            input.value = original;
            validationDiv.innerHTML = '<span class="text-red-600">Error validasi</span>';
        });
}

function updateCodeBarangInDatabase(stockId, newCode, input, validationDiv, originalCode) {
    fetch('process_component.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded',
        },
        body: `action=update_code_barang&stock_id=${stockId}&new_code=${newCode}`
    })
    .then(response => response.json())
    .then(data => {
        if(data.success) {
            validationDiv.innerHTML = '<span class="text-green-600"><i class="fas fa-check-circle mr-1"></i>Berhasil diupdate</span>';
            input.classList.remove('invalid');
            input.classList.add('valid');
            input.dataset.original = newCode;
            
            setTimeout(() => {
                validationDiv.innerHTML = '';
                input.classList.remove('valid');
            }, 3000);
        } else {
            validationDiv.innerHTML = '<span class="text-red-600">' + data.message + '</span>';
            input.value = originalCode;
        }
    })
    .catch(error => {
        console.error('Error:', error);
        validationDiv.innerHTML = '<span class="text-red-600">Error update</span>';
        input.value = originalCode;
    });
}

// Delete Stock Item
function deleteStockItem(stockId, codeBarang) {
    if(confirm(`Hapus stock item dengan code barang ${codeBarang}?`)) {
        fetch('process_component.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded',
            },
            body: `action=delete_stock_item&stock_id=${stockId}`
        })
        .then(response => response.json())
        .then(data => {
            if(data.success) {
                alert('Stock item berhasil dihapus!');
                location.reload();
            } else {
                alert('Error: ' + data.message);
            }
        })
        .catch(error => {
            alert('Error: ' + error);
        });
    }
}
</script>

<?php
include '../template_it/footer.php';
?>