<?php
$page_title = "History Peminjaman";
include '../template_borrower/header.php';

$borrower_id = $_SESSION['user_id'];

// Pagination
$items_per_page = 10;
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$offset = ($page - 1) * $items_per_page;

// Filter status
$filter_status = isset($_GET['status']) ? $_GET['status'] : 'all';

// Query untuk menghitung total data
$query_count = "SELECT COUNT(DISTINCT st.id) as total 
                FROM stock_transactions st
                WHERE st.borrower_id = ?";

if ($filter_status != 'all') {
    $query_count .= " AND st.status = ?";
}

$stmt_count = $conn->prepare($query_count);
if ($filter_status != 'all') {
    $stmt_count->bind_param("is", $borrower_id, $filter_status);
} else {
    $stmt_count->bind_param("i", $borrower_id);
}
$stmt_count->execute();
$result_count = $stmt_count->get_result();
$total_data = $result_count->fetch_assoc()['total'];
$total_pages = ceil($total_data / $items_per_page);
$stmt_count->close();

// Query untuk mengambil data transaksi
$query_transactions = "SELECT st.*, 
                       COUNT(ti.id) as total_items,
                       GROUP_CONCAT(ti.code_color SEPARATOR ', ') as code_colors
                       FROM stock_transactions st
                       LEFT JOIN transaction_items ti ON st.id = ti.transaction_id
                       WHERE st.borrower_id = ?";

if ($filter_status != 'all') {
    $query_transactions .= " AND st.status = ?";
}

$query_transactions .= " GROUP BY st.id 
                        ORDER BY st.transaction_date DESC 
                        LIMIT ? OFFSET ?";

$stmt_trans = $conn->prepare($query_transactions);
if ($filter_status != 'all') {
    $stmt_trans->bind_param("isii", $borrower_id, $filter_status, $items_per_page, $offset);
} else {
    $stmt_trans->bind_param("iii", $borrower_id, $items_per_page, $offset);
}
$stmt_trans->execute();
$result_trans = $stmt_trans->get_result();
?>

<div class="w-full max-w-7xl mx-auto px-2 sm:px-4">
    <!-- Page Header -->
    <div class="bg-gradient-to-r from-blue-500 to-indigo-600 rounded-lg shadow-lg p-4 sm:p-6 mb-4 sm:mb-6 text-white">
        <div class="flex items-center justify-between">
            <div>
                <div class="flex items-center mb-2">
                    <i class="fas fa-history text-3xl mr-3"></i>
                    <h2 class="text-2xl sm:text-3xl font-bold">History Peminjaman</h2>
                </div>
                <p class="text-sm opacity-90">Lihat semua riwayat peminjaman color panel Anda</p>
            </div>
            <div class="hidden sm:block">
                <div class="bg-white bg-opacity-20 rounded-lg p-3 text-center">
                    <p class="text-xs opacity-75">Total Transaksi</p>
                    <p class="text-2xl font-bold"><?php echo $total_data; ?></p>
                </div>
            </div>
        </div>
    </div>

    <!-- Filter & Statistics -->
    <div class="grid grid-cols-1 lg:grid-cols-4 gap-4 mb-6">
        <!-- Filter Status -->
        <div class="lg:col-span-4">
            <div class="bg-white rounded-lg shadow-md p-4">
                <h3 class="text-sm font-semibold text-gray-700 mb-3 flex items-center">
                    <i class="fas fa-filter text-blue-500 mr-2"></i>
                    Filter Status
                </h3>
                <div class="flex flex-wrap gap-2">
                    <a href="?status=all" class="px-4 py-2 rounded-lg text-sm font-medium transition-all <?php echo $filter_status == 'all' ? 'bg-blue-500 text-white' : 'bg-gray-100 text-gray-700 hover:bg-gray-200'; ?>">
                        <i class="fas fa-list mr-1"></i> Semua
                    </a>
                    <a href="?status=pending" class="px-4 py-2 rounded-lg text-sm font-medium transition-all <?php echo $filter_status == 'pending' ? 'bg-yellow-500 text-white' : 'bg-gray-100 text-gray-700 hover:bg-gray-200'; ?>">
                        <i class="fas fa-clock mr-1"></i> Pending
                    </a>
                    <a href="?status=approved" class="px-4 py-2 rounded-lg text-sm font-medium transition-all <?php echo $filter_status == 'approved' ? 'bg-green-500 text-white' : 'bg-gray-100 text-gray-700 hover:bg-gray-200'; ?>">
                        <i class="fas fa-check-circle mr-1"></i> Approved
                    </a>
                    <a href="?status=rejected" class="px-4 py-2 rounded-lg text-sm font-medium transition-all <?php echo $filter_status == 'rejected' ? 'bg-red-500 text-white' : 'bg-gray-100 text-gray-700 hover:bg-gray-200'; ?>">
                        <i class="fas fa-times-circle mr-1"></i> Rejected
                    </a>
                    <a href="?status=returned" class="px-4 py-2 rounded-lg text-sm font-medium transition-all <?php echo $filter_status == 'returned' ? 'bg-purple-500 text-white' : 'bg-gray-100 text-gray-700 hover:bg-gray-200'; ?>">
                        <i class="fas fa-undo mr-1"></i> Returned
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Transaction List -->
    <div class="bg-white rounded-lg shadow-md overflow-hidden">
        <?php if ($result_trans->num_rows > 0): ?>
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead class="bg-gradient-to-r from-gray-50 to-gray-100 border-b-2 border-gray-200">
                    <tr>
                        <th class="px-4 py-3 text-left text-xs font-semibold text-gray-700 uppercase tracking-wider">No. Transaksi</th>
                        <th class="px-4 py-3 text-left text-xs font-semibold text-gray-700 uppercase tracking-wider">Tanggal</th>
                        <th class="px-4 py-3 text-left text-xs font-semibold text-gray-700 uppercase tracking-wider">Total Item</th>
                        <th class="px-4 py-3 text-left text-xs font-semibold text-gray-700 uppercase tracking-wider">Status</th>
                        <th class="px-4 py-3 text-center text-xs font-semibold text-gray-700 uppercase tracking-wider">Aksi</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-200">
                    <?php while ($transaction = $result_trans->fetch_assoc()): ?>
                    <tr class="hover:bg-gray-50 transition-colors">
                        <td class="px-4 py-4">
                            <div class="flex items-center">
                                <div class="flex-shrink-0 h-10 w-10 bg-blue-100 rounded-full flex items-center justify-center">
                                    <i class="fas fa-receipt text-blue-600"></i>
                                </div>
                                <div class="ml-3">
                                    <p class="text-sm font-semibold text-gray-900"><?php echo htmlspecialchars($transaction['transaction_number']); ?></p>
                                    <p class="text-xs text-gray-500">
                                        <?php 
                                        $codes = explode(', ', $transaction['code_colors']);
                                        echo count($codes) > 3 ? implode(', ', array_slice($codes, 0, 3)) . '...' : $transaction['code_colors'];
                                        ?>
                                    </p>
                                </div>
                            </div>
                        </td>
                        <td class="px-4 py-4">
                            <p class="text-sm text-gray-900"><?php echo date('d M Y', strtotime($transaction['transaction_date'])); ?></p>
                            <p class="text-xs text-gray-500"><?php echo date('H:i', strtotime($transaction['transaction_date'])); ?> WIB</p>
                        </td>
                        <td class="px-4 py-4">
                            <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-purple-100 text-purple-800">
                                <i class="fas fa-box mr-1"></i>
                                <?php echo $transaction['total_items']; ?> Item
                            </span>
                        </td>
                        <td class="px-4 py-4">
                            <?php
                            $status_class = '';
                            $status_icon = '';
                            $status_text = '';
                            
                            switch($transaction['status']) {
                                case 'pending':
                                    $status_class = 'bg-yellow-100 text-yellow-800';
                                    $status_icon = 'fa-clock';
                                    $status_text = 'Pending';
                                    break;
                                case 'approved':
                                    $status_class = 'bg-green-100 text-green-800';
                                    $status_icon = 'fa-check-circle';
                                    $status_text = 'Approved';
                                    break;
                                case 'rejected':
                                    $status_class = 'bg-red-100 text-red-800';
                                    $status_icon = 'fa-times-circle';
                                    $status_text = 'Rejected';
                                    break;
                                case 'returned':
                                    $status_class = 'bg-purple-100 text-purple-800';
                                    $status_icon = 'fa-undo';
                                    $status_text = 'Returned';
                                    break;
                                default:
                                    $status_class = 'bg-gray-100 text-gray-800';
                                    $status_icon = 'fa-question-circle';
                                    $status_text = ucfirst($transaction['status']);
                            }
                            ?>
                            <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-semibold <?php echo $status_class; ?>">
                                <i class="fas <?php echo $status_icon; ?> mr-1"></i>
                                <?php echo $status_text; ?>
                            </span>
                        </td>
                        <td class="px-4 py-4 text-center">
                            <a href="detail_peminjaman.php?id=<?php echo $transaction['id']; ?>" 
                               class="inline-flex items-center px-4 py-2 bg-blue-500 hover:bg-blue-600 text-white text-sm font-medium rounded-lg transition-colors duration-200">
                                <i class="fas fa-eye mr-2"></i>
                                Detail
                            </a>
                        </td>
                    </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        <?php if ($total_pages > 1): ?>
        <div class="bg-gray-50 px-4 py-3 border-t border-gray-200 sm:px-6">
            <div class="flex items-center justify-between">
                <div class="flex-1 flex justify-between sm:hidden">
                    <?php if ($page > 1): ?>
                    <a href="?status=<?php echo $filter_status; ?>&page=<?php echo $page - 1; ?>" 
                       class="relative inline-flex items-center px-4 py-2 border border-gray-300 text-sm font-medium rounded-md text-gray-700 bg-white hover:bg-gray-50">
                        Previous
                    </a>
                    <?php endif; ?>
                    <?php if ($page < $total_pages): ?>
                    <a href="?status=<?php echo $filter_status; ?>&page=<?php echo $page + 1; ?>" 
                       class="ml-3 relative inline-flex items-center px-4 py-2 border border-gray-300 text-sm font-medium rounded-md text-gray-700 bg-white hover:bg-gray-50">
                        Next
                    </a>
                    <?php endif; ?>
                </div>
                <div class="hidden sm:flex-1 sm:flex sm:items-center sm:justify-between">
                    <div>
                        <p class="text-sm text-gray-700">
                            Menampilkan
                            <span class="font-medium"><?php echo $offset + 1; ?></span>
                            sampai
                            <span class="font-medium"><?php echo min($offset + $items_per_page, $total_data); ?></span>
                            dari
                            <span class="font-medium"><?php echo $total_data; ?></span>
                            transaksi
                        </p>
                    </div>
                    <div>
                        <nav class="relative z-0 inline-flex rounded-md shadow-sm -space-x-px" aria-label="Pagination">
                            <?php if ($page > 1): ?>
                            <a href="?status=<?php echo $filter_status; ?>&page=<?php echo $page - 1; ?>" 
                               class="relative inline-flex items-center px-2 py-2 rounded-l-md border border-gray-300 bg-white text-sm font-medium text-gray-500 hover:bg-gray-50">
                                <i class="fas fa-chevron-left"></i>
                            </a>
                            <?php endif; ?>
                            
                            <?php for ($i = 1; $i <= $total_pages; $i++): ?>
                                <?php if ($i == $page): ?>
                                <span class="relative inline-flex items-center px-4 py-2 border border-blue-500 bg-blue-500 text-sm font-medium text-white">
                                    <?php echo $i; ?>
                                </span>
                                <?php else: ?>
                                <a href="?status=<?php echo $filter_status; ?>&page=<?php echo $i; ?>" 
                                   class="relative inline-flex items-center px-4 py-2 border border-gray-300 bg-white text-sm font-medium text-gray-700 hover:bg-gray-50">
                                    <?php echo $i; ?>
                                </a>
                                <?php endif; ?>
                            <?php endfor; ?>
                            
                            <?php if ($page < $total_pages): ?>
                            <a href="?status=<?php echo $filter_status; ?>&page=<?php echo $page + 1; ?>" 
                               class="relative inline-flex items-center px-2 py-2 rounded-r-md border border-gray-300 bg-white text-sm font-medium text-gray-500 hover:bg-gray-50">
                                <i class="fas fa-chevron-right"></i>
                            </a>
                            <?php endif; ?>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
        <?php endif; ?>

        <?php else: ?>
        <!-- Empty State -->
        <div class="text-center py-16 px-4">
            <div class="inline-flex items-center justify-center w-24 h-24 bg-gray-100 rounded-full mb-4">
                <i class="fas fa-inbox text-gray-400 text-4xl"></i>
            </div>
            <h3 class="text-xl font-semibold text-gray-700 mb-2">Belum Ada Transaksi</h3>
            <p class="text-gray-500 mb-6">
                <?php if ($filter_status != 'all'): ?>
                    Tidak ada transaksi dengan status "<?php echo ucfirst($filter_status); ?>"
                <?php else: ?>
                    Anda belum pernah melakukan peminjaman color panel
                <?php endif; ?>
            </p>
            <?php if ($filter_status != 'all'): ?>
            <a href="?status=all" class="inline-flex items-center px-6 py-3 bg-blue-500 hover:bg-blue-600 text-white font-medium rounded-lg transition-colors duration-200">
                <i class="fas fa-list mr-2"></i>
                Lihat Semua Transaksi
            </a>
            <?php else: ?>
            <a href="ajukan_peminjaman.php" class="inline-flex items-center px-6 py-3 bg-purple-500 hover:bg-purple-600 text-white font-medium rounded-lg transition-colors duration-200">
                <i class="fas fa-plus-circle mr-2"></i>
                Ajukan Peminjaman Sekarang
            </a>
            <?php endif; ?>
        </div>
        <?php endif; ?>
    </div>
</div>

<?php
$stmt_trans->close();
include '../template_borrower/footer.php';
?>