<?php
$page_title = "Detail Peminjaman";
include '../template_borrower/header.php';

$borrower_id = $_SESSION['user_id'];
$transaction_id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

// Query untuk mengambil data transaksi
$query_transaction = "SELECT st.*, bu.nama_borrower, bu.nik, bu.email,
                      wc.wc_code, wc.wc_description
                      FROM stock_transactions st
                      JOIN borrower_users bu ON st.borrower_id = bu.id
                      LEFT JOIN wc_master wc ON bu.wc_id = wc.id
                      WHERE st.id = ? AND st.borrower_id = ?";
$stmt_trans = $conn->prepare($query_transaction);
$stmt_trans->bind_param("ii", $transaction_id, $borrower_id);
$stmt_trans->execute();
$result_trans = $stmt_trans->get_result();

if ($result_trans->num_rows == 0) {
    header("Location: history_peminjaman.php");
    exit();
}

$transaction = $result_trans->fetch_assoc();
$stmt_trans->close();

// Query untuk mengambil item-item yang dipinjam
$query_items = "SELECT ti.*, mc.color_name, csi.lokasi_penyimpanan, csi.lemari_number,
                csi.manufacturing_date, csi.expired_date
                FROM transaction_items ti
                JOIN color_stock_items csi ON ti.stock_item_id = csi.id
                JOIN master_color mc ON csi.master_color_id = mc.id
                WHERE ti.transaction_id = ?";
$stmt_items = $conn->prepare($query_items);
$stmt_items->bind_param("i", $transaction_id);
$stmt_items->execute();
$result_items = $stmt_items->get_result();
?>

<div class="w-full max-w-7xl mx-auto px-2 sm:px-4">
    <!-- Back Button -->
    <div class="mb-4">
        <a href="history_peminjaman.php" class="inline-flex items-center text-blue-600 hover:text-blue-800 font-medium transition-colors">
            <i class="fas fa-arrow-left mr-2"></i>
            Kembali ke History
        </a>
    </div>

    <!-- Transaction Header -->
    <div class="bg-gradient-to-r from-purple-500 to-indigo-600 rounded-lg shadow-lg p-6 mb-6 text-white">
        <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between gap-4">
            <div>
                <div class="flex items-center mb-2">
                    <i class="fas fa-file-invoice text-3xl mr-3"></i>
                    <h2 class="text-2xl sm:text-3xl font-bold">Detail Peminjaman</h2>
                </div>
                <p class="text-lg opacity-90">No. Transaksi: <span class="font-bold"><?php echo htmlspecialchars($transaction['transaction_number']); ?></span></p>
            </div>
            <div>
                <?php
                $status_class = '';
                $status_icon = '';
                $status_text = '';
                
                switch($transaction['status']) {
                    case 'pending':
                        $status_class = 'bg-yellow-500';
                        $status_icon = 'fa-clock';
                        $status_text = 'Pending Approval';
                        break;
                    case 'approved':
                        $status_class = 'bg-green-500';
                        $status_icon = 'fa-check-circle';
                        $status_text = 'Approved';
                        break;
                    case 'rejected':
                        $status_class = 'bg-red-500';
                        $status_icon = 'fa-times-circle';
                        $status_text = 'Rejected';
                        break;
                    case 'returned':
                        $status_class = 'bg-purple-500';
                        $status_icon = 'fa-undo';
                        $status_text = 'Returned';
                        break;
                }
                ?>
                <div class="inline-flex items-center px-6 py-3 <?php echo $status_class; ?> bg-opacity-90 rounded-lg text-white font-bold text-lg shadow-lg">
                    <i class="fas <?php echo $status_icon; ?> mr-2"></i>
                    <?php echo $status_text; ?>
                </div>
            </div>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <!-- Informasi Peminjam -->
        <div class="lg:col-span-1">
            <div class="bg-white rounded-lg shadow-md p-6 mb-6">
                <h3 class="text-lg font-bold text-gray-800 mb-4 flex items-center border-b pb-3">
                    <i class="fas fa-user-circle text-purple-500 mr-2 text-xl"></i>
                    Informasi Peminjam
                </h3>
                <div class="space-y-3">
                    <div>
                        <p class="text-xs text-gray-500 mb-1">Nama Lengkap</p>
                        <p class="text-sm font-semibold text-gray-800"><?php echo htmlspecialchars($transaction['nama_borrower']); ?></p>
                    </div>
                    <div>
                        <p class="text-xs text-gray-500 mb-1">NIK</p>
                        <p class="text-sm font-semibold text-gray-800"><?php echo htmlspecialchars($transaction['nik']); ?></p>
                    </div>
                    <div>
                        <p class="text-xs text-gray-500 mb-1">Email</p>
                        <p class="text-sm font-semibold text-gray-800"><?php echo htmlspecialchars($transaction['email']); ?></p>
                    </div>
                    <div>
                        <p class="text-xs text-gray-500 mb-1">Work Center</p>
                        <p class="text-sm font-semibold text-gray-800">
                            <?php echo htmlspecialchars($transaction['wc_code']); ?> - 
                            <?php echo htmlspecialchars($transaction['wc_description']); ?>
                        </p>
                    </div>
                </div>
            </div>

            <!-- Timeline Peminjaman -->
            <div class="bg-white rounded-lg shadow-md p-6">
                <h3 class="text-lg font-bold text-gray-800 mb-4 flex items-center border-b pb-3">
                    <i class="fas fa-calendar-alt text-blue-500 mr-2 text-xl"></i>
                    Timeline Peminjaman
                </h3>
                <div class="space-y-4">
                    <div class="flex items-start">
                        <div class="flex-shrink-0 w-10 h-10 bg-blue-100 rounded-full flex items-center justify-center">
                            <i class="fas fa-calendar-plus text-blue-600"></i>
                        </div>
                        <div class="ml-3 flex-1">
                            <p class="text-xs text-gray-500">Tanggal Pengajuan</p>
                            <p class="text-sm font-semibold text-gray-800">
                                <?php echo date('d M Y, H:i', strtotime($transaction['transaction_date'])); ?> WIB
                            </p>
                        </div>
                    </div>
                    
                    <?php if (!empty($transaction['expected_return_date'])): ?>
                    <div class="flex items-start">
                        <div class="flex-shrink-0 w-10 h-10 bg-orange-100 rounded-full flex items-center justify-center">
                            <i class="fas fa-calendar-check text-orange-600"></i>
                        </div>
                        <div class="ml-3 flex-1">
                            <p class="text-xs text-gray-500">Estimasi Pengembalian</p>
                            <p class="text-sm font-semibold text-gray-800">
                                <?php echo date('d M Y', strtotime($transaction['expected_return_date'])); ?>
                            </p>
                            <p class="text-xs text-gray-500 mt-1">
                                <i class="fas fa-hourglass-half mr-1"></i>
                                Durasi: 90 hari
                            </p>
                        </div>
                    </div>
                    <?php endif; ?>

                    <?php 
                    // Check if any item has actual_return_date
                    $items_temp = $result_items->fetch_all(MYSQLI_ASSOC);
                    $has_return = false;
                    $return_date = null;
                    foreach ($items_temp as $item_temp) {
                        if (!empty($item_temp['actual_return_date'])) {
                            $has_return = true;
                            $return_date = $item_temp['actual_return_date'];
                            break;
                        }
                    }
                    // Reset result pointer
                    $result_items->data_seek(0);
                    
                    if ($has_return): 
                    ?>
                    <div class="flex items-start">
                        <div class="flex-shrink-0 w-10 h-10 bg-green-100 rounded-full flex items-center justify-center">
                            <i class="fas fa-check-circle text-green-600"></i>
                        </div>
                        <div class="ml-3 flex-1">
                            <p class="text-xs text-gray-500">Tanggal Pengembalian</p>
                            <p class="text-sm font-semibold text-gray-800">
                                <?php echo date('d M Y, H:i', strtotime($return_date)); ?> WIB
                            </p>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Item yang Dipinjam -->
        <div class="lg:col-span-2">
            <div class="bg-white rounded-lg shadow-md p-6">
                <h3 class="text-lg font-bold text-gray-800 mb-4 flex items-center justify-between border-b pb-3">
                    <span>
                        <i class="fas fa-boxes text-indigo-500 mr-2 text-xl"></i>
                        Item yang Dipinjam
                    </span>
                    <span class="bg-indigo-100 text-indigo-800 text-sm font-semibold px-3 py-1 rounded-full">
                        <?php echo count($items_temp); ?> Item
                    </span>
                </h3>

                <div class="space-y-4">
                    <?php 
                    $item_number = 1;
                    foreach ($items_temp as $item): 
                    ?>
                    <div class="border border-gray-200 rounded-lg p-4 hover:shadow-md transition-shadow">
                        <div class="flex items-start justify-between mb-3">
                            <div class="flex items-start">
                                <div class="flex-shrink-0 w-12 h-12 bg-gradient-to-br from-purple-100 to-indigo-100 rounded-lg flex items-center justify-center mr-3">
                                    <span class="text-purple-600 font-bold text-lg">#<?php echo $item_number; ?></span>
                                </div>
                                <div>
                                    <h4 class="font-bold text-gray-800 text-lg mb-1">
                                        <?php echo htmlspecialchars($item['color_name']); ?>
                                    </h4>
                                    <p class="text-sm text-gray-600">
                                        <span class="inline-flex items-center bg-purple-100 text-purple-800 px-2 py-1 rounded text-xs font-semibold">
                                            <i class="fas fa-barcode mr-1"></i>
                                            <?php echo htmlspecialchars($item['code_color']); ?>
                                        </span>
                                    </p>
                                </div>
                            </div>
                            <?php
                            $item_status_class = '';
                            $item_status_icon = '';
                            $item_status_text = '';
                            
                            switch($item['borrow_status']) {
                                case 'pending':
                                    $item_status_class = 'bg-yellow-100 text-yellow-800';
                                    $item_status_icon = 'fa-clock';
                                    $item_status_text = 'Pending';
                                    break;
                                case 'approved':
                                    $item_status_class = 'bg-green-100 text-green-800';
                                    $item_status_icon = 'fa-check-circle';
                                    $item_status_text = 'Approved';
                                    break;
                                case 'rejected':
                                    $item_status_class = 'bg-red-100 text-red-800';
                                    $item_status_icon = 'fa-times-circle';
                                    $item_status_text = 'Rejected';
                                    break;
                                case 'borrowed':
                                    $item_status_class = 'bg-blue-100 text-blue-800';
                                    $item_status_icon = 'fa-hand-holding';
                                    $item_status_text = 'Borrowed';
                                    break;
                                case 'returned':
                                    $item_status_class = 'bg-purple-100 text-purple-800';
                                    $item_status_icon = 'fa-undo';
                                    $item_status_text = 'Returned';
                                    break;
                            }
                            ?>
                            <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-semibold <?php echo $item_status_class; ?>">
                                <i class="fas <?php echo $item_status_icon; ?> mr-1"></i>
                                <?php echo $item_status_text; ?>
                            </span>
                        </div>

                        <div class="grid grid-cols-2 gap-4 bg-gray-50 rounded-lg p-3">
                            <div>
                                <p class="text-xs text-gray-500 mb-1">
                                    <i class="fas fa-map-marker-alt mr-1"></i>
                                    Lokasi
                                </p>
                                <p class="text-sm font-semibold text-gray-800">
                                    <?php echo htmlspecialchars($item['lokasi_penyimpanan'] ?? '-'); ?>
                                </p>
                            </div>
                            <div>
                                <p class="text-xs text-gray-500 mb-1">
                                    <i class="fas fa-archive mr-1"></i>
                                    Lemari
                                </p>
                                <p class="text-sm font-semibold text-gray-800">
                                    <?php echo htmlspecialchars($item['lemari_number'] ?? '-'); ?>
                                </p>
                            </div>
                            <div>
                                <p class="text-xs text-gray-500 mb-1">
                                    <i class="fas fa-calendar-day mr-1"></i>
                                    Tgl. Peminjaman
                                </p>
                                <p class="text-sm font-semibold text-gray-800">
                                    <?php echo !empty($item['borrow_date']) ? date('d M Y', strtotime($item['borrow_date'])) : '-'; ?>
                                </p>
                            </div>
                            <div>
                                <p class="text-xs text-gray-500 mb-1">
                                    <i class="fas fa-calendar-times mr-1"></i>
                                    Expired Date
                                </p>
                                <p class="text-sm font-semibold text-gray-800">
                                    <?php echo !empty($item['expired_date_after_borrow']) ? date('d M Y', strtotime($item['expired_date_after_borrow'])) : '-'; ?>
                                </p>
                            </div>
                        </div>

                        <?php if (!empty($item['return_condition'])): ?>
                        <div class="mt-3 p-3 bg-blue-50 border border-blue-200 rounded-lg">
                            <p class="text-xs text-blue-700 font-semibold mb-1">
                                <i class="fas fa-info-circle mr-1"></i>
                                Kondisi Pengembalian
                            </p>
                            <p class="text-sm text-blue-800 capitalize">
                                <?php echo htmlspecialchars($item['return_condition']); ?>
                            </p>
                            <?php if (!empty($item['return_notes'])): ?>
                            <p class="text-xs text-blue-600 mt-2">
                                Catatan: <?php echo htmlspecialchars($item['return_notes']); ?>
                            </p>
                            <?php endif; ?>
                        </div>
                        <?php endif; ?>
                    </div>
                    <?php 
                    $item_number++;
                    endforeach; 
                    ?>
                </div>

                <?php if (!empty($transaction['notes'])): ?>
                <div class="mt-6 p-4 bg-yellow-50 border-l-4 border-yellow-400 rounded">
                    <h4 class="text-sm font-bold text-yellow-800 mb-2">
                        <i class="fas fa-sticky-note mr-2"></i>
                        Catatan Transaksi
                    </h4>
                    <p class="text-sm text-yellow-700"><?php echo nl2br(htmlspecialchars($transaction['notes'])); ?></p>
                </div>
                <?php endif; ?>
            </div>

            <!-- Action Buttons -->
            <div class="mt-6 flex flex-col sm:flex-row gap-3">
                <a href="history_peminjaman.php" class="flex-1 inline-flex items-center justify-center px-6 py-3 bg-gray-500 hover:bg-gray-600 text-white font-semibold rounded-lg transition-colors duration-200">
                    <i class="fas fa-arrow-left mr-2"></i>
                    Kembali ke History
                </a>
                <button onclick="window.print()" class="flex-1 inline-flex items-center justify-center px-6 py-3 bg-blue-500 hover:bg-blue-600 text-white font-semibold rounded-lg transition-colors duration-200">
                    <i class="fas fa-print mr-2"></i>
                    Cetak Detail
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Print Styles -->
<style>
@media print {
    body * {
        visibility: hidden;
    }
    .w-full.max-w-7xl, .w-full.max-w-7xl * {
        visibility: visible;
    }
    .w-full.max-w-7xl {
        position: absolute;
        left: 0;
        top: 0;
    }
    button, .bg-gray-500, .fas.fa-arrow-left {
        display: none !important;
    }
}
</style>

<?php
$stmt_items->close();
include '../template_borrower/footer.php';
?>