<?php
$page_title = "Ajukan Peminjaman";
include '../template_borrower/header.php';

$borrower_id = $_SESSION['user_id'];

if (!isset($_SESSION['cart'])) {
    $_SESSION['cart'] = array();
}

if (isset($_POST['add_to_cart'])) {
    $code_color = trim($_POST['code_color']);
    
    $query_check = "SELECT csi.*, mc.color_name 
                    FROM color_stock_items csi
                    JOIN master_color mc ON csi.master_color_id = mc.id
                    WHERE csi.code_color = ? AND csi.status = 'available'";
    $stmt_check = $conn->prepare($query_check);
    $stmt_check->bind_param("s", $code_color);
    $stmt_check->execute();
    $result_check = $stmt_check->get_result();
    
    if ($result_check->num_rows > 0) {
        $item = $result_check->fetch_assoc();
        
        $already_in_cart = false;
        foreach ($_SESSION['cart'] as $cart_item) {
            if ($cart_item['code_color'] == $code_color) {
                $already_in_cart = true;
                break;
            }
        }
        
        if (!$already_in_cart) {
            $_SESSION['cart'][] = array(
                'code_color' => $item['code_color'],
                'stock_item_id' => $item['id'],
                'color_name' => $item['color_name'],
                'lokasi_penyimpanan' => $item['lokasi_penyimpanan'],
                'lemari_number' => $item['lemari_number']
            );
            echo json_encode(['success' => true, 'message' => 'Item berhasil ditambahkan ke keranjang!']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Item sudah ada di keranjang!']);
        }
    } else {
        echo json_encode(['success' => false, 'message' => 'Code Color tidak ditemukan atau tidak tersedia!']);
    }
    $stmt_check->close();
    exit();
}

if (isset($_GET['remove'])) {
    $remove_index = $_GET['remove'];
    if (isset($_SESSION['cart'][$remove_index])) {
        unset($_SESSION['cart'][$remove_index]);
        $_SESSION['cart'] = array_values($_SESSION['cart']);
        $success_message = "Item berhasil dihapus dari keranjang!";
    }
}

if (isset($_POST['submit_peminjaman'])) {
    if (count($_SESSION['cart']) > 0) {
        $conn->begin_transaction();
        
        try {
            $week_number = date('W');
            
            $query_last_resv = "SELECT transaction_number FROM stock_transactions 
                               WHERE transaction_number LIKE ? 
                               ORDER BY id DESC LIMIT 1";
            $like_pattern = "resv/%/" . $week_number;
            $stmt_last = $conn->prepare($query_last_resv);
            $stmt_last->bind_param("s", $like_pattern);
            $stmt_last->execute();
            $result_last = $stmt_last->get_result();
            
            if ($result_last->num_rows > 0) {
                $last_resv = $result_last->fetch_assoc()['transaction_number'];
                $parts = explode('/', $last_resv);
                $last_number = intval($parts[1]);
                $new_number = $last_number + 1;
            } else {
                $new_number = 1;
            }
            $stmt_last->close();
            
            $transaction_number = sprintf("resv/%06d/%s", $new_number, $week_number);
            
            $transaction_date = date('Y-m-d H:i:s');
            $expected_return_date = date('Y-m-d H:i:s', strtotime('+90 days'));
            
            $query_transaction = "INSERT INTO stock_transactions 
                                 (transaction_number, borrower_id, transaction_date, expected_return_date, status) 
                                 VALUES (?, ?, ?, ?, 'pending')";
            $stmt_trans = $conn->prepare($query_transaction);
            $stmt_trans->bind_param("siss", $transaction_number, $borrower_id, $transaction_date, $expected_return_date);
            $stmt_trans->execute();
            $transaction_id = $conn->insert_id;
            $stmt_trans->close();
            
            $borrow_date = date('Y-m-d H:i:s');
            $expected_return = date('Y-m-d H:i:s', strtotime('+90 days'));
            $expired_date_after_borrow = date('Y-m-d', strtotime('+90 days'));
            
            foreach ($_SESSION['cart'] as $item) {
                $query_expired = "SELECT expired_date FROM color_stock_items WHERE id = ?";
                $stmt_expired = $conn->prepare($query_expired);
                $stmt_expired->bind_param("i", $item['stock_item_id']);
                $stmt_expired->execute();
                $result_expired = $stmt_expired->get_result();
                $expired_data = $result_expired->fetch_assoc();
                $expired_date_before = $expired_data['expired_date'];
                $stmt_expired->close();
                
                $query_item = "INSERT INTO transaction_items 
                              (transaction_id, stock_item_id, code_color, borrower_id, borrow_date, expected_return_date, expired_date_before_borrow, expired_date_after_borrow) 
                              VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
                $stmt_item = $conn->prepare($query_item);
                $stmt_item->bind_param("iisisss",
                    $transaction_id,
                    $item['stock_item_id'],
                    $item['code_color'],
                    $borrower_id,
                    $borrow_date,
                    $expected_return,
                    $expired_date_before,
                    $expired_date_after_borrow
                );
                $stmt_item->execute();
                $stmt_item->close();
                
                $query_update = "UPDATE color_stock_items SET status = 'borrowed' WHERE code_color = ?";
                $stmt_update = $conn->prepare($query_update);
                $stmt_update->bind_param("s", $item['code_color']);
                $stmt_update->execute();
                $stmt_update->close();
            }
            
            $conn->commit();
            $_SESSION['cart'] = array();
            $peminjaman_success = true;
            
        } catch (Exception $e) {
            $conn->rollback();
            $error_message = "Terjadi kesalahan: " . $e->getMessage();
        }
    } else {
        $error_message = "Keranjang kosong!";
    }
}
?>

<?php if (isset($peminjaman_success) && $peminjaman_success): ?>
<div id="successPopup" class="fixed inset-0 bg-black bg-opacity-60 flex items-center justify-center z-50" style="animation: fadeIn 0.4s;">
    <div class="bg-white rounded-2xl shadow-2xl max-w-2xl w-full mx-4" style="animation: slideInScale 0.4s;">
        <div class="p-8 sm:p-12">
            <div class="text-center mb-6">
                <img src="../images/notif.png" alt="Success" class="w-40 h-40 sm:w-56 sm:h-56 mx-auto">
            </div>
            
            <div class="text-center mb-6">
                <div class="inline-flex items-center justify-center w-20 h-20 bg-green-100 rounded-full mb-4">
                    <i class="fas fa-check text-green-600 text-4xl"></i>
                </div>
                <h3 class="text-3xl sm:text-4xl font-bold text-gray-800 mb-3">Peminjaman Berhasil!</h3>
                <p class="text-gray-600 text-base sm:text-lg">Pengajuan peminjaman Anda telah berhasil dan menunggu persetujuan</p>
            </div>
            
            <div class="bg-gradient-to-r from-purple-50 to-indigo-50 rounded-xl p-6 mb-6 border-2 border-purple-200">
                <div class="flex items-center justify-center mb-2">
                    <i class="fas fa-receipt text-purple-600 text-2xl mr-3"></i>
                    <p class="text-sm text-gray-600 font-medium">Nomor Transaksi</p>
                </div>
                <p class="text-3xl sm:text-4xl font-bold text-purple-600 text-center tracking-wider"><?php echo $transaction_number; ?></p>
            </div>
            
            <div class="bg-blue-50 border border-blue-200 rounded-lg p-4 mb-6">
                <div class="flex items-start">
                    <i class="fas fa-info-circle text-blue-600 text-xl mr-3 mt-1"></i>
                    <p class="text-sm text-blue-800">Silakan catat nomor transaksi di atas untuk melihat status peminjaman Anda.</p>
                </div>
            </div>
            
            <div class="space-y-3">
                <button onclick="closePopup()" class="w-full bg-gradient-to-r from-purple-500 to-indigo-600 hover:from-purple-600 hover:to-indigo-700 text-white font-bold py-4 px-6 rounded-xl transition duration-200 shadow-lg text-base sm:text-lg">
                    <i class="fas fa-check-circle mr-2"></i>
                    OK, Saya Mengerti
                </button>
            </div>
        </div>
    </div>
</div>

<style>
@keyframes fadeIn {
    from { opacity: 0; }
    to { opacity: 1; }
}
@keyframes slideInScale {
    from { 
        transform: translateY(-30px) scale(0.95);
        opacity: 0;
    }
    to { 
        transform: translateY(0) scale(1);
        opacity: 1;
    }
}
@keyframes fadeOut {
    from { opacity: 1; }
    to { opacity: 0; }
}
</style>

<script>
function closePopup() {
    document.getElementById('successPopup').style.animation = 'fadeOut 0.3s';
    setTimeout(function() {
        window.location.href = 'ajukan_peminjaman.php';
    }, 300);
}
</script>
<?php endif; ?>

<div class="w-full max-w-7xl mx-auto px-2 sm:px-4">
    <div class="bg-white rounded-lg shadow-md p-4 sm:p-6 mb-4 sm:mb-6">
        <div class="flex items-center mb-2">
            <i class="fas fa-clipboard-list text-purple-500 text-2xl mr-3"></i>
            <h2 class="text-xl sm:text-2xl font-bold text-gray-800">Ajukan Peminjaman</h2>
        </div>
        <p class="text-sm text-gray-600">Scan barcode color panel yang ingin dipinjam</p>
    </div>

    <?php if (isset($success_message)): ?>
    <div class="bg-green-100 border-l-4 border-green-500 text-green-700 p-4 mb-4 rounded" id="alertMessage">
        <div class="flex items-center">
            <i class="fas fa-check-circle mr-2"></i>
            <p><?php echo $success_message; ?></p>
        </div>
    </div>
    <script>
    setTimeout(function() {
        document.getElementById('alertMessage').style.display = 'none';
    }, 3000);
    </script>
    <?php endif; ?>

    <?php if (isset($error_message)): ?>
    <div class="bg-red-100 border-l-4 border-red-500 text-red-700 p-4 mb-4 rounded" id="alertMessage">
        <div class="flex items-center">
            <i class="fas fa-exclamation-circle mr-2"></i>
            <p><?php echo $error_message; ?></p>
        </div>
    </div>
    <script>
    setTimeout(function() {
        document.getElementById('alertMessage').style.display = 'none';
    }, 3000);
    </script>
    <?php endif; ?>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-4 sm:gap-6">
        <div class="lg:col-span-1">
            <div class="bg-white rounded-lg shadow-md p-4 sm:p-6">
                <h3 class="text-lg font-bold text-gray-800 mb-4 flex items-center">
                    <i class="fas fa-barcode text-purple-500 mr-2"></i>
                    Scan Barcode
                </h3>
                
                <!-- Scanner Area -->
                <div class="space-y-4">
                    <div id="reader" class="w-full rounded-lg overflow-hidden border-2 border-gray-300"></div>
                    
                    <button id="startScanBtn" onclick="startScanner()" class="w-full bg-green-500 hover:bg-green-600 text-white font-semibold py-3 px-4 rounded-lg transition duration-200 flex items-center justify-center">
                        <i class="fas fa-camera mr-2"></i>
                        Mulai Scan
                    </button>
                    
                    <button id="stopScanBtn" onclick="stopScanner()" class="w-full bg-red-500 hover:bg-red-600 text-white font-semibold py-3 px-4 rounded-lg transition duration-200 flex items-center justify-center hidden">
                        <i class="fas fa-stop-circle mr-2"></i>
                        Stop Scan
                    </button>
                    
                    <div id="scanStatus" class="text-center p-3 rounded-lg bg-gray-100 text-gray-600 text-sm hidden">
                        <i class="fas fa-info-circle mr-2"></i>
                        <span id="statusText">Siap untuk scan</span>
                    </div>
                </div>

                <div class="mt-6 bg-blue-50 border border-blue-200 rounded-lg p-3">
                    <h4 class="text-sm font-semibold text-blue-800 mb-2 flex items-center">
                        <i class="fas fa-info-circle mr-2"></i>
                        Cara Menggunakan
                    </h4>
                    <ul class="text-xs text-blue-700 space-y-1">
                        <li class="flex items-start">
                            <i class="fas fa-check text-blue-500 mr-2 mt-0.5"></i>
                            <span>Klik tombol "Mulai Scan"</span>
                        </li>
                        <li class="flex items-start">
                            <i class="fas fa-check text-blue-500 mr-2 mt-0.5"></i>
                            <span>Arahkan kamera ke barcode</span>
                        </li>
                        <li class="flex items-start">
                            <i class="fas fa-check text-blue-500 mr-2 mt-0.5"></i>
                            <span>Item otomatis masuk keranjang</span>
                        </li>
                        <li class="flex items-start">
                            <i class="fas fa-check text-blue-500 mr-2 mt-0.5"></i>
                            <span>Scan lagi untuk tambah item</span>
                        </li>
                    </ul>
                </div>

                <div class="mt-4 bg-yellow-50 border border-yellow-200 rounded-lg p-3">
                    <h4 class="text-sm font-semibold text-yellow-800 mb-2 flex items-center">
                        <i class="fas fa-clock mr-2"></i>
                        Informasi Peminjaman
                    </h4>
                    <ul class="text-xs text-yellow-700 space-y-1">
                        <li class="flex items-start">
                            <i class="fas fa-check text-yellow-500 mr-2 mt-0.5"></i>
                            <span>Durasi: 90 hari (3 bulan)</span>
                        </li>
                        <li class="flex items-start">
                            <i class="fas fa-check text-yellow-500 mr-2 mt-0.5"></i>
                            <span>Status: Pending approval</span>
                        </li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="lg:col-span-2">
            <div class="bg-white rounded-lg shadow-md p-4 sm:p-6">
                <div class="flex items-center justify-between mb-4">
                    <h3 class="text-lg font-bold text-gray-800 flex items-center">
                        <i class="fas fa-shopping-cart text-purple-500 mr-2"></i>
                        Keranjang Peminjaman
                        <span class="ml-2 bg-purple-500 text-white text-xs px-2 py-1 rounded-full" id="cartCount">
                            <?php echo count($_SESSION['cart']); ?>
                        </span>
                    </h3>
                </div>

                <div id="cartItems">
                    <?php if (count($_SESSION['cart']) > 0): ?>
                    <div class="space-y-3 mb-6">
                        <?php foreach ($_SESSION['cart'] as $index => $item): ?>
                        <div class="bg-gray-50 rounded-lg p-4 border border-gray-200 hover:shadow-md transition-shadow">
                            <div class="flex items-start justify-between">
                                <div class="flex-1">
                                    <div class="flex items-center mb-2">
                                        <span class="bg-purple-100 text-purple-800 text-xs font-semibold px-2 py-1 rounded">
                                            <?php echo htmlspecialchars($item['code_color']); ?>
                                        </span>
                                    </div>
                                    <h4 class="font-semibold text-gray-800 mb-1">
                                        <?php echo htmlspecialchars($item['color_name']); ?>
                                    </h4>
                                    <div class="grid grid-cols-2 gap-2 text-xs text-gray-600">
                                        <div>
                                            <span class="font-medium">Lokasi:</span> 
                                            <?php echo htmlspecialchars($item['lokasi_penyimpanan'] ?? '-'); ?>
                                        </div>
                                        <div>
                                            <span class="font-medium">Lemari:</span> 
                                            <?php echo htmlspecialchars($item['lemari_number'] ?? '-'); ?>
                                        </div>
                                    </div>
                                </div>
                                <a href="?remove=<?php echo $index; ?>" 
                                   class="ml-4 text-red-500 hover:text-red-700 transition-colors"
                                   onclick="return confirm('Hapus item ini dari keranjang?')">
                                    <i class="fas fa-trash text-lg"></i>
                                </a>
                            </div>
                        </div>
                        <?php endforeach; ?>
                    </div>

                    <div class="border-t pt-4">
                        <div class="bg-gradient-to-r from-purple-50 to-indigo-50 rounded-lg p-4 mb-4">
                            <h4 class="font-semibold text-gray-800 mb-2">Detail Peminjaman</h4>
                            <div class="grid grid-cols-1 sm:grid-cols-2 gap-2 text-sm text-gray-700">
                                <div>
                                    <span class="font-medium">Total Item:</span> 
                                    <span class="text-purple-600 font-bold"><?php echo count($_SESSION['cart']); ?></span>
                                </div>
                                <div>
                                    <span class="font-medium">Durasi:</span> 
                                    <span class="text-purple-600 font-bold">90 Hari</span>
                                </div>
                                <div>
                                    <span class="font-medium">Tanggal Pinjam:</span> 
                                    <?php echo date('d M Y'); ?>
                                </div>
                                <div>
                                    <span class="font-medium">Est. Pengembalian:</span> 
                                    <?php echo date('d M Y', strtotime('+90 days')); ?>
                                </div>
                            </div>
                        </div>

                        <form method="POST" action="" onsubmit="return confirm('Apakah Anda yakin ingin mengajukan peminjaman ini?')">
                            <button type="submit" 
                                    name="submit_peminjaman"
                                    class="w-full bg-gradient-to-r from-purple-500 to-indigo-600 hover:from-purple-600 hover:to-indigo-700 text-white font-bold py-3 px-6 rounded-lg transition duration-200 flex items-center justify-center shadow-lg">
                                <i class="fas fa-paper-plane mr-2"></i>
                                Ajukan Peminjaman
                            </button>
                        </form>
                    </div>

                    <?php else: ?>
                    <div class="text-center py-12">
                        <i class="fas fa-shopping-cart text-gray-300 text-6xl mb-4"></i>
                        <p class="text-gray-500 text-lg mb-2">Keranjang Kosong</p>
                        <p class="text-gray-400 text-sm">Silakan scan barcode untuk menambahkan item</p>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Include Html5-QRCode Library -->
<script src="https://unpkg.com/html5-qrcode"></script>

<script>
let html5QrcodeScanner = null;
let isScanning = false;

function startScanner() {
    if (isScanning) return;
    
    document.getElementById('startScanBtn').classList.add('hidden');
    document.getElementById('stopScanBtn').classList.remove('hidden');
    document.getElementById('scanStatus').classList.remove('hidden');
    document.getElementById('statusText').textContent = 'Sedang memindai...';
    
    html5QrcodeScanner = new Html5Qrcode("reader");
    
    const config = {
        fps: 10,
        qrbox: { width: 250, height: 250 },
        aspectRatio: 1.0
    };
    
    html5QrcodeScanner.start(
        { facingMode: "environment" },
        config,
        onScanSuccess,
        onScanError
    ).then(() => {
        isScanning = true;
    }).catch(err => {
        console.error('Error starting scanner:', err);
        alert('Gagal membuka kamera. Pastikan Anda memberikan izin akses kamera.');
        resetScanner();
    });
}

function stopScanner() {
    if (!isScanning) return;
    
    html5QrcodeScanner.stop().then(() => {
        resetScanner();
    }).catch(err => {
        console.error('Error stopping scanner:', err);
        resetScanner();
    });
}

function resetScanner() {
    isScanning = false;
    document.getElementById('startScanBtn').classList.remove('hidden');
    document.getElementById('stopScanBtn').classList.add('hidden');
    document.getElementById('scanStatus').classList.add('hidden');
    html5QrcodeScanner = null;
}

function onScanSuccess(decodedText, decodedResult) {
    // Stop scanner setelah berhasil scan
    stopScanner();
    
    // Show loading status
    document.getElementById('scanStatus').classList.remove('hidden');
    document.getElementById('statusText').textContent = 'Memproses...';
    
    // Send to server
    fetch('ajukan_peminjaman.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded',
        },
        body: 'add_to_cart=1&code_color=' + encodeURIComponent(decodedText)
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            // Show success message
            showNotification(data.message, 'success');
            // Reload page untuk update keranjang
            setTimeout(() => {
                window.location.reload();
            }, 1500);
        } else {
            // Show error message
            showNotification(data.message, 'error');
            document.getElementById('scanStatus').classList.add('hidden');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        showNotification('Terjadi kesalahan saat menambahkan item', 'error');
        document.getElementById('scanStatus').classList.add('hidden');
    });
}

function onScanError(errorMessage) {
    // Ignore scan errors (too frequent)
}

function showNotification(message, type) {
    const bgColor = type === 'success' ? 'bg-green-500' : 'bg-red-500';
    const icon = type === 'success' ? 'fa-check-circle' : 'fa-exclamation-circle';
    
    const notification = document.createElement('div');
    notification.className = `fixed top-4 right-4 ${bgColor} text-white px-6 py-4 rounded-lg shadow-lg z-50 flex items-center`;
    notification.innerHTML = `
        <i class="fas ${icon} mr-3 text-xl"></i>
        <span>${message}</span>
    `;
    
    document.body.appendChild(notification);
    
    setTimeout(() => {
        notification.style.animation = 'fadeOut 0.3s';
        setTimeout(() => {
            document.body.removeChild(notification);
        }, 300);
    }, 3000);
}

// Auto hide alert messages
window.addEventListener('load', function() {
    const alerts = document.querySelectorAll('#alertMessage');
    alerts.forEach(alert => {
        setTimeout(() => {
            alert.style.display = 'none';
        }, 3000);
    });
});
</script>

<?php include '../template_borrower/footer.php'; ?>