
<?php $__env->startSection('title','Operations Dashboard'); ?>

<?php $__env->startPush('styles'); ?>
<style>
  .kpi-card{border-radius:1rem}
  .kpi-icon{width:42px;height:42px;display:grid;place-items:center;border-radius:999px;background:#f3f6ff}
  .table-sm td,.table-sm th{padding:.5rem .6rem}
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="container my-4">

  <div class="row g-3 mb-4">
    <div class="col-md-3">
      <div class="card kpi-card shadow-sm">
        <div class="card-body d-flex justify-content-between align-items-center">
          <div>
            <div class="text-muted small">Inbox (Approvals)</div>
            <div class="fs-4 fw-semibold"><?php echo e($kpi_inbox); ?></div>
          </div>
          <div class="kpi-icon text-primary"><i class="fa fa-envelope-open-text"></i></div>
        </div>
      </div>
    </div>
    <div class="col-md-3">
      <div class="card kpi-card shadow-sm">
        <div class="card-body d-flex justify-content-between align-items-center">
          <div>
            <div class="text-muted small">My Open Requests</div>
            <div class="fs-4 fw-semibold"><?php echo e($kpi_my_open); ?></div>
          </div>
          <div class="kpi-icon text-info"><i class="fa fa-clipboard-list"></i></div>
        </div>
      </div>
    </div>
    <div class="col-md-3">
      <div class="card kpi-card shadow-sm">
        <div class="card-body d-flex justify-content-between align-items-center">
          <div>
            <div class="text-muted small">Approved (30 days)</div>
            <div class="fs-4 fw-semibold text-success"><?php echo e($kpi_approved_30d); ?></div>
          </div>
          <div class="kpi-icon text-success"><i class="fa fa-thumbs-up"></i></div>
        </div>
      </div>
    </div>
    <div class="col-md-3">
      <div class="card kpi-card shadow-sm">
        <div class="card-body d-flex justify-content-between align-items-center">
          <div>
            <div class="text-muted small">Rejected (30 days)</div>
            <div class="fs-4 fw-semibold text-danger"><?php echo e($kpi_rejected_30d); ?></div>
          </div>
          <div class="kpi-icon text-danger"><i class="fa fa-thumbs-down"></i></div>
        </div>
      </div>
    </div>
  </div>

  <div class="row g-4">
    
    <div class="col-lg-6">
      <div class="card shadow-sm border-0">
        <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
          <div><i class="fa fa-truck-ramp-box me-2"></i>PO Suggestions</div>
          <div class="d-flex gap-2 small">
            <span class="badge bg-warning text-dark" id="countNeedOrder">
              Need Order: <?php echo e($poCounts['need_order']); ?>

            </span>
            <span class="badge bg-dark" id="countNeedOrderTo">
              Need Order for TO: <?php echo e($poCounts['need_order_for_to']); ?>

            </span>
            <span class="badge bg-info text-dark" id="countFollowUp">
              Follow Up: <?php echo e($poCounts['follow_up']); ?>

            </span>
            <span class="badge bg-success" id="countForStock">
              For Stock: <?php echo e($poCounts['for_stock']); ?>

            </span>
            <span class="badge bg-secondary" id="countNoNeed">
              No Need: <?php echo e($poCounts['no_need']); ?>

            </span>
          </div>
        </div>

        <div class="card-body">

          <div class="row g-2 align-items-end mb-3">
            <div class="col-md-6">
              <label class="form-label small">Filter by Vendor</label>
              <select id="poVendorFilter" class="form-select form-select-sm">
                <option value="">All vendors</option>
                <?php $__currentLoopData = $poVendors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <option value="<?php echo e($v); ?>"><?php echo e($v); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </select>
            </div>
            <div class="col-md-3">
              <label class="form-label small">Location</label>
              <select id="poLocationFilter" class="form-select form-select-sm">
                <option value="">All locations</option>
                <?php $__currentLoopData = $poLocations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $loc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <option value="<?php echo e($loc); ?>"><?php echo e($loc); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </select>
            </div>
          </div>

          <div class="mb-3">
            <canvas id="poStatusChart" height="140"></canvas>
          </div>

          <div class="table-responsive">
            <table class="table table-sm align-middle">
              <thead class="table-light">
                <tr>
                  <th>Item</th>
                  <th>Vendor</th>
                  <th class="text-center">QtyToOrder</th>
                  <th>Status</th>
                  <th>Loc</th>
                </tr>
              </thead>
              <tbody id="poTableBody">
                
                <?php $__empty_1 = true; $__currentLoopData = $poTop; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                  <tr>
                    <td>
                      <div class="fw-semibold"><?php echo e($r['item_no'] ?? '—'); ?></div>
                      <div class="small text-muted"><?php echo e($r['description'] ?? ''); ?></div>
                    </td>
                    <td class="small"><?php echo e($r['vendor_name'] ?? '—'); ?></td>
                    <td class="text-center"><?php echo e($r['qty_to_order'] ?? '—'); ?></td>
                    <td><span class="badge bg-light text-dark"><?php echo e($r['status'] ?? '—'); ?></span></td>
                    <td class="small"><?php echo e($r['location_code'] ?? '—'); ?></td>
                  </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                  <tr><td colspan="5" class="text-muted">No rows.</td></tr>
                <?php endif; ?>
              </tbody>
            </table>
          </div>

          <div class="text-end">
            <a href="<?php echo e(route('po-suggestions')); ?>" class="btn btn-outline-primary btn-sm">
              <i class="fa fa-arrow-right me-1"></i> Go to PO Suggestions
            </a>
          </div>
        </div>
      </div>
    </div>

    <div class="col-lg-6">
      <div class="card shadow-sm border-0">
        <div class="card-header bg-dark text-white d-flex justify-content-between align-items-center">
          <div><i class="fa fa-layer-group me-2"></i>SKU Mapping</div>
          <div class="d-flex gap-2 small">
            <span class="badge bg-light text-dark">Rows: <?php echo e($skuCounts['rows']); ?></span>
            <span class="badge bg-info text-dark">Modified 30d: <?php echo e($skuCounts['modified_30d']); ?></span>
          </div>
        </div>
        <div class="card-body">
          <div class="table-responsive">
            <table class="table table-sm align-middle">
              <thead class="table-light">
                <tr>
                  <th>Item</th>
                  <th>Location</th>
                  <th class="text-center">Cons(2m)</th>
                  <th>Real Min/Max</th>
                  <th>Suggest Min/Max</th>
                  <th class="text-center">Forecast Min (Avg)</th>
                  <th class="text-center">Forecast Max (Avg)</th>
                </tr>
              </thead>
              <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $skuTop; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                  <tr>
                    <td>
                      <div class="fw-semibold"><?php echo e($r['Item_No'] ?? '—'); ?></div>
                      <div class="small text-muted"><?php echo e($r['Description'] ?? ''); ?></div>
                    </td>
                    <td class="small"><?php echo e($r['Location'] ?? '—'); ?></td>
                    <td class="text-center"><?php echo e($r['Consumption / 2 months'] ?? 0); ?></td>
                    <td class="small">
                      <?php echo e($r['RealMinQty'] ?? 0); ?> / <?php echo e($r['RealMaxQty'] ?? 0); ?>

                    </td>
                    <td class="small">
                      <?php echo e($r['SuggestMinQty'] ?? 0); ?> / <?php echo e($r['SuggestMaxQty'] ?? 0); ?>

                    </td>
                    <td class="text-center">
                      <?php echo e($r['ForecMin_Avg'] ?? '—'); ?>

                      <div class="small text-muted">
                        HIC: <?php echo e($r['ForecMin_HIC'] ?? '—'); ?>,
                        RBC: <?php echo e($r['ForecMin_RBC'] ?? '—'); ?>

                      </div>
                    </td>
                    <td class="text-center">
                      <?php echo e($r['ForecMax_Avg'] ?? '—'); ?>

                      <div class="small text-muted">
                        HIC: <?php echo e($r['ForecMax_HIC'] ?? '—'); ?>,
                        RBC: <?php echo e($r['ForecMax_RBC'] ?? '—'); ?>

                      </div>
                    </td>
                  </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                  <tr><td colspan="7" class="text-muted">No rows.</td></tr>
                <?php endif; ?>
              </tbody>
            </table>
          </div>
          <div class="text-end">
            <a href="<?php echo e(route('sku-mapping')); ?>" class="btn btn-outline-dark btn-sm">
              <i class="fa fa-arrow-right me-1"></i> Go to SKU Mapping
            </a>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
  <?php $__env->startPush('scripts'); ?>
  <script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.1/dist/chart.umd.min.js"></script>
  <script>
  (function(){
    const PO_ROWS = <?php echo json_encode($poRows ?? [], 15, 512) ?>;

    const STATUS_KEYS = [
      'Need Order',
      'Need Order For TO',
      'Follow Up PO',
      'Order For Stock',
      'No Need Order'
    ];

    const COLORS = ['#3b82f6','#ef4444','#f59e0b','#10b981','#94a3b8'];

    const selVendor   = document.getElementById('poVendorFilter');
    const selLocation = document.getElementById('poLocationFilter');

    const countNeedOrder   = document.getElementById('countNeedOrder');
    const countNeedOrderTo = document.getElementById('countNeedOrderTo');
    const countFollowUp    = document.getElementById('countFollowUp');
    const countForStock    = document.getElementById('countForStock');
    const countNoNeed      = document.getElementById('countNoNeed');

    const tableBody = document.getElementById('poTableBody');

    let activeStatuses = new Set(STATUS_KEYS);

    const ctx = document.getElementById('poStatusChart');
    const chart = new Chart(ctx, {
      type: 'pie',
      data: {
        labels: STATUS_KEYS,
        datasets: [{
          data: [0,0,0,0,0],
          backgroundColor: COLORS,
          borderColor: '#fff',
          borderWidth: 1
        }]
      },
      options: {
        plugins: {
          legend: {
            position: 'bottom',
            onClick: (e, legendItem) => {
              const label = legendItem.text;
              if (activeStatuses.has(label)) activeStatuses.delete(label);
              else activeStatuses.add(label);
              updateAll();
            }
          },
          tooltip: {
            callbacks: {
              label: (ctx) => `${ctx.label}: ${ctx.raw}`
            }
          }
        },
        onClick: (e, elements) => {
          if (!elements.length) return;
          const idx = elements[0].index;
          const clicked = STATUS_KEYS[idx];
          if (activeStatuses.size === 1 && activeStatuses.has(clicked)) {
            activeStatuses = new Set(STATUS_KEYS);
          } else {
            activeStatuses = new Set([clicked]);
          }
          updateAll();
        }
      }
    });

    function applyFilters(rows) {
      const v = selVendor.value.trim();
      const l = selLocation.value.trim();
      return rows.filter(r => {
        const okV = !v || r.vendor_name === v;
        const okL = !l || r.location_code === l;
        const okS = activeStatuses.has(r.status || '');
        return okV && okL && okS;
      });
    }

    function summarize(rows) {
      const counts = {
        'Need Order': 0,
        'Need Order For TO': 0,
        'Follow Up PO': 0,
        'Order For Stock': 0,
        'No Need Order': 0
      };
      rows.forEach(r => { if (counts.hasOwnProperty(r.status)) counts[r.status]++; });
      return counts;
    }

    function topN(rows, n=8) {
      return [...rows].sort((a,b) => (b.qty_to_order||0) - (a.qty_to_order||0)).slice(0,n);
    }

    function renderTable(rows) {
      const top = topN(rows);
      if (!top.length) {
        tableBody.innerHTML = `<tr><td colspan="5" class="text-muted">No rows.</td></tr>`;
        return;
      }
      tableBody.innerHTML = top.map(r => `
        <tr>
          <td>
            <div class="fw-semibold">${esc(r.item_no ?? '—')}</div>
            <div class="small text-muted">${esc(r.description ?? '')}</div>
          </td>
          <td class="small">${esc(r.vendor_name ?? '—')}</td>
          <td class="text-center">${r.qty_to_order ?? '—'}</td>
          <td><span class="badge bg-light text-dark">${esc(r.status ?? '—')}</span></td>
          <td class="small">${esc(r.location_code ?? '—')}</td>
        </tr>
      `).join('');
    }

    function updateCounts(counts) {
      countNeedOrder.textContent   = `Need Order: ${counts['Need Order']}`;
      countNeedOrderTo.textContent = `Need Order for TO: ${counts['Need Order For TO']}`;
      countFollowUp.textContent    = `Follow Up: ${counts['Follow Up PO']}`;
      countForStock.textContent    = `For Stock: ${counts['Order For Stock']}`;
      countNoNeed.textContent      = `No Need: ${counts['No Need Order']}`;
    }

    function updateChart(counts) {
      chart.data.datasets[0].data = STATUS_KEYS.map(k => counts[k] || 0);
      // Dim inactive statuses (optional)
      chart.data.datasets[0].backgroundColor = STATUS_KEYS.map((k,i) =>
        activeStatuses.has(k) ? COLORS[i] : hexToRgba(COLORS[i], 0.25)
      );
      chart.update();
    }

    function esc(x){return String(x ?? '').replaceAll('&','&amp;').replaceAll('<','&lt;').replaceAll('>','&gt;');}
    function hexToRgba(hex, a){
      const m = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex);
      if(!m) return hex;
      const r=parseInt(m[1],16), g=parseInt(m[2],16), b=parseInt(m[3],16);
      return `rgba(${r},${g},${b},${a})`;
    }

    function updateAll(){
      const filtered = applyFilters(PO_ROWS);
      const counts   = summarize(filtered);
      updateCounts(counts);
      updateChart(counts);
      renderTable(filtered);
    }

    selVendor.addEventListener('change', updateAll);
    selLocation.addEventListener('change', updateAll);

    updateAll();
  })();
  </script>
  <?php $__env->stopPush(); ?>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/pawc5944/public_html/bc/resources/views/dashboard/index.blade.php ENDPATH**/ ?>