@extends('layouts.app')
@section('title','All Requests')

@push('styles')
<style>.card-rounded{border-radius:1rem}</style>
@endpush

@section('content')
<div class="container py-4">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h4 class="mb-0"><i class="fa fa-clipboard-list me-2"></i>All Requests</h4>
    <div class="d-flex gap-2">
      <a href="{{ route('approvals.mine') }}" class="btn btn-outline-secondary btn-sm">
        <i class="fa fa-inbox me-1"></i> My Forms
      </a>
      <a href="{{ route('approvals.new') ?? url('/approvals/new') }}" class="btn btn-primary btn-sm">
        <i class="fa fa-plus me-1"></i> New Item Request
      </a>
    </div>
  </div>

  <form class="row g-2 mb-3" method="GET" action="{{ route('approvals.all') }}">
      <div class="col-lg-4 col-md-6">
        <input type="text" name="q" value="{{ $q ?? '' }}" class="form-control"
               placeholder="Search number, vendor, requester…">
      </div>
    
      <div class="col-lg-2 col-md-6">
        <select name="status" class="form-select">
          <option value="">Status (any)</option>
          @foreach(['Draft','InReview','Approved','Rejected'] as $opt)
            <option value="{{ $opt }}" @selected(($status ?? '')===$opt)>{{ $opt }}</option>
          @endforeach
        </select>
      </div>
    
      <div class="col-lg-2 col-md-6">
        <input type="date" name="from" value="{{ request('from') }}" class="form-control" placeholder="From">
      </div>
    
      <div class="col-lg-2 col-md-6">
        <input type="date" name="to" value="{{ request('to') }}" class="form-control" placeholder="To">
      </div>
    
      <div class="col-lg-1 col-md-6">
        <button class="btn btn-primary w-100">
          <i class="fa fa-search me-1"></i> Filter
        </button>
      </div>
    
      <div class="col-lg-1 col-md-6">
        <a href="{{ route('approvals.all') }}" class="btn btn-outline-secondary w-100">Reset</a>
      </div>
    </form>

  <div class="card card-rounded shadow-sm">
    <div class="table-responsive">
      <table class="table align-middle">
        <thead class="table-light">
          <tr>
            <th style="width:70px">#</th>
            <th>Vendor</th>
            <th>Requester</th>
            <th>Flow</th>
            <th>Status</th>
            <th style="width:80px">Step</th>
            <th style="width:80px">Lines</th>
            <th style="width:140px">Posting Date</th>
            <th style="width:160px">Updated</th>
            <th style="width:90px">Open</th>
          </tr>
        </thead>
        <tbody>
        @forelse($items as $r)
          <tr>
            <td><span class="badge bg-secondary">#{{ $r->id }}</span></td>
            <td>{{ $r->vendor_name ?? '—' }}</td>
            <td>
              {{ $r->requester?->name ?? '—' }}
              @if($r->requester?->email)
                <div class="small text-muted">{{ $r->requester->email }}</div>
              @endif
            </td>
            <td>
              {{ $r->flow?->name ?? '—' }}
              @if($r->flow?->version) <span class="text-muted small">v{{ $r->flow->version }}</span> @endif
            </td>
            <td>
              @php
                $cls = $r->status==='Approved' ? 'bg-success' :
                       ($r->status==='Rejected' ? 'bg-danger' :
                       ($r->status==='InReview' ? 'bg-warning text-dark' : 'bg-secondary'));
              @endphp
              <span class="badge {{ $cls }}">{{ $r->status }}</span>
            </td>
            <td>{{ $r->current_step_no ?? '—' }}</td>
            <td><span class="badge bg-info">{{ $r->lines_count }}</span></td>
            <td>{{ optional($r->posting_date)->format('Y-m-d') ?? '—' }}</td>
            <td>{{ optional($r->updated_at)->format('Y-m-d H:i') }}</td>
            <td>
              <a href="{{ route('approvals.show', $r->id) }}" class="btn btn-outline-primary btn-sm">
                <i class="fa fa-eye me-1"></i> View
              </a>
            </td>
          </tr>
        @empty
          <tr><td colspan="11" class="text-muted">No requests yet.</td></tr>
        @endforelse
        </tbody>
      </table>
    </div>
    <div class="p-3">
      {{ $items->links() }}
    </div>
  </div>
</div>
@endsection
