
<?php $__env->startSection('title', 'Transfer Order'); ?>
<?php $__env->startSection('content'); ?>
    <div class="container-fluid py-4" id="transfer-page" style="min-height:100vh; background-color:#fffaf7;">
        <h3 class="text-center mb-4 fw-bold text-primary">📦 Transfer Order (Material)</h3>

        
        <div class="row mb-3 justify-content-center">
            <div class="col-md-4 mb-2">
                <input type="text" id="searchInput" class="form-control shadow-sm" placeholder="🔍 Search item...">
            </div>
            <div class="col-md-3 mb-2">
                <select id="filterSelect" class="form-select shadow-sm">
                    <option value="">All Replenishment Systems</option>
                    <option value="Transfer">Transfer</option>
                    <option value="Purchase">Purchase</option>
                    <option value="Production">Production</option>
                </select>
            </div>
            <div class="col-md-2 mb-2 text-center">
                <button class="btn btn-primary w-auto fw-semibold" id="createTO" disabled>
                    ➕ Create Transfer Order
                </button>
            </div>
        </div>

        
        <div id="skeletonContainer">
            <?php for($i = 0; $i < 6; $i++): ?>
                <div class="card mb-3 shadow-sm p-3 border-0 rounded-4 skeleton-card">
                    <div class="placeholder-glow">
                        <div class="placeholder col-1 me-3" style="height: 24px;"></div>
                        <div class="placeholder col-3" style="height: 24px;"></div>
                        <div class="placeholder col-2 ms-auto" style="height: 24px;"></div>
                    </div>
                </div>
            <?php endfor; ?>
        </div>

        
        <div id="itemContainer" class="d-none"></div>
    </div>

    <!-- Create Transfer Order Modal -->
    <div class="modal fade" id="toModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content border-0 shadow-sm" style="border-radius: 1rem;">

                <!-- Header -->
                <div class="modal-header text-white"
                    style="background:#9FCBE6; border-top-left-radius:1rem; border-top-right-radius:1rem;">
                    <h5 class="modal-title fw-semibold">Create Transfer Order (TO)</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"
                        aria-label="Close"></button>
                </div>

                <!-- Body -->
                <div class="modal-body p-4">
                    <form id="toForm">
                        <!-- ===== HEADER SECTION ===== -->
                        <div class="border rounded-3 p-3 mb-4 bg-light">
                            <h6 class="fw-semibold text-primary mb-3">Header Information</h6>
                            <div class="row g-3">
                                <div class="col-md-6">
                                    <label class="form-label fw-semibold">No. Series</label>
                                    <select id="to_noSeries" class="form-select" disabled>
                                        <option value="TO.CI" selected>CI</option>
                                    </select>
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label fw-semibold">Transfer Spec</label>
                                    <select id="to_transSpec" class="form-select" disabled>
                                        <option value="ST. ORDER"selected>Transfer Internal Business Unit</option>
                                    </select>
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label fw-semibold">Business Unit</label>
                                    <select id="to_businessUnit" class="form-select" disabled>
                                        <option value="CI" selected>Canggu International</option>
                                    </select>
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label fw-semibold">Department</label>
                                    <input type="text" id="to_department" class="form-control" value="8410" disabled>
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label fw-semibold">Transfer From</label>
                                    <select id="to_transferFrom" class="form-select">
                                        <option value="CI.1010" selected>Food Central (CI.1010)</option>
                                        <option value="CI.1020">Operational (CI.1020)</option>
                                        <option value="CI.3000">Maintenance (CI.3000)</option>
                                    </select>
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label fw-semibold">Transfer To</label>
                                    <select id="to_transferTo" class="form-select" disabled>
                                        <option value="CI.1011" selected>Butcher</option>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <!-- ===== ITEM SECTION ===== -->
                        <div class="border rounded-3 p-3 bg-light">
                            <div class="d-flex justify-content-between align-items-center mb-3">
                                <h6 class="fw-semibold text-primary mb-0">Item Lines</h6>
                            </div>

                            <table class="table align-middle" id="selectedItems">
                                <thead class="table-light">
                                    <tr>
                                        <th>Item No</th>
                                        <th>Description</th>
                                        <th>Qty</th>
                                        <th>UoM</th>
                                    </tr>
                                </thead>
                                <tbody>

                                </tbody>
                            </table>
                        </div>

                        <div class="d-grid mt-4">
                            <button class="btn text-white fw-semibold" type="submit" style="background-color:#7DC5E3;">
                                <i class="bi bi-arrow-repeat me-1"></i> Create TO
                            </button>
                        </div>

                    </form>
                </div>
            </div>
        </div>
    </div>
    <div class="liquid-progress-wrapper">
        <div class="liquid-progress">
            <div class="liquid"></div>
            

            <!-- tombol aslinya tetap -->
            <button id="createTOstick"
                class="btn btn-primary fw-semibold shadow-lg d-flex align-items-center justify-content-center floating-btn"
                title="Create Transfer Order" disabled>
                ➕
            </button>
        </div>
    </div>

    <div id="budgetLiquidButton" class="liquid-bar-wrapper" style="cursor: pointer">
        <div class="liquid-bar">
            <svg viewBox="0 0 300 100" class="liquid-svg">
                <defs>
                    <mask id="liquidMaskBar">
                        <rect width="300" height="300" fill="white"></rect>
                        <g transform="scale(1,-1) translate(0, -100)">
                            <!-- Wave layer 1 -->
                            <path id="liquidWave1" fill="black">
                                <animate attributeName="d" dur="4s" begin="indefinite" id="waveAnim1"
                                    repeatCount="indefinite"
                                    values="
M0 30 Q50 20 100 30 T200 30 T300 30 V100 H0 Z;
M0 32 Q50 40 100 32 T200 32 T300 32 V100 H0 Z;
M0 28 Q50 10 100 28 T200 28 T300 28 V100 H0 Z;
M0 30 Q50 20 100 30 T200 30 T300 30 V100 H0 Z;">
                                </animate>
                            </path>

                            <!-- Wave layer 2 -->
                            <path id="liquidWave2" fill="black" opacity="0.5">
                                <animate attributeName="d" dur="2.8s" begin="indefinite" id="waveAnim2"
                                    repeatCount="indefinite"
                                    values="
M0 32 Q50 25 100 32 T200 32 T300 32 V100 H0 Z;
M0 34 Q50 45 100 34 T200 34 T300 34 V100 H0 Z;
M0 30 Q50 15 100 30 T200 30 T300 30 V100 H0 Z;
M0 32 Q50 25 100 32 T200 32 T300 32 V100 H0 Z;">
                                </animate>
                            </path>
                    </mask>
                </defs>

                <!-- Liquid color -->
                <rect width="300" height="300" class="liquid-fill" mask="url(#liquidMaskBar)"></rect>
            </svg>

            <div class="liquid-bar-text">
                <div id="budget" class="budget-text">Budget</div>

                <small id="Maxbudget">Rp 0</small>
                <br>
                <span id="budgetPercent">0%</span>
                <br>
                <small id="budgetUsedText">Rp 0</small>
            </div>
        </div>
    </div>





<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    
    <script>
        const maxbudget = <?php echo json_encode($budgetSumRounded, 15, 512) ?>;
        document.addEventListener("DOMContentLoaded", function() {
            const btn = document.getElementById("budgetLiquidButton");

            if (btn) {
                btn.addEventListener("click", function() {

                    // (opsional) sembunyikan dulu untuk animasi
                    btn.style.opacity = "0";
                    btn.style.transition = "opacity 0.3s ease";

                    setTimeout(() => {
                        // Redirect ke route inventorybudget.index
                        window.location.href = "<?php echo e(route('inventorybudget.index')); ?>";
                    }, 250);

                });
            }
        });
        $(document).ready(function() {
            const itemContainer = $('#itemContainer');
            const skeletonContainer = $('#skeletonContainer');
            const createTOButton = $('#createTO');
            const createTOButtonstick = $('#createTOstick');
            const selectedItemsTable = $('#selectedItems');
            let allData = [];
            let selectedItems = [];

            // =====================================
            // === BATAS MAKSIMAL BUDGET (300JUTA)
            // =====================================
            const MAX_BUDGET_LIMIT = maxbudget;

            // =====================================
            // === FETCH BUDGET INVENTORY (BC) ====
            // =====================================
            let budgetTotal = 0;

            function disableTOButtons() {
                createTOButton.prop('disabled', true);
                createTOButtonstick.prop('disabled', true);
            }

            function loadBudgetInventory() {
                return $.get("<?php echo e(route('budget.inventory')); ?>")
                    .done(res => {
                        if (res && res.TotalCost) {
                            budgetTotal = Number(res.TotalCost);
                        }
                        if (budgetTotal >= MAX_BUDGET_LIMIT) {
                            disableTOButtons();
                        }
                        updateLiquidBudgetButton();
                    })
                    .fail(() => {
                        console.warn("Failed to load budget inventory");
                    });
            }
            loadBudgetInventory();

            const transferLines = <?php echo json_encode($transferLines ?? [], 15, 512) ?>;
            const assemblyLines = <?php echo json_encode($assemblyLines ?? [], 15, 512) ?>;

            const TO_MAP = {};
            transferLines.forEach(line => {
                const key = line.itemNo;
                if (!TO_MAP[key]) TO_MAP[key] = [];
                TO_MAP[key].push({
                    date: line.shipmentDate,
                    qty: line.quantity,
                    uom: line.uomCode,
                    status: line.status,
                });
            });

            const AO_MAP = {};
            assemblyLines.forEach(line => {
                const key = line.docNo;
                if (!AO_MAP[key]) AO_MAP[key] = [];
                AO_MAP[key].push({
                    date: line.creationDate,
                    qty: Number(line.Quantity || 0),
                    uom: line.unitOfMeasure || line.variantCode || ''
                });
            });

            const AO_MAP_NORMALIZED = {};
            Object.keys(AO_MAP).forEach(docNo => {
                AO_MAP_NORMALIZED[docNo] = AO_MAP[docNo];
            });

            const resultData = <?php echo json_encode($result ?? [], 15, 512) ?>;

            // === Fetch Combined Data ===
            $.get("<?php echo e(route('bc.combined-stock')); ?>", function(data) {
                if (data && data.items) {
                    allData = data.items;

                    // ------ Tambahan SORT FIELD -------
                    allData.forEach(i => {
                        i.Unit_Cost = Number(i.Unit_Cost || 0);
                        i.Total_Cost = Number(i.Total_Cost || 0);

                        i._sort_UnitCost = i.Unit_Cost;
                        i._sort_TotalCost = i.Total_Cost;
                    });

                    renderItems(allData);
                } else {
                    itemContainer.html('<p class="text-center text-muted mt-4">No data found</p>');
                }
                skeletonContainer.hide();
                itemContainer.removeClass('d-none');
            });

            function formatInventoryCustom(value) {
                return value != null ? Number(value).toLocaleString() : '-';
            }

            function formatDate(d) {
                if (!d) return '-';
                const dt = new Date(d);
                return `${String(dt.getDate()).padStart(2,'0')}-${String(dt.getMonth()+1).padStart(2,'0')}-${dt.getFullYear()}`;
            }

            let currentSort = {
                column: null,
                direction: 'asc'
            };

            function sortItems(items, key) {
                const direction = currentSort.direction === 'asc' ? 1 : -1;
                return items.sort((a, b) => {
                    let va = a[key] ?? '';
                    let vb = b[key] ?? '';
                    if (typeof va === 'string') va = va.toLowerCase();
                    if (typeof vb === 'string') vb = vb.toLowerCase();
                    if (va > vb) return 1 * direction;
                    if (va < vb) return -1 * direction;
                    return 0;
                });
            }

            // ============================================================
            // RENDER BODY FUNCTION
            // ============================================================
            function renderItemsBody(items) {
                const tbody = $('#itemTable tbody');
                tbody.empty();

                if (!items.length) {
                    tbody.append(
                        `<tr><td colspan="12" class="text-center text-muted py-4">No items found</td></tr>`);
                    return;
                }

                items.forEach(item => {
                    const isChecked = selectedItems.some(sel => sel.Item_No === item.Item_No);

                    let onTOCell = '-';
                    let firstTODate = null;
                    const toData = TO_MAP[item.Item_No];

                    if (toData && toData.length > 0) {
                        const sortedTO = [...toData].sort((a, b) => new Date(a.date) - new Date(b.date));
                        firstTODate = sortedTO[0].date;

                        onTOCell = sortedTO
                            .map(t => {
                                let badgeClass =
                                    t.status === 'Release' ?
                                    'badge bg-success-subtle text-success' :
                                    t.status === 'Open' ?
                                    'badge bg-warning-subtle text-warning' :
                                    'badge bg-secondary-subtle text-secondary';

                                return `
                                ${formatDate(t.date)} (${t.qty}${t.uom})
                                <br>
                                <span class="${badgeClass} px-2 py-1 mt-1">${t.status}</span>
                            `;
                            })
                            .join('<br><br>');
                    }

                    let onAOCell = '-';
                    let totalAOQty = 0;
                    const aoData = AO_MAP_NORMALIZED[item.Item_No];
                    if (aoData && aoData.length > 0) {
                        totalAOQty = aoData.reduce((sum, a) => sum + Number(a.qty || 0), 0);
                        onAOCell = `${formatInventoryCustom(totalAOQty)} ${aoData[0].uom || ''}`.trim();
                    }

                    const status = item.Inventory < item.Minimum_Stock ? 'Need to Order' : 'Standby';
                    const statusBadge =
                        status === 'Need to Order' ?
                        `<span class="badge bg-danger-subtle text-danger px-3 py-2">${status}</span>` :
                        `<span class="badge bg-success-subtle text-success px-3 py-2">${status}</span>`;

                    item.Status = status;

                    item._sort_OnTO = firstTODate ? new Date(firstTODate).getTime() : null;
                    item._sort_OnAO = totalAOQty;
                    item._sort_Status = status;

                    // -------------- NEW SORT FIELDS --------------
                    item._sort_UnitCost = Number(item.Unit_Cost || 0);
                    item._sort_TotalCost = Number(item.Total_Cost || 0);

                    const row = $(`
                    <tr data-itemno="${item.Item_No}" class="align-middle">
                        <td><input type="checkbox" class="form-check-input select-item" value="${item.Item_No}" ${isChecked ? 'checked' : ''}></td>
                        <td>${item.Item_No}</td>
                        <td>${item.Description}</td>
                        <td>${formatInventoryCustom(item.Minimum_Stock)}</td>
                        <td>${formatInventoryCustom(item.Maximum_Inventory)}</td>
                        <td>${onTOCell}</td>
                        <td>${onAOCell}</td>
                        <td><span class="badge bg-${item.Inventory <= 0 ? 'danger' : 'success'} rounded-pill px-3 py-2">${formatInventoryCustom(item.Inventory)}</span></td>
                        <td>${statusBadge}</td>
                        <td>${item.Base_UoM || '-'}</td>
                        <td>${formatInventoryCustom(item.Unit_Cost)}</td>
                        <td>${formatInventoryCustom(item.Total_Cost)}</td>
                    </tr>
                `);

                    tbody.append(row);
                });
            }

            // ============================================================
            // RENDER FULL TABLE FUNCTION
            // ============================================================
            function renderItems(items) {
                itemContainer.empty();

                const table = $(`
                <table class="table table-hover align-middle text-sm small-table" id="itemTable">
                    <thead class="table-light">
                        <tr>
                            <th style="width: 5%;">#</th>
                            <th data-sort="Item_No" style="width: 12%;">Item No <span class="sort-icon"></span></th>
                            <th data-sort="Description" style="width: 18%;">Description <span class="sort-icon"></span></th>
                            <th data-sort="Minimum_Stock" style="width: 10%;">Min Stock <span class="sort-icon"></span></th>
                            <th data-sort="Maximum_Inventory" style="width: 10%;">Max Stock <span class="sort-icon"></span></th>
                            <th data-sort="OnTO" style="width: 15%;">On TO <span class="sort-icon"></span></th>
                            <th data-sort="OnAO" style="width: 15%;">On AO <span class="sort-icon"></span></th>
                            <th data-sort="Inventory" style="width: 10%;">Stock <span class="sort-icon"></span></th>
                            <th data-sort="Status" style="width: 12%;">Status <span class="sort-icon"></span></th>
                            <th style="width: 5%;">UoM</th>
                            <th data-sort="Unit_Cost" style="width: 10%;">Unit Cost <span class="sort-icon"></span></th>
                            <th data-sort="Total_Cost" style="width: 10%;">Total Cost <span class="sort-icon"></span></th>
                        </tr>
                    </thead>
                    <tbody></tbody>
                </table>
            `);

                itemContainer.append(table);
                renderItemsBody(items);

                itemContainer.off('click', 'th[data-sort]').on('click', 'th[data-sort]', function() {
                    const key = $(this).data('sort');

                    if (currentSort.column === key) {
                        currentSort.direction = currentSort.direction === 'asc' ? 'desc' : 'asc';
                    } else {
                        currentSort.column = key;
                        currentSort.direction = 'asc';
                    }

                    let sortKey = key;
                    if (key === 'OnTO') sortKey = '_sort_OnTO';
                    if (key === 'OnAO') sortKey = '_sort_OnAO';
                    if (key === 'Status') sortKey = '_sort_Status';

                    // ------------ NEW SORT KEYS ------------
                    if (key === 'Unit_Cost') sortKey = '_sort_UnitCost';
                    if (key === 'Total_Cost') sortKey = '_sort_TotalCost';

                    const sorted = sortItems([...items], sortKey);
                    renderItemsBody(sorted);

                    $('#itemTable th[data-sort] .sort-icon').text('');
                    $(this).find('.sort-icon').text(currentSort.direction === 'asc' ? '▲' : '▼');
                });
            }

            // === Checkbox persist selection ===
            $(document).on('change', '.select-item', function() {
                const itemNo = $(this).val();
                if (this.checked) {
                    const item = allData.find(i => i.Item_No === itemNo);
                    if (item && !selectedItems.some(sel => sel.Item_No === item.Item_No)) {
                        selectedItems.push(item);
                    }
                } else {
                    selectedItems = selectedItems.filter(i => i.Item_No !== itemNo);
                }
                updateSelectedItems();
            });

            function updateSelectedItems() {
                const tbody = selectedItemsTable.find('tbody');
                tbody.empty();

                selectedItems.forEach(item => {
                    const uoms = Array.isArray(item.UoM) && item.UoM.length > 0 ?
                        item.UoM : [{
                            Code: item.Base_UoM || '-'
                        }];

                    const uomOptions = uoms.map(u => `<option value="${u.Code}">${u.Code}</option>`).join(
                        '');

                    tbody.append(`
                    <tr>
                        <td class="item-no">${item.Item_No}</td>
                        <td class="item-desc">${item.Description}</td>
                        <td><input type="number" class="form-control form-control-sm item-qty" value="1" min="1"></td>
                        <td><select class="form-select form-select-sm item-uom">${uomOptions}</select></td>
                    </tr>
                `);
                });

                createTOButtonstick.prop('disabled', selectedItems.length === 0);
                createTOButton.prop('disabled', selectedItems.length === 0);
            }

            function handleCreateTOOpen() {
                if (budgetTotal >= MAX_BUDGET_LIMIT) {
                    Swal.fire({
                        icon: 'warning',
                        title: 'Budget Melebihi Limit',
                        text: 'Total biaya untuk lokasi CI.1011 telah mencapai atau melebihi batas maksimal (300 juta). Transfer Order tidak dapat dibuat.',
                    });
                    return;
                }

                updateSelectedItems();
                $('#toModal').modal('show');
            }

            createTOButtonstick.on('click', handleCreateTOOpen);
            createTOButton.on('click', handleCreateTOOpen);

            $('#searchInput, #filterSelect').on('input change', function() {
                const keyword = $('#searchInput').val().toLowerCase();
                const filter = $('#filterSelect').val();
                const filtered = allData.filter(i =>
                    i.Description.toLowerCase().includes(keyword) &&
                    (!filter || i.Replenishment_System === filter)
                );
                renderItems(filtered);
            });

            let wavesStarted = false;

            function updateLiquidBudgetButton() {
                const percent = Math.min(100, Math.round((budgetTotal / MAX_BUDGET_LIMIT) * 100));

                $("#budgetPercent").text(percent + "%");
                $("#budgetUsedText").text("Used: Rp " + budgetTotal.toLocaleString());
                $("#Maxbudget").text("Rp " + MAX_BUDGET_LIMIT.toLocaleString());

                const barHeight = $(".liquid-bar").height();
                let translateValue = barHeight * (1 - percent / 100);

                $(".liquid-fill").css("transform", `translateY(${translateValue}px)`);
            }
        });
    </script>

    <script>
        $(document).ready(function() {
            const selectedItemsTable = $('#selectedItems');

            // === Event Submit Transfer Order ===
            $('#toForm').on('submit', async function(e) {
                e.preventDefault();

                const csrfToken = $('meta[name="csrf-token"]').attr('content');
                const $submitBtn = $('#toForm button[type="submit"]');
                $submitBtn.prop('disabled', true);

                // --- Ambil data header ---
                const headerData = {
                    noSeries: $('#to_noSeries').val(),
                    transSpec: $('#to_transSpec').val(),
                    businessUnit: $('#to_businessUnit').val(),
                    department: $('#to_department').val(),
                    transferFromCode: $('#to_transferFrom').val(),
                    transfertoCode: $('#to_transferTo').val(),
                };

                // --- Ambil data items dari tabel (pastikan tbody) ---
                const lines = [];
                $('#selectedItems tbody tr').each(function() {
                    const itemNo = $(this).find('.item-no').text().trim();
                    const desc = $(this).find('.item-desc').text().trim();
                    const qty = parseFloat($(this).find('.item-qty').val()) || 0;
                    const uomCode = $(this).find('.item-uom').val() || '';

                    if (itemNo && qty > 0) {
                        lines.push({
                            itemNo,
                            description: desc,
                            quantity: qty,
                            uomCode,
                        });
                    }
                });


                if (lines.length === 0) {
                    Swal.fire({
                        icon: 'warning',
                        title: 'No Items Selected',
                        text: 'Please add at least one item before submitting.',
                        background: '#FFF8F3',
                        confirmButtonColor: '#7DC5E3',
                    });
                    $submitBtn.prop('disabled', false);
                    return;
                }

                // === Step 1: Proses Simpan Header + Lines ===
                Swal.fire({
                    title: 'Processing Transfer Order...',
                    html: '<b>Creating Header and Items...</b>',
                    allowOutsideClick: false,
                    didOpen: () => {
                        Swal.showLoading();
                    },
                    background: '#FFF8F3',
                    color: '#333',
                });

                try {
                    const response = await $.ajax({
                        url: "<?php echo e(route('bc.store-transfer')); ?>",
                        method: 'POST',
                        contentType: 'application/json',
                        dataType: 'json',
                        headers: {
                            'X-CSRF-TOKEN': csrfToken
                        },
                        data: JSON.stringify({
                            ...headerData,
                            lines: lines
                        }),

                    });
                    if (response.status !== 'success') {
                        throw new Error(response.message || 'Failed to create Transfer Order.');
                    }

                    Swal.close();
                    Swal.fire({
                        icon: 'success',
                        title: 'Transfer Order Complete!',
                        html: `
                    <div class="text-start">
                        <p class="mb-1">Header <b>${response.header?.no || '-'}</b> created successfully.</p>
                        <p class="mb-1">Total lines: <b>${response.lines?.length || 0}</b></p>
                    </div>
                `,
                        background: '#F0FFF0',
                        confirmButtonColor: '#7DC5E3',
                    });

                    // Reset form dan modal
                    $('#toForm')[0].reset();
                    $('#selectedItems tbody').empty();
                    $('#toModal').modal('hide');

                } catch (err) {
                    Swal.close();
                    Swal.fire({
                        icon: 'error',
                        title: 'Error Creating Transfer Order',
                        text: err.message || 'Failed to process transfer order.',
                        background: '#FFF0F0',
                        confirmButtonColor: '#E67C73',
                    });
                } finally {
                    $submitBtn.prop('disabled', false);
                }
            });
        });
    </script>




    <style>
        .skeleton-card .placeholder {
            border-radius: 10px;
            background: linear-gradient(90deg, #f0ece9 25%, #f6f3f1 50%, #f0ece9 75%);
            background-size: 200% 100%;
            animation: shimmer 1.5s infinite;
        }

        @keyframes shimmer {
            0% {
                background-position: -200% 0;
            }

            100% {
                background-position: 200% 0;
            }
        }

        .custom-checkbox {
            position: relative;
            cursor: pointer;
        }

        .custom-checkbox input {
            opacity: 0;
            position: absolute;
        }

        .custom-checkbox .checkmark {
            width: 22px;
            height: 22px;
            border-radius: 6px;
            border: 2px solid #9c9997;
            display: inline-block;
            transition: all 0.3s ease;
        }

        .custom-checkbox input:checked+.checkmark {
            background-color: #74b9ff;
            border-color: #0984e3;
            box-shadow: 0 0 5px rgba(9, 132, 227, 0.5);
        }

        .item-card:hover {
            background-color: #fff3e9;
            transform: scale(1.01);
            transition: all 0.2s ease-in-out;
        }
    </style>
    <style>
        /* Tambahan untuk memperkecil font */
        .small-table th,
        .small-table td {
            font-size: 12px !important;
            white-space: nowrap;
        }

        .small-table th .sort-icon {
            font-size: 10px !important;
            margin-left: 3px;
        }

        /* --- Tombol Mengambang di Pojok Kanan Bawah --- */
        .floating-btn {
            position: fixed;
            bottom: 24px;
            right: 24px;
            border-radius: 50%;
            z-index: 1050;
            transition: transform 0.25s ease, box-shadow 0.25s ease;
        }

        /* Ukuran default (desktop) */
        .floating-btn {
            width: 56px;
            height: 56px;
            font-size: 1.5rem;
        }

        /* Hover efek */
        .floating-btn:hover {
            transform: scale(1.08);
            box-shadow: 0 0 15px rgba(0, 0, 0, 0.25);
        }

        /* 📱 Ukuran untuk tablet & layar sentuh */
        @media (max-width: 992px) {
            .floating-btn {
                width: 72px;
                height: 72px;
                font-size: 1.8rem;
                bottom: 18px;
                right: 18px;
            }
        }

        /* 🎨 Opsi tambahan warna lembut */
        .btn-primary {
            background-color: #4da6ff;
            border-color: #4da6ff;
        }

        .btn-primary:hover {
            background-color: #3385ff;
            border-color: #3385ff;
        }

        /* === STICKY LEFT-BOTTOM BAR === */
        .liquid-bar-wrapper {
            position: fixed;
            bottom: 2vh;
            left: 2vh;
            z-index: 9999;
        }

        /* Kontainer mengikuti ukuran layar */
        .liquid-bar {
            width: 8vw;
            /* menyesuaikan lebar layar */
            height: 9vw;
            /* otomatis proporsional */
            max-width: 120px;
            /* batas agar tidak kebesaran */
            max-height: 135px;
            min-width: 65px;
            /* batas agar tidak terlalu kecil */
            min-height: 75px;
            border-radius: 2vw;
            overflow: hidden;
            position: relative;
            background: #e8f0ff;
            box-shadow: 0 0.8vw 2vw rgba(0, 0, 0, 0.15);
            display: flex;
            align-items: center;
            justify-content: center;
        }

        /* SVG otomatis ikut kontainer */
        .liquid-svg {
            position: absolute;
            width: 359%;
            height: 9.7vw;
            top: 0;
            left: 0;
        }

        /* Fill tetap relatif */
        .liquid-fill {
            fill: #91c6ff;
            transform: translateY(100%);
            transition: transform 1.2s ease;
        }

        /* Teks proporsional */
        .liquid-bar-text {
            position: relative;
            z-index: 5;
            text-align: center;
            font-weight: 700;
            color: #003366;
        }

        .liquid-bar-text span {
            font-size: 1.3vw;
        }

        .liquid-bar-text small {
            font-size: 0.7vw;
            opacity: 0.85;
        }

        .liquid-bar-text div {
            font-size: 1vw;
            opacity: 0.85;
        }

        /* Batasan agar ukuran teks tetap readable */
        @media (max-width: 700px) {
            .liquid-bar-text span {
                font-size: 3vw;
            }

            .liquid-bar-text small {
                font-size: 2vw;
            }
        }
    </style>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/pawc5944/public_html/butcher/resources/views/items.blade.php ENDPATH**/ ?>