@extends('layouts.app')
@section('title', 'Budget Report')
@section('content')

    <div class="container-fluid py-4" style="min-height:100vh; background:#fff9f4;">

        <h3 class="text-center mb-4 fw-bold text-primary">
            📊 Monthly Budget Summary
        </h3>

        {{-- ===== Top Row: Summary + Search Bar ===== --}}
        <div class="row mb-3 align-items-center" style="margin-left: 250px">

            {{-- SUMMARY: Total Budget Bulan Lalu (Sebelah kiri search) --}}
            <div class="col-auto">
                <div class="p-3 shadow-sm rounded-4 text-center" style="background:#ffffff; min-width:180px;">
                    <div class="fw-bold text-secondary">
                        Cost Used ({{ \Carbon\Carbon::now()->subMonth()->format('F Y') }})
                    </div>
                    <div class="fs-6 fw-bold text-danger">
                        {{ number_format($sumCost) }}
                    </div>
                </div>
            </div>

            {{-- SEARCH BAR (Tetap tepat di tengah halaman) --}}
            <div class="col-md-4 ">
                <input id="searchInput" type="text" class="form-control shadow-sm text-center"
                    placeholder="🔍 Search anything...">
            </div>

        </div>


        {{-- ===== Table Card ===== --}}
        <div class="card shadow-sm border-0 rounded-4 p-3" style="background:#ffffff;">
            <div class="table-responsive">
                <table id="budgetTable" class="table table-hover align-middle ">
                    <thead class="table-light">
                        <tr>
                            <th data-sort="ItemNo">Item No <span class="sort-icon"></span></th>
                            <th data-sort="Description">Description <span class="sort-icon"></span></th>
                            <th data-sort="LocationCode">Location <span class="sort-icon"></span></th>
                            <th data-sort="PostingDate">Posting Date <span class="sort-icon"></span></th>
                            <th data-sort="Stock">Stock <span class="sort-icon"></span></th>
                            <th data-sort="CostAmountActual">Cost Actual <span class="sort-icon"></span></th>


                        </tr>
                    </thead>

                    <tbody id="budgetBody">
                        @foreach ($budgetItems as $item)
                            <tr class="fade-in-row">
                                <td>{{ $item['ItemNo'] }}</td>
                                <td>{{ $item['Description'] }}</td>
                                <td>{{ $item['LocationCode'] }}</td>
                                <td>{{ $item['PostingDate'] }}</td>
                                <td class=" badge rounded-pill text-bg-success">
                                    {{ $item['Stock'] }}
                                    <span>{{ $item['Base_UoM'] }}</span>
                                </td>

                                <td class="text-danger fw-semibold">{{ number_format($item['TotalCostActual']) }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>

    </div>

@endsection

@push('styles')
    <style>
        .small-table th,
        .small-table td {
            font-size: 13px !important;
        }

        .sort-icon {
            font-size: 12px;
            opacity: .6;
            margin-left: 3px;
            visibility: hidden;
            /* default hidden */
        }

        .sorted-column .sort-icon {
            visibility: visible !important;
        }

        /* Row animation */
        .fade-in-row {
            opacity: 0;
            transform: translateY(10px);
            animation: fadeSlideIn .4s ease forwards;
        }

        @keyframes fadeSlideIn {
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        /* Hover effect */
        #budgetTable tbody tr:hover {
            background: #fff3e6;
            transition: .2s ease;
        }
    </style>
@endpush

@push('scripts')
    <script>
        // ===========================================
        // REALTIME SEARCH
        // ===========================================
        document.getElementById('searchInput').addEventListener('keyup', function() {
            const value = this.value.toLowerCase();
            const rows = document.querySelectorAll('#budgetBody tr');

            rows.forEach(row => {
                row.style.display = row.innerText.toLowerCase().includes(value) ? '' : 'none';
            });
        });

        // ===========================================
        // SORTING TABLE improved with better icons
        // ===========================================
        const headers = document.querySelectorAll('#budgetTable th[data-sort]');

        headers.forEach(th => {
            th.addEventListener('click', () => {
                const tbody = document.getElementById('budgetBody');
                const rows = Array.from(tbody.querySelectorAll('tr'));
                const asc = th.classList.toggle('sorted-asc');

                // Reset semua header lain
                headers.forEach(h => {
                    if (h !== th) {
                        h.classList.remove('sorted-asc', 'sorted-desc', 'sorted-column');
                        h.querySelector('.sort-icon').innerText = '';
                    }
                });

                // Set icon + class untuk kolom aktif
                const icon = th.querySelector('.sort-icon');
                th.classList.add('sorted-column');

                if (asc) {
                    th.classList.remove('sorted-desc');
                    icon.innerText = '↑';
                } else {
                    th.classList.add('sorted-desc');
                    icon.innerText = '↓';
                }

                const index = th.cellIndex;

                rows.sort((a, b) => {
                    const valA = a.children[index].innerText.trim();
                    const valB = b.children[index].innerText.trim();

                    if (!isNaN(valA) && !isNaN(valB)) {
                        return asc ? valA - valB : valB - valA;
                    }

                    return asc ?
                        valA.localeCompare(valB) :
                        valB.localeCompare(valA);
                });

                tbody.innerHTML = "";
                rows.forEach(r => tbody.appendChild(r));
            });
        });
    </script>
@endpush
