<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('budget_butcher', function (Blueprint $table) {
            $table->id();

            $table->string('LocationCode', 50)->index();
            $table->date('PostingDate')->index();
            $table->float('CostAmountActual');

            $table->string('ItemNo', 50)->nullable()->index();     // 🔥 field baru
            $table->string('Description', 255)->nullable();        // 🔥 field baru

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('budget_butcher');
    }
};
