<?php

namespace App\Http\Controllers;
use App\Services\BusinessCentralService;
use Illuminate\Http\Request;

class Inventorylot extends Controller
{
    protected $bc;

    public function __construct(BusinessCentralService $bc)
    {
        $this->bc = $bc;
    }

    public function index()
{
    // Ambil data dari service
    $response = $this->bc->getItemLot();

    // Cek error
    if ($response['status'] !== 'success') {
        return view('Inventorylot.index', [
            'items'  => [],
            'error'  => $response['message'] ?? 'Unknown error'
        ]);
    }

    $items = $response['items'];

    // ===========================
    // FILTER: HANYA AMBIL YANG TotalQty > 0
    // ===========================
    $items = array_filter($items, function ($i) {
        return isset($i['TotalQty']) && $i['TotalQty'] > 0;
    });

    // Optional: reindex array
    $items = array_values($items);

    // Debug jika mau
    

    return view('Inventorylot.index', [
        'items' => $items,
        'count' => count($items),
    ]);
}
}
