<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>PO Suggestions</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/vue@3.4.0/dist/vue.global.prod.js"></script>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">

<link rel="stylesheet" href="https://unpkg.com/vue-select@4.0.0/dist/style.css">
<script src="https://unpkg.com/vue-select@4.0.0/dist/vue-select.iife.js"></script>
    <style>
        body {
            background-color: #f8f9fa;
            font-family: "Segoe UI", Tahoma, Geneva, Verdana, sans-serif;
        }

        .container {
            max-width: 100%;
        }

        .card {
            border-radius: 1rem;
            box-shadow: 0 6px 20px rgba(0, 0, 0, 0.1);
            border: none;
        }

        .card-header {
            background-color: #0d6efd;
            color: white;
            font-weight: 500;
            border-top-left-radius: 1rem;
            border-top-right-radius: 1rem;
        }

        .table th, .table td {
            vertical-align: middle;
            font-size: 0.9rem;
        }

        .table th {
            background-color: #0d6efd;
            color: white;
        }

        .table tbody tr:hover {
            background-color: #f1f1f1;
        }

        .form-label {
            font-weight: 600;
            color: #333;
        }

        select[multiple] {
            min-height: 140px;
            overflow-y: auto;
        }

        select.form-select option {
            padding: 10px;
            font-weight: 500;
        }
        .btn {
            transition: all 0.2s ease-in-out;
        }
        .btn-success {
            border-radius: 10px;
            padding: 10px 24px;
            font-weight: 600;
            transition: all 0.3s ease;
        }

        .btn-success:hover {
            background-color: #198754;
            box-shadow: 0 4px 12px rgba(25, 135, 84, 0.2);
            transform: translateY(-1px);
        }

        .pagination .page-link {
            color: #0d6efd;
            border-radius: 0.5rem;
            margin: 0 2px;
        }

        .pagination .page-item.active .page-link {
            background-color: #0d6efd;
            border-color: #0d6efd;
        }

        .overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.6);
            z-index: 9999;
            display: flex;
            align-items: center;
            justify-content: center;
            animation: fadeIn 0.3s ease-in-out;
        }

        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }

        .btn:hover {
            transform: translateY(-1px);
            box-shadow: 0 4px 10px rgba(0,0,0,0.1);
        }

        .spinner-box {
            text-align: center;
        }

        @media (max-width: 768px) {
            .form-label { font-size: 0.85rem; }
            .form-control, .form-select { font-size: 0.85rem; }
            .table td { padding: 0.75rem 0.5rem; }
            .form-control, .form-select {
                font-size: 0.9rem;
            }

            .table thead {
                display: none;
            }

            .table tbody td {
                display: block;
                width: 100%;
            }

            .table tbody tr {
                margin-bottom: 1rem;
                border-bottom: 2px solid #dee2e6;
            }

            .table tbody td:before {
                content: attr(data-label);
                font-weight: bold;
                display: block;
                margin-bottom: 5px;
                color: #495057;
            }
        }
    </style>

</head>
<body>

<div id="app" class="container mt-4">
    <div v-if="isSubmitting || isExporting" class="overlay">
    <div class="spinner-box">
        <div class="spinner-border text-light" role="status"></div>
        <p class="text-white mt-3">
            <span v-if="isSubmitting">Creating PO... Please wait.</span>
            <span v-else>Exporting... Please wait.</span>
        </p>    
    </div>
</div>
    <div class="row g-4">
        <div class="col-md-10">
            <h2>PO Suggestions</h2>
        </div>
        <div class="col-md-2">
            <form method="GET" action="<?php echo e(route('export.missing.vendor')); ?>" @submit="onExportClick" class="d-inline">
                <?php echo csrf_field(); ?>
                <button type="submit" class="btn btn-outline-danger mb-3" :disabled="isExporting">
                    <i class="bi bi-file-earmark-excel"></i>
                    <span v-if="isExporting">Exporting...</span>
                    <span v-else>Export Missing Vendor</span>
                </button>
            </form>

        </div>
    </div>

    
    <?php if(session('success')): ?>
        <div class="alert alert-success">
            <?php echo e(session('success')); ?>

            <ul>
                <?php $__currentLoopData = session('createdPOs', []); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $po): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li>Vendor: <?php echo e($po['vendor']); ?>, PO No: <?php echo e($po['po_no']); ?>, Lines: <?php echo e($po['line_count']); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>
    <div class="row mb-3">
        <div class="card mb-4">
            <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
                <span><i class="bi bi-funnel me-2"></i>Filters</span>
                <button class="btn btn-outline-light btn-sm" @click="resetFilters">
                    <i class="bi bi-arrow-clockwise me-1"></i> Reset
                </button>
            </div>
            <div class="card-body">
                <div class="row g-4">
                    <div class="col-md-4">
                        <label class="form-label">Search Vendor</label>
                        <input type="text" class="form-control" v-model="vendorSearch" placeholder="e.g., PRATAMA|AMRITHA">
                        
                        <label class="form-label mt-3">Search Item</label>
                        <input type="text" class="form-control" v-model="itemSearch" placeholder="e.g., DRY GOODS|PASTRY">
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">Filter by Vendor</label>
                        <select class="form-select" multiple v-model="selectedVendors">
                            <option v-for="(name, no) in vendors" :value="no">{{ name }}</option>
                        </select>

                        <label class="form-label mt-3">Filter by Location</label>
                        <select class="form-select" v-model="selectedLocation">
                            <option value="">All Locations</option>
                            <option v-for="loc in locations" :value="loc">{{ loc }}</option>
                        </select>
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">Filter by Status</label>
                        <div class="d-flex flex-wrap gap-2">
                            <div v-for="status in statuses" :key="status" class="form-check form-check-inline">
                                <input class="form-check-input" type="checkbox" :id="'status-' + status" :value="status" v-model="selectedStatus">
                                <label class="form-check-label" :for="'status-' + status">{{ status }}</label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <form ref="poForm" method="POST" action="<?php echo e(route('create-po')); ?>">
        <?php echo csrf_field(); ?>
        <table class="table table-bordered table-striped">
            <thead class="table-primary">
            <tr>
                <th><input type="checkbox" @change="toggleSelectAll($event)" :checked="areAllFilteredSelected"></th>
                <th @click="sortBy('item_no')" style="cursor:pointer">Item No <span v-if="sortKey === 'item_no'">{{ sortDirection === 'asc' ? '▲' : '▼' }}</span> </th>
                <th @click="sortBy('vendor_no')" style="cursor:pointer">Vendors <span v-if="sortKey === 'vendor_no'">{{ sortDirection === 'asc' ? '▲' : '▼' }}</span> </th>
                <th @click="sortBy('description')" style="cursor:pointer">Description <span v-if="sortKey === 'description'">{{ sortDirection === 'asc' ? '▲' : '▼' }}</span> </th>
                <th @click="sortBy('min_qty')" style="cursor:pointer">MinQty <span v-if="sortKey === 'min_qty'">{{ sortDirection === 'asc' ? '▲' : '▼' }}</span> </th>
                <th @click="sortBy('max_qty')" style="cursor:pointer">MaxQty <span v-if="sortKey === 'max_qty'">{{ sortDirection === 'asc' ? '▲' : '▼' }}</span> </th>
                <th @click="sortBy('stock')" style="cursor:pointer">Stock <span v-if="sortKey === 'stock'">{{ sortDirection === 'asc' ? '▲' : '▼' }}</span> </th>
                <th @click="sortBy('on_po')" style="cursor:pointer">OnPO <span v-if="sortKey === 'on_po'">{{ sortDirection === 'asc' ? '▲' : '▼' }}</span> </th>
                <th @click="sortBy('in_transfer')" style="cursor:pointer">InTransfer <span v-if="sortKey === 'in_transfer'">{{ sortDirection === 'asc' ? '▲' : '▼' }}</span> </th>
                <th @click="sortBy('qty_to_order')" style="cursor:pointer">QtyToOrder <span v-if="sortKey === 'qty_to_order'">{{ sortDirection === 'asc' ? '▲' : '▼' }}</span> </th>
                <th>Status</th>
            </tr>
            </thead>
            <tbody>
            <tr v-for="item in paginatedItems" :key="item.item_no">                    
                <td><input type="checkbox" name="selected_items[]" :value="item.item_no" v-model="selectedItems"></td>
                    <td>{{ item.item_no }}</td>
                    <td>
                        <select class="form-select"
                            :name="'vendor_no[' + item.item_no + ']'"
                            v-model="item.vendor_no">
                        <option 
                            v-for="(vendor, vendorNo) in vendorOptionsByItem[item.item_no] || {}" 
                            :key="vendorNo" 
                            :value="vendorNo"
                        >
                            {{ vendor.name }} - Rp {{ Number(vendor.unit_cost).toLocaleString() }}
                        </option>
                        </select>
                    </td>
                    <td>{{ item.description }}</td>
                    <td>{{ item.min_qty }}</td>
                    <td>{{ item.max_qty }}</td>
                    <td>{{ item.stock }}</td>
                    <td>{{ item.on_po }}</td>
                    <td>{{ item.in_transfer }}</td>
                    <td>
                        
                        <input 
                            type="number" 
                            class="form-control form-control-sm"
                            min="0"
                            step="any"
                            v-model.number="item.qty_to_order"
                            :name="'qty_to_order[' + item.item_no + ']'"
                        >
                    </td>
                    <td>
                        <span v-if="item.status && item.status.startsWith('Transfer')" class="badge bg-warning text-dark">{{ item.status }}</span>
                        <span v-else-if="item.status === 'Order For Stock'" class="badge bg-success">{{ item.status }}</span>
                        <span v-else-if="item.status === 'No Need Order'" class="badge bg-secondary">{{ item.status }}</span>
                        <span v-else-if="item.status === 'Need Order'" class="badge bg-danger">{{ item.status }}</span>
                    </td>
                </tr>
            </tbody>
        </table>

        <nav>
            <ul class="pagination justify-content-center">
                <li class="page-item" :class="{ disabled: currentPage === 1 }">
                    <a class="page-link" href="#" @click.prevent="currentPage--">Previous</a>
                </li>
                <li class="page-item" v-for="page in visiblePages" :key="page" :class="{ active: currentPage === page }">
                    <a class="page-link" href="#" @click.prevent="currentPage = page">{{ page }}</a>
                </li>

                <li class="page-item" :class="{ disabled: currentPage === totalPages }">
                    <a class="page-link" href="#" @click.prevent="currentPage++">Next</a>
                </li>
            </ul>
        </nav>
        <div class="text-end">
            <button class="btn btn-success btn-lg rounded-pill">
                <i class="bi bi-check2-circle me-1"></i> Create PO
            </button>
        </div>
    </form>
</div>
<script>
    const { createApp } = Vue;    
    const app = createApp({
        data() {
            return {
                vendorOptionsByItem: <?php echo json_encode($vendorOptionsByItem, 15, 512) ?>,
                isSubmitting: false,
                items: <?php echo json_encode($items, 15, 512) ?>,
                vendors: <?php echo json_encode($vendors, 15, 512) ?>,
                locations: <?php echo json_encode($locations, 15, 512) ?>,
                statuses: <?php echo json_encode($statuses, 15, 512) ?>,
                selectedStatus: [],
                selectedItems: [],
                selectedVendors: [],
                selectedLocation: '',
                itemSearch: '',
                currentPage: 1,
                perPage: 30,
                vendorSearch: '',
                sortKey: '',
                sortDirection: 'asc',
                isExporting: false,
            };
        },
        computed: {
            filteredItems() {
                let results = this.items.filter(item => {
                    const trimmedVendorNo = item.vendor_no?.trim() ?? '';
                    const itemNo = String(item.item_no).trim();
                    const allVendorNames = Object.values(this.vendorOptionsByItem[itemNo] || {}).map(v => v.name);
                    const vendorKeywords = this.vendorSearch.toLowerCase().split('|').map(v => v.trim()).filter(v => v !== '');
                    const itemVendorNos = Object.keys(this.vendorOptionsByItem[item.item_no] || {});
                    const matchVendor = this.selectedVendors.length === 0 ||
                        this.selectedVendors.some(vendor => itemVendorNos.includes(vendor));
                    const matchVendorSearch = vendorKeywords.length === 0 ||
                        vendorKeywords.some(keyword =>
                            allVendorNames.some(name => name.toLowerCase().includes(keyword))
                        );                    
                    const matchLocation = this.selectedLocation === '' || item.location_code === this.selectedLocation;
                    const itemKeywords = this.itemSearch.toLowerCase().split('|').map(v => v.trim()).filter(v => v !== '');
                    const matchStatus = this.selectedStatus.length === 0 || this.selectedStatus.includes(item.status);
                    const matchSearch = itemKeywords.length === 0 || itemKeywords.some(v => {
                        const searchText = `${item.item_no ?? ''} ${item.description ?? ''}`.toLowerCase();
                        return searchText.includes(v);
                    });
                    return matchVendor && matchVendorSearch && matchLocation && matchSearch && matchStatus;

                });
                if (this.sortKey) {
                    results.sort((a, b) => {
                        const aVal = a[this.sortKey] ?? '';
                        const bVal = b[this.sortKey] ?? '';
                        if (typeof aVal === 'number' && typeof bVal === 'number') {
                            return this.sortDirection === 'asc' ? aVal - bVal : bVal - aVal;
                        }
                        return this.sortDirection === 'asc'
                            ? String(aVal).localeCompare(String(bVal))
                            : String(bVal).localeCompare(String(aVal));
                    });
                }

                return results;
            },
            paginatedItems() {
                const start = (this.currentPage - 1) * this.perPage;
                return this.filteredItems.slice(start, start + this.perPage);
            },
            totalPages() {
                return Math.ceil(this.filteredItems.length / this.perPage);
            },
            pageStart() {
                return Math.floor((this.currentPage - 1) / 10) * 10 + 1;
            },
            pageEnd() {
                return Math.min(this.pageStart + 9, this.totalPages);
            },
            visiblePages() {
                const pages = [];
                for (let i = this.pageStart; i <= this.pageEnd; i++) {
                pages.push(i);
                }
                return pages;
            },
            areAllFilteredSelected() {
                return this.filteredItems.every(item => this.selectedItems.includes(item.item_no));
            }
            
        },
        watch: {
            itemSearch() { this.currentPage = 1; },
            vendorSearch() { this.currentPage = 1; },
            selectedVendors() { this.currentPage = 1; },
            selectedLocation() { this.currentPage = 1; },
            selectedStatus() { this.currentPage = 1; },
        },
        methods: {
            resetFilters() {
            this.itemSearch = '';
            this.vendorSearch = '';
            this.selectedVendors = [];
            this.selectedLocation = '';
            this.selectedStatus = [];
            this.currentPage = 1;
        },
            toggleSelectAll(event) {
                const isChecked = event.target.checked;
                const filteredIds = this.filteredItems.map(item => item.item_no);

                if (isChecked) {
                    this.selectedItems = Array.from(new Set([...this.selectedItems, ...filteredIds]));
                } else {
                    this.selectedItems = this.selectedItems.filter(id => !filteredIds.includes(id));
                }
            },
            sortBy(key) {
                if (this.sortKey === key) {
                    this.sortDirection = this.sortDirection === 'asc' ? 'desc' : 'asc';
                } else {
                    this.sortKey = key;
                    this.sortDirection = 'asc';
                }
            },
            onExportClick(event) {
                this.isExporting = true;

            },
            validateAndSubmit() {
                if (this.isSubmitting) return;
                const itemsWithNoVendor = this.selectedItems.filter(itemNo => {
                    const item = this.items.find(i => i.item_no === itemNo);
                    return !item?.vendor_no;
                });

                if (itemsWithNoVendor.length > 0) {
                    alert(`The following items have no vendor selected:\n${itemsWithNoVendor.join(', ')}`);
                    return;
                }
                this.isSubmitting = true;

                const form = this.$refs.poForm;
                form.querySelectorAll('.dynamic-hidden').forEach(el => el.remove());

                this.selectedItems.forEach(itemNo => {
                    const item = this.items.find(i => i.item_no === itemNo);
                    if (!item) return;
                    const inputItem = document.createElement('input');
                    inputItem.type = 'hidden';
                    inputItem.name = 'selected_items[]';
                    inputItem.value = itemNo;
                    inputItem.classList.add('dynamic-hidden');
                    form.appendChild(inputItem);
                    const inputVendor = document.createElement('input');
                    inputVendor.type = 'hidden';
                    inputVendor.name = `vendor_no[${itemNo}]`;
                    inputVendor.value = item.vendor_no ?? '';
                    inputVendor.classList.add('dynamic-hidden');
                    form.appendChild(inputVendor);
                    const inputQty = document.createElement('input');
                    inputQty.type = 'hidden';
                    inputQty.name = `qty_to_order[${itemNo}]`;
                    inputQty.value = item.qty_to_order ?? 0;
                    inputQty.classList.add('dynamic-hidden');
                    form.appendChild(inputQty);
                });

                form.submit();

                this.items = this.items.filter(item => !this.selectedItems.includes(item.item_no));
                this.selectedItems = [];
            }

        }
    })
    app.component('v-select', window['vue-select']);
  
    app.mount('#app');
</script>



</body>
</html><?php /**PATH /home/kmir2197/public_html/bc/resources/views/po-suggestion.blade.php ENDPATH**/ ?>