@extends('layouts.app')
@push('styles')
<style>
    .sticky-table-wrapper {
        max-height: 600px;
        overflow-y: auto;
        overflow-x: auto;
    }

    .sticky-table-wrapper table {
        width: 100%;
        table-layout: auto;
    }

    .sticky-table-wrapper thead th {
        position: sticky;
        top: 0;
        background-color: #111111;
        color: white;
        z-index: 10;
        text-align: justify;
    }

    .sticky-table-wrapper input[type="checkbox"] {
        transform: scale(1.5); 
        margin: 0.3rem;
        cursor: pointer;
    }
    .sticky-table-wrapper td textarea {
        white-space: normal !important;
        min-width: 150px;
    }
    .sticky-table-wrapper tbody td,
    .sticky-table-wrapper tbody input,
    .sticky-table-wrapper tbody textarea,
    .sticky-table-wrapper tbody select {
        font-size: 15px;
        font-weight: bold;
    }
    .fit-content {
        width: 1%;
        max-width: 100px;
        white-space: nowrap;
    }
</style>
@endpush
@section('content')
<div class="container-fluid py-4">

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif
    
    <div id="app">
        <div class="row mb-3">
            <div class="col-md-8">
                <h2>SKU Suggestion Mapping</h2>
            </div>
            <div class="col-md-4 d-flex justify-content-start">
                <form action="{{ route('refresh.MinMax.suggestions') }}" method="POST">
                    @csrf
                    <button class="btn btn-outline-primary">
                        <i class="bi bi-arrow-repeat me-1"></i> Refresh Cache
                    </button>
                </form>
            </div>
        </div>
        <div class="row mb-3">
            <div class="col-md-4">
                <div class="d-flex flex-wrap gap-2 mb-3">
                    @if(Str::contains(session('user')['email'] ?? '', ['Michael', 'adminbc']))
                        <button class="btn btn-primary" @click="uploadStockkeeping" :disabled="isSubmitting">
                            <i class="fas fa-upload me-1"></i> Upload Stockkeeping
                        </button>
                    @else
                    <button class="btn btn-success" @click="submitUpdates" :disabled="isSubmitting">
                        <i class="fas fa-save me-1"></i>
                        <span v-if="isSubmitting">Updating...</span>
                        <span v-else>Update SKU</span>
                    </button>
                    @endif
                    <button class="btn btn-outline-secondary" @click="resetAllRows" :disabled="isSubmitting">
                        <i class="fas fa-rotate-left me-1"></i> Undo All
                    </button>
                </div>
                <div class="mb-3">
                    <button class="btn btn-warning w-100" @click="applySuggestionToSelected" :disabled="isSubmitting">
                        <i class="fas fa-magic me-1"></i> Follow Suggestion
                    </button>
                </div>
            </div>
            <div class="col-md-4">
                <div class="mb-3">
                    <label for="locationFilter" class="form-label fw-bold">Filter by Location</label>
                    <select class="form-select w-auto d-inline" v-model="selectedLocation" id="locationFilter">
                        <option value="">All Locations</option>
                        <option value="CI.1010">CI.1010</option>
                        <option value="CI.1020">CI.1020</option>
                    </select>
                </div>
                <div class="form-check mb-3">
                    <input class="form-check-input" type="checkbox" id="onlyModified" v-model="showOnlyModified">
                    <label class="form-check-label" for="onlyModified">
                        Show Only Modified Rows
                    </label>
                </div>
                <div class="form-check mb-3">
                    <input class="form-check-input" type="checkbox" id="onlySelected" v-model="showOnlySelected">
                    <label class="form-check-label" for="onlySelected">
                        Show Only Selected Rows
                    </label>
                </div>
            </div>
            <div class="col-md-4">
                <div class="mb-3">
                    <label for="searchText" class="form-label fw-bold">Search Item No / Name</label>
                    <input type="text" class="form-control form-control-sm" id="searchText" v-model="searchText" placeholder="Search...">
                </div>
                <div class="mb-3">
                    <label class="form-label fw-bold">Filter by Status</label>
                    <select class="form-select w-auto d-inline" v-model="statusFilter">
                        <option value="">All</option>
                        <option value="active">Active</option>
                        <option value="inactive">Inactive</option>
                    </select>
                </div>
            </div>  
        </div>
        <div class="sticky-table-wrapper">
            <table class="table table-striped table-hover table-bordered align-middle">
                    <thead class="table-dark">
                        <tr>
                            <th><input type="checkbox" v-model="selectAll" @change="toggleSelectAll"></th>
                            <th @click="sortBy('Item_No')" style="cursor:pointer">
                                Item No
                                <span v-if="sortColumn === 'Item_No'">
                                    <i :class="sortDirection === 'asc' ? 'fas fa-arrow-up' : 'fas fa-arrow-down'"></i>
                                </span>
                            </th>
                            <th @click="sortBy('Description')" style="cursor:pointer">
                                Description
                                <span v-if="sortColumn === 'Description'">
                                    <i :class="sortDirection === 'asc' ? 'fas fa-arrow-up' : 'fas fa-arrow-down'"></i>
                                </span>
                            </th>
                            <th class="fit-content" @click="sortBy('Stock_For')" style="cursor:pointer">
                                Stock For <br> (Days)
                                <span v-if="sortColumn === 'Stock_For'">
                                    <i :class="sortDirection === 'asc' ? 'fas fa-arrow-up' : 'fas fa-arrow-down'"></i>
                                </span>
                            </th>
                            <th class="fit-content" @click="sortBy('Lead Time')" style="cursor:pointer">
                                Lead Time
                                <span v-if="sortColumn === 'Lead Time'">
                                    <i :class="sortDirection === 'asc' ? 'fas fa-arrow-up' : 'fas fa-arrow-down'"></i>
                                </span>
                            </th>
                            <th class="fit-content" @click="sortBy('Consumption')" style="cursor:pointer">
                                Consumption<br><small>For 2 Months</small>
                                <span v-if="sortColumn === 'Consumption'">
                                    <i :class="sortDirection === 'asc' ? 'fas fa-arrow-up' : 'fas fa-arrow-down'"></i>
                                </span>
                            </th>
                            <th class="fit-content" @click="sortBy('SuggestMinQty')" style="cursor:pointer">
                                Min Qty <br> <small>(Suggested)</small>
                                <span v-if="sortColumn === 'SuggestMinQty'">
                                    <i :class="sortDirection === 'asc' ? 'fas fa-arrow-up' : 'fas fa-arrow-down'"></i>
                                </span>
                            </th>
                            <th class="fit-content" @click="sortBy('ActMinQty')" style="cursor:pointer">
                                Min Qty <br> <small>(Temp)</small>
                                <span v-if="sortColumn === 'ActMinQty'">
                                    <i :class="sortDirection === 'asc' ? 'fas fa-arrow-up' : 'fas fa-arrow-down'"></i>
                                </span>
                            </th>
                            <th class="fit-content" @click="sortBy('RealMinQty')" style="cursor:pointer">
                                Min Qty <br> <small>(Actual)</small>
                                <span v-if="sortColumn === 'RealMinQty'">
                                    <i :class="sortDirection === 'asc' ? 'fas fa-arrow-up' : 'fas fa-arrow-down'"></i>
                                </span>
                            </th>
                            <th class="fit-content" @click="sortBy('SuggestMaxQty')" style="cursor:pointer">
                                Max Qty <br> <small>(Suggested)</small>
                                <span v-if="sortColumn === 'SuggestMaxQty'">
                                    <i :class="sortDirection === 'asc' ? 'fas fa-arrow-up' : 'fas fa-arrow-down'"></i>
                                </span>
                            </th>
                            <th class="fit-content" @click="sortBy('ActMaxQty')" style="cursor:pointer">
                                Max Qty <br> <small>(Temp)</small>
                                <span v-if="sortColumn === 'ActMaxQty'">
                                    <i :class="sortDirection === 'asc' ? 'fas fa-arrow-up' : 'fas fa-arrow-down'"></i>
                                </span>
                            </th>
                            <th class="fit-content" @click="sortBy('RealMaxQty')" style="cursor:pointer">
                                Max Qty <br> <small>(Actual)</small>
                                <span v-if="sortColumn === 'RealMaxQty'">
                                    <i :class="sortDirection === 'asc' ? 'fas fa-arrow-up' : 'fas fa-arrow-down'"></i>
                                </span>
                            </th>
                            <th>Reset</th>
                            <th>Action</th>
                            <th style="min-width: 150px;">Comment</th>
                            <th @click="sortBy('LastModifiedAt')" style="cursor:pointer">
                                Modified At
                                <span v-if="sortColumn === 'LastModifiedAt'">
                                    <i :class="sortDirection === 'asc' ? 'fas fa-arrow-up' : 'fas fa-arrow-down'"></i>
                                </span>
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr v-for="(row, index) in filteredRows" :key="index" :class="{ 'table-danger': isRowModified(row) }">
                            <td> <input type="checkbox" v-model="row.selected"></td>
                            <td><strong>@{{ row.Item_No }}</strong></td>
                            <td>@{{ row.Description }}</td>
                            <td>
                            <input type="number"
                                    class="form-control form-control-sm"
                                    v-model.number="row['Stock_For']"
                                    @input="updateSuggestions(row)">
                            </td>
                            <td>
                            <input type="number"
                                    class="form-control form-control-sm"
                                    v-model.number="row['Lead Time']"
                                    @input="updateSuggestions(row)">
                            </td>                            
                            <td>@{{ formatNumber(row['Consumption']) }}</td>
                            <td class="text-primary">@{{ formatNumber(row.SuggestMinQty) }}</td>
                            <td><input type="number" class="form-control form-control-sm" v-model.number="row.ActMinQty"></td>
                            <td class="text-success">@{{ formatNumber(row.RealMinQty) }}</td>
                            <td class="text-primary">@{{ formatNumber(row.SuggestMaxQty) }}</td>
                            <td><input type="number" class="form-control form-control-sm" v-model.number="row.ActMaxQty"></td>
                            <td class="text-success">@{{ formatNumber(row.RealMaxQty) }}</td>
                            <td>
                                <button class="btn btn-sm btn-outline-secondary" @click="resetRow(row)">
                                    <i class="fas fa-undo"></i> Reset
                                </button>
                            </td>
                            <td >
                                <div class="d-flex flex-column flex-md-row gap-1">
                                    <button
                                            class="btn btn-sm btn-warning"
                                            :disabled="isSubmitting"
                                            @click="applySuggestionToRow(row)">
                                            <i class="fas fa-magic me-1"></i> Follow
                                    </button>

                                    @php
                                        $email = strtolower(session('user')['email'] ?? '');
                                    @endphp

                                    @if(Str::contains($email, ['michael', 'adminbc']))
                                        <button
                                            class="btn btn-sm btn-primary"
                                            :disabled="isSubmitting"
                                            @click="uploadStockkeepingRow(row)">
                                            <i class="fas fa-upload me-1"></i> Upload
                                        </button>
                                    @else
                                        <button
                                            class="btn btn-sm btn-success"
                                            :disabled="isSubmitting"
                                            @click="saveSingleRow(row)">
                                            <i class="fas fa-save me-1"></i> Save
                                        </button>
                                        
                                    @endif
                                </div>
                            </td>
                            <td style="min-width: 150px; white-space: normal;">
                                <textarea class="form-control form-control-sm" rows="3" v-model="row['Comment']"></textarea>
                            </td>
                            <td>
                                @{{ row.LastModifiedAt }}
                            </td>
                        </tr>
                    </tbody>
                </table>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css">
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>
<script>
    $(document).ready(function () {
        $('#sku-table').DataTable({
            pageLength: 25,
            order: [[ 0, 'asc' ]],
            responsive: true,
            language: {
                search: "_INPUT_",
                searchPlaceholder: "Search Item No or Qty..."
            }
        });
    });
</script>

<script>
const { createApp } = Vue;

createApp({
    data() {
        return {
            rows: @json($result),
            isSubmitting: false,
            selectedLocation: '',
            showOnlyModified: false,
            selectAll: false,
            searchText: '',
            showOnlySelected: false,
            sortColumn: '',
            sortDirection: 'asc',
            statusFilter: '',
        };
    },
    computed: {
    filteredRows() {
        let result = this.rows.filter(row => {
            const desc = row.Description?.toUpperCase() || '';
            if (desc.includes('FRUIT & VEGETABLE') || desc.includes('MEAT - ')) {
                return false;
            }
            const matchesLocation = this.selectedLocation === '' || row.Location === this.selectedLocation;

            const search = this.searchText.toLowerCase();
            const matchesSearch =
                this.searchText === '' ||
                row.Item_No.toLowerCase().includes(search) ||
                row.Description.toLowerCase().includes(search);

            const isSelected = !this.showOnlySelected || row.selected;

            const original = row.original || {};
            const isModified =
                row.Stock_For !== original.Stock_For ||
                row['Lead Time'] !== original['Lead Time'] ||
                row.ActMinQty !== row.RealMinQty ||
                row.ActMaxQty !== row.RealMaxQty;
            const isActive = !(Number(row['Consumption']) === 0);

            const matchesStatus =
                this.statusFilter === '' ||
                (this.statusFilter === 'active' && isActive) ||
                (this.statusFilter === 'inactive' && !isActive);

            if (this.showOnlyModified) {
                return matchesLocation && matchesSearch && isModified && isSelected & matchesStatus;
            }

            return matchesLocation && matchesSearch && isSelected & matchesStatus;
        });

        // if (this.sortColumn) {
        //     result.sort((a, b) => {
        //         const valA = a[this.sortColumn] ?? '';
        //         const valB = b[this.sortColumn] ?? '';
        //         const direction = this.sortDirection === 'asc' ? 1 : -1;

        //         if (typeof valA === 'number' && typeof valB === 'number') {
        //             return (valA - valB) * direction;
        //         }

        //         return valA.toString().localeCompare(valB.toString()) * direction;
        //     });
        // }

        return result;
    }


        },
            methods: {
                parseDate(str) {
                    const months = {
                        january: 0, february: 1, march: 2, april: 3,
                        may: 4, june: 5, july: 6, august: 7,
                        september: 8, october: 9, november: 10, december: 11
                    };

                    if (!str) return null;

                    const parts = str.trim().split(' ');
                    if (parts.length !== 3) return null;

                    const day = parseInt(parts[0], 10);
                    const month = months[parts[1].toLowerCase()];
                    const year = parseInt(parts[2], 10);

                    return new Date(year, month, day);
                },
                uploadStockkeepingRow(row) {
                    this.isSubmitting = true;

                    axios.post('{{ route("api.stockkeeping.upload") }}', {
                        rows: [row]
                    })
                    .then(response => {
                        alert(response.data.message || 'Stockkeeping uploaded successfully.');
                        this.updateSuggestions(row);
                        row.RealMinQty = row.ActMinQty;
                        row.RealMaxQty = row.ActMaxQty;
                        Object.assign(row.original, JSON.parse(JSON.stringify(row)));
                        row.selected = false;
                    })
                    .catch(error => {
                        console.error(error);
                        alert('Upload failed. See console for details.');
                    })
                    .finally(() => {
                        this.isSubmitting = false;
                    });
                },
                applySuggestionToRow(row) {
                    row.ActMinQty = row.SuggestMinQty;
                    row.ActMaxQty = row.SuggestMaxQty;
                },
                saveSingleRow(row) {
                    this.isSubmitting = true;

                    axios.post('{{ route("sku.update") }}', {
                        rows: [row]  
                    })
                    .then(response => {
                        this.updateSuggestions(row);
                        Object.assign(row.original, JSON.parse(JSON.stringify(row)));
                        row.selected = false;
                    })
                    .catch(error => {
                        console.error(error);
                        alert('Row update failed. See console/logs.');
                    })
                    .finally(() => {
                        this.isSubmitting = false;
                    });
                },

                applySuggestionToSelected() {
                    this.rows.forEach(row => {
                        if (row.selected) {
                            row.ActMinQty = row.SuggestMinQty;
                            row.ActMaxQty = row.SuggestMaxQty;
                        }
                    });
                },
        toggleSelectAll() {
            this.filteredRows.forEach(row => {
                row.selected = this.selectAll;
            });
        },
        updateSuggestions(row) {
            const consumption = row['Consumption / 2 months'] ?? 0;
            const stockFor = row['Stock_For'] || 0;
            const leadTime = row['Lead Time'] || 0;
            row.Consumption = consumption;
            row.SuggestMinQty = Math.ceil((leadTime + 1) * (consumption / 60));
            row.SuggestMaxQty = Math.ceil(stockFor * (consumption / 60));
        },
        formatNumber(value) {
            return new Intl.NumberFormat().format(value ?? 0);
        },
        isRowModified(row) {
            const original = row.original ?? {};
            return (
                row['Stock_For'] !== original['Stock_For'] ||
                row['Lead Time'] !== original['Lead Time'] ||
                row.ActMinQty !== original.ActMinQty ||
                row.ActMaxQty !== original.ActMaxQty ||
                row.Comment !== original.Comment
            );
        },
        resetRow(row) {
            const original = JSON.parse(JSON.stringify(row.original));
            Object.keys(original).forEach(key => {
                if (key !== 'original') row[key] = original[key];
            });
            row.selected = false;
        },

        resetAllRows() {
            this.rows.forEach(row => {
                const original = JSON.parse(JSON.stringify(row.original));
                Object.keys(original).forEach(key => {
                    if (key !== 'original') row[key] = original[key];
                });
                row.selected = false;
            });
        },
        today() {
            return new Date().toISOString(); 
        },
        uploadStockkeeping() {
            this.isSubmitting = true;

            const selectedRows = this.rows.filter(row => row.selected);

            if (selectedRows.length === 0) {
                alert('Please select at least one row to upload.');
                this.isSubmitting = false;
                return;
            }

            axios.post('{{ route("api.stockkeeping.upload") }}', {
                rows: selectedRows
            })
            .then(response => {
                alert(response.data.message || 'Stockkeeping uploaded successfully.');
                selectedRows.forEach(row => {
                    this.updateSuggestions(row);
                    row.RealMinQty = row.ActMinQty;
                    row.RealMaxQty = row.ActMaxQty;
                    row.LastModifiedAt = this.today();
                    Object.assign(row.original, JSON.parse(JSON.stringify(row)));;
                    row.selected = false;
                });
            })
            .catch(error => {
                if (error.response) {
                    console.error("Response error:", error.response);
                    alert(`Upload failed: ${error.response.status} - ${error.response.data?.message || 'Server error'}`);
                } else if (error.request) {
                    console.error("No response received:", error.request);
                    alert('Upload failed: No response from server.');
                } else {
                    console.error("Axios error:", error.message);
                    alert('Upload failed: ' + error.message);
                }
            })
            .finally(() => {
                this.isSubmitting = false;
            });
        },
        submitUpdates() {
            this.isSubmitting = true;

            const modifiedRows = this.rows.filter(row =>
                this.isRowModified(row) && row.selected
            );

            if (modifiedRows.length === 0) {
                alert('No changes to update.');
                this.isSubmitting = false;
                return;
            }

            axios.post('{{ route("sku.update") }}', {
                rows: modifiedRows
            })
            .then(response => {
                alert(response.data.message || 'Update success');
                modifiedRows.forEach(row => {
                    this.updateSuggestions(row);
                    Object.assign(row.original, JSON.parse(JSON.stringify(row)));;
                    row.selected = false;
                });
            })
            .catch(error => {
                console.error(error);
                alert('Update failed. Check console or logs.');
            })
            .finally(() => {
                this.isSubmitting = false;
            });
        },  
       sortBy(column) {
            if (this.sortColumn === column) {
                this.sortDirection = this.sortDirection === 'asc' ? 'desc' : 'asc';
            } else {
                this.sortColumn = column;
                this.sortDirection = 'asc';
            }
            const direction = this.sortDirection === 'asc' ? 1 : -1;
            const parseDate = (str) => {
                if (!str) return null;
                const parts = str.trim().split(' ');
                if (parts.length !== 3) return null;
                const day = parseInt(parts[0], 10);
                const month = new Date(`${parts[1]} 1, 2000`).getMonth(); 
                const year = parseInt(parts[2], 10);
                return new Date(year, month, day);
            };
            count = 0
            this.rows.sort((a, b) => {
                const valA = a[column];
                const valB = b[column];
                if (column == 'LastModifiedAt') {
                    const dateA = parseDate(valA);
                    const dateB = parseDate(valB);

                    if (!dateA || !dateB || isNaN(dateA) || isNaN(dateB)) return 0;
                    if (count < 100 && dateA != dateB){
                        console.log(a.Description, 'Val A' , dateA.getTime());
                        console.log(b.Description, 'Val B' , dateB.getTime());
                        console.log((dateA.getTime() - dateB.getTime()) * direction);
                    }
                    count += 1;

                    return (dateA.getTime() - dateB.getTime()) * direction;
                }

                if (typeof valA === 'number' && typeof valB === 'number') {
                    return (valA - valB) * direction;
                }

                
                return valA.toString().localeCompare(valB.toString()) * direction;
            });
        }

    },
    mounted() {
        const test = "03 May 2024";
        const parsed = this.parseDate(test);
        console.log("Parsed:", parsed);
        this.rows.forEach(row => {
            this.updateSuggestions(row);
            row.selected = false;
            row.original = JSON.parse(JSON.stringify(row));
        });
    }
}).mount('#app');
</script>
@endpush