<?php $__env->startSection('content'); ?>
    <div class="container py-4">

        <h2 class="fw-bold mb-4 text-gradient">My Approval Requests</h2>

        <?php
            $grandTotal = 0;
            foreach ($groups as $po => $items) {
                $grandTotal += $items->sum('Outstanding_Amount_LCY');
            }
        ?>

        <div class="alert alert-info fw-semibold d-flex justify-content-between align-items-center mb-4 rounded-3 shadow-sm">
            <span>Total Outstanding Approvals:</span>
            <span id="grandTotalValue" class="text-primary fs-5">
                Rp <?php echo e(number_format($grandTotal, 0, ',', '.')); ?>

            </span>
        </div>

        <!-- SELECT ALL + TOP APPROVE BUTTON -->
        <div class="d-flex justify-content-between align-items-center mb-3">
            <div class="form-check">
                <input type="checkbox" id="selectAll" class="form-check-input">
                <label for="selectAll" class="form-check-label fw-semibold">Select All</label>
            </div>

            <button id="btnApproveTop" class="btn btn-primary px-4" disabled>
                Approve Selected (0)
            </button>
        </div>
        
        <div class="d-flex justify-content-between align-items-center mb-3">
            <div>
                <label class="fw-semibold">Filter by Location</label>
                <select id="filterLocation" class="form-select w-auto d-inline-block">
                    <option value="all">All Locations</option>
                    <?php $__currentLoopData = $locations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $loc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($loc); ?>"><?php echo e($loc); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            <div>
                <label class="fw-semibold me-2">Records per page</label>
                <select id="pageSize" class="form-select d-inline-block w-auto">
                    <option value="5">5</option>
                    <option value="10" selected>10</option>
                    <option value="20">20</option>
                    <option value="50">50</option>
                </select>
            </div>
        </div>

        <div class="mb-3 d-flex justify-content-between align-items-center">

            <div class="d-flex gap-2">
                <button id="expandAll" class="btn btn-outline-primary btn-sm">
                    Expand All
                </button>

                <button id="collapseAll" class="btn btn-outline-secondary btn-sm">
                    Collapse All
                </button>
            </div>

            <div class="fw-semibold text-muted">
                Total Count:
                <span id="totalCountText" class="text-primary">0</span>
            </div>

        </div>

        <div class="accordion" id="approvalAccordion">
            <?php $__currentLoopData = $groups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $poNumber => $items): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $vendor = $items[0]['VendName'];
                    $total = $items->sum(function ($line) {
                        $outstanding = (float) ($line['Outstanding_Amount_LCY'] ?? 0);

                        if ($outstanding === 0.0) {
                            return (float) ($line['Unit_Cost_LCY'] ?? 0)
                                * (float) ($line['Quantity'] ?? 0);
                        }

                        return $outstanding;
                    });
                    $entryNo = $items[0]['EntryNo'];
                    $locationsList = implode(", ", $items->pluck('Location_Code')->unique()->toArray());
                    $header = $items[0]['Header'] ?? [];
                    $createdBy = $header['SystemCreatedBy'] ?? '-';
                    $createdAt = $header['SystemCreatedAt'] ?? null;
                ?>

                <div class="accordion-item shadow-sm border-0 mb-3 rounded-4 overflow-hidden po-card"
                    data-locations="<?php echo e(implode(',', $items->pluck('Location_Code')->unique()->toArray())); ?>">

                    <!-- HEADER -->
                    <h2 class="accordion-header" id="heading-<?php echo e($poNumber); ?>">
                        <div class="d-flex align-items-center w-100">

                            <div class="checkbox-wrapper me-3">
                                <input type="checkbox" class="form-check-input po-check" value="<?php echo e($poNumber); ?>"
                                    data-amount="<?php echo e($total); ?>" data-entry="<?php echo e($entryNo); ?>">
                                <!-- ORIGINAL ENTRYNO -->
                            </div>

                            <button class="accordion-button collapsed px-4 py-3 d-flex align-items-center w-100"
                                type="button" data-bs-toggle="collapse" data-bs-target="#collapse-<?php echo e($poNumber); ?>"
                                aria-expanded="false" aria-controls="collapse-<?php echo e($poNumber); ?>">

                                <div class="po-header">
                                    <div class="po-title">PO #<?php echo e($poNumber); ?></div>

                                    <div class="po-meta">
                                        <span>
                                            <i class="fa-regular fa-user"></i>
                                            <?php echo e($items[0]['Salesperson'] ?? '-'); ?>

                                        </span>

                                        <span>
                                            <i class="fa-solid fa-building"></i>
                                            <?php echo e($items[0]['Buy_from_Vendor_Name'] ?? '-'); ?>

                                        </span>

                                        <span>
                                            <i class="fa-solid fa-arrows-rotate"></i>
                                            <?php echo e($header['Transaction_Type'] ?? '-'); ?>

                                        </span>

                                        <span>
                                            <i class="fa-regular fa-clock"></i>
                                            <?php echo e(isset($header['SystemCreatedAt'])
                                                ? \Carbon\Carbon::parse($header['SystemCreatedAt'])
                                                    ->setTimezone('Asia/Jakarta')
                                                    ->format('d M Y H:i')
                                                : '-'); ?>

                                        </span>

                                        <span>
                                            <i class="fa-solid fa-location-dot"></i>
                                            <?php echo e($locationsList); ?>

                                        </span>
                                    </div>
                                </div>

                                <div class="d-flex align-items-center ms-auto">

                                    <div class="d-flex flex-column align-items-end me-3">
                                        <div class="fw-bold">Rp <?php echo e(number_format($total, 0, ',', '.')); ?></div>
                                        <div class="text-muted small">Total</div>
                                    </div>

                                    <span class="badge bg-success me-3">Pending</span>
                                    <i class="fa-solid fa-chevron-down"></i>
                                </div>

                            </button>
                        </div>
                    </h2>

                    <!-- CONTENT -->
                    <div id="collapse-<?php echo e($poNumber); ?>" class="accordion-collapse collapse"
                        aria-labelledby="heading-<?php echo e($poNumber); ?>" data-bs-parent="#approvalAccordion">

                        <div class="accordion-body px-4">

                            <div class="d-flex justify-content-between align-items-center mb-3 pb-2 border-bottom">
                                <h5 class="fw-semibold m-0">PO Total</h5>
                                <h5 class="fw-bold text-primary m-0">
                                    Rp <?php echo e(number_format($total, 0, ',', '.')); ?>

                                </h5>
                            </div>

                            <div class="d-flex flex-wrap gap-4 mb-3 p-3 rounded-3 bg-light border">

                                <div>
                                    <div class="text-muted small">Transaction Type</div>
                                    <div class="fw-semibold">
                                        <?php echo e($header['Transaction_Type'] ?? '-'); ?>

                                    </div>
                                </div>

                                <div>
                                    <div class="text-muted small">Currency</div>
                                    <div class="fw-semibold">
                                        <?php echo e(!empty($header['Currency_Code']) ? $header['Currency_Code'] : 'IDR'); ?>

                                    </div>
                                </div>

                                <div>
                                    <div class="text-muted small">Prepayment</div>
                                    <div class="fw-semibold">
                                        <?php echo e(number_format($header['Prepayment_Percent'] ?? 0, 0)); ?>%
                                    </div>
                                </div>

                                <div>
                                    <div class="text-muted small">VAT Bus. Posting Group</div>
                                    <div class="fw-semibold">
                                        <?php echo e($header['VAT_Bus_Posting_Group'] ?? '-'); ?>

                                    </div>
                                </div>
                            </div>

                            <div class="d-flex justify-content-between align-items-center mb-3 p-3 rounded-3 bg-light border">
                                <div class="fw-semibold text-muted">
                                    <i class="fa-solid fa-building me-2 text-primary"></i>
                                    Vendor
                                </div>
                                <div class="fw-bold text-dark">
                                    <?php echo e($items[0]['Buy_from_Vendor_Name'] ?? '-'); ?>

                                </div>
                            </div>

                            <div class="po-line-header">
                                <span>Description</span>
                                <span>Qty</span>
                                <span>Amt. Incl VAT (LCY)</span>
                                <span>Loc</span>
                            </div>

                            
                            <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $line): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $isComment =
                                        (float) $line['Quantity'] === 0.0 &&
                                        (float) $line['Outstanding_Quantity'] === 0.0 &&
                                        (float) $line['Outstanding_Amount_LCY'] === 0.0;
                                    $lineAmount =
                                        (float) $line['Outstanding_Amount_LCY'] === 0.0
                                            ? ((float) ($line['Unit_Cost_LCY'] ?? 0) * (float) ($line['Quantity'] ?? 0))
                                            : (float) $line['Outstanding_Amount_LCY'];
                                ?>
                                <div class="mb-4">

                                    
                                    <?php if($isComment): ?>
                                        <div class="po-line-comment">
                                            💬 <?php echo e($line['Description']); ?>

                                        </div>

                                    
                                    <?php else: ?>
                                        <div class="po-line">
                                            <div class="po-line-desc">
                                                <?php echo e($line['Description']); ?>

                                                <div class="text-muted small mt-1">
                                                    Unit Cost:
                                                    <span class="fw-semibold text-dark">
                                                        Rp <?php echo e(number_format($line['Unit_Cost_LCY'] ?? 0, 0, ',', '.')); ?>

                                                    </span>
                                                </div>
                                            </div>

                                            <div class="po-line-meta">
                                                <span class="qty"><?php echo e($line['Quantity']); ?></span>

                                                <span class="amt">
                                                    Rp <?php echo e(number_format($lineAmount, 0, ',', '.')); ?>

                                                </span>

                                                <span class="loc"><?php echo e($line['Location_Code']); ?></span>
                                            </div>

                                        </div>
                                    <?php endif; ?>

                                </div>

                                <div class="line-divider"></div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            
                            <div class="my-3">
                                <h6 class="fw-semibold text-secondary">Attachments</h6>

                                <?php $__empty_1 = true; $__currentLoopData = $attachments[$poNumber] ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $att): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <div class="d-flex justify-content-between align-items-center py-1">
                                        <div>
                                            <i class="fa fa-paperclip me-2"></i>
                                            <?php echo e($att['fileName']); ?>.<?php echo e($att['ext']); ?>

                                        </div>

                                        <a href="<?php echo e(route('approve.previewAttachment', ['id' => $att['id']])); ?>"
                                        target="_blank"
                                        class="btn btn-sm btn-outline-primary">
                                            Preview
                                        </a>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <div class="text-muted small">No attachments.</div>
                                <?php endif; ?>
                            </div>

                            <div class="po-footer-info mt-4 pt-3 border-top">
                                <span>
                                    <i class="fa-regular fa-user"></i>
                                    Created by <?php echo e($items[0]['Salesperson'] ?? '-'); ?>

                                </span>

                                <span>
                                    <i class="fa-regular fa-clock"></i>
                                    <?php echo e(isset($header['SystemCreatedAt'])
                                        ? \Carbon\Carbon::parse($header['SystemCreatedAt'])
                                            ->setTimezone('Asia/Jakarta')
                                            ->format('d M Y H:i')
                                        : '-'); ?>

                                </span>
                            </div>

                            
                            <div class="d-flex justify-content-end gap-3 mt-3">
                                <button class="btn btn-outline-danger px-4 btnRejectPO"
                                    data-entry="<?php echo e($items[0]['EntryNo']); ?>">
                                    Reject PO
                                </button>
                            </div>

                        </div>
                    </div>

                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
            <div class="d-flex justify-content-center align-items-center gap-3 mt-4">
            <button id="prevPage" class="btn btn-outline-secondary btn-sm">Prev</button>
            <span id="pageIndicator" class="fw-semibold"></span>
            <button id="nextPage" class="btn btn-outline-secondary btn-sm">Next</button>
        </div>
    </div>

    <!-- STICKY BOTTOM APPROVE BAR -->
    <div id="stickyBar" class="sticky-approval-bar shadow-lg">
        <div class="container py-2 d-flex justify-content-between align-items-center">

            <div class="fw-semibold">
                Selected Total:
                <span id="selectedTotal" class="fw-bold text-primary">Rp 0</span>
            </div>

            <button id="btnApproveBottom" class="btn btn-primary px-4" disabled>
                Approve Selected (0)
            </button>

        </div>
    </div>


    <div id="pageLoader" class="loader-overlay" style="display:none;">
        <div class="loader-spinner"></div>
        <div class="loader-text">Please wait...</div>
    </div>

    <style>
        .text-gradient {
            background: linear-gradient(135deg, #0d6efd, #20c997);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }

        .accordion-button {
            background: #f8f9fa !important;
            border-radius: 0 !important;
        }

        .accordion-button:not(.collapsed) {
            background: #eef6ff !important;
            color: #0d6efd !important;
        }

        .accordion-item {
            border-radius: 1rem !important;
        }

        .accordion-button::after {
            display: none !important;
        }

        .checkbox-wrapper {
            pointer-events: auto !important;
        }

        .sticky-approval-bar {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            background: white;
            border-top: 1px solid #dcdcdc;
            display: none;
            z-index: 1000;
        }
        .line-divider {
            height: 1px;
            background: linear-gradient(to right, #e0e0e0, #cfcfcf, #e0e0e0);
            border-radius: 2px;
            margin-top: 1rem;
            margin-bottom: 1rem;
        }
        /* Fade & slide animation for accordion body */
        .accordion-body {
            animation: fadeSlide 0.35s ease;
        }

        .po-header {
            display: flex;
            flex-direction: column;
            gap: 6px;
        }
        .po-meta span {
            display: inline-flex;
            align-items: center;
            gap: 6px;
        }

        .po-meta i.fa-building {
            color: #6366f1; /* subtle indigo */
        }
        .po-title {
            font-size: 1.1rem;
            font-weight: 700;
            letter-spacing: 0.2px;
        }

        .po-meta {
            display: flex;
            flex-wrap: wrap;
            gap: 14px;
            font-size: 0.85rem;
            color: #6c757d;
        }

        .po-meta i {
            margin-right: 5px;
            opacity: 0.75;
        }

        .po-footer-info {
            display: flex;
            gap: 24px;
            font-size: 0.85rem;
            color: #6c757d;
        }

        .po-footer-info i {
            margin-right: 6px;
            opacity: 0.7;
        }


        @keyframes fadeSlide {
            from {
                opacity: 0;
                transform: translateY(-6px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        /* Rotate arrow smoothly */
        .accordion-button i {
            transition: transform 0.3s ease;
        }

        .accordion-button:not(.collapsed) i {
            transform: rotate(180deg);
        }

        /* Smooth background highlight on expand */
        .accordion-item.showing {
            animation: itemReveal 0.3s ease;
        }

        @keyframes itemReveal {
            from {
                background-color: #f0f8ff;
            }
            to {
                background-color: white;
            }
        }

        .loader-overlay {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(255, 255, 255, 0.85);
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            z-index: 2000;
            backdrop-filter: blur(3px);
            animation: fadeIn 0.3s ease-in-out;
        }

        .loader-spinner {
            width: 50px;
            height: 50px;
            border: 5px solid #cce5ff;
            border-top-color: #0d6efd;
            border-radius: 50%;
            animation: spin 1s linear infinite;
        }

        .loader-text {
            margin-top: 15px;
            font-weight: 600;
            color: #0d6efd;
            font-size: 1.1rem;
        }

        @keyframes spin {
            to {
                transform: rotate(360deg);
            }
        }

        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }

        .po-line-header,
        .po-line {
            display: grid;
            grid-template-columns: 1fr 60px 160px 90px;
            gap: 12px;
            align-items: center;
        }

        .po-line-header {
            font-size: 0.8rem;
            font-weight: 600;
            color: #6c757d;
            padding-bottom: 6px;
            border-bottom: 1px solid #e5e7eb;
            margin-bottom: 8px;
        }

        .po-line {
            padding: 6px 0;
            border-bottom: 1px dashed #e5e7eb;
        }

        .po-line:last-child {
            border-bottom: none;
        }

        .po-line-desc {
            font-size: 0.9rem;
            font-weight: 500;
        }

        .po-line-meta {
            display: contents;
        }

        .po-line-meta span {
            text-align: right;
            font-size: 0.85rem;
            color: #374151;
        }

        .po-line-meta .amt {
            font-weight: 600;
            color: #0d6efd;
        }

        .po-line-meta .loc {
            font-size: 0.8rem;
            color: #6b7280;
        }

        /* Comment line */
        .po-line-comment {
            font-size: 0.85rem;
            color: #6b7280;
            font-style: italic;
            padding: 6px 0 6px 12px;
            border-left: 3px solid #dbeafe;
            margin-bottom: 6px;
        }



    </style>

    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <script>
        document.addEventListener("DOMContentLoaded", () => {

            // =============================
            // ELEMENTS
            // =============================
            const all          = document.querySelector("#selectAll");
            const checks       = document.querySelectorAll(".po-check");
            const sticky       = document.querySelector("#stickyBar");
            const lblTotal     = document.querySelector("#selectedTotal");
            const btnTop       = document.querySelector("#btnApproveTop");
            const btnBottom    = document.querySelector("#btnApproveBottom");
            const filterSelect = document.querySelector("#filterLocation");
            const pageSizeSel  = document.querySelector("#pageSize");
            const pageIndicator= document.querySelector("#pageIndicator");
            const selectedEntries = new Set();

            let currentPage = 1;
            let pageSize    = parseInt(pageSizeSel.value);

            const cards = Array.from(document.querySelectorAll(".po-card"));

            const btnExpandAll   = document.getElementById("expandAll");
            const btnCollapseAll = document.getElementById("collapseAll");

            const savedLocation = localStorage.getItem("approval_filter_location");
            if (savedLocation) {
                filterSelect.value = savedLocation;
                filterSelect.dispatchEvent(new Event("change"));
            }

            if (cards.length === 0) {
                localStorage.removeItem("approval_filter_location");
            }

            btnExpandAll.addEventListener("click", () => {
                cards.forEach(card => {
                    if (card.dataset.filtered === "true" && card.style.display !== "none") {
                        const collapseEl = card.querySelector(".accordion-collapse");
                        if (collapseEl && !collapseEl.classList.contains("show")) {
                            const bsCollapse = new bootstrap.Collapse(collapseEl, {
                                toggle: false
                            });
                            bsCollapse.show();
                        }
                    }
                });
            });

            btnCollapseAll.addEventListener("click", () => {
                cards.forEach(card => {
                    if (card.dataset.filtered === "true" && card.style.display !== "none") {
                        const collapseEl = card.querySelector(".accordion-collapse");
                        if (collapseEl && collapseEl.classList.contains("show")) {
                            const bsCollapse = new bootstrap.Collapse(collapseEl, {
                                toggle: false
                            });
                            bsCollapse.hide();
                        }
                    }
                });
            });

            // =============================
            // INIT FILTER STATE
            // =============================
            cards.forEach(card => {
                card.dataset.filtered = "true";
            });

            function updateTotalCountText() {
                const totalCount = cards.filter(c => c.dataset.filtered === "true").length;
                document.getElementById("totalCountText").innerText = totalCount;
            }
            function recalc() {
                let total = 0;

                selectedEntries.forEach(entry => {
                    const cb = document.querySelector(`.po-check[data-entry="${entry}"]`);
                    if (cb) {
                        total += parseFloat(cb.dataset.amount) || 0;
                    }
                });

                const count = selectedEntries.size;

                lblTotal.textContent = "Rp " + total.toLocaleString("id-ID");
                btnTop.textContent = `Approve Selected (${count})`;
                btnBottom.textContent = `Approve Selected (${count})`;

                btnTop.disabled = count === 0;
                btnBottom.disabled = count === 0;

                sticky.style.display = count > 0 ? "block" : "none";
            }

            checks.forEach(cb => {
                cb.addEventListener("change", () => {
                    const entry = cb.dataset.entry;

                    if (cb.checked) {
                        selectedEntries.add(entry);
                    } else {
                        selectedEntries.delete(entry);
                    }

                    recalc();
                });
            });

            // =============================
            // GRAND TOTAL (FILTERED)
            // =============================
            function recalcGrandTotal() {
                let total = 0;

                cards.forEach(card => {
                    if (card.dataset.filtered === "true") {
                        total += parseFloat(card.querySelector(".po-check").dataset.amount) || 0;
                    }
                });

                document.querySelector("#grandTotalValue").innerText =
                    "Rp " + total.toLocaleString("id-ID");
            }

            // =============================
            // PAGINATION
            // =============================
            function paginate() {
                const filteredCards = cards.filter(c => c.dataset.filtered === "true");
                const totalPages = Math.max(1, Math.ceil(filteredCards.length / pageSize));

                if (currentPage > totalPages) currentPage = totalPages;

                // hide all
                cards.forEach(card => card.style.display = "none");

                // show current page only
                filteredCards.forEach((card, i) => {
                    const start = (currentPage - 1) * pageSize;
                    const end   = start + pageSize;

                    if (i >= start && i < end) {
                        card.style.display = "";
                    }
                });

                // reset selection when page changes
                checks.forEach(cb => {
                cb.checked = selectedEntries.has(cb.dataset.entry);
                });
                recalc();

                pageIndicator.textContent = `Page ${currentPage} of ${totalPages}`;
            }

            // =============================
            // FILTER BY LOCATION
            // =============================
            filterSelect.addEventListener("change", () => {
                const selected = filterSelect.value;

                cards.forEach(card => {
                    const locs = (card.dataset.locations || "").split(",").filter(Boolean);
                    card.dataset.filtered =
                        (selected === "all" || locs.includes(selected)) ? "true" : "false";
                });

                currentPage = 1;
                paginate();
                recalcGrandTotal();
                updateTotalCountText();
            });

            // =============================
            // PAGE SIZE
            // =============================
            pageSizeSel.addEventListener("change", e => {
                pageSize = parseInt(e.target.value);
                currentPage = 1;
                paginate();
            });

            document.querySelector("#prevPage").onclick = () => {
                if (currentPage > 1) {
                    currentPage--;
                    paginate();
                }
            };

            document.querySelector("#nextPage").onclick = () => {
                currentPage++;
                paginate();
            };

            // =============================
            // SELECT ALL (CURRENT PAGE ONLY)
            // =============================
            all.addEventListener("change", () => {
                const checked = all.checked;

                cards.forEach(card => {
                    if (
                        card.dataset.filtered === "true" &&
                        card.style.display !== "none"
                    ) {
                        const cb = card.querySelector(".po-check");
                        if (!cb) return;

                        cb.checked = checked;

                        if (checked) {
                            selectedEntries.add(cb.dataset.entry);
                        } else {
                            selectedEntries.delete(cb.dataset.entry);
                        }
                    }
                });

                recalc();
            });

            function lockPageForReload(message = "Refreshing page...") {
                const loader = document.getElementById("pageLoader");

                if (loader) {
                    loader.style.display = "flex";
                    const textEl = loader.querySelector(".loader-text");
                    if (textEl) {
                        textEl.textContent = message;
                    }
                }

                // Disable all interactions
                document.body.style.pointerEvents = "none";
            }


            // =============================
            // APPROVE
            // =============================
            function getSelectedEntries() {
                const entries = [];
                checks.forEach(c => {
                    if (c.checked) entries.push(c.dataset.entry);
                });
                return entries;
            }

            function showLoader() {
                document.getElementById("pageLoader").style.display = "flex";
            }

            function hideLoader() {
                setTimeout(() => {
                    document.getElementById("pageLoader").style.display = "none";
                }, 500);
            }

            function approveAction() {
                const entriesArr = getSelectedEntries();
                if (!entriesArr.length) return;
                const entries = entriesArr.join(",");

                showLoader();
                Swal.fire({
                    title: "Processing...",
                    allowOutsideClick: false,
                    didOpen: () => Swal.showLoading()
                });

                fetch("<?php echo e(route('request.approved')); ?>", {
                    method: "POST",
                    headers: {
                        "Content-Type": "application/json",
                        "X-CSRF-TOKEN": "<?php echo e(csrf_token()); ?>"
                    },
                    body: JSON.stringify({ entries })
                })
                .then(async r => {
                    const text = await r.text();

                    try {
                        return JSON.parse(text);
                    } catch (e) {
                        // ❌ response is not JSON → prevent Safari error
                        throw new Error("Server returned invalid response");
                    }
                })
                .then(res => {
                    hideLoader();

                    if (res.status === "success") {
                        Swal.fire({
                            icon: "success",
                            title: "Success",
                            timer: 1500,
                            showConfirmButton: false
                        }).then(() => {
                            lockPageForReload("Refreshing data...");
                            localStorage.setItem("approval_filter_location", filterSelect.value);
                            window.location.reload();
                        });
                    } else {
                        Swal.fire("Failed", res.message ?? "Approval failed", "error");
                    }
                })
                .catch(err => {
                    hideLoader();
                    Swal.fire("Error", err.message, "error");
                });
            }


            btnTop.addEventListener("click", approveAction);
            btnBottom.addEventListener("click", approveAction);

            // =============================
            // REJECT
            // =============================
            document.querySelectorAll(".btnRejectPO").forEach(btn => {
                btn.addEventListener("click", () => {
                    const entry = btn.dataset.entry;

                    Swal.fire({
                        title: "Reject this request?",
                        icon: "warning",
                        showCancelButton: true,
                        confirmButtonText: "Yes, Reject"
                    }).then(result => {
                        if (!result.isConfirmed) return;

                        Swal.fire({
                            title: "Processing...",
                            allowOutsideClick: false,
                            didOpen: () => Swal.showLoading()
                        });

                        fetch("<?php echo e(route('request.rejected')); ?>", {
                            method: "POST",
                            headers: {
                                "Content-Type": "application/json",
                                "X-CSRF-TOKEN": "<?php echo e(csrf_token()); ?>"
                            },
                            body: JSON.stringify({ entries: [entry] })
                        })
                        .then(async r => {
                            const text = await r.text();
                            try {
                                return JSON.parse(text);
                            } catch {
                                throw new Error("Server returned invalid response");
                            }
                        })
                        .then(res => {
                            if (res.status === "success") {
                                Swal.fire({
                                    icon: "success",
                                    title: "Rejected",
                                    timer: 1500,
                                    showConfirmButton: false
                                }).then(() => {
                                    lockPageForReload("Refreshing data...");
                                    localStorage.setItem("approval_filter_location", filterSelect.value);
                                    window.location.reload();
                                });
                            } else {
                                Swal.fire("Failed", res.message ?? "Reject failed", "error");
                            }
                        });
                    });
                });
            });

            // =============================
            // INIT
            // =============================
            paginate();
            recalcGrandTotal();
            updateTotalCountText();
        });
        </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/pawc5944/public_html/approvalpobc/resources/views/Approve.blade.php ENDPATH**/ ?>