<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up() {
        Schema::create('approval_step_approvers', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('step_template_id')->index();
            $table->unsignedBigInteger('approver_user_id')->nullable()->index();
            $table->unsignedBigInteger('approver_role_id')->nullable()->index();
            $table->timestamps();

            $table->foreign('step_template_id')->references('id')->on('approval_step_templates')->onDelete('cascade');
            // you may have foreigns for user/role depending on your schema:
            // $table->foreign('approver_user_id')->references('id')->on('users')->onDelete('set null');
            // $table->foreign('approver_role_id')->references('id')->on('roles')->onDelete('set null');
        });

        // add require_all (bool) to step templates
        Schema::table('approval_step_templates', function (Blueprint $table) {
            $table->boolean('require_all')->default(false)->after('step_no');
        });
    }

    public function down() {
        Schema::table('approval_step_templates', function (Blueprint $table) {
            $table->dropColumn('require_all');
        });
        Schema::dropIfExists('approval_step_approvers');
    }
};