<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
  public function up(): void {
    Schema::create('number_sequences', function (Blueprint $t) {
      $t->id();
      $t->foreignId('company_id')->constrained()->cascadeOnDelete();
      $t->string('code');                // 'ITEM'
      $t->string('prefix')->default('IT-{YYYY}-');
      $t->unsignedInteger('next_no')->default(1);
      $t->unsignedTinyInteger('padding')->default(4); // 0001
      $t->timestamps();
      $t->unique(['company_id','code']);
    });
  }
  public function down(): void {
    Schema::dropIfExists('number_sequences');
  }
};
