<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use Laravel\Socialite\Facades\Socialite;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Str;

class AzureAuthController extends Controller
{
    
    public function redirectToProvider()
{
    return redirect()->away(
        'https://login.microsoftonline.com/' . env('AZURE_TENANT_ID') . '/oauth2/v2.0/authorize?' . http_build_query([
            'client_id'     => env('AZURE_CLIENT_ID'),
            'response_type' => 'code',
            'redirect_uri'  => route('azure.callback'),
            'response_mode' => 'query',
            'scope' => implode(' ', [
                'openid',
                'profile',
                'email',
                'offline_access',
                'https://api.businesscentral.dynamics.com/user_impersonation',
            ]),
        ])
    );
}


    // public function handleProviderCallback(Request $request)
    // {
    //     try {
    //         /**
    //          * ======================================================
    //          * 1. GET USER FROM MICROSOFT AZURE AD
    //          * ======================================================
    //          */
    //         $user = Socialite::driver('microsoft')->stateless()->user();

    //         $email = strtolower($user->getEmail());
    //         $name  = $user->getName();

    //         Log::info("Azure Login: " . $email);

    //         /**
    //          * ======================================================
    //          * 2. ROLE HANDLER (TERMASUK TITANIA BYPASS)
    //          * ======================================================
    //          */
    //         $isTitania = str_contains($email, 'titania'); // Bypass role-check, tetap lanjut token

    //         if ($isTitania) {
    //             $role = 'SUPER'; // atau SUPER
    //         } elseif (str_contains($email, 'adnyani')) {
    //             $role = 'Regent';
    //         } elseif (
    //             str_contains($email, 'pebri') ||
    //             str_contains($email, 'pratiwi') ||
    //             str_contains($email, 'feybe')
    //         ) {
    //             $role = 'HIN';
    //         } elseif (
    //             str_contains($email, 'admin') ||
    //             str_contains($email, 'michael') ||
    //             str_contains($email, 'kristina') ||
    //             str_contains($email, 'costingho') ||
    //             str_contains($email, 'erlina') ||
    //             str_contains($email, 'titania')
    //         ) {
    //             $role = 'SUPER';
    //         } else {
    //             $role = 'Regent';
    //         }

    //         /**
    //          * ======================================================
    //          * 3. SIMPAN GRAPH TOKEN (ACCESS TOKEN + REFRESH TOKEN)
    //          * ======================================================
    //          */
    //         session([
    //             'user' => [
    //                 'name'  => $name,
    //                 'email' => $email,
    //                 'role'  => $role,
    //             ],
    //             'graph' => [
    //                 'access_token'  => $user->token,
    //                 'refresh_token' => $user->refreshToken,
    //                 'expires_at'    => now()->addSeconds($user->expiresIn ?? 3600)->toIso8601String(),
    //             ],
    //         ]);


    //         /**
    //          * ======================================================
    //          * 4. EXCHANGE REFRESH TOKEN → BUSINESS CENTRAL TOKEN
    //          * ======================================================
    //          */
    //         $tenant       = env('AZURE_TENANT_ID');
    //         $clientId     = env('AZURE_CLIENT_ID');
    //         $clientSecret = env('AZURE_CLIENT_SECRET');

    //         $tokenResponse = Http::asForm()->post(
    //             "https://login.microsoftonline.com/$tenant/oauth2/v2.0/token",
    //             [
    //                 'client_id'     => $clientId,
    //                 'client_secret' => $clientSecret,
    //                 'grant_type'    => 'refresh_token',
    //                 'refresh_token' => $user->refreshToken,
    //                 'scope'         => 'https://api.businesscentral.dynamics.com/.default'
    //             ]
    //         );

    //         if (!$tokenResponse->successful()) {
    //             throw new \Exception("Failed to exchange BC delegated token: " . $tokenResponse->body());
    //         }

    //         $bcToken = $tokenResponse->json()['access_token'];

    //         /**
    //          * ======================================================
    //          * 5. SIMPAN BC TOKEN
    //          * ======================================================
    //          */
    //         session(['bc_token' => $bcToken]);

    //         session()->save();

    //         /**
    //          * ======================================================
    //          * 6. REDIRECT KE HALAMAN APPROVAL
    //          * ======================================================
    //          */
    //         return redirect()->route('approvals.list');


    //     } catch (\Exception $e) {

    //         Log::error('Azure AD Auth Error: ' . $e->getMessage());

    //         Auth::logout();
    //         $request->session()->invalidate();
    //         $request->session()->flush();
    //         $request->session()->regenerateToken();

    //         return redirect()->route('login');
    //     }
    // }
    
    public function handleProviderCallback(Request $request)
    {
        $code = $request->get('code');
    
        $response = Http::asForm()->post(
            'https://login.microsoftonline.com/' . env('AZURE_TENANT_ID') . '/oauth2/v2.0/token',
            [
                'client_id'     => env('AZURE_CLIENT_ID'),
                'client_secret' => env('AZURE_CLIENT_SECRET'),
                'grant_type'    => 'authorization_code',
                'code'          => $code,
                'redirect_uri'  => route('azure.callback'),
                'scope' => implode(' ', [
                    'openid',
                    'profile',
                    'email',
                    'offline_access',
                    'https://api.businesscentral.dynamics.com/user_impersonation',
                ]),
            ]
        );
    
        if (!$response->successful()) {
            abort(500, $response->body());
        }
    
        $token = $response->json('access_token');
    
        // OPTIONAL: decode once to verify
        $payload = json_decode(
            base64_decode(explode('.', $token)[1]),
            true
        );
    
        if (($payload['aud'] ?? null) !== 'https://api.businesscentral.dynamics.com') {
            abort(500, 'Not a Business Central token');
        }
    
        session([
            'user' => [
                'email' => $payload['upn'] ?? null,
                'name'  => $payload['name'] ?? null,
                'role'  => 'SUPER',
            ],
            'bc_token' => $token,
        ]);
    
        return redirect()->route('approvals.list');
    }


    public function logout(Request $request)
    {
        Auth::logout();
        $request->session()->invalidate();
        $request->session()->flush();
        $request->session()->regenerateToken();

        // Logout juga dari Microsoft Identity (agar tidak auto-login)
        $microsoftLogoutUrl = 'https://login.microsoftonline.com/common/oauth2/v2.0/logout?post_logout_redirect_uri='
            . urlencode(route('microsoft.login'));

        return redirect($microsoftLogoutUrl);
    }
}
