<?php
// File: superadmin/superadmin_view_task.php
include 'auth_check.php'; require_role(['superadmin']); require_once('../db.php'); 

if (!isset($_GET['task_id'])) die("ID Tugas tidak valid.");
$task_id = (int)$_GET['task_id'];

// Ambil Detail Tugas
$sql = "SELECT t.*, p.project_name, c.username as creator, m.username as member 
        FROM tasks t 
        JOIN projects p ON t.project_id = p.project_id 
        JOIN users c ON t.creator_id = c.id 
        JOIN users m ON t.assigned_to = m.id 
        WHERE t.id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $task_id);
$stmt->execute();
$task = $stmt->get_result()->fetch_assoc();

if (!$task) die("Tugas tidak ditemukan.");

// Ambil Attachment
$sql_att = "SELECT * FROM task_attachments WHERE task_id = ?";
$stmt_att = $conn->prepare($sql_att);
$stmt_att->bind_param("i", $task_id);
$stmt_att->execute();
$attachment = $stmt_att->get_result()->fetch_assoc();
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <title>Detail Tugas</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600;700&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Poppins', sans-serif; background: #f4f6f9; padding: 40px; }
        .container { max-width: 800px; margin: 0 auto; background: white; padding: 40px; border-radius: 15px; box-shadow: 0 5px 20px rgba(0,0,0,0.05); border-top: 5px solid #111; }
        h1 { margin-top: 0; color: #111; font-size: 24px; border-bottom: 1px solid #eee; padding-bottom: 20px; margin-bottom: 20px; }
        .info-grid { display: grid; grid-template-columns: 1fr 1fr; gap: 20px; margin-bottom: 30px; }
        .info-item h4 { font-size: 12px; color: #888; text-transform: uppercase; margin: 0 0 5px 0; }
        .info-item p { margin: 0; font-weight: 600; font-size: 16px; color: #333; }
        .desc-box { background: #f9f9f9; padding: 20px; border-radius: 10px; margin-bottom: 30px; line-height: 1.6; }
        .btn-back { text-decoration: none; color: #666; font-weight: 600; display: inline-block; margin-top: 20px; }
        .badge { padding: 5px 12px; border-radius: 50px; font-size: 12px; font-weight: bold; text-transform: uppercase; display: inline-block; }
        .bg-pending { background: #fffbeb; color: #b45309; } .bg-completed { background: #dcfce7; color: #166534; } .bg-in_progress { background: #eff6ff; color: #1d4ed8; }
        .file-box { background: #eef2f5; padding: 15px; border-radius: 8px; display: inline-flex; align-items: center; gap: 10px; text-decoration: none; color: #007bff; font-weight: 600; }
    </style>
</head>
<body>
    <div class="container">
        <h1>🔍 Detail Tugas #<?php echo $task['id']; ?></h1>
        
        <div class="info-grid">
            <div class="info-item"><h4>Judul</h4><p><?php echo htmlspecialchars($task['title']); ?></p></div>
            <div class="info-item">
                <h4>Status</h4>
                <?php $clean = strtolower($task['status']); if(empty($clean))$clean='pending'; ?>
                <span class="badge bg-<?php echo $clean; ?>"><?php echo strtoupper(str_replace('_',' ',$clean)); ?></span>
            </div>
            <div class="info-item"><h4>Project</h4><p><?php echo htmlspecialchars($task['project_name']); ?></p></div>
            <div class="info-item"><h4>Deadline</h4><p style="color:red"><?php echo $task['due_date']; ?></p></div>
            <div class="info-item"><h4>Pembuat</h4><p><?php echo htmlspecialchars($task['creator']); ?></p></div>
            <div class="info-item"><h4>Penerima</h4><p><?php echo htmlspecialchars($task['member']); ?></p></div>
        </div>

        <h4>Deskripsi:</h4>
        <div class="desc-box"><?php echo nl2br(htmlspecialchars($task['description'])); ?></div>

        <?php if ($attachment): ?>
            <h4>Lampiran:</h4>
            <a href="../download.php?file=<?php echo urlencode($attachment['unique_file_name']); ?>" class="file-box" target="_blank">
                📄 <?php echo htmlspecialchars($attachment['original_file_name']); ?>
            </a>
        <?php else: ?>
            <p style="color:#999; font-style:italic;">Tidak ada lampiran file.</p>
        <?php endif; ?>

        <br>
        <a href="superadmin_dashboard.php" class="btn-back">← Kembali ke Dashboard</a>
    </div>
</body>
</html>