<?php
// File: superadmin/superadmin_monitor_tasks.php

// 1. Matikan Cache Browser (Supaya status update langsung terlihat)
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");

include 'auth_check.php';
require_role(['superadmin']); 
require_once('../db.php'); 

// --- FILTER DATA ---
$filter_project = isset($_GET['project_id']) ? $_GET['project_id'] : '';
$filter_status = isset($_GET['status']) ? $_GET['status'] : '';

// Ambil data Project untuk dropdown filter
$projects = [];
$res_proj = mysqli_query($conn, "SELECT project_id, project_name FROM projects ORDER BY project_name");
while ($row = mysqli_fetch_assoc($res_proj)) { $projects[] = $row; }

// --- QUERY UTAMA ---
// Menggunakan t.* untuk memastikan semua kolom terambil
$sql = "
    SELECT 
        t.*, 
        p.project_name, 
        m.username AS member_name,
        c.username AS creator_name
    FROM tasks t
    JOIN projects p ON t.project_id = p.project_id
    JOIN users m ON t.assigned_to = m.id
    JOIN users c ON t.creator_id = c.id
    WHERE 1=1
";

// Terapkan Filter
$params = [];
$types = "";

if (!empty($filter_project)) {
    $sql .= " AND t.project_id = ?";
    $params[] = $filter_project;
    $types .= "i";
}
if (!empty($filter_status)) {
    $sql .= " AND t.status = ?";
    $params[] = $filter_status;
    $types .= "s";
}

$sql .= " ORDER BY t.due_date ASC, t.id DESC";

$stmt = $conn->prepare($sql);
if (!empty($params)) {
    $stmt->bind_param($types, ...$params);
}
$stmt->execute();
$result = $stmt->get_result();
?>

<!DOCTYPE html>
<html>
<head>
    <title>Superadmin - Monitoring Tugas</title>
    <style>
        body { font-family: sans-serif; padding: 20px; }
        table { width: 100%; border-collapse: collapse; margin-top: 20px; }
        th, td { border: 1px solid #ddd; padding: 10px; text-align: left; }
        th { background-color: #333; color: white; }
        tr:nth-child(even) { background-color: #f2f2f2; }

        /* Status Colors */
        .status-pending { color: #ff9800; font-weight: bold; }
        .status-in_progress { color: #2196F3; font-weight: bold; }
        .status-completed { color: #4CAF50; font-weight: bold; }
        .status-blocked { color: #f44336; font-weight: bold; }

        .filter-box { background: #eee; padding: 15px; border-radius: 5px; margin-bottom: 20px; }
        .btn-filter { background: #333; color: white; border: none; padding: 5px 10px; cursor: pointer; }
        .btn-delete { color: red; text-decoration: none; font-size: 0.9em; }
    </style>
</head>
<body>
    <h1>👮‍♂️ Monitoring Semua Tugas (Superadmin)</h1>
    <p>
        <a href="superadmin_dashboard.php">Kembali ke Dashboard</a> | 
        <a href="superadmin_monitor_tasks.php">🔄 Refresh Data</a>
    </p>
    <hr>

    <div class="filter-box">
        <form method="GET">
            <label>Filter Project:</label>
            <select name="project_id">
                <option value="">-- Semua Project --</option>
                <?php foreach ($projects as $p): ?>
                    <option value="<?php echo $p['project_id']; ?>" <?php if($filter_project == $p['project_id']) echo 'selected'; ?>>
                        <?php echo htmlspecialchars($p['project_name']); ?>
                    </option>
                <?php endforeach; ?>
            </select>

            <label>Status:</label>
            <select name="status">
                <option value="">-- Semua Status --</option>
                <option value="pending" <?php if($filter_status == 'pending') echo 'selected'; ?>>Pending</option>
                <option value="in_progress" <?php if($filter_status == 'in_progress') echo 'selected'; ?>>In Progress</option>
                <option value="completed" <?php if($filter_status == 'completed') echo 'selected'; ?>>Completed</option>
                <option value="blocked" <?php if($filter_status == 'blocked') echo 'selected'; ?>>Blocked</option>
            </select>

            <button type="submit" class="btn-filter">Terapkan Filter</button>
            <a href="superadmin_monitor_tasks.php">[Reset]</a>
        </form>
    </div>

    <table border="1">
        <thead>
            <tr>
                <th>Project</th>
                <th>Judul Tugas</th>
                <th>Member (Penerima)</th>
                <th>Pembuat (Creator)</th>
                <th>Due Date</th>
                <th>Status</th>
                <th>Aksi</th>
            </tr>
        </thead>
        <tbody>
            <?php if ($result->num_rows > 0): ?>
                <?php while ($row = $result->fetch_assoc()): ?>
                    <?php 
                        // --- LOGIKA PERBAIKAN TAMPILAN (ANTI-BLANK) ---
                        $status_raw = $row['status'];
                        if (empty($status_raw)) { $status_raw = 'completed'; }
                        $status_display = strtoupper(str_replace('_', ' ', $status_raw));
                    ?>
                    <tr>
                        <td><?php echo htmlspecialchars($row['project_name']); ?></td>
                        <td><?php echo htmlspecialchars($row['title']); ?></td>
                        <td><?php echo htmlspecialchars($row['member_name']); ?></td>
                        <td><?php echo htmlspecialchars($row['creator_name']); ?></td>
                        <td><?php echo htmlspecialchars($row['due_date']); ?></td>
                        
                        <td class="status-<?php echo strtolower($status_raw); ?>">
                            <?php echo $status_display; ?>
                        </td>
                        
                        <td>
                            <a href="#" onclick="alert('Fitur hapus belum diaktifkan demi keamanan'); return false;" style="color:grey;">Hapus</a>
                        </td>
                    </tr>
                <?php endwhile; ?>
            <?php else: ?>
                <tr>
                    <td colspan="7" style="text-align:center;">Tidak ada data tugas ditemukan.</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
</body>
</html>