<?php
// File: superadmin/superadmin_list_project.php

// 1. Matikan Cache
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Pragma: no-cache");

require_once('../db.php'); 
include 'auth_check.php';
require_role(['superadmin']); 

$username = $_SESSION['username'] ?? 'Superadmin';

// --- LOGIKA PENCARIAN & PAGINATION ---
$search = isset($_GET['search']) ? trim($_GET['search']) : '';
$limit = 5; 
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$offset = ($page - 1) * $limit;

// 1. Hitung Total Data
$sql_count = "SELECT COUNT(*) as total FROM projects";
if (!empty($search)) {
    $sql_count .= " WHERE project_name LIKE '%$search%'";
}
$res_count = mysqli_query($conn, $sql_count);
$total_records = mysqli_fetch_assoc($res_count)['total'];
$total_pages = ceil($total_records / $limit);

// 2. Ambil Data Project
$query = "SELECT * FROM projects";
if (!empty($search)) {
    $query .= " WHERE project_name LIKE '%$search%'";
}
$query .= " ORDER BY project_id DESC LIMIT $limit OFFSET $offset";
$result = mysqli_query($conn, $query);
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <title>Daftar Project</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600;700;800&display=swap" rel="stylesheet">
    <style>
        /* STYLE SUPERADMIN */
        :root { --primary: #111; --accent: #39ff14; --bg: #f4f6f9; }
        * { margin: 0; padding: 0; box-sizing: border-box; font-family: 'Poppins', sans-serif; }
        body { background-color: var(--bg); color: #333; padding-bottom: 50px; }

        /* HEADER */
        .header {
            position: sticky; top: 0; z-index: 1000;
            background: linear-gradient(135deg, #1a1a1a, #2c3e50);
            color: white;
            padding: 20px 30px 25px;
            text-align: center;
            border-bottom: 4px solid var(--accent);
            box-shadow: 0 4px 20px rgba(0,0,0,0.2);
            margin-bottom: 30px;
            display: flex; justify-content: space-between; align-items: center;
        }
        .header-left .text-brand { font-size: 22px; font-weight: 800; color: white; text-transform: uppercase; letter-spacing: 0.5px; }
        .header-left .text-brand span { color: var(--accent); }
        .header-center { position: absolute; left: 50%; transform: translateX(-50%); text-align: center; }
        .header-center h1 { font-size: 28px; font-weight: 700; margin: 0; letter-spacing: 1px; }
        .header-center p { font-size: 14px; opacity: 0.9; margin-top: 5px; }
        .btn-logout-top { background-color: #ff3333; color: white; padding: 8px 20px; border-radius: 50px; text-decoration: none; font-weight: 700; font-size: 12px; border: 2px solid white; box-shadow: 0 4px 10px rgba(0,0,0,0.3); transition: 0.3s; }
        .btn-logout-top:hover { background-color: white; color: #ff3333; }

        /* CONTAINER */
        .container { max-width: 1200px; margin: 0 auto; padding: 0 20px; }
        .monitoring-section { background: white; padding: 30px; border-radius: 15px; box-shadow: 0 5px 20px rgba(0,0,0,0.05); }
        .section-header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px; border-bottom: 2px solid #eee; padding-bottom: 15px; }
        .section-title { font-size: 24px; font-weight: 700; margin: 0; }
        
        .btn-add { background: #FF9800; color: white; text-decoration: none; padding: 10px 20px; border-radius: 8px; font-weight: 600; font-size: 14px; box-shadow: 0 4px 10px rgba(255, 152, 0, 0.3); transition: 0.2s; }
        .btn-add:hover { background: #F57C00; transform: translateY(-2px); }

        .btn-back { text-decoration: none; color: #666; font-weight: 600; font-size: 14px; display: flex; align-items: center; gap: 5px; margin-bottom: 20px; }
        .btn-back:hover { color: #000; }

        /* SEARCH */
        .filter-form { background: #f8f9fa; padding: 15px; border-radius: 10px; display: flex; gap: 15px; align-items: center; margin-bottom: 20px; }
        .filter-form input { padding: 10px; border-radius: 5px; border: 1px solid #ddd; flex: 1; }
        .btn-filter { background: #333; color: white; border: none; padding: 10px 20px; border-radius: 5px; cursor: pointer; font-weight: bold; }
        .reset-filter { color: #d32f2f; font-weight: 600; text-decoration: none; font-size: 13px; }

        /* TABLE */
        .table-responsive { overflow-x: auto; }
        table { width: 100%; border-collapse: collapse; }
        th { background: #333; color: white; padding: 15px; text-align: left; font-size: 14px; text-transform: uppercase; }
        td { padding: 15px; border-bottom: 1px solid #eee; font-size: 15px; vertical-align: middle; }
        
        .badge-emp { background: #e3f2fd; color: #1565C0; padding: 3px 8px; border-radius: 4px; font-size: 11px; font-weight: 600; display: inline-block; margin-bottom: 3px; border: 1px solid #bbdefb; }
        .badge-mem { background: #fff3e0; color: #EF6C00; padding: 3px 8px; border-radius: 4px; font-size: 11px; font-weight: 600; display: inline-block; margin-bottom: 3px; border: 1px solid #ffe0b2; }

        /* TOMBOL AKSI YANG RAPI */
        .action-group {
            display: flex;
            gap: 8px; /* Jarak antar tombol */
            justify-content: flex-start; /* Rata kiri */
            flex-wrap: wrap; /* Kalau layar sempit, tombol turun */
        }

        .btn-sm {
            padding: 6px 12px;
            font-size: 12px;
            border-radius: 6px;
            text-decoration: none;
            font-weight: 600;
            display: inline-block;
            transition: all 0.2s;
            text-align: center;
            border: 1px solid transparent;
        }

        .btn-detail { color: #0d6efd; background-color: #e7f1ff; border-color: #0d6efd; }
        .btn-detail:hover { background-color: #0d6efd; color: white; }

        .btn-edit { color: #856404; background-color: #fff3cd; border-color: #ffeeba; }
        .btn-edit:hover { background-color: #ffc107; color: #212529; }

        .btn-delete { color: #842029; background-color: #f8d7da; border-color: #f5c6cb; }
        .btn-delete:hover { background-color: #dc3545; color: white; }

        .pagination { margin-top: 30px; text-align: center; }
        .page-link { display: inline-block; padding: 8px 14px; margin: 0 4px; border: 1px solid #ddd; color: #333; text-decoration: none; border-radius: 6px; }
        .page-link.active { background-color: #333; color: white; }
    </style>
</head>
<body>

    <div class="header">
        <div class="header-left"><div class="text-brand">TASK <span>MANAGEMENT</span></div></div>
        <div class="header-center"><h1>📂 Manajemen Project</h1><p>Superadmin Panel</p></div>
        <div class="header-right"><a href="../logout.php" class="btn-logout-top">LOGOUT</a></div>
    </div>

    <div class="container">
        <a href="superadmin_dashboard.php" class="btn-back">← Kembali ke Dashboard</a>

        <div class="monitoring-section">
            <div class="section-header">
                <div class="section-title">Daftar Project & Tim</div>
                <a href="superadmin_create_project.php" class="btn-add">➕ Buat Project Baru</a>
            </div>

            <form method="GET" class="filter-form">
                <input type="text" name="search" placeholder="Cari nama project..." value="<?php echo htmlspecialchars($search); ?>">
                <button type="submit" class="btn-filter">Cari</button>
                <?php if($search): ?><a href="superadmin_list_project.php" class="reset-filter">Reset</a><?php endif; ?>
            </form>

            <div class="table-responsive">
                <table width="100%">
                    <thead>
                        <tr>
                            <th width="20%">Nama Project</th>
                            <th width="25%">Deskripsi</th>
                            <th width="20%">Employer</th>
                            <th width="20%">Member</th>
                            <th width="15%">Aksi</th> </tr>
                    </thead>
                    <tbody>
                        <?php if (mysqli_num_rows($result) > 0): ?>
                            <?php while ($row = mysqli_fetch_assoc($result)) { 
                                $pid = $row['project_id'];
                                $emps = []; $q_emp = mysqli_query($conn, "SELECT u.username FROM users u JOIN employer_projects ep ON u.id = ep.employer_id WHERE ep.project_id = $pid");
                                while($e = mysqli_fetch_assoc($q_emp)) $emps[] = $e['username'];
                                
                                $mems = []; $q_mem = mysqli_query($conn, "SELECT u.username FROM users u JOIN member_projects mp ON u.id = mp.member_id WHERE mp.project_id = $pid");
                                while($m = mysqli_fetch_assoc($q_mem)) $mems[] = $m['username'];
                            ?>
                            <tr>
                                <td><strong><?php echo htmlspecialchars($row['project_name']); ?></strong></td>
                                <td style="font-size:13px; color:#666;"><?php echo htmlspecialchars(substr($row['description'], 0, 60)) . '...'; ?></td>
                                <td><?php if(empty($emps)) echo "-"; else foreach($emps as $en) echo "<span class='badge-emp'>$en</span> "; ?></td>
                                <td><?php if(empty($mems)) echo "-"; else foreach($mems as $mn) echo "<span class='badge-mem'>$mn</span> "; ?></td>
                                
                                <td>
                                    <div class="action-group">
                                        <a href="superadmin_view_project.php?id=<?php echo $row['project_id']; ?>" class="btn-sm btn-detail" title="Lihat Detail">Detail</a>
                                        <a href="superadmin_edit_project.php?id=<?php echo $row['project_id']; ?>" class="btn-sm btn-edit" title="Edit Project">Edit</a>
                                        <a href="superadmin_delete_project.php?id=<?php echo $row['project_id']; ?>" class="btn-sm btn-delete" onclick="return confirm('Hapus Project ini beserta isinya?');" title="Hapus Project">Hapus</a>
                                    </div>
                                </td>
                            </tr>
                            <?php } ?>
                        <?php else: ?>
                            <tr><td colspan="5" style="text-align:center; padding:30px; color:#999;">Tidak ada project ditemukan.</td></tr>
                        <?php endif; ?>
                    </tbody>
                </table>

                <div class="pagination">
                    <?php $link_search = ($search) ? "&search=$search" : ""; ?>
                    <?php for ($i = 1; $i <= $total_pages; $i++): ?>
                        <a href="?page=<?php echo $i . $link_search; ?>" class="page-link <?php echo ($i == $page) ? 'active' : ''; ?>"><?php echo $i; ?></a>
                    <?php endfor; ?>
                </div>
            </div>
        </div>
    </div>

</body>
</html>