<?php
// Pastikan jalur ini benar. Jika db.php berada satu level di atas 'superadmin', gunakan '../db.php'.
require_once('../db.php'); 
include 'auth_check.php';
require_role(['superadmin']); // Pembatasan akses hanya untuk superadmin

$message = "";

// Cek apakah ada ID user yang dikirim melalui URL (GET parameter)
if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    // Jika tidak ada ID yang valid, arahkan kembali
    header("Location: superadmin_list_user.php");
    exit();
}

$user_id_to_delete = $_GET['id'];

// --- Pencegahan: Jangan biarkan superadmin menghapus dirinya sendiri ---
// Anda mungkin ingin menambahkan logika di sini untuk mencegah superadmin yang sedang login terhapus.
if ($user_id_to_delete == $_SESSION['user_id']) {
    $message = "❌ Anda tidak dapat menghapus akun Anda sendiri!";
    // Tampilkan pesan dan berhenti, atau arahkan kembali
    // Biasanya, file delete hanya melakukan aksi dan redirect, bukan menampilkan HTML
    echo "<script>alert('$message'); window.location.href='superadmin_list_user.php';</script>";
    exit();
}

// --- Proses Delete (Menggunakan Prepared Statement) ---

// 1. Definisikan query DELETE
$delete_stmt = mysqli_prepare($conn, "DELETE FROM users WHERE id = ?");

// 2. Bind parameter (i = integer)
mysqli_stmt_bind_param($delete_stmt, "i", $user_id_to_delete);

// 3. Eksekusi statement
if (mysqli_stmt_execute($delete_stmt)) {
    // Cek apakah ada baris yang terpengaruh (terhapus)
    if (mysqli_stmt_affected_rows($delete_stmt) > 0) {
        $message = "✅ User dengan ID **$user_id_to_delete** berhasil dihapus!";
    } else {
        $message = "⚠️ User dengan ID **$user_id_to_delete** tidak ditemukan atau sudah terhapus!";
    }
} else {
    $message = "❌ Gagal menghapus user. Error: " . mysqli_error($conn); 
}

// 4. Tutup statement
mysqli_stmt_close($delete_stmt);

// Redirect kembali ke halaman daftar user setelah proses selesai
// Pesan bisa dilewatkan melalui Session jika Anda ingin menampilkannya di halaman list
$_SESSION['status_message'] = $message;
header("Location: superadmin_list_user.php");
exit();
?>