<?php
// File: superadmin/export_excel.php

include 'auth_check.php';
require_role(['superadmin']);
require_once('../db.php');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $project_id = isset($_POST['project_id']) ? (int)$_POST['project_id'] : 0;

    // 1. Validasi Project
    if ($project_id == 0) {
        echo "<script>alert('Pilih project terlebih dahulu!'); window.location='superadmin_dashboard.php';</script>";
        exit;
    }

    // 2. Ambil Nama Project untuk Nama File
    $q_proj = mysqli_query($conn, "SELECT project_name FROM projects WHERE project_id = $project_id");
    $p_data = mysqli_fetch_assoc($q_proj);
    
    // Bersihkan nama file dari karakter aneh
    $project_name_safe = preg_replace('/[^a-zA-Z0-9]/', '_', $p_data['project_name']); 
    $filename = "Laporan_Task_" . $project_name_safe . "_" . date('Y-m-d') . ".xls";

    // 3. Header agar browser mengenali ini sebagai file Excel
    header("Content-Type: application/vnd.ms-excel");
    header("Content-Disposition: attachment; filename=\"$filename\"");
    header("Pragma: no-cache");
    header("Expires: 0");

    // 4. Query Data Task Lengkap
    $sql = "
        SELECT 
            t.title, 
            t.description, 
            t.due_date, 
            t.status, 
            m.username as member_name,
            c.username as creator_name
        FROM tasks t
        LEFT JOIN users m ON t.assigned_to = m.id
        LEFT JOIN users c ON t.creator_id = c.id
        WHERE t.project_id = $project_id
        ORDER BY t.id DESC
    ";
    $result = mysqli_query($conn, $sql);

    // 5. Output HTML Table (Excel akan membacanya sebagai sel)
    echo '<table border="1">';
    echo '<tr style="background-color:#f0f0f0; font-weight:bold;">
            <th>No</th>
            <th>Judul Tugas</th>
            <th>Deskripsi</th>
            <th>Penerima (Member)</th>
            <th>Pembuat (Employer)</th>
            <th>Deadline</th>
            <th>Status</th>
          </tr>';

    $no = 1;
    while ($row = mysqli_fetch_assoc($result)) {
        // Styling status warna warni (Excel support basic color)
        $status_color = '#ffffff';
        if($row['status'] == 'pending') $status_color = '#fff3cd'; // Kuning muda
        if($row['status'] == 'in_progress') $status_color = '#cff4fc'; // Biru muda
        if($row['status'] == 'completed') $status_color = '#d1e7dd'; // Hijau muda

        echo '<tr>
                <td style="text-align:center;">' . $no++ . '</td>
                <td>' . htmlspecialchars($row['title']) . '</td>
                <td>' . htmlspecialchars($row['description']) . '</td>
                <td>' . htmlspecialchars($row['member_name']) . '</td>
                <td>' . htmlspecialchars($row['creator_name']) . '</td>
                <td style="text-align:center;">' . $row['due_date'] . '</td>
                <td style="background-color:'.$status_color.'; text-align:center;">' . strtoupper(str_replace('_', ' ', $row['status'])) . '</td>
              </tr>';
    }
    echo '</table>';
    exit; 
}
?>