<?php
// ===============================
// auth_check.php — Middleware Otorisasi Role
// ===============================

// Perbaikan untuk mengatasi "Ignoring session_start()":
// Cek status sesi sebelum memulai sesi
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// 1. Cek apakah user sudah login
if (!isset($_SESSION['user_id'])) {
    // Arahkan ke halaman login jika sesi user_id tidak ditemukan
    header("Location: login.php");
    exit();
}

/**
 * Memastikan user memiliki salah satu role yang diizinkan
 * @param array $roles Array berisi role yang diizinkan (e.g., ['superadmin', 'admin'])
 */
function require_role($roles = []) {
    // Cek apakah role user saat ini ada di dalam daftar role yang diizinkan
    if (!in_array($_SESSION['role'], $roles)) {
        // Tampilkan pesan dan hentikan eksekusi
        echo "<h1>Akses Ditolak!</h1>"; 
        echo "<p>Anda tidak memiliki hak akses untuk melihat halaman ini.</p>";
        // Anda juga bisa mengarahkan ke halaman dashboard
        // header("Location: user_dashboard.php");
        exit();
    }
}
?>