<?php
session_start();
require_once 'db.php'; 

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username']);
    $password = $_POST['password'];

    $stmt = $conn->prepare("SELECT id, password, role FROM users WHERE username = ?");
    $stmt->bind_param("s", $username);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows === 1) {
        $row = $result->fetch_assoc();
        if (password_verify($password, $row['password'])) {
            $_SESSION['user_id'] = $row['id'];
            $_SESSION['username'] = $username;
            $_SESSION['role'] = $row['role'];

            if ($row['role'] == 'superadmin') { header("Location: superadmin/superadmin_dashboard.php"); }
            elseif ($row['role'] == 'employer') { header("Location: employer/employer_dashboard.php"); }
            elseif ($row['role'] == 'member') { header("Location: member/member_dashboard.php"); }
            exit;
        } else {
            $error = "Password salah!";
        }
    } else {
        $error = "Username tidak ditemukan!";
    }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - Task Management</title>
    <link href="https://fonts.googleapis.com/css2?family=Fugaz+One&family=Poppins:wght@400;600;700&display=swap" rel="stylesheet">
    
    <style>
        /* --- RESET & BASIC --- */
        * { margin: 0; padding: 0; box-sizing: border-box; font-family: 'Poppins', sans-serif; }

        body {
            color: #333; 
            height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            
            /* --- BACKGROUND ORIGINAL (TIDAK BERUBAH) --- */
            background-image: 
                linear-gradient(rgba(0, 0, 0, 0.1), rgba(0, 0, 0, 0.3)), 
                url('https://images.unsplash.com/photo-1432405972618-c60b0225b8f9?q=80&w=1920&auto=format&fit=crop'); 
            background-size: cover;
            background-position: center;
            background-repeat: no-repeat;
        }

        /* --- CONTAINER LOGIN --- */
        .login-container {
            background-color: rgba(255, 255, 255, 0.92);
            padding: 50px 40px;
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.5); 
            width: 100%;
            max-width: 400px;
            text-align: center;
            position: relative;
            overflow: hidden;
            background-image: linear-gradient(135deg, transparent 0%, transparent 85%, #39ff14 85%, #39ff14 100%);
        }

        /* Garis Neon di Atas */
        .login-container::before {
            content: ''; position: absolute; top: 0; left: 0; width: 100%; height: 6px;
            background: #39ff14; box-shadow: 0 2px 15px rgba(57, 255, 20, 0.6);
        }

        h2 {
            font-family: 'Fugaz One', cursive; margin-bottom: 10px; color: #111; font-size: 32px;
            text-transform: uppercase; font-style: italic; line-height: 1.1; text-shadow: 2px 2px 0px #ddd;
        }
        h2 span { color: #00c800; text-shadow: 2px 2px 0px #39ff14; }
        .subtitle { font-size: 12px; color: #666; margin-bottom: 30px; font-weight: 600; letter-spacing: 1px; text-transform: uppercase; }

        /* --- INPUT FIELD --- */
        .input-group { margin-bottom: 20px; text-align: left; }
        label { display: block; margin-bottom: 8px; font-size: 13px; color: #333; font-weight: 700; text-transform: uppercase; }

        /* WRAPPER PASSWORD (Supaya Ikon Mata bisa masuk) */
        .password-wrapper { position: relative; width: 100%; }

        input {
            width: 100%; padding: 14px 15px; background-color: #f4f4f4; border: 2px solid #ddd;
            border-radius: 8px; color: #333; font-size: 15px; font-weight: 600; outline: none; transition: all 0.3s ease;
        }
        input::placeholder { color: #aaa; font-weight: 400; }
        input:focus { border-color: #39ff14; background-color: #fff; box-shadow: 0 0 15px rgba(57, 255, 20, 0.3); }

        /* IKON MATA (MODIFIKASI) */
        .toggle-password {
            position: absolute; right: 15px; top: 50%; transform: translateY(-50%);
            cursor: pointer; color: #888; font-size: 18px; user-select: none;
        }
        .toggle-password:hover { color: #00c800; }

        /* LINK LUPA PASSWORD */
        .forgot-link {
            display: block; text-align: right; margin-top: 5px; font-size: 12px;
            color: #666; text-decoration: none; font-weight: 500; transition: 0.2s;
        }
        .forgot-link:hover { color: #00c800; text-decoration: underline; }

        /* --- TOMBOL LOGIN --- */
        .btn-login {
            width: 100%; padding: 15px; background: linear-gradient(90deg, #39ff14, #28a745);
            color: #000; border: none; border-radius: 50px; font-family: 'Fugaz One', cursive;
            font-size: 18px; cursor: pointer; transition: all 0.3s ease; margin-top: 15px;
            text-transform: uppercase; letter-spacing: 1px; box-shadow: 0 5px 15px rgba(40, 167, 69, 0.4);
        }
        .btn-login:hover { transform: translateY(-3px) skewX(-5deg); box-shadow: 0 8px 25px rgba(57, 255, 20, 0.6); }
        .btn-login:active { transform: scale(0.98); }

        .error-msg {
            background-color: #ffebee; color: #c62828; border-left: 5px solid #c62828;
            padding: 12px; border-radius: 4px; margin-bottom: 20px; font-size: 13px; font-weight: 600; text-align: left;
        }
        .footer { margin-top: 30px; font-size: 11px; color: #888; font-weight: 500; }
    </style>
</head>
<body>

    <div class="login-container">
        <h2>TASK<br><span>MANAGEMENT</span></h2>
        <div class="subtitle">System Login Area</div>

        <?php if ($error): ?>
            <div class="error-msg"><?php echo $error; ?></div>
        <?php endif; ?>

        <form method="POST">
            <div class="input-group">
                <label for="username">Username</label>
                <input type="text" id="username" name="username" placeholder="Type username..." required autocomplete="off">
            </div>

            <div class="input-group">
                <label for="password">Password</label>
                <div class="password-wrapper">
                    <input type="password" id="password" name="password" placeholder="Type password..." required>
                    <span class="toggle-password" onclick="togglePassword()">👁️</span>
                </div>
                <a href="forgot_password.php" class="forgot-link">Lupa Password?</a>
            </div>

            <button type="submit" class="btn-login">LOGIN</button>
        </form>

        <div class="footer">
            &copy; 2025 PAWINDO Official System
        </div>
    </div>

    <script>
        function togglePassword() {
            var input = document.getElementById("password");
            var icon = document.querySelector(".toggle-password");
            if (input.type === "password") {
                input.type = "text";
                icon.textContent = "🙈"; // Ikon mata tertutup
            } else {
                input.type = "password";
                icon.textContent = "👁️"; // Ikon mata terbuka
            }
        }
    </script>

</body>
</html>