<?php
// File: employer/employer_monitor_tasks.php

// 1. Matikan Cache Browser
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");

include 'auth_check.php';
require_role(['employer']); 
require_once('../db.php'); 

$employer_id = $_SESSION['user_id'];

// --- QUERY UTAMA ---
// Menggunakan t.* agar semua kolom status terambil
$sql = "
    SELECT 
        t.*, 
        p.project_name, 
        m.username AS member_name
    FROM tasks t
    JOIN projects p ON t.project_id = p.project_id
    JOIN users m ON t.assigned_to = m.id
    WHERE t.creator_id = ?
    ORDER BY t.due_date ASC, t.id DESC
";

$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $employer_id);
$stmt->execute();
$result = $stmt->get_result();
?>

<!DOCTYPE html>
<html>
<head>
    <title>Employer - Monitoring Tugas</title>
    <style>
        body { font-family: sans-serif; padding: 20px; }
        table { width: 100%; border-collapse: collapse; margin-top: 20px; }
        th, td { border: 1px solid #ddd; padding: 10px; text-align: left; }
        th { background-color: #007bff; color: white; } /* Warna Biru untuk Employer */
        tr:nth-child(even) { background-color: #f9f9f9; }

        /* Status Colors */
        .status-pending { color: #ff9800; font-weight: bold; }
        .status-in_progress { color: #2196F3; font-weight: bold; }
        .status-completed { color: #4CAF50; font-weight: bold; }
        .status-blocked { color: #f44336; font-weight: bold; }
    </style>
</head>
<body>
    <h1>💼 Monitoring Tugas (Employer)</h1>
    <p>Berikut adalah progres tugas yang Anda berikan kepada member.</p>
    
    <p>
        <a href="employer_dashboard.php">Kembali ke Dashboard</a> |
        <a href="employer_monitor_tasks.php">🔄 Refresh Data</a>
    </p>
    <hr>

    <table border="1">
        <thead>
            <tr>
                <th>Judul Tugas</th>
                <th>Project</th>
                <th>Ditugaskan Ke (Member)</th>
                <th>Batas Waktu</th>
                <th>Status Terkini</th>
            </tr>
        </thead>
        <tbody>
            <?php if ($result->num_rows > 0): ?>
                <?php while ($row = $result->fetch_assoc()): ?>
                    <?php 
                        // --- LOGIKA PERBAIKAN TAMPILAN (ANTI-BLANK) ---
                        $status_raw = $row['status'];
                        if (empty($status_raw)) { $status_raw = 'completed'; }
                        $status_display = strtoupper(str_replace('_', ' ', $status_raw));
                    ?>
                    <tr>
                        <td><?php echo htmlspecialchars($row['title']); ?></td>
                        <td><?php echo htmlspecialchars($row['project_name']); ?></td>
                        <td><?php echo htmlspecialchars($row['member_name']); ?></td>
                        <td><?php echo htmlspecialchars($row['due_date']); ?></td>
                        
                        <td class="status-<?php echo strtolower($status_raw); ?>">
                            <?php echo $status_display; ?>
                        </td>
                    </tr>
                <?php endwhile; ?>
            <?php else: ?>
                <tr>
                    <td colspan="5" style="text-align:center;">Anda belum membuat tugas apapun.</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
</body>
</html>