<?php
// Pastikan session sudah dimulai
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

function require_role(array $roles) {
    // Cek apakah user sudah login (apakah ada user_id di session)
    if (!isset($_SESSION['user_id'])) {
        // Jika belum login, redirect ke halaman login
        header('Location: ../login.php');
        exit();
    }
    
    $user_role = $_SESSION['role'] ?? null;
    
    // Cek apakah role user ada di array role yang diizinkan
    if (!in_array($user_role, $roles)) {
        // Jika role tidak sesuai, berikan pesan error atau redirect ke dashboard yang benar
        // Contoh sederhana: redirect ke dashboard default (jika ada)
        
        $error_message = "Akses Ditolak! Role Anda ($user_role) tidak diizinkan mengakses halaman ini.";
        // Atau: header('Location: index.php');
        
        die("<h1>".$error_message."</h1>");
    }
}
?>