<?php
require_once 'config/connection.php';

$error = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $employee_id = sanitize($_POST['employee_id']);
    $password = hash('sha256', $_POST['password']);
    
    if (empty($employee_id) || empty($_POST['password'])) {
        $error = 'Employee ID dan Password harus diisi!';
    } else {
        // Check in superadmins table
        $stmt = $pdo->prepare("SELECT * FROM superadmins WHERE employee_id = ? AND password = ? AND is_active = 1");
        $stmt->execute([$employee_id, $password]);
        $user = $stmt->fetch();
        
        if ($user) {
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['user_type'] = 'superadmin';
            $_SESSION['user_name'] = $user['full_name'];
            $_SESSION['employee_id'] = $user['employee_id'];
            redirect('superadmin/dashboard.php');
        }
        
        // Check in admins table
        $stmt = $pdo->prepare("SELECT * FROM admins WHERE employee_id = ? AND password = ? AND is_active = 1");
        $stmt->execute([$employee_id, $password]);
        $user = $stmt->fetch();
        
        if ($user) {
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['user_type'] = 'admin';
            $_SESSION['user_name'] = $user['full_name'];
            $_SESSION['employee_id'] = $user['employee_id'];
            redirect('admin/dashboard.php');
        }
        
        // Check in borrowers table
        $stmt = $pdo->prepare("SELECT * FROM borrowers WHERE employee_id = ? AND password = ? AND is_active = 1");
        $stmt->execute([$employee_id, $password]);
        $user = $stmt->fetch();
        
        if ($user) {
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['user_type'] = 'borrower';
            $_SESSION['user_name'] = $user['full_name'];
            $_SESSION['employee_id'] = $user['employee_id'];
            redirect('borrower/dashboard.php');
        }
        
        $error = 'Employee ID atau Password salah!';
    }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - Peminjaman Tools Room</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        'leaf-green': '#90EE90',
                        'dark-leaf': '#32CD32',
                        'soft-gray': '#F5F5F5',
                        'medium-gray': '#9CA3AF'
                    }
                }
            }
        }
    </script>
    <style>
        body {
            background: linear-gradient(135deg, #90EE90 0%, #32CD32 100%);
        }
    </style>
</head>
<body class="min-h-screen flex items-center justify-center p-4">
    <div class="w-full max-w-md">
        <div class="bg-white rounded-2xl shadow-xl p-8">
            <!-- Logo -->
            <div class="text-center mb-8">
                <img src="images/logo.png" alt="Logo" class="mx-auto h-16 w-16 mb-4" onerror="this.style.display='none'">
                <h1 class="text-2xl font-bold text-gray-800">Peminjaman Tools Room</h1>
                <p class="text-medium-gray mt-2">Silakan login untuk melanjutkan</p>
            </div>

            <!-- Error Message -->
            <?php if ($error): ?>
                <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
                    <?php echo $error; ?>
                </div>
            <?php endif; ?>

            <!-- Login Form -->
            <form method="POST" class="space-y-6">
                <div>
                    <label for="employee_id" class="block text-sm font-medium text-gray-700 mb-2">Employee ID</label>
                    <input type="text" id="employee_id" name="employee_id" required
                           class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-dark-leaf focus:border-dark-leaf transition duration-200"
                           placeholder="Masukkan Employee ID">
                </div>

                <div>
                    <label for="password" class="block text-sm font-medium text-gray-700 mb-2">Password</label>
                    <input type="password" id="password" name="password" required
                           class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-dark-leaf focus:border-dark-leaf transition duration-200"
                           placeholder="Masukkan Password">
                </div>

                <button type="submit"
                        class="w-full bg-dark-leaf hover:bg-green-600 text-white font-semibold py-3 px-4 rounded-lg transition duration-200 transform hover:scale-105">
                    Login
                </button>
            </form>

            <!-- Footer -->
            <div class="mt-8 text-center">
                <p class="text-xs text-medium-gray">
                    Sistem Manajemen Peminjaman Asset
                </p>
            </div>
        </div>
    </div>

    <script>
        // Simple form validation
        document.querySelector('form').addEventListener('submit', function(e) {
            const employee_id = document.getElementById('employee_id').value.trim();
            const password = document.getElementById('password').value.trim();
            
            if (!employee_id || !password) {
                e.preventDefault();
                alert('Employee ID dan Password harus diisi!');
                return false;
            }
            
            if (employee_id.length < 3) {
                e.preventDefault();
                alert('Employee ID minimal 3 karakter!');
                return false;
            }
        });

        // Auto-focus on first input
        document.addEventListener('DOMContentLoaded', function() {
            document.getElementById('employee_id').focus();
        });

        // Enter key navigation
        document.getElementById('employee_id').addEventListener('keypress', function(e) {
            if (e.key === 'Enter') {
                e.preventDefault();
                document.getElementById('password').focus();
            }
        });
    </script>
</body>
</html>