
<?php $__env->startSection('content'); ?>
<!-- Pastry Recipes Blade - Refactored JS (template literals, modular) -->
<div class="container py-4" style="background:#FFF8F0; border-radius:14px;">
  <div class="d-flex align-items-center justify-content-between mb-4">
    <div>
      <h2 class="fw-bold mb-0" style="color:#183647;">Pastry Recipes</h2>
      <div class="small text-muted">Production · Pastry Department</div>
    </div>

    <div class="d-flex gap-2 align-items-center">
      <input id="searchInput" class="form-control form-control-sm" placeholder="Search recipe..." style="min-width:260px; background:#fff; border-radius:12px;" />
      <button id="refreshBtn" class="btn btn-sm" title="Refresh" style="background:#F2E6DA; color:#5a3e2b; border-radius:10px;">⟳</button>
    </div>
  </div>

  <div class="table-responsive shadow-sm rounded-3 bg-white p-3">
    <table class="table mb-0 align-middle" id="recipesTable">
      <thead style="background:#FAEBD7; border-radius:8px;">
        <tr>
          <th style="width:4%">No</th>
          <th style="width:46%">Recipe</th>
          <th style="width:18%">Stock</th>
          <th style="width:12%">Status</th>
          <th style="width:20%" class="text-end">Actions</th>
        </tr>
      </thead>
      <tbody id="recipesTbody">
        <!-- Rows injected by JS -->
      </tbody>
    </table>
  </div>
</div>

<!-- ============================= -->
<!-- 🍰 AO MODAL -->
<!-- ============================= -->
<div class="modal fade" id="aoModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered modal-lg">
    <div class="modal-content">
      <div class="modal-header" style="background:#FFD6A5;">
        <h5 class="modal-title fw-semibold">Create Assembly Order (AO)</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <form id="aoForm">
          <?php echo csrf_field(); ?>
          <input type="hidden" id="ao_recipe_id">
          <!-- Header Section -->
          <div class="row g-3 mb-3">
            <div class="col-md-6">
              <label class="form-label">Recipe Description</label>
              <input type="text" id="ao_recipe_name" class="form-control" readonly>
            </div>
            <div class="col-md-3">
              <label class="form-label">Item No</label>
              <input type="text" id="ao_item_no" class="form-control" readonly>
            </div>
            <div class="col-md-3">
              <label class="form-label">Base Unit</label>
              <input type="text" id="ao_uom" class="form-control" readonly>
            </div>
          </div>

          <div class="mb-3">
            <label class="form-label">Quantity</label>
            <input type="number" id="ao_qty" class="form-control" min="1" value="1">
          </div>

          <!-- Line Section -->
          <div class="border rounded p-3 bg-light mb-2">
            <div class="fw-semibold mb-2">Material Requirements</div>
            <div id="aoLines" class="table-responsive">
              <table class="table table-sm align-middle mb-0">
                <thead>
                  <tr>
                    <th>Material</th>
                    <th>Needed</th>
                    <th>Inventory</th>
                    <th>Status</th>
                  </tr>
                </thead>
                <tbody id="aoLineBody">
                  <tr><td colspan="4" class="text-muted text-center small">Enter quantity to calculate materials...</td></tr>
                </tbody>
              </table>
            </div>
          </div>

          <!-- Warning -->
          <div id="aoWarning" class="text-danger small mb-2" style="display:none;">
            ⚠️ Insufficient stock to produce this quantity.
          </div>

          <!-- Submit -->
          <div class="d-grid">
            <button id="aoSubmit" class="btn" style="background:#FFB84D; color:white;" type="submit" disabled>
              Create AO
            </button>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>

<!-- TO Modal -->
<!-- Create Transfer Order Modal -->
<div class="modal fade" id="toModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered modal-lg">
    <div class="modal-content border-0 shadow-sm" style="border-radius: 1rem;">
      
      <!-- Header -->
      <div class="modal-header text-white" style="background:#9FCBE6; border-top-left-radius:1rem; border-top-right-radius:1rem;">
        <h5 class="modal-title fw-semibold">Create Transfer Order (TO)</h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>

      <!-- Body -->
      <div class="modal-body p-4">
        <form id="toForm">
          
          <!-- ===== HEADER SECTION ===== -->
          <div class="border rounded-3 p-3 mb-4 bg-light">
            <h6 class="fw-semibold text-primary mb-3">Header Information</h6>

            <div class="row g-3">
              <div class="col-md-6">
                <label class="form-label fw-semibold">No. Series</label>
                <select id="to_noSeries" name="header[noSeries]" class="form-select">
                  <option value="TO.RBC" selected>RBC</option>
                  <option value="TO.CI">CI</option>
                </select>
              </div>

              <div class="col-md-6">
                <label class="form-label fw-semibold">Transfer Spec</label>
                <select id="to_transSpec" name="header[transSpec]" class="form-select">
                  <option value="ST. ORDER">Transfer Internal Business Unit</option>
                  <option value="ST.EXT BU">Transfer Antara Business Unit</option>
                </select>
              </div>

              <div class="col-md-6">
                <label class="form-label fw-semibold">Business Unit</label>
                <select id="to_businessUnit" name="header[businessUnit]" class="form-select" disabled>
                  <option value="RBC" selected>Regent Bali Canggu</option>
                </select>
              </div>

              <div class="col-md-6">
                <label class="form-label fw-semibold">Department</label>
                <input type="text" id="to_department" name="header[department]" class="form-control" value="8430" readonly>
              </div>

              <div class="col-md-6">
                <label class="form-label fw-semibold">Transfer From</label>
                <select id="to_transferFrom" name="header[transferFrom]" class="form-select">
                  <option value="CI.1010" selected>Food Central</option>
                </select>
              </div>

              <div class="col-md-6">
                <label class="form-label fw-semibold">Transfer To</label>
                <select id="to_transferTo" name="header[transferTo]" class="form-select">
                  <option value="RBC.2040" selected>Pastry</option>
                </select>
              </div>
            </div>
          </div>

          <!-- ===== ITEM SECTION ===== -->
          <div class="border rounded-3 p-3 bg-light">
            <div class="d-flex justify-content-between align-items-center mb-3">
              <h6 class="fw-semibold text-primary mb-0">Item Lines</h6>
              <button type="button" class="btn btn-sm btn-outline-primary fw-semibold" id="addItemBtn">
                <i class="bi bi-plus-circle me-1"></i> Add Item
              </button>
            </div>

            <div id="itemContainer">
              <!-- Dynamic items will be added here -->
            </div>
          </div>

          <!-- Submit -->
          <div class="d-grid mt-4">
            <button class="btn text-white fw-semibold" type="submit" style="background-color:#7DC5E3;">
              <i class="bi bi-arrow-repeat me-1"></i> Create TO
            </button>
          </div>

        </form>
      </div>
    </div>
  </div>
</div>


<style>
  /* Pastel + mockup-like table styling */
  body { background:#F0FAFF; }
  #recipesTable thead th { border-top-left-radius:8px; border-top-right-radius:8px; }
  .recipe-row { transition: transform .18s ease, box-shadow .18s ease, background .15s ease; }
  .recipe-row:hover { transform: translateY(-4px); background:#FFF7EE; }

  .status-ready { background:#E6F9EF; color:#0f5132; padding:.4rem .6rem; border-radius:8px; display:inline-block; }
  .status-need { background:#FFF1F0; color:#842029; padding:.4rem .6rem; border-radius:8px; display:inline-block; }

  .ingredients-card { overflow:hidden; transition: max-height .28s cubic-bezier(.2,.8,.2,1), opacity .2s ease; max-height:0; opacity:0; }
  .ingredients-card.open { max-height:800px; opacity:1; }
  .ingredients-inner { background:#FFF8F0; border:1px solid #FAEBD7; border-radius:10px; padding:12px; box-shadow:0 6px 18px rgba(15, 23, 42, 0.04); }

  .progress-small { height:10px; border-radius:8px; overflow:hidden; background:#FFF3EB; }
  .progress-bar-soft { height:10px; border-radius:8px; }

  .btn-ao { background:#FFB84D; color:white; border-radius:8px; padding:.35rem .7rem; border:none; }
  .btn-to { background:#6FB3D2; color:white; border-radius:8px; padding:.35rem .7rem; border:none; }

  .ingredients-grid { display:flex; gap:18px; flex-wrap:wrap; }
  .ingredients-col { flex:1 1 300px; }
  .small-muted{ color:#6b7280; }

  @media (max-width: 768px){
    .ingredients-grid { flex-direction:column; }
    #searchInput{ min-width:160px }
  }
</style>

<script>
document.addEventListener('DOMContentLoaded', async () => {

  const qs = (s) => document.querySelector(s);
  const qsa = (s) => Array.from(document.querySelectorAll(s));

  // =============================
  // Skeleton Loader
  // =============================
  function showSkeleton() {
    const skeletonRows = Array(5).fill().map(() => `
      <tr>
        <td colspan="5">
          <div class="d-flex align-items-center gap-3 p-2">
            <div class="skeleton-box" style="width:60px; height:20px;"></div>
            <div class="skeleton-box flex-grow-1" style="height:20px;"></div>
            <div class="skeleton-box" style="width:80px; height:20px;"></div>
          </div>
        </td>
      </tr>
    `).join('');
    qs('#recipesTbody').innerHTML = skeletonRows;
  }

  function hideSkeleton() {
    qsa('.skeleton-box').forEach(el => el.remove());
  }

  // =============================
  // Fetch BOM / Recipe data (utama)
  // =============================
  async function fetchBOMData() {
    showSkeleton();
    try {
      const res = await fetch(`<?php echo e(route('bc.bom-with-stock')); ?>`);
      if (!res.ok) throw new Error(`HTTP ${res.status}`);
      const data = await res.json();

      if (data.status === 'success') {
        renderTable(data.items);
      } else {
        qs('#recipesTbody').innerHTML = `<tr><td colspan="5" class="text-center text-danger">Failed to load data</td></tr>`;
      }
    } catch (e) {
      qs('#recipesTbody').innerHTML = `<tr><td colspan="5" class="text-center text-danger">Error loading data</td></tr>`;
      console.error(e);
    } finally {
      hideSkeleton();
    }
  }

  // =============================
  // Utility
  // =============================
  function percent(stock, cap){ return cap > 0 ? Math.round((stock / cap) * 100) : 0; }

  function ingredientDropdownHtml(ingredients){
    if(!ingredients || ingredients.length===0) return `<div class="p-2 text-muted">No ingredients</div>`;
    return `
      <div class="p-2 border rounded bg-light">
        <table class="table table-sm mb-0">
          <thead>
            <tr>
              <th>Material</th>
              <th>Qty</th>
              <th>UoM</th>
              <th>Inventory</th>
            </tr>
          </thead>
          <tbody>
            ${ingredients.map(i => `
              <tr>
                <td>${i.BOM}~${i.BOM_Description}</td>
                <td>${i.Quantity}</td>
                <td>${i.Uom_BOM}</td>
                <td>${i.Inventory ?? 0}</td>
              </tr>
            `).join('')}
          </tbody>
        </table>
      </div>
    `;
  }

  // =============================
  // 🔹 Logika status item
  // =============================
  function getRecipeStatus(r) {
    const inv = parseFloat(r.Inventory ?? 0);
    const min = parseFloat(r.Minimum_Stock ?? 0);
    const hasTO = r.statusTO === true;

    if (hasTO) {
      if (inv > min) return 'Need To Transfer';
      return 'Need To Assemble';
    }

    if (inv <= min) return 'Need To Assemble';

    return 'Standby';
  }

  // =============================
  // 🔹 Render row table (tanpa ubah style status)
  // =============================
  function renderRow(r, index){
    const status = getRecipeStatus(r);
    const statusColor =
      status === 'Need To Assemble'
        ? 'status-need'
        : status === 'Need To Transfer'
          ? 'status-need'
          : 'status-ready';

    const p = percent(r.Inventory ?? 0, 100);
    return `
      <tr class="recipe-row" data-id="${r.BOM_Parent}">
        <td>${index}</td>
        <td>
          <div class="fw-semibold">${r.Description_BOM}</div>
          <div class="small text-muted">${r.BOM_Parent}</div>
          <a href="#" class="small view-ings" data-id="${r.BOM_Parent}">Show Materials ▾</a>
        </td>
        <td>
          <div class="d-flex align-items-center gap-3">
            <div class="fw-semibold">${r.Inventory ?? 0}</div>
            <div style="flex:1">
              <div class="progress-small">
                <div class="progress-bar-soft" style="width:${p}%; background:${p>70 ? '#90EEA2' : (p<=50 ? '#FFD58A' : '#FCA5A5')};"></div>
              </div>
            </div>
          </div>
        </td>
        <td><span class="${statusColor}">${status}</span></td>
        <td class="text-end">
          <button class="btn-ao me-2" data-id="${r.BOM_Parent}">Assembly Order</button>
        </td>
      </tr>
      <tr class="ing-row" style="display:none;">
        <td colspan="5">
          ${ingredientDropdownHtml(r.Item_Operation)}
        </td>
      </tr>
    `;
  }

  // =============================
  // 🔹 Render table (prioritas: TO true paling atas)
  // =============================
  function renderTable(data){
    if (!data || data.length === 0) {
      qs('#recipesTbody').innerHTML = `<tr><td colspan="5" class="text-center text-muted py-4">No recipes found.</td></tr>`;
      return;
    }
    window._lastRecipeData = data;

    const sorted = [...data].sort((a, b) => {
      const aStatus = getRecipeStatus(a);
      const bStatus = getRecipeStatus(b);
      // TO true paling atas
      if (a.statusTO && !b.statusTO) return -1;
      if (!a.statusTO && b.statusTO) return 1;

      // Lalu urutan berdasarkan status biasa
      const priority = { 'Need To Assemble': 1, 'Need To Transfer': 2, 'Standby': 3 };
      return priority[aStatus] - priority[bStatus];
    });

    const html = sorted.map((r, i) => renderRow(r, i+1)).join('');
    qs('#recipesTbody').innerHTML = html;
    attachListeners(sorted);
  }

  // =============================
  // Attach listeners
  // =============================
  function attachListeners(data){
    qsa('.view-ings').forEach(a => a.addEventListener('click', e => {
      e.preventDefault();
      const row = a.closest('tr');
      const next = row.nextElementSibling;
      if(next && next.classList.contains('ing-row')){
        next.style.display = next.style.display === 'none' ? 'table-row' : 'none';
      }
    }));

    qsa('.btn-ao').forEach(btn => btn.addEventListener('click', () => {
      const bomId = btn.getAttribute('data-id');
      const recipe = data.find(x => x.BOM_Parent === bomId);
      openAOModal(recipe);
    }));
  }

  // =============================
  // AO Modal Handling
  // =============================
  let currentAORecipe = null;

  function openAOModal(recipe){
    const modal = new bootstrap.Modal(qs('#aoModal'));
    currentAORecipe = recipe;

    qs('#ao_recipe_id').value = recipe.BOM_Parent;
    qs('#ao_recipe_name').value = recipe.Description_BOM;
    qs('#ao_item_no').value = recipe.BOM_Parent;
    qs('#ao_uom').value = recipe.Uom_BOM_Parent || '-';
    qs('#ao_qty').value = 1;

    renderAOLines(recipe, 1);
    modal.show();
  }

  function renderAOLines(recipe, qty){
    const tbody = qs('#aoLineBody');
    const warning = qs('#aoWarning');
    const submitBtn = qs('#aoSubmit');

    if(!recipe.Item_Operation || recipe.Item_Operation.length === 0){
      tbody.innerHTML = `<tr><td colspan="4" class="text-muted text-center small">No materials listed for this recipe.</td></tr>`;
      submitBtn.disabled = true;
      warning.style.display = 'block';
      return;
    }

    let hasInsufficient = false;
    const rows = recipe.Item_Operation.map(i => {
      const need = (i.Quantity ?? 0) * qty;
      const inv = i.Inventory ?? 0;
      const diff = inv - need;
      const enough = diff >= 0;
      if(!enough) hasInsufficient = true;
      return `
        <tr class="fade-in">
          <td>${i.BOM_Description}</td>
          <td>${need} ${i.Uom_BOM}</td>
          <td>${inv}</td>
          <td><span class="badge ${enough?'bg-success-subtle text-success':'bg-danger-subtle text-danger'}">
            ${enough?'Sufficient':'Insufficient'}
          </span></td>
        </tr>`;
    }).join('');

    tbody.innerHTML = rows;

    if(hasInsufficient){
      submitBtn.disabled = true;
      submitBtn.style.background = '#ccc';
      warning.style.display = 'block';
    } else {
      submitBtn.disabled = false;
      submitBtn.style.background = '#FFB84D';
      warning.style.display = 'none';
    }
  }

  qs('#ao_qty').addEventListener('input', (e)=>{
    const qty = parseInt(e.target.value)||0;
    if(currentAORecipe && qty>0) renderAOLines(currentAORecipe, qty);
  });

  // =============================
  // AO Submit
  // =============================
  qs('#aoForm').addEventListener('submit', async e=>{
    e.preventDefault();
    const qty = parseInt(qs('#ao_qty').value);
    if(!currentAORecipe || qty<=0) return;

    const payload = {
      itemNo: currentAORecipe.BOM_Parent,
      quantity: qty,
      postingDate: new Date().toISOString().split('T')[0],
    };

    Swal.fire({
      title: 'Preparing your Assembly Order...',
      html: `
        <div class="pastry-loader">
          <div class="dough-rise"></div>
          <p class="mt-3 text-muted small">Mixing and shaping your pastry dough 🍞</p>
        </div>
      `,
      allowOutsideClick: false,
      showConfirmButton: false,
      background: '#fffbea',
      customClass: { popup: 'sweet-slim' }
    });

    try {
      const res = await fetch(`<?php echo e(route('bc.assembly-header.create')); ?>`, {
        method: 'POST',
        headers: {
          'Accept': 'application/json',
          'Content-Type': 'application/json',
          'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
        },
        body: JSON.stringify(payload)
      });

      const text = await res.text();
      const data = JSON.parse(text);

      if (res.ok && data.status === 'success') {
        Swal.fire({
          title: 'Assembly Order Created!',
          html: `
            <div class="bread-success">
              <div class="bread"></div>
              <div class="steam success"></div>
              <p class="mt-3 text-success">Your pastry is perfectly baked!</p>
            </div>
          `,
          icon: 'success',
          confirmButtonColor: '#FFB84D',
          background: '#fffbea',
          customClass: { popup: 'sweet-slim' },
          showConfirmButton: true
        });

        bootstrap.Modal.getInstance(qs('#aoModal')).hide();
      } else {
        throw new Error(data.message || 'Server returned an error');
      }

    } catch (err) {
      console.error(err);
      Swal.fire({
        title: 'Oops! The oven overheated 🔥',
        html: `
          <div class="bread-error">
            <div class="burnt-bread"></div>
            <div class="smoke"></div>
            <p class="mt-3 text-danger">Failed to create Assembly Order.</p>
          </div>
        `,
        icon: 'error',
        confirmButtonColor: '#F87171',
        background: '#fffbea',
        customClass: { popup: 'sweet-slim' }
      });
    }
  });

  // =============================
  // Auto Refresh
  // =============================
  let refreshController = null;
  let isRefreshing = false;
  const REFRESH_INTERVAL = 30000;

  async function softRefreshBOM() {
    if (isRefreshing) return;
    isRefreshing = true;

    if (refreshController) refreshController.abort();
    refreshController = new AbortController();
    const signal = refreshController.signal;

    const timeout = setTimeout(() => {
      if (!signal.aborted) refreshController.abort();
    }, 20000);

    try {
      const res = await fetch(`<?php echo e(route('bc.bom-with-stock')); ?>`, { signal });
      if (!res.ok) throw new Error(`HTTP ${res.status}`);
      const data = await res.json();

      if (!signal.aborted && data?.status === 'success' && Array.isArray(data.items)) {
        renderTable(data.items);
        console.log("✅ Auto-refresh success at", new Date().toLocaleTimeString());
      }
    } catch (err) {
      if (err.name === 'AbortError') {
        console.log("⏹️ Fetch aborted — normal during refresh swap");
      } else {
        console.warn("⚠️ Auto-refresh skipped:", err.message);
      }
    } finally {
      clearTimeout(timeout);
      isRefreshing = false;
    }
  }

  await fetchBOMData();
  setInterval(softRefreshBOM, REFRESH_INTERVAL);

});
</script>


<style>
/* === SweetAlert container refinement === */
.swal2-popup.sweet-slim {
  width: 550px !important;
  border-radius: 20px;
  padding: 1.5rem 1.2rem;
}

/* ============================
   🥐 Refined Pastry Animations
============================ */
.pastry-loader, .bread-success, .bread-error {
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
  animation: fadeIn 0.8s ease-in-out;
}

@keyframes fadeIn {
  from { opacity: 0; transform: translateY(15px); }
  to { opacity: 1; transform: translateY(0); opacity: 1; }
}

/* === Dough Rise Animation === */
.dough-rise {
  width: 80px;
  height: 80px;
  border-radius: 50%;
  background: radial-gradient(circle at 30% 30%, #ffe7c3, #f8c47f);
  box-shadow: inset -3px -5px 8px rgba(0,0,0,0.1), 0 5px 12px rgba(0,0,0,0.1);
  animation: riseRotate 2.5s ease-in-out infinite;
}

@keyframes riseRotate {
  0% { transform: scale(0.95) rotate(0deg); }
  50% { transform: scale(1.05) rotate(6deg); }
  100% { transform: scale(0.95) rotate(-6deg); }
}

/* === Success Bread === */
.bread-success .bread {
  width: 90px;
  height: 55px;
  background: linear-gradient(to bottom, #ffcf83, #f9b760);
  border-radius: 40% 40% 35% 35%;
  box-shadow: 0 3px 6px rgba(0,0,0,0.25);
  animation: breadAppear 1.2s ease-out;
  position: relative;
}

@keyframes breadAppear {
  0% { transform: scale(0.7) translateY(15px); opacity: 0.5; }
  100% { transform: scale(1) translateY(0); opacity: 1; }
}

.steam.success::before, .steam.success::after {
  content: '';
  position: absolute;
  width: 6px;
  height: 25px;
  background: linear-gradient(to top, rgba(255,255,255,0), rgba(255,255,255,0.9));
  border-radius: 50%;
  animation: steamUp 2.4s ease-in-out infinite;
  top: -30px;
}

.steam.success::before { left: -15px; animation-delay: 0.4s; }
.steam.success::after { right: -15px; animation-delay: 1s; }

@keyframes steamUp {
  0% { opacity: 0; transform: translateY(10px); }
  50% { opacity: 1; }
  100% { opacity: 0; transform: translateY(-25px); }
}

/* === Error Burnt Bread === */
.bread-error .burnt-bread {
  width: 90px;
  height: 55px;
  background: linear-gradient(to bottom, #4b2c16, #3c1c0a);
  border-radius: 40% 40% 35% 35%;
  box-shadow: 0 3px 8px rgba(0,0,0,0.4);
  animation: slightShake 0.8s ease-in-out;
  position: relative;
}

@keyframes slightShake {
  0%, 100% { transform: rotate(0deg); }
  25% { transform: rotate(-2deg); }
  50% { transform: rotate(2deg); }
  75% { transform: rotate(-1deg); }
}

.smoke::before, .smoke::after {
  content: '';
  position: absolute;
  width: 6px;
  height: 25px;
  background: linear-gradient(to top, rgba(80,80,80,0), rgba(80,80,80,0.6));
  border-radius: 50%;
  animation: smokeUp 2s ease-in-out infinite;
  top: -30px;
}

.smoke::before { left: -12px; animation-delay: 0.3s; }
.smoke::after { right: -12px; animation-delay: 1s; }

@keyframes smokeUp {
  0% { opacity: 0; transform: translateY(10px); }
  50% { opacity: 0.7; }
  100% { opacity: 0; transform: translateY(-25px); }
}
</style>


<style>
.skeleton-box {
  background: linear-gradient(90deg, #f0f0f0 25%, #e0e0e0 50%, #f0f0f0 75%);
  background-size: 200% 100%;
  animation: skeleton 1.5s infinite;
  border-radius: 4px;
}
@keyframes skeleton {
  0% { background-position: 200% 0; }
  100% { background-position: -200% 0; }
}
.ingredients-card {
  transition: all 0.3s ease;
}
.fade-in { animation: fadeIn 0.3s ease-in; }
@keyframes fadeIn {
  from { opacity: 0; transform: translateY(3px); }
  to { opacity: 1; transform: translateY(0); }
}
.badge.bg-success-subtle {
  background-color: #90EEA2 !important;
  color: #075E0D !important;
}
.badge.bg-danger-subtle {
  background-color: #FCA5A5 !important;
  color: #7C1C1C !important;
}

</style>




<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\agusy\OneDrive\Dokumen\Kerjaan\Pastry\resources\views/transferheader.blade.php ENDPATH**/ ?>