<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Third Party Services
    |--------------------------------------------------------------------------
    |
    | This file is for storing the credentials for third party services such
    | as Mailgun, Postmark, AWS and more. This file provides the de facto
    | location for this type of information, allowing packages to have
    | a conventional file to locate the various service credentials.
    |
    */

    'postmark' => [
        'token' => env('POSTMARK_TOKEN'),
    ],

    'resend' => [
        'key' => env('RESEND_KEY'),
    ],

    'ses' => [
        'key' => env('AWS_ACCESS_KEY_ID'),
        'secret' => env('AWS_SECRET_ACCESS_KEY'),
        'region' => env('AWS_DEFAULT_REGION', 'us-east-1'),
    ],

    'slack' => [
        'notifications' => [
            'bot_user_oauth_token' => env('SLACK_BOT_USER_OAUTH_TOKEN'),
            'channel' => env('SLACK_BOT_USER_DEFAULT_CHANNEL'),
        ],
    ],

    'microsoft' => [
        'client_id' => env('AZURE_CLIENT_ID'),
        'client_secret' => env('AZURE_CLIENT_SECRET'),
        'redirect' => env('AZURE_LOGIN_REDIRECT_URI'),
        'tenant' => "5f138de3-8774-4114-8fc4-1a93dfc31a3a", 
        'token_url' => env('AZURE_TOKEN_URL'),
        'scope' => env('AZURE_SCOPE', 'openid profile email'),
        'guzzle' => [],
    ],
    'azure' => [
        'tenant_id'     => "5f138de3-8774-4114-8fc4-1a93dfc31a3a",
        'client_id'     => env('AZURE_CLIENT_ID'),
        'client_secret' => env('AZURE_CLIENT_SECRET'),
    ],
    'onedrive' => [
        'owner_upn'=> "adminbc@citbi.onmicrosoft.com",
        'hic_path'=> "Bali Canggu/history_forecast(HIC).txt",
        'hic_share_url' => "https://citbi-my.sharepoint.com/personal/adminbc_citbi_onmicrosoft_com/Documents/Bali%20Canggu/history_forecast(HIC).txt",
        'hin_path' =>   "Bali Canggu/history_forecast(HIND).txt" ,
        'hin_share_url' => "https://citbi-my.sharepoint.com/personal/adminbc_citbi_onmicrosoft_com/Documents/Bali%20Canggu/history_forecast(HIND).txt",
        'rbc_path' => "Bali Canggu/history_forecast.txt",
        'rbc_share_url' =>  "https://citbi-my.sharepoint.com/personal/adminbc_citbi_onmicrosoft_com/Documents/Bali%20Canggu/history_forecast.txt",
    ],


];
