<?php
// Start session
session_start();

// Include database connection
require_once "../config/connection.php";

// Set JSON header
header('Content-Type: application/json');

// Check if user is logged in and is IT user
if (!is_logged_in() || !is_user_type('it')) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized access']);
    exit();
}

// Get buyer ID from request
$buyer_id = isset($_GET['buyer_id']) ? (int)$_GET['buyer_id'] : 0;

try {
    // Get buyer name if specific buyer selected
    $buyer_name = null;
    if ($buyer_id > 0) {
        $buyer_stmt = $conn->prepare("SELECT nama_buyer FROM buyers WHERE id = ?");
        $buyer_stmt->bind_param("i", $buyer_id);
        $buyer_stmt->execute();
        $buyer_result = $buyer_stmt->get_result();
        if ($buyer_row = $buyer_result->fetch_assoc()) {
            $buyer_name = $buyer_row['nama_buyer'];
        }
        $buyer_stmt->close();
    }
    
    // Count total stock items
    $items_query = "
        SELECT COUNT(*) as total
        FROM color_stock_items csi
        JOIN master_color_panel mcp ON csi.color_id = mcp.id
    ";
    
    if ($buyer_id > 0) {
        $items_query .= " WHERE mcp.buyer_id = ?";
    }
    
    $items_stmt = $conn->prepare($items_query);
    if ($buyer_id > 0) {
        $items_stmt->bind_param("i", $buyer_id);
    }
    $items_stmt->execute();
    $items_result = $items_stmt->get_result();
    $total_items = $items_result->fetch_assoc()['total'];
    $items_stmt->close();
    
    // Count total color panels
    $panels_query = "
        SELECT COUNT(DISTINCT mcp.id) as total
        FROM master_color_panel mcp
    ";
    
    if ($buyer_id > 0) {
        $panels_query .= " WHERE mcp.buyer_id = ?";
    }
    
    $panels_stmt = $conn->prepare($panels_query);
    if ($buyer_id > 0) {
        $panels_stmt->bind_param("i", $buyer_id);
    }
    $panels_stmt->execute();
    $panels_result = $panels_stmt->get_result();
    $total_panels = $panels_result->fetch_assoc()['total'];
    $panels_stmt->close();
    
    // Count total master colors
    $master_colors_query = "
        SELECT COUNT(DISTINCT mc.id) as total
        FROM master_color mc
    ";
    
    if ($buyer_id > 0) {
        $master_colors_query .= " WHERE mc.buyer_id = ?";
    }
    
    $master_colors_stmt = $conn->prepare($master_colors_query);
    if ($buyer_id > 0) {
        $master_colors_stmt->bind_param("i", $buyer_id);
    }
    $master_colors_stmt->execute();
    $master_colors_result = $master_colors_stmt->get_result();
    $total_master_colors = $master_colors_result->fetch_assoc()['total'];
    $master_colors_stmt->close();
    
    // Count by item type for additional info
    $item_types_query = "
        SELECT 
            csi.item_type,
            COUNT(*) as count
        FROM color_stock_items csi
        JOIN master_color_panel mcp ON csi.color_id = mcp.id
    ";
    
    if ($buyer_id > 0) {
        $item_types_query .= " WHERE mcp.buyer_id = ?";
    }
    
    $item_types_query .= " GROUP BY csi.item_type";
    
    $item_types_stmt = $conn->prepare($item_types_query);
    if ($buyer_id > 0) {
        $item_types_stmt->bind_param("i", $buyer_id);
    }
    $item_types_stmt->execute();
    $item_types_result = $item_types_stmt->get_result();
    
    $item_types_breakdown = [];
    while ($row = $item_types_result->fetch_assoc()) {
        $item_types_breakdown[$row['item_type']] = $row['count'];
    }
    $item_types_stmt->close();
    
    echo json_encode([
        'success' => true,
        'total_items' => (int)$total_items,
        'total_panels' => (int)$total_panels,
        'total_master_colors' => (int)$total_master_colors,
        'buyer_name' => $buyer_name,
        'item_types_breakdown' => $item_types_breakdown
    ]);
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Error: ' . $e->getMessage()
    ]);
}

$conn->close();
?>