<?php
require_once "config/connection.php";

$buyer_id = isset($_POST['buyer_id']) ? $_POST['buyer_id'] : null;
$color_id = isset($_POST['color_id']) ? $_POST['color_id'] : null;
$component_id = isset($_POST['component_id']) ? $_POST['component_id'] : null;
$status = isset($_POST['status']) ? $_POST['status'] : null;

// Build the query
$query = "SELECT mcp.id, mcp.code_color, mcp.deskripsi, mcp.lemari, mcp.status, 
                 b.nama_buyer, c.component_name, 
                 COUNT(csi.id) as item_count
          FROM master_color_panel_surabaya mcp
          JOIN buyers_surabaya b ON mcp.buyer_id = b.id
          JOIN color_panel_components_surabaya cpc ON mcp.id = cpc.color_id
          JOIN color_components_surabaya c ON cpc.component_id = c.id
          JOIN color_stock_items_surabaya csi ON (mcp.id = csi.color_id AND c.id = csi.component_id)
          WHERE 1=1";

if ($buyer_id) {
    $query .= " AND mcp.buyer_id = $buyer_id";
}

if ($color_id) {
    $query .= " AND mcp.id = $color_id";
}

if ($component_id) {
    $query .= " AND c.id = $component_id";
}

if ($status) {
    $query .= " AND csi.status = '$status'";
}

$query .= " GROUP BY mcp.id, mcp.code_color, mcp.deskripsi, mcp.lemari, mcp.status, b.nama_buyer
            ORDER BY b.nama_buyer, mcp.code_color";

$result = mysqli_query($conn, $query);

if (mysqli_num_rows($result) > 0) {
    while ($row = mysqli_fetch_assoc($result)) {
        echo '<div class="color-panel bg-white rounded-lg shadow" data-color-code="' . htmlspecialchars($row['code_color']) . '">';
        echo '<div class="color-panel-header p-6 cursor-pointer flex justify-between items-center">';
        echo '<div>';
        echo '<h3 class="text-xl font-semibold">' . htmlspecialchars($row['code_color']) . '</h3>';
        echo '<p class="text-gray-600">' . htmlspecialchars($row['deskripsi']) . ' | ' . htmlspecialchars($row['nama_buyer']) . '</p>';
        echo '</div>';
        echo '<div class="flex items-center">';
        echo '<span class="px-3 py-1 rounded-full text-sm font-medium ' . 
             ($row['status'] == 'Hijau' ? 'bg-green-100 text-green-800' : 
              ($row['status'] == 'Kuning' ? 'bg-yellow-100 text-yellow-800' : 'bg-red-100 text-red-800')) . '">';
        echo htmlspecialchars($row['status']);
        echo '</span>';
        echo '<span class="ml-4 text-gray-500">' . $row['item_count'] . ' items</span>';
        echo '</div>';
        echo '</div>';
        
        // Get stock items for this color panel
        $items_query = "SELECT csi.*, c.component_name 
                        FROM color_stock_items_surabaya csi
                        JOIN color_components_surabaya c ON csi.component_id = c.id
                        WHERE csi.color_id = " . $row['id'];
        
        if ($component_id) {
            $items_query .= " AND csi.component_id = $component_id";
        }
        
        if ($status) {
            $items_query .= " AND csi.status = '$status'";
        }
        
        $items_query .= " ORDER BY c.component_name, csi.stock_number";
        
        $items_result = mysqli_query($conn, $items_query);
        
        echo '<div class="stock-items-container px-6 pb-6 hidden">';
        echo '<div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">';
        
        while ($item = mysqli_fetch_assoc($items_result)) {
            $status_class = '';
            switch ($item['status']) {
                case 'Tersedia': $status_class = 'bg-green-100 text-green-800'; break;
                case 'Dipinjam': $status_class = 'bg-blue-100 text-blue-800 cursor-pointer'; break;
                case 'Rusak': $status_class = 'bg-red-100 text-red-800'; break;
                case 'Hilang': $status_class = 'bg-gray-100 text-gray-800'; break;
                case 'Expired': $status_class = 'bg-purple-100 text-purple-800'; break;
                case 'Renew': $status_class = 'bg-yellow-100 text-yellow-800'; break;
                default: $status_class = 'bg-gray-100 text-gray-800';
            }
            
            echo '<div class="stock-item p-4 border rounded-lg ' . $status_class . '" ' . 
                 'data-item-id="' . $item['id'] . '" ' .
                 'data-code-barang="' . htmlspecialchars($item['kode_barang']) . '" ' .
                 'data-status="' . htmlspecialchars($item['status']) . '">';
            echo '<div class="flex justify-between items-start">';
            echo '<div>';
            echo '<h4 class="font-medium">' . htmlspecialchars($item['component_name']) . '</h4>';
            echo '<p class="text-sm">' . htmlspecialchars($item['kode_barang']) . ' - #' . $item['stock_number'] . '</p>';
            echo '<p class="text-sm">Rack: ' . htmlspecialchars($item['rack_no'] ?: 'N/A') . '</p>';
            echo '</div>';
            echo '<span class="px-2 py-1 rounded-full text-xs font-medium ' . $status_class . '">';
            echo htmlspecialchars($item['status']);
            echo '</span>';
            echo '</div>';
            echo '</div>';
        }
        
        echo '</div>';
        echo '</div>';
    }
} else {
    echo '<div class="text-center py-8 text-gray-500">No color panels found matching the selected filters.</div>';
}
?>