<?php
require_once "config/connection.php";

$query = "SELECT ti.id, csi.kode_barang, csi.stock_number, 
                 c.component_name, mcp.code_color,
                 st.reservation_number, b.nama_borrower,
                 st.tanggal_pengembalian
          FROM transaction_items_surabaya ti
          JOIN color_stock_items_surabaya csi ON ti.stock_item_id = csi.id
          JOIN color_components_surabaya c ON csi.component_id = c.id
          JOIN master_color_panel_surabaya mcp ON csi.color_id = mcp.id
          JOIN stock_transactions_surabaya st ON ti.transaction_id = st.id
          JOIN borrower_users_surabaya b ON st.borrower_id = b.id
          WHERE ti.dikembalikan = 0 AND st.status_peminjaman = 'Dipinjam'
          ORDER BY st.tanggal_pengembalian ASC";

$result = mysqli_query($conn, $query);
?>

<div class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center p-4">
    <div class="bg-white rounded-lg shadow-lg w-full max-w-4xl max-h-[80vh] overflow-y-auto">
        <div class="p-6">
            <div class="flex justify-between items-center mb-4">
                <h3 class="text-xl font-semibold">Borrowed Items</h3>
                <button onclick="closeModal('borrowed_modal')" class="text-gray-500 hover:text-gray-700">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                    </svg>
                </button>
            </div>
            
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Code Barang</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Component</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Color Code</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Borrower</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Reservation #</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Due Date</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        <?php while ($row = mysqli_fetch_assoc($result)): ?>
                        <tr>
                            <td class="px-6 py-4 whitespace-nowrap"><?php echo htmlspecialchars($row['kode_barang']); ?></td>
                            <td class="px-6 py-4 whitespace-nowrap"><?php echo htmlspecialchars($row['component_name']); ?></td>
                            <td class="px-6 py-4 whitespace-nowrap"><?php echo htmlspecialchars($row['code_color']); ?></td>
                            <td class="px-6 py-4 whitespace-nowrap"><?php echo htmlspecialchars($row['nama_borrower']); ?></td>
                            <td class="px-6 py-4 whitespace-nowrap"><?php echo htmlspecialchars($row['reservation_number']); ?></td>
                            <td class="px-6 py-4 whitespace-nowrap"><?php echo date('d M Y H:i', strtotime($row['tanggal_pengembalian'])); ?></td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <button onclick="showItemDetailModal(<?php echo $row['id']; ?>)" class="text-blue-600 hover:text-blue-900">Details</button>
                            </td>
                        </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            </div>
            
            <div class="mt-6 flex justify-end">
                <button onclick="closeModal('borrowed_modal')" class="px-4 py-2 bg-gray-200 rounded-md hover:bg-gray-300">Close</button>
            </div>
        </div>
    </div>
</div>