<?php
// Start session
session_start();

// Include database connection
require_once "../config/connection.php";

// Redirect if not borrower user - using functions from connection.php
if (!is_logged_in() || !is_user_type('borrower')) {
    header("Location: ../login.php");
    exit();
}

// Get borrower data
$borrower_id = $_SESSION['user_id'];
$stmt = $conn->prepare("SELECT * FROM borrower_users_semarang WHERE id = ?");
$stmt->bind_param("i", $borrower_id);
$stmt->execute();
$borrower_data = $stmt->get_result()->fetch_assoc();
$stmt->close();

// Check if account is active, redirect to logout if not
if ($borrower_data['status'] == 'nonactive') {
    // Log this attempt
    error_log("Nonactive borrower attempted to access panduan: " . $_SESSION['username']);
    
    // Clear all session variables
    $_SESSION = array();
    
    // Destroy the session
    session_destroy();
    
    // Redirect to login with message
    header("Location: ../login.php?error=inactive");
    exit();
}

// Log activity
log_activity($conn, $borrower_id, 'borrower', 'Panduan Access', 'borrower user accessed panduan peminjaman');

// Get active tab from query string, default to borrowing guide
$active_tab = isset($_GET['tab']) ? $_GET['tab'] : 'peminjaman';

// Set page title
$page_title = "panduan peminjaman Color Code";

// Include header
include '../template_peminjam/header.php';
?>

<!-- Main Content Area -->
<main class="flex-1 p-3 md:p-6 overflow-auto bg-gradient-to-br from-blue-100 via-teal-100 to-green-100">
    <div class="bg-white rounded-lg shadow-md p-4 md:p-6 mb-6 max-w-4xl mx-auto">
        <h1 class="text-xl md:text-2xl font-bold text-gray-800 mb-4 md:mb-6">panduan peminjaman Color Code</h1>
        
        <!-- Tabs Navigation - Mobile Responsive -->
        <div class="mb-4 md:mb-6 border-b border-gray-200">
            <!-- Dropdown for Mobile -->
            <div class="md:hidden">
                <select id="tab-select" onchange="window.location.href='?tab='+this.value" class="block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-500 focus:ring-opacity-50 py-2 px-3 text-sm bg-white">
                    <option value="peminjaman" <?php echo $active_tab == 'peminjaman' ? 'selected' : ''; ?>>panduan peminjaman</option>
                    <option value="history" <?php echo $active_tab == 'history' ? 'selected' : ''; ?>>Panduan History peminjaman</option>
                </select>
            </div>
            
            <!-- Tabs for Tablet/Desktop -->
            <nav class="hidden md:flex whitespace-nowrap">
                <a href="?tab=peminjaman" class="<?php echo $active_tab == 'peminjaman' ? 'border-b-2 border-blue-500 text-blue-600' : 'text-gray-500 hover:text-gray-700 hover:border-gray-300'; ?> py-3 px-4 border-b-2 border-transparent font-medium text-base">
                    panduan peminjaman
                </a>
                <a href="?tab=history" class="<?php echo $active_tab == 'history' ? 'border-b-2 border-blue-500 text-blue-600' : 'text-gray-500 hover:text-gray-700 hover:border-gray-300'; ?> py-3 px-4 border-b-2 border-transparent font-medium text-base">
                    Panduan History peminjaman
                </a>
            </nav>
        </div>
        
        <?php if ($active_tab == 'peminjaman'): ?>
        <!-- Borrowing Guide Content -->
        <div class="space-y-6 md:space-y-8">
            <!-- Introduction -->
            <section>
                <h2 class="text-lg md:text-xl font-semibold text-blue-700 mb-2 md:mb-3">Perkenalan</h2>
                <p class="text-sm md:text-base text-gray-700 mb-3">
                    Selamat datang di panduan peminjaman Color Code. Dokumen ini akan membantu Anda memahami langkah-langkah 
                    yang diperlukan untuk meminjam panel warna dalam sistem kami.
                </p>
                <p class="text-sm md:text-base text-gray-700">
                    peminjaman Color Code adalah proses meminjam panel warna dari Color Room untuk keperluan pengujian, 
                    verifikasi, atau kebutuhan produksi lainnya. peminjaman harus disetujui oleh admin sebelum Anda dapat 
                    mengambil barang yang dipinjam.
                </p>
            </section>
            
            <!-- Overview of the Process -->
            <section>
                <h2 class="text-lg md:text-xl font-semibold text-blue-700 mb-2 md:mb-3">Ringkasan Proses peminjaman</h2>
                <div class="bg-blue-50 p-3 md:p-4 rounded-md">
                    <ol class="list-decimal list-inside space-y-1 md:space-y-2 text-sm md:text-base text-gray-800">
                        <li>Pilih <strong>Buyer</strong> dari daftar</li>
                        <li>Pilih <strong>collection_semarang</strong> yang tersedia untuk buyer tersebut</li>
                        <li>Pilih <strong>Color Code</strong> yang ingin dipinjam</li>
                        <li>Tentukan durasi peminjaman (tanggal mulai dan durasi)</li>
                        <li>Pilih <strong>Component</strong> yang ingin dipinjam dari daftar yang tersedia</li>
                        <li>Isi keterangan jika diperlukan</li>
                        <li>Ajukan peminjaman dengan mengklik tombol "Ajukan peminjaman"</li>
                        <li>Tunggu persetujuan dari admin</li>
                    </ol>
                </div>
            </section>
            
            <!-- Step-by-Step Guide -->
            <section>
                <h2 class="text-lg md:text-xl font-semibold text-blue-700 mb-2 md:mb-3">Panduan Langkah demi Langkah</h2>
                
                <!-- Step 1: Select Buyer -->
                <div class="mb-4 md:mb-6">
                    <h3 class="text-base md:text-lg font-medium text-gray-800 mb-2">Langkah 1: Memilih Buyer</h3>
                    <div class="bg-gray-50 p-3 md:p-4 rounded-md">
                        <ul class="list-disc list-outside pl-5 text-sm md:text-base text-gray-700 space-y-1">
                            <li>Pada halaman formulir peminjaman, Anda akan melihat dropdown untuk memilih "Buyer".</li>
                            <li>Pilih buyer sesuai dengan kebutuhan Anda dari daftar yang tersedia.</li>
                            <li>Buyer adalah perusahaan atau client yang terkait dengan collection_semarang dan color code.</li>
                        </ul>
                    </div>
                </div>
                
                <!-- Step 2: Select collection_semarang -->
                <div class="mb-4 md:mb-6">
                    <h3 class="text-base md:text-lg font-medium text-gray-800 mb-2">Langkah 2: Memilih collection_semarang</h3>
                    <div class="bg-gray-50 p-3 md:p-4 rounded-md">
                        <ul class="list-disc list-outside pl-5 text-sm md:text-base text-gray-700 space-y-1">
                            <li>Setelah memilih buyer, dropdown "collection_semarang" akan aktif dan menampilkan collection_semarang yang tersedia untuk buyer yang dipilih.</li>
                            <li>Pilih collection_semarang yang berisi color code yang ingin Anda pinjam.</li>
                            <li>collection_semarang mengelompokkan berbagai color code dalam satu proyek atau lini produk.</li>
                        </ul>
                    </div>
                </div>
                
                <!-- Step 3: Select Color Code -->
                <div class="mb-4 md:mb-6">
                    <h3 class="text-base md:text-lg font-medium text-gray-800 mb-2">Langkah 3: Memilih Color Code</h3>
                    <div class="bg-gray-50 p-3 md:p-4 rounded-md">
                        <ul class="list-disc list-outside pl-5 text-sm md:text-base text-gray-700 space-y-1">
                            <li>Setelah memilih collection_semarang, dropdown "Color Code" akan aktif dan menampilkan kode warna yang tersedia.</li>
                            <li>Pilih color code yang ingin Anda pinjam dari daftar yang tersedia.</li>
                            <li>Format color code biasanya [kode] - [deskripsi] untuk memudahkan Anda mengidentifikasi warna yang diinginkan.</li>
                        </ul>
                    </div>
                </div>
                
                <!-- Step 4: Set Borrowing Duration -->
                <div class="mb-4 md:mb-6">
                    <h3 class="text-base md:text-lg font-medium text-gray-800 mb-2">Langkah 4: Menentukan Durasi peminjaman</h3>
                    <div class="bg-gray-50 p-3 md:p-4 rounded-md">
                        <ul class="list-disc list-outside pl-5 text-sm md:text-base text-gray-700 space-y-1">
                            <li>Tentukan "Tanggal Transaksi" (tanggal mulai) peminjaman.</li>
                            <li>Masukkan "Durasi peminjaman" dalam satuan hari (default: 7 hari).</li>
                            <li>Sistem akan otomatis menghitung "Tanggal Pengembalian" berdasarkan tanggal mulai dan durasi.</li>
                            <li>Pastikan untuk mengembalikan item sebelum atau pada tanggal pengembalian untuk menghindari sanksi.</li>
                        </ul>
                    </div>
                </div>
                
                <!-- Step 5: Select Components -->
                <div class="mb-4 md:mb-6">
                    <h3 class="text-base md:text-lg font-medium text-gray-800 mb-2">Langkah 5: Memilih Component</h3>
                    <div class="bg-gray-50 p-3 md:p-4 rounded-md">
                        <ul class="list-disc list-outside pl-5 text-sm md:text-base text-gray-700 space-y-1">
                            <li>Setelah memilih color code, tabel "Components yang Tersedia" akan ditampilkan.</li>
                            <li>Centang kotak di sebelah component yang ingin Anda pinjam.</li>
                            <li>Perhatikan status component sebelum memilih:</li>
                            <ul class="list-disc list-outside pl-5 mt-1 mb-2 text-sm md:text-base text-gray-600 space-y-1">
                                <li><span class="font-medium text-gray-800">Tersedia</span>: Component siap untuk dipinjam.</li>
                                <li><span class="font-medium text-yellow-600">Dipinjam</span>: Component sedang dipinjam oleh borrower lain, tetapi Anda masih dapat meminjamnya jika diperlukan.</li>
                                <li><span class="font-medium text-red-600">Rusak</span>: Component dapat dipinjam, tetapi kualitasnya mungkin tidak optimal.</li>
                                <li><span class="font-medium text-gray-400">Expired/Renew</span>: Component tidak dapat dipinjam.</li>
                            </ul>
                            <li>Jika Anda memilih component dengan status "Dipinjam", sistem akan menampilkan informasi tentang borrower saat ini.</li>
                            <li>Jika Anda memilih component dengan status "Rusak", sistem akan menampilkan peringatan tentang kemungkinan kualitas yang tidak optimal.</li>
                        </ul>
                    </div>
                </div>
                
                <!-- Step 6: Add Notes -->
                <div class="mb-4 md:mb-6">
                    <h3 class="text-base md:text-lg font-medium text-gray-800 mb-2">Langkah 6: Menambahkan Keterangan</h3>
                    <div class="bg-gray-50 p-3 md:p-4 rounded-md">
                        <ul class="list-disc list-outside pl-5 text-sm md:text-base text-gray-700 space-y-1">
                            <li>Isi kolom "Keterangan" jika ada informasi tambahan yang perlu disampaikan kepada admin.</li>
                            <li>Keterangan ini akan membantu admin memahami tujuan atau kebutuhan spesifik dari peminjaman Anda.</li>
                        </ul>
                    </div>
                </div>
                
                <!-- Step 7: Check Borrowing Details & Submit Request -->
                <div class="mb-4 md:mb-6">
                    <h3 class="text-base md:text-lg font-medium text-gray-800 mb-2">Langkah 7: Memeriksa Detail peminjaman</h3>
                    <div class="bg-gray-50 p-3 md:p-4 rounded-md">
                        <ul class="list-disc list-outside pl-5 text-sm md:text-base text-gray-700 space-y-1">
                            <li>Setelah semua informasi terisi dan component yang diperlukan dipilih, klik tombol "Cek peminjaman".</li>
                            <li>Modal akan ditampilkan dengan ringkasan semua detail peminjaman Anda, termasuk daftar item, durasi, dan keterangan.</li>
                            <li>Periksa kembali semua informasi untuk memastikan keakuratan.</li>
                            <li>Jika ada yang perlu diubah, klik "Kembali" dan lakukan perubahan yang diperlukan.</li>
                            <li>Jika semua informasi sudah benar, klik "Ajukan peminjaman" untuk mengirimkan permintaan Anda.</li>
                        </ul>
                    </div>
                </div>
                
                <!-- Step 8: Wait for Approval -->
                <div>
                    <h3 class="text-base md:text-lg font-medium text-gray-800 mb-2">Langkah 8: Menunggu Persetujuan</h3>
                    <div class="bg-gray-50 p-3 md:p-4 rounded-md">
                        <ul class="list-disc list-outside pl-5 text-sm md:text-base text-gray-700 space-y-1">
                            <li>Setelah mengajukan peminjaman, status awal akan menjadi "Diajukan".</li>
                            <li>Admin akan meninjau permintaan Anda dan menyetujui atau menolaknya.</li>
                            <li>Anda dapat memeriksa status peminjaman di halaman "Cek History peminjaman".</li>
                            <li>Jika disetujui, Anda dapat mengambil component dari Color Room pada tanggal yang telah ditentukan.</li>
                        </ul>
                    </div>
                </div>
            </section>
            
            <!-- Important Notes -->
            <section>
                <h2 class="text-lg md:text-xl font-semibold text-blue-700 mb-2 md:mb-3">Catatan Penting</h2>
                <div class="bg-yellow-50 border-l-4 border-yellow-400 p-3 md:p-4">
                    <div class="flex flex-col md:flex-row">
                        <div class="flex-shrink-0 mb-2 md:mb-0 md:mr-3">
                            <svg class="h-5 w-5 text-yellow-400" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                                <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd" />
                            </svg>
                        </div>
                        <div>
                            <h3 class="text-base md:text-lg font-medium text-yellow-800 mb-2">Hal-hal yang perlu diperhatikan:</h3>
                            <ul class="list-disc list-outside pl-5 text-sm md:text-base text-yellow-700 space-y-1 md:space-y-2">
                                <li>Anda <strong>harus memilih minimal satu component</strong> untuk dapat mengajukan peminjaman.</li>
                                <li>Durasi peminjaman maksimal adalah <strong>30 hari</strong>. Untuk peminjaman lebih lama, hubungi admin.</li>
                                <li>Jika Anda memilih component yang sedang dipinjam, koordinasikan dengan borrower saat ini untuk menghindari konflik.</li>
                                <li>Pastikan untuk mengembalikan component tepat waktu untuk menghindari sanksi dan memungkinkan pengguna lain meminjam.</li>
                                <li>Jika component mengalami kerusakan selama peminjaman, segera laporkan kepada admin.</li>
                                <li>Anda hanya dapat mengajukan peminjaman baru jika akun Anda berstatus "active".</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </section>
            
            <!-- Contact Information -->
            <section>
                <h2 class="text-lg md:text-xl font-semibold text-blue-700 mb-2 md:mb-3">Informasi Kontak</h2>
                <div class="bg-gray-50 p-3 md:p-4 rounded-md">
                    <p class="text-sm md:text-base text-gray-700 mb-2">Jika Anda memiliki pertanyaan atau mengalami masalah, silakan hubungi:</p>
                    <ul class="text-sm md:text-base text-gray-700 space-y-1">
                        <li><span class="font-medium">Admin Color Room:</span> coloradmin@company.com</li>
                        <li><span class="font-medium">Telepon:</span> Ext. 123</li>
                    </ul>
                </div>
            </section>
            
            <!-- Call to Action -->
            <div class="mt-6 md:mt-8 flex justify-center">
                <a href="formulir_isi_peminjam.php" class="w-full md:w-auto inline-flex items-center justify-center px-4 md:px-6 py-2 md:py-3 border border-transparent text-sm md:text-base font-medium rounded-md text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 transition-colors duration-200">
                    Mulai peminjaman Sekarang
                </a>
            </div>
        </div>
        
        <?php else: ?>
        <!-- Borrowing History Guide Content -->
        <div class="space-y-6 md:space-y-8">
            <!-- Introduction -->
            <section>
                <h2 class="text-lg md:text-xl font-semibold text-blue-700 mb-2 md:mb-3">Perkenalan</h2>
                <p class="text-sm md:text-base text-gray-700 mb-3">
                    Selamat datang di panduan history peminjaman Color Code. Dokumen ini akan membantu Anda memahami cara 
                    memeriksa dan mengelola riwayat peminjaman Color Code Anda dalam sistem kami.
                </p>
                <p class="text-sm md:text-base text-gray-700">
                    Menu history peminjaman memungkinkan Anda memantau status semua permintaan peminjaman, melihat detail transaksi, 
                    dan mengelola peminjaman yang sedang berjalan. Anda juga dapat membatalkan permintaan peminjaman yang belum disetujui.
                </p>
            </section>
            
            <!-- Overview of the History Page -->
            <section>
                <h2 class="text-lg md:text-xl font-semibold text-blue-700 mb-2 md:mb-3">Ringkasan Halaman History peminjaman</h2>
                <div class="bg-blue-50 p-3 md:p-4 rounded-md">
                    <ol class="list-decimal list-outside pl-5 space-y-1 md:space-y-2 text-sm md:text-base text-gray-800">
                        <li>Lihat daftar semua transaksi peminjaman Anda</li>
                        <li>Periksa status setiap transaksi</li>
                        <li>Lihat detail lengkap transaksi tertentu</li>
                        <li>Batalkan permintaan yang belum disetujui</li>
                        <li>Pantau tanggal pengembalian</li>
                    </ol>
                </div>
            </section>
            
            <!-- Step-by-Step Guide -->
            <section>
                <h2 class="text-lg md:text-xl font-semibold text-blue-700 mb-2 md:mb-3">Panduan Langkah demi Langkah</h2>
                
                <!-- Step 1: Accessing the Borrowing History -->
                <div class="mb-4 md:mb-6">
                    <h3 class="text-base md:text-lg font-medium text-gray-800 mb-2">Langkah 1: Mengakses History peminjaman</h3>
                    <div class="bg-gray-50 p-3 md:p-4 rounded-md">
                        <ul class="list-disc list-outside pl-5 text-sm md:text-base text-gray-700 space-y-1">
                            <li>Pada menu navigasi, klik "Cek History peminjaman".</li>
                            <li>Halaman akan menampilkan daftar semua transaksi peminjaman Anda, diurutkan berdasarkan tanggal (terbaru di atas).</li>
                            <li>Setiap baris menampilkan ID transaksi, tanggal transaksi, color codes, total items, status, dan opsi aksi.</li>
                        </ul>
                    </div>
                </div>
                
                <!-- Step 2: Understanding Transaction Status -->
                <div class="mb-4 md:mb-6">
                    <h3 class="text-base md:text-lg font-medium text-gray-800 mb-2">Langkah 2: Memahami Status Transaksi</h3>
                    <div class="bg-gray-50 p-3 md:p-4 rounded-md">
                        <ul class="list-disc list-outside pl-5 text-sm md:text-base text-gray-700 space-y-1">
                            <li>Anda akan melihat status untuk setiap transaksi dengan kode warna yang berbeda:</li>
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-2 mt-2 mb-2">
                                <div class="flex items-center"><span class="inline-block px-2 py-1 rounded-full bg-yellow-100 text-yellow-800 text-xs font-semibold mr-2">Diajukan</span> Permintaan belum ditinjau admin</div>
                                <div class="flex items-center"><span class="inline-block px-2 py-1 rounded-full bg-blue-100 text-blue-800 text-xs font-semibold mr-2">OnProccesing</span> Sedang ditinjau admin</div>
                                <div class="flex items-center"><span class="inline-block px-2 py-1 rounded-full bg-green-100 text-green-800 text-xs font-semibold mr-2">Disetujui</span> Siap untuk diambil</div>
                                <div class="flex items-center"><span class="inline-block px-2 py-1 rounded-full bg-red-100 text-red-800 text-xs font-semibold mr-2">Ditolak</span> Permintaan ditolak</div>
                                <div class="flex items-center"><span class="inline-block px-2 py-1 rounded-full bg-purple-100 text-purple-800 text-xs font-semibold mr-2">Dipinjam</span> Sedang dipinjam</div>
                                <div class="flex items-center"><span class="inline-block px-2 py-1 rounded-full bg-purple-100 text-purple-800 text-xs font-semibold mr-2">Dikembalikan</span> Sudah dikembalikan</div>
                            </div>
                            <li>Transaksi yang telah selesai (dikembalikan) akan ditampilkan dengan garis tercoret untuk membedakannya dari transaksi aktif.</li>
                        </ul>
                    </div>
                </div>
                
                <!-- Step 3: Viewing Transaction Details -->
                <div class="mb-4 md:mb-6">
                    <h3 class="text-base md:text-lg font-medium text-gray-800 mb-2">Langkah 3: Melihat Detail Transaksi</h3>
                    <div class="bg-gray-50 p-3 md:p-4 rounded-md">
                        <ul class="list-disc list-outside pl-5 text-sm md:text-base text-gray-700 space-y-1">
                            <li>Untuk melihat detail lengkap dari suatu transaksi, klik tombol "Detail" pada baris transaksi tersebut.</li>
                            <li>Akan muncul modal yang menampilkan informasi rinci tentang transaksi, termasuk:</li>
                            <ul class="list-disc list-outside pl-5 mt-1 mb-2 text-sm md:text-base text-gray-600 space-y-1">
                                <li>Informasi umum transaksi (ID, status, tanggal)</li>
                                <li>Buyer dan collection_semarang yang terkait</li>
                                <li>Keterangan atau catatan tambahan</li>
                                <li>Daftar semua item yang dipinjam, dikelompokkan berdasarkan buyer dan collection_semarang</li>
                                <li>Status setiap item (dikembalikan atau belum)</li>
                                <li>Kondisi item saat dikembalikan (Baik, Rusak, atau Hilang)</li>
                            </ul>
                            <li>Setelah selesai melihat detail, klik di luar modal atau tombol tutup untuk kembali ke daftar transaksi.</li>
                        </ul>
                    </div>
                </div>
                
                <!-- Step 4: Cancelling a Pending Request -->
                <div class="mb-4 md:mb-6">
                    <h3 class="text-base md:text-lg font-medium text-gray-800 mb-2">Langkah 4: Membatalkan Permintaan peminjaman</h3>
                    <div class="bg-gray-50 p-3 md:p-4 rounded-md">
                        <ul class="list-disc list-outside pl-5 text-sm md:text-base text-gray-700 space-y-1">
                            <li>Anda hanya dapat membatalkan permintaan peminjaman dengan status "Diajukan".</li>
                            <li>Untuk membatalkan permintaan, klik tombol "Batalkan" pada baris transaksi tersebut.</li>
                            <li>Konfirmasi bahwa Anda ingin membatalkan permintaan tersebut.</li>
                            <li>Setelah dikonfirmasi, permintaan akan dihapus dari sistem dan tidak akan diproses lebih lanjut.</li>
                            <li>Notifikasi sukses akan muncul jika pembatalan berhasil.</li>
                        </ul>
                    </div>
                </div>
                
                <!-- Step 5: Monitoring Borrowing Status -->
                <div>
                    <h3 class="text-base md:text-lg font-medium text-gray-800 mb-2">Langkah 5: Memantau Status peminjaman</h3>
                    <div class="bg-gray-50 p-3 md:p-4 rounded-md">
                        <ul class="list-disc list-outside pl-5 text-sm md:text-base text-gray-700 space-y-1">
                            <li>Periksa history peminjaman secara berkala untuk memantau status permintaan Anda.</li>
                            <li>Perhatikan tanggal pengembalian untuk memastikan Anda mengembalikan item tepat waktu.</li>
                            <li>Jika permintaan ditolak, periksa detail transaksi untuk melihat catatan penolakan dari admin.</li>
                            <li>Jika status peminjaman sudah "Disetujui", Anda dapat mengambil item sesuai dengan tanggal transaksi yang ditentukan.</li>
                        </ul>
                    </div>
                </div>
            </section>
            
            <!-- Important Notes -->
            <section>
                <h2 class="text-lg md:text-xl font-semibold text-blue-700 mb-2 md:mb-3">Catatan Penting</h2>
                <div class="bg-yellow-50 border-l-4 border-yellow-400 p-3 md:p-4">
                    <div class="flex flex-col md:flex-row">
                        <div class="flex-shrink-0 mb-2 md:mb-0 md:mr-3">
                            <svg class="h-5 w-5 text-yellow-400" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                                <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd" />
                            </svg>
                        </div>
                        <div>
                            <h3 class="text-base md:text-lg font-medium text-yellow-800 mb-2">Hal-hal yang perlu diperhatikan:</h3>
                            <ul class="list-disc list-outside pl-5 text-sm md:text-base text-yellow-700 space-y-1 md:space-y-2">
                                <li>Permintaan dengan status "Diajukan" masih dapat dibatalkan, tetapi permintaan yang sudah diproses tidak dapat dibatalkan.</li>
                                <li>Jika status permintaan Anda tetap "Diajukan" setelah beberapa waktu, Anda dapat menghubungi admin untuk tindak lanjut.</li>
                                <li>Tanggal transaksi menunjukkan kapan peminjaman dimulai, dan tanggal pengembalian menunjukkan kapan item harus dikembalikan.</li>
                                <li>Jika item dikembalikan terlambat, Anda mungkin dikenakan sanksi sesuai dengan kebijakan Color Room.</li>
                                <li>Jika item rusak atau hilang saat peminjaman, segera laporkan kepada admin untuk menghindari masalah lebih lanjut.</li>
                                <li>Transaksi yang telah selesai (Disetujui dan Dikembalikan) tetap ditampilkan dalam history sebagai referensi, tetapi dibedakan dengan garis tercoret.</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </section>
            
            <!-- Call to Action -->
            <div class="mt-6 md:mt-8 flex justify-center">
                <a href="cek_history_peminjam.php" class="w-full md:w-auto inline-flex items-center justify-center px-4 md:px-6 py-2 md:py-3 border border-transparent text-sm md:text-base font-medium rounded-md text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 transition-colors duration-200">
                    Lihat History peminjaman
                </a>
            </div>
        </div>
        <?php endif; ?>
    </div>
</main>

<?php include '../template_peminjam/footer.php'; ?>