<?php
// Start session
session_start();

// Include database connection
require_once "../config/connection.php";

// Redirect if not borrower user - using functions from connection.php
if (!is_logged_in() || !is_user_type('borrower')) {
    header("Location: ../login.php");
    exit();
}

// Get borrower data
$borrower_id = $_SESSION['user_id'];

// Log activity
log_activity($conn, $borrower_id, 'borrower', 'Contact Access', 'borrower user accessed contact page');

// Get contact list from database
$it_contacts_query = "SELECT * FROM contact WHERE akses = 'it' ORDER BY nama";
$it_contacts_result = $conn->query($it_contacts_query);
$it_contacts = [];
while ($row = $it_contacts_result->fetch_assoc()) {
    $it_contacts[] = $row;
}

$admin_contacts_query = "SELECT * FROM contact WHERE akses = 'admin' ORDER BY nama";
$admin_contacts_result = $conn->query($admin_contacts_query);
$admin_contacts = [];
while ($row = $admin_contacts_result->fetch_assoc()) {
    $admin_contacts[] = $row;
}

// Fungsi untuk mengubah format nomor telepon untuk whatsapp
function formatWhatsAppNumber($phone) {
    // Hapus karakter '+' jika ada
    $phone = str_replace('+', '', $phone);
    // Jika diawali dengan '62', gunakan langsung
    // Jika diawali dengan '0', ganti dengan '62'
    if (substr($phone, 0, 1) === '0') {
        $phone = '62' . substr($phone, 1);
    }
    return $phone;
}

// Set page title
$page_title = "Kontak peminjaman Color Code";

// Include header
include '../template_peminjam/header.php';
?>

<!-- Main Content Area -->
<main class="flex-1 p-6 overflow-auto bg-gradient-to-br from-blue-100 via-teal-100 to-green-100">
    <div class="max-w-4xl mx-auto">
        <!-- Logo and Header -->
        <div class="text-center mb-10">
            <img src="../images/logo.png" alt="Color Room Logo" class="mx-auto mb-4 h-24">
            <h1 class="text-3xl font-bold text-gray-800 mb-2">Kontak peminjaman Color Code</h1>
            <p class="text-gray-600 text-lg">Hubungi kami untuk informasi lebih lanjut mengenai sistem peminjaman color panel</p>
        </div>
        
        <!-- Contact Information Cards -->
        <div class="grid grid-cols-1 md:grid-cols-2 gap-8 mb-10">
            <!-- IT Contact Card -->
            <div class="bg-white rounded-lg shadow-md overflow-hidden">
                <div class="bg-blue-600 px-6 py-4">
                    <h2 class="text-xl font-bold text-white flex items-center">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 mr-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 3v2m6-2v2M9 19v2m6-2v2M5 9H3m2 6H3m18-6h-2m2 6h-2M7 19h10a2 2 0 002-2V7a2 2 0 00-2-2H7a2 2 0 00-2 2v10a2 2 0 002 2zM9 9h6v6H9V9z" />
                        </svg>
                        Kontak Tim IT
                    </h2>
                    <p class="text-blue-100">Untuk bantuan teknis dan masalah sistem</p>
                </div>
                <div class="p-6">
                    <p class="text-gray-700 mb-4">
                        Hubungi tim IT untuk permasalahan teknis seperti:
                    </p>
                    <ul class="list-disc pl-5 text-gray-600 mb-6">
                        <li>Login gagal atau masalah akses sistem</li>
                        <li>Sistem error atau tidak berfungsi dengan baik</li>
                        <li>Permintaan fitur baru untuk sistem</li>
                        <li>Bantuan penggunaan aplikasi</li>
                        <li class="font-medium text-blue-600">Mengajukan pertanyaan seputar bug atau error pada sistem</li>
                    </ul>
                    
                    <div class="space-y-4">
                        <?php foreach ($it_contacts as $contact): ?>
                        <div class="flex items-center p-3 bg-blue-50 rounded-lg">
                            <div class="bg-blue-500 rounded-full p-2 mr-3">
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z" />
                                </svg>
                            </div>
                            <div>
                                <h3 class="font-medium text-gray-800"><?php echo htmlspecialchars($contact['nama']); ?></h3>
                                <a href="https://wa.me/<?php echo formatWhatsAppNumber($contact['nomor_phone']); ?>" class="text-blue-600 hover:underline flex items-center" target="_blank">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 mr-1" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z" />
                                    </svg>
                                    <?php echo htmlspecialchars($contact['nomor_phone']); ?>
                                    <span class="ml-1 text-xs bg-green-100 text-green-800 px-1 py-0.5 rounded">WhatsApp</span>
                                </a>
                            </div>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
            
            <!-- Admin Contact Card -->
            <div class="bg-white rounded-lg shadow-md overflow-hidden">
                <div class="bg-green-600 px-6 py-4">
                    <h2 class="text-xl font-bold text-white flex items-center">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 mr-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z" />
                        </svg>
                        Kontak Tim Admin
                    </h2>
                    <p class="text-green-100">Untuk bantuan proses peminjaman dan persetujuan</p>
                </div>
                <div class="p-6">
                    <p class="text-gray-700 mb-4">
                        Hubungi tim Admin untuk hal-hal berikut:
                    </p>
                    <ul class="list-disc pl-5 text-gray-600 mb-6">
                        <li>Informasi status peminjaman</li>
                        <li>Konfirmasi persetujuan peminjaman</li>
                        <li>Pengaturan jadwal pengembalian</li>
                        <li>Permasalahan terkait color panel dan komponennya</li>
                        <li class="font-medium text-green-600">Mengajukan pertanyaan kepada admin jika bingung dalam kinerja sistem</li>
                    </ul>
                    
                    <div class="space-y-4">
                        <?php foreach ($admin_contacts as $contact): ?>
                        <div class="flex items-center p-3 bg-green-50 rounded-lg">
                            <div class="bg-green-500 rounded-full p-2 mr-3">
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z" />
                                </svg>
                            </div>
                            <div>
                                <h3 class="font-medium text-gray-800"><?php echo htmlspecialchars($contact['nama']); ?></h3>
                                <a href="https://wa.me/<?php echo formatWhatsAppNumber($contact['nomor_phone']); ?>" class="text-green-600 hover:underline flex items-center" target="_blank">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 mr-1" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z" />
                                    </svg>
                                    <?php echo htmlspecialchars($contact['nomor_phone']); ?>
                                    <span class="ml-1 text-xs bg-green-100 text-green-800 px-1 py-0.5 rounded">WhatsApp</span>
                                </a>
                            </div>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Additional Information -->
        <div class="bg-white rounded-lg shadow-md p-6 mb-8">
            <h2 class="text-xl font-bold text-gray-800 mb-4 flex items-center">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 mr-2 text-purple-500" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                </svg>
                Informasi Penting
            </h2>
            
            <!-- Jam Operasional -->
            <div class="mb-6">
                <h3 class="font-semibold text-gray-700 mb-3">Jam Operasional:</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-x-6 gap-y-2">
                    <div class="flex justify-between border-b border-gray-200 pb-1">
                        <span class="text-gray-600">Senin</span>
                        <span class="font-medium text-gray-800">08.00 - 17.00</span>
                    </div>
                    <div class="flex justify-between border-b border-gray-200 pb-1">
                        <span class="text-gray-600">Selasa</span>
                        <span class="font-medium text-gray-800">08.00 - 17.00</span>
                    </div>
                    <div class="flex justify-between border-b border-gray-200 pb-1">
                        <span class="text-gray-600">Rabu</span>
                        <span class="font-medium text-gray-800">08.00 - 17.00</span>
                    </div>
                    <div class="flex justify-between border-b border-gray-200 pb-1">
                        <span class="text-gray-600">Kamis</span>
                        <span class="font-medium text-gray-800">08.00 - 17.00</span>
                    </div>
                    <div class="flex justify-between border-b border-gray-200 pb-1">
                        <span class="text-gray-600">Jumat</span>
                        <span class="font-medium text-gray-800">08.00 - 17.00</span>
                    </div>
                    <div class="flex justify-between border-b border-gray-200 pb-1">
                        <span class="text-gray-600">Sabtu</span>
                        <span class="font-medium text-gray-800">08.00 - 14.00</span>
                    </div>
                </div>
            </div>
            
            <div class="space-y-4 text-gray-700">
                <div class="flex items-start">
                    <div class="flex-shrink-0 mt-1">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-purple-500" viewBox="0 0 20 20" fill="currentColor">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                        </svg>
                    </div>
                    <p class="ml-3">Untuk permintaan peminjaman mendesak di luar jam kerja, silakan hubungi Admin melalui WhatsApp yang disediakan.</p>
                </div>
                
                <div class="flex items-start">
                    <div class="flex-shrink-0 mt-1">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-purple-500" viewBox="0 0 20 20" fill="currentColor">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                        </svg>
                    </div>
                    <p class="ml-3">Waktu persetujuan peminjaman biasanya 1-2 jam pada jam kerja sejak pengajuan peminjaman.</p>
                </div>
                
                <div class="flex items-start">
                    <div class="flex-shrink-0 mt-1">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-purple-500" viewBox="0 0 20 20" fill="currentColor">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                        </svg>
                    </div>
                    <p class="ml-3">Hubungi <strong class="text-green-600">Admin</strong> untuk mengajukan pertanyaan jika bingung dalam kinerja sistem.</p>
                </div>
                
                <div class="flex items-start">
                    <div class="flex-shrink-0 mt-1">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-purple-500" viewBox="0 0 20 20" fill="currentColor">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                        </svg>
                    </div>
                    <p class="ml-3">Hubungi <strong class="text-blue-600">IT</strong> untuk mengajukan pertanyaan seputar bug atau error pada sistem.</p>
                </div>
                
                <div class="flex items-start">
                    <div class="flex-shrink-0 mt-1">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-purple-500" viewBox="0 0 20 20" fill="currentColor">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                        </svg>
                    </div>
                    <p class="ml-3">Untuk pertanyaan tentang ketersediaan color code, mohon hubungi Admin terlebih dahulu.</p>
                </div>
            </div>
        </div>
    </div>
</main>

<?php include '../template_peminjam/footer.php'; ?>