<?php
require_once 'config/connection.php';

// Check if user is already logged in and redirect to appropriate dashboard
if (isLoggedIn()) {
    switch ($_SESSION['user_type']) {
        case 'superadmin':
            redirect('superadmin/dashboard.php');
            break;
        case 'admin':
            redirect('admin/dashboard.php');
            break;
        case 'borrower':
            redirect('borrower/dashboard.php');
            break;
        default:
            session_destroy();
            redirect('login.php');
    }
} else {
    // If not logged in, redirect to login
    redirect('login.php');
}
?>