<?php
require_once '../config/connection.php';
checkUserType(['borrower']);

// Get borrower stats
$borrower_id = $_SESSION['employee_id'];

// Count pending requests
$stmt = $pdo->prepare("SELECT COUNT(*) as pending FROM borrow_history WHERE borrower_employee_id = ? AND status = 'pending_approval'");
$stmt->execute([$borrower_id]);
$pending_count = $stmt->fetch()['pending'];

// Count active borrows
$stmt = $pdo->prepare("SELECT COUNT(*) as active FROM borrow_history WHERE borrower_employee_id = ? AND status = 'borrowed'");
$stmt->execute([$borrower_id]);
$active_count = $stmt->fetch()['active'];

// Count total history
$stmt = $pdo->prepare("SELECT COUNT(*) as total FROM borrow_history WHERE borrower_employee_id = ?");
$stmt->execute([$borrower_id]);
$total_count = $stmt->fetch()['total'];

// Count returned items
$stmt = $pdo->prepare("SELECT COUNT(*) as returned FROM borrow_history WHERE borrower_employee_id = ? AND status = 'returned'");
$stmt->execute([$borrower_id]);
$returned_count = $stmt->fetch()['returned'];

// Get recent history (last 5)
$stmt = $pdo->prepare("
    SELECT bh.*, a.asset_name, a.asset_number 
    FROM borrow_history bh 
    JOIN assets a ON bh.asset_id = a.id 
    WHERE bh.borrower_employee_id = ? 
    ORDER BY bh.created_at DESC 
    LIMIT 5
");
$stmt->execute([$borrower_id]);
$recent_history = $stmt->fetchAll();

// Get stats by organization
$borrower_org = getBorrowerOrganization($pdo, $borrower_id);
$stmt = $pdo->prepare("
    SELECT 
        COUNT(*) as total_org_borrows,
        COUNT(CASE WHEN status = 'borrowed' THEN 1 END) as active_org_borrows
    FROM borrow_history 
    WHERE organization = ?
");
$stmt->execute([$borrower_org]);
$org_stats = $stmt->fetch();

// Get available assets count
$stmt = $pdo->prepare("
    SELECT COUNT(*) as available_count
    FROM assets 
    WHERE status_borrower = 'available' AND kondisi IN ('baik', 'rusak')
");
$stmt->execute();
$available_count = $stmt->fetch()['available_count'];
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard Borrower - Peminjaman Tools Room</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        'leaf-green': '#90EE90',
                        'dark-leaf': '#32CD32',
                        'soft-gray': '#F5F5F5',
                        'medium-gray': '#9CA3AF'
                    }
                }
            }
        }
    </script>
</head>
<body class="bg-soft-gray min-h-screen">
    <!-- Header -->
    <header class="bg-white shadow-sm border-b-2 border-leaf-green">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between items-center py-4">
                <div class="flex items-center space-x-4">
                    <img src="../images/logo.png" alt="Logo" class="h-10 w-10" onerror="this.style.display='none'">
                    <div>
                        <h1 class="text-xl font-bold text-gray-800">Tools Room</h1>
                        <p class="text-sm text-medium-gray">Dashboard Borrower</p>
                    </div>
                </div>
                <div class="flex items-center space-x-4">
                    <div class="text-right">
                        <span class="text-sm text-gray-600">Halo, <?php echo $_SESSION['user_name']; ?></span>
                        <p class="text-xs text-medium-gray"><?php echo $borrower_org; ?></p>
                    </div>
                    <a href="../logout.php" class="bg-red-500 hover:bg-red-600 text-white px-4 py-2 rounded-lg text-sm transition duration-200">
                        Logout
                    </a>
                </div>
            </div>
        </div>
    </header>

    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
        <!-- Welcome Card -->
        <div class="bg-gradient-to-r from-leaf-green to-dark-leaf rounded-xl shadow-lg p-6 mb-8 text-white">
            <div class="flex justify-between items-center">
                <div>
                    <h2 class="text-2xl font-bold mb-2">Selamat Datang, <?php echo $_SESSION['user_name']; ?>!</h2>
                    <p class="opacity-90">Kelola peminjaman tools Anda dengan mudah</p>
                    <p class="text-sm opacity-75 mt-1">Waktu: <?php echo date('d F Y, H:i'); ?> WIB</p>
                </div>
                <div class="text-right">
                    <div class="text-2xl font-bold"><?php echo $available_count; ?></div>
                    <div class="text-sm opacity-90">Asset Tersedia</div>
                </div>
            </div>
        </div>

        <!-- Stats Cards -->
        <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-8">
            <!-- Pending Card -->
            <div class="bg-white rounded-xl shadow-lg p-6 cursor-pointer hover:shadow-xl transition duration-300 border-l-4 border-yellow-400" onclick="toggleDetails('pending')">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-medium-gray text-sm font-medium">Menunggu Persetujuan</p>
                        <p class="text-3xl font-bold text-yellow-600"><?php echo $pending_count; ?></p>
                    </div>
                    <div class="bg-yellow-100 p-3 rounded-full">
                        <svg class="w-6 h-6 text-yellow-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                    </div>
                </div>
            </div>

            <!-- Active Card -->
            <div class="bg-white rounded-xl shadow-lg p-6 cursor-pointer hover:shadow-xl transition duration-300 border-l-4 border-green-400" onclick="toggleDetails('active')">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-medium-gray text-sm font-medium">Sedang Dipinjam</p>
                        <p class="text-3xl font-bold text-green-600"><?php echo $active_count; ?></p>
                    </div>
                    <div class="bg-green-100 p-3 rounded-full">
                        <svg class="w-6 h-6 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                    </div>
                </div>
            </div>

            <!-- Returned Card -->
            <div class="bg-white rounded-xl shadow-lg p-6 cursor-pointer hover:shadow-xl transition duration-300 border-l-4 border-purple-400" onclick="toggleDetails('returned')">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-medium-gray text-sm font-medium">Dikembalikan</p>
                        <p class="text-3xl font-bold text-purple-600"><?php echo $returned_count; ?></p>
                    </div>
                    <div class="bg-purple-100 p-3 rounded-full">
                        <svg class="w-6 h-6 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h10a8 8 0 018 8v2M3 10l6 6m-6-6l6-6"></path>
                        </svg>
                    </div>
                </div>
            </div>

            <!-- Total Card -->
            <div class="bg-white rounded-xl shadow-lg p-6 cursor-pointer hover:shadow-xl transition duration-300 border-l-4 border-blue-400" onclick="toggleDetails('history')">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-medium-gray text-sm font-medium">Total Riwayat</p>
                        <p class="text-3xl font-bold text-blue-600"><?php echo $total_count; ?></p>
                    </div>
                    <div class="bg-blue-100 p-3 rounded-full">
                        <svg class="w-6 h-6 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"></path>
                        </svg>
                    </div>
                </div>
            </div>
        </div>

        <!-- Organization Stats -->
        <div class="bg-white rounded-xl shadow-lg p-6 mb-8">
            <h3 class="text-lg font-semibold text-gray-800 mb-4">Statistik Organisasi: <?php echo $borrower_org; ?></h3>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div class="text-center">
                    <div class="text-2xl font-bold text-blue-600"><?php echo $org_stats['total_org_borrows']; ?></div>
                    <div class="text-medium-gray">Total Peminjaman Organisasi</div>
                </div>
                <div class="text-center">
                    <div class="text-2xl font-bold text-green-600"><?php echo $org_stats['active_org_borrows']; ?></div>
                    <div class="text-medium-gray">Sedang Dipinjam Organisasi</div>
                </div>
            </div>
        </div>

        <!-- Quick Actions -->
        <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-8">
            <a href="borrow.php" class="bg-white rounded-xl shadow-lg p-6 hover:shadow-xl transition duration-300 block">
                <div class="flex items-center space-x-4">
                    <div class="bg-dark-leaf p-3 rounded-full">
                        <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"></path>
                        </svg>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-gray-800">Ajukan Peminjaman</h3>
                        <p class="text-medium-gray">Scan atau input manual asset</p>
                    </div>
                </div>
            </a>

            <a href="return.php" class="bg-white rounded-xl shadow-lg p-6 hover:shadow-xl transition duration-300 block">
                <div class="flex items-center space-x-4">
                    <div class="bg-purple-500 p-3 rounded-full">
                        <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h10a8 8 0 018 8v2M3 10l6 6m-6-6l6-6"></path>
                        </svg>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-gray-800">Pengembalian Asset</h3>
                        <p class="text-medium-gray">Foto dan kembalikan asset</p>
                    </div>
                </div>
            </a>

            <a href="history.php" class="bg-white rounded-xl shadow-lg p-6 hover:shadow-xl transition duration-300 block">
                <div class="flex items-center space-x-4">
                    <div class="bg-blue-500 p-3 rounded-full">
                        <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-gray-800">Riwayat Peminjaman</h3>
                        <p class="text-medium-gray">Lihat semua riwayat lengkap</p>
                    </div>
                </div>
            </a>
        </div>

        <!-- Details Sections (Hidden by default) -->
        <div id="details-section" class="hidden mb-8">
            <div class="bg-white rounded-xl shadow-lg p-6">
                <div class="flex justify-between items-center mb-4">
                    <h3 id="details-title" class="text-lg font-semibold text-gray-800"></h3>
                    <button onclick="document.getElementById('details-section').classList.add('hidden')" 
                            class="text-gray-400 hover:text-gray-600">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                        </svg>
                    </button>
                </div>
                <div id="details-content"></div>
            </div>
        </div>

        <!-- Recent Activity -->
        <?php if ($recent_history): ?>
        <div class="bg-white rounded-xl shadow-lg p-6">
            <h3 class="text-lg font-semibold text-gray-800 mb-4">Aktivitas Terbaru</h3>
            <div class="space-y-4">
                <?php foreach ($recent_history as $history): ?>
                <div class="flex items-center justify-between p-4 bg-soft-gray rounded-lg">
                    <div class="flex items-center space-x-3">
                        <div class="w-2 h-2 rounded-full <?php 
                            echo $history['status'] == 'pending_approval' ? 'bg-yellow-400' : 
                                ($history['status'] == 'borrowed' ? 'bg-green-400' : 
                                ($history['status'] == 'returned' ? 'bg-purple-400' : 'bg-gray-400')); 
                        ?>"></div>
                        <div>
                            <p class="font-medium text-gray-800"><?php echo $history['asset_name']; ?></p>
                            <p class="text-sm text-medium-gray"><?php echo $history['asset_number']; ?></p>
                            <?php if ($history['mesin']): ?>
                            <p class="text-xs text-medium-gray">Mesin: <?php echo $history['mesin']; ?></p>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="text-right">
                        <p class="text-sm font-medium <?php 
                            echo $history['status'] == 'pending_approval' ? 'text-yellow-600' : 
                                ($history['status'] == 'borrowed' ? 'text-green-600' : 
                                ($history['status'] == 'returned' ? 'text-purple-600' : 'text-gray-600')); 
                        ?>">
                            <?php 
                            echo $history['status'] == 'pending_approval' ? 'Menunggu' : 
                                ($history['status'] == 'borrowed' ? 'Dipinjam' : 
                                ($history['status'] == 'returned' ? 'Dikembalikan' : 'Lainnya')); 
                            ?>
                        </p>
                        <p class="text-xs text-medium-gray">
                            <?php 
                            if ($history['status'] == 'returned' && $history['tanggal_kembali']) {
                                echo 'Kembali: ' . date('d/m/Y H:i', strtotime($history['tanggal_kembali']));
                            } elseif ($history['tanggal_peminjam']) {
                                echo 'Pinjam: ' . date('d/m/Y H:i', strtotime($history['tanggal_peminjam']));
                            } else {
                                echo 'Dibuat: ' . date('d/m/Y H:i', strtotime($history['created_at']));
                            }
                            ?>
                        </p>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
            
            <div class="mt-4 text-center">
                <a href="history.php" class="text-blue-600 hover:text-blue-800 text-sm font-medium">
                    Lihat Semua Riwayat →
                </a>
            </div>
        </div>
        <?php endif; ?>
    </div>

    <script>
        function toggleDetails(type) {
            const detailsSection = document.getElementById('details-section');
            const detailsTitle = document.getElementById('details-title');
            const detailsContent = document.getElementById('details-content');
            
            // Show details section
            detailsSection.classList.remove('hidden');
            
            // Set title and load content based on type
            switch(type) {
                case 'pending':
                    detailsTitle.textContent = 'Peminjaman Menunggu Persetujuan';
                    loadDetails('pending_approval');
                    break;
                case 'active':
                    detailsTitle.textContent = 'Peminjaman Aktif';
                    loadDetails('borrowed');
                    break;
                case 'returned':
                    detailsTitle.textContent = 'Asset yang Dikembalikan';
                    loadDetails('returned');
                    break;
                case 'history':
                    detailsTitle.textContent = 'Semua Riwayat Peminjaman';
                    loadDetails('all');
                    break;
            }
            
            // Scroll to details
            detailsSection.scrollIntoView({ behavior: 'smooth' });
        }
        
        function loadDetails(status) {
            const detailsContent = document.getElementById('details-content');
            detailsContent.innerHTML = '<div class="text-center py-4"><div class="animate-spin rounded-full h-8 w-8 border-b-2 border-dark-leaf mx-auto"></div></div>';
            
            // In a real implementation, this would fetch data via AJAX
            // For now, we'll show a placeholder message
            setTimeout(() => {
                let content = `
                    <div class="overflow-x-auto">
                        <table class="min-w-full">
                            <thead>
                                <tr class="bg-gray-50">
                                    <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Asset</th>
                                    <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Mesin</th>
                                    <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Tanggal Pinjam</th>
                                    <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                `;
                
                if (status === 'returned' || status === 'all') {
                    content += '<th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Tanggal Kembali</th>';
                    content += '<th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Kondisi</th>';
                }
                
                if (status === 'borrowed') {
                    content += '<th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Aksi</th>';
                }
                
                content += `
                                </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200">
                                <tr>
                                    <td colspan="7" class="px-4 py-8 text-center text-gray-500">
                                        <div class="space-y-2">
                                            <p>Detail data akan dimuat melalui AJAX</p>
                                            <p class="text-sm">Status filter: <span class="font-medium">${status}</span></p>
                                            <p class="text-xs text-gray-400">Implementasi lengkap memerlukan endpoint AJAX tambahan</p>
                                        </div>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                `;
                
                if (status === 'borrowed') {
                    content += `
                        <div class="mt-6 p-4 bg-blue-50 rounded-lg">
                            <h4 class="font-medium text-blue-800 mb-2">Quick Actions</h4>
                            <div class="space-x-3">
                                <a href="return.php" class="inline-flex items-center px-4 py-2 bg-purple-500 text-white rounded-lg hover:bg-purple-600 transition duration-200">
                                    <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h10a8 8 0 018 8v2M3 10l6 6m-6-6l6-6"></path>
                                    </svg>
                                    Ke Halaman Pengembalian
                                </a>
                            </div>
                        </div>
                    `;
                }
                
                if (status === 'pending_approval') {
                    content += `
                        <div class="mt-6 p-4 bg-yellow-50 rounded-lg">
                            <h4 class="font-medium text-yellow-800 mb-2">Informasi</h4>
                            <p class="text-sm text-yellow-700">Peminjaman yang menunggu persetujuan admin. Anda akan mendapat notifikasi setelah disetujui.</p>
                        </div>
                    `;
                }
                
                detailsContent.innerHTML = content;
            }, 1000);
        }

        // Auto-refresh stats every 30 seconds (optional)
        setInterval(() => {
            // In a real app, you could refresh the stats via AJAX
            console.log('Stats could be refreshed here');
        }, 30000);

        // Show notification if there are pending items
        <?php if ($pending_count > 0): ?>
        document.addEventListener('DOMContentLoaded', function() {
            // You could show a notification here
            console.log('You have <?php echo $pending_count; ?> pending requests');
        });
        <?php endif; ?>
    </script>
</body>
</html>