<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo $__env->yieldContent('title', 'Cost Furniture - KMI'); ?></title>
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Poppins', sans-serif;
            background: #f4f6f9;
        }
        
        .sidebar {
            width: 260px;
            height: 100vh;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            position: fixed;
            left: 0;
            top: 0;
            overflow-y: auto;
            box-shadow: 4px 0 10px rgba(0,0,0,0.1);
            transition: all 0.3s ease;
            z-index: 1000;
        }
        
        .sidebar-header {
            padding: 25px 20px;
            text-align: center;
            border-bottom: 1px solid rgba(255,255,255,0.1);
            background: rgba(0,0,0,0.1);
        }
        
        .sidebar-header h3 {
            color: #fff;
            font-size: 22px;
            font-weight: 700;
            margin: 0;
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        
        .sidebar-header p {
            color: rgba(255,255,255,0.8);
            font-size: 12px;
            margin: 5px 0 0 0;
        }
        
        .sidebar-menu {
            padding: 20px 0;
        }
        
        .menu-title {
            color: rgba(255,255,255,0.6);
            font-size: 11px;
            font-weight: 600;
            text-transform: uppercase;
            padding: 10px 20px 5px;
            letter-spacing: 1px;
        }
        
        .menu-item {
            position: relative;
        }
        
        .menu-item a {
            display: flex;
            align-items: center;
            padding: 12px 20px;
            color: rgba(255,255,255,0.9);
            text-decoration: none;
            transition: all 0.3s ease;
            font-size: 14px;
            font-weight: 500;
        }
        
        .menu-item a i {
            width: 25px;
            margin-right: 12px;
            font-size: 16px;
        }
        
        .menu-item a:hover,
        .menu-item a.active {
            background: rgba(255,255,255,0.1);
            border-left: 4px solid #fff;
            padding-left: 16px;
        }
        
        .submenu {
            display: none;
            background: rgba(0,0,0,0.1);
        }
        
        .submenu.show {
            display: block;
        }
        
        .submenu a {
            padding-left: 57px;
            font-size: 13px;
        }
        
        .menu-item .dropdown-toggle::after {
            content: '\f107';
            font-family: 'Font Awesome 6 Free';
            font-weight: 900;
            position: absolute;
            right: 20px;
            transition: transform 0.3s ease;
        }
        
        .menu-item .dropdown-toggle.active::after {
            transform: rotate(180deg);
        }
        
        .coming-soon-badge {
            background: #ff6b6b;
            color: #fff;
            font-size: 9px;
            padding: 2px 6px;
            border-radius: 3px;
            margin-left: 8px;
            font-weight: 600;
        }
        
        .ready-badge {
            background: #51cf66;
            color: #fff;
            font-size: 9px;
            padding: 2px 6px;
            border-radius: 3px;
            margin-left: 8px;
            font-weight: 600;
        }
        
        .main-content {
            margin-left: 260px;
            padding: 0;
            min-height: 100vh;
            transition: all 0.3s ease;
        }
        
        .top-navbar {
            background: #fff;
            padding: 15px 30px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
            display: flex;
            justify-content: space-between;
            align-items: center;
            position: sticky;
            top: 0;
            z-index: 999;
        }
        
        .navbar-user {
            display: flex;
            align-items: center;
            gap: 15px;
        }
        
        .user-info {
            text-align: right;
        }
        
        .user-info .name {
            font-weight: 600;
            color: #2c3e50;
            font-size: 14px;
        }
        
        .user-info .role {
            font-size: 12px;
            color: #7f8c8d;
        }
        
        .user-avatar {
            width: 45px;
            height: 45px;
            border-radius: 50%;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            display: flex;
            align-items: center;
            justify-content: center;
            color: #fff;
            font-weight: 600;
            font-size: 16px;
        }
        
        .content-wrapper {
            padding: 30px;
        }
        
        .page-title {
            font-size: 28px;
            font-weight: 700;
            color: #2c3e50;
            margin-bottom: 25px;
        }
        
        /* Alert Styles */
        .alert {
            border: none;
            border-radius: 8px;
            padding: 15px 20px;
            margin-bottom: 20px;
            font-size: 14px;
        }
        
        .alert-success {
            background: #d4edda;
            color: #155724;
        }
        
        .alert-danger {
            background: #f8d7da;
            color: #721c24;
        }
        
        /* Scrollbar Styling */
        .sidebar::-webkit-scrollbar {
            width: 6px;
        }
        
        .sidebar::-webkit-scrollbar-track {
            background: rgba(0,0,0,0.1);
        }
        
        .sidebar::-webkit-scrollbar-thumb {
            background: rgba(255,255,255,0.3);
            border-radius: 10px;
        }
        
        .sidebar::-webkit-scrollbar-thumb:hover {
            background: rgba(255,255,255,0.5);
        }
        
        /* Mobile Responsive */
        @media (max-width: 768px) {
            .sidebar {
                margin-left: -260px;
            }
            
            .sidebar.active {
                margin-left: 0;
            }
            
            .main-content {
                margin-left: 0;
            }
        }
    </style>
    
    <?php echo $__env->yieldPushContent('styles'); ?>
</head>
<body>
    <?php if(auth()->guard()->check()): ?>
    <!-- Sidebar -->
    <div class="sidebar" id="sidebar">
        <div class="sidebar-header">
            <h3><i class="fas fa-couch"></i> COST FURNITURE</h3>
            <p>KMI Management System</p>
        </div>
        
        <div class="sidebar-menu">
            <!-- Menu Utama: Home -->
            <div class="menu-title">MAIN MENU</div>
            <div class="menu-item">
                <a href="<?php echo e(route('dashboard')); ?>" class="<?php echo e(request()->routeIs('dashboard') ? 'active' : ''); ?>">
                    <i class="fas fa-home"></i>
                    <span>Home</span>
                </a>
            </div>
            
            <!-- Menu Utama: Buat Invoice -->
<div class="menu-title">INVOICE</div>
<div class="menu-item">
    <a href="#" class="dropdown-toggle" onclick="toggleSubmenu(event, 'invoice-submenu')">
        <i class="fas fa-file-invoice"></i>
        <span>Buat Invoice</span>
    </a>
    <div class="submenu" id="invoice-submenu">
        <a href="#">
            <span>Invoice HPP</span>
            <span class="coming-soon-badge">SOON</span>
        </a>
        <a href="<?php echo e(route('invoice.bom.index')); ?>" class="<?php echo e(request()->routeIs('invoice.bom.*') ? 'active' : ''); ?>">
            <span>Invoice BOM</span>
            <span class="ready-badge">READY</span>
        </a>
        <a href="<?php echo e(route('invoice.hardware.index')); ?>" class="<?php echo e(request()->routeIs('invoice.hardware.*') ? 'active' : ''); ?>">
            <span>Invoice Hardware</span>
            <span class="ready-badge">READY</span>
        </a>
        <a href="<?php echo e(route('invoice.fitting.index')); ?>" class="<?php echo e(request()->routeIs('invoice.fitting.*') ? 'active' : ''); ?>">
            <span>Invoice Fitting</span>
            <span class="ready-badge">READY</span>
        </a>
        <a href="<?php echo e(route('invoice.handle.index')); ?>" class="<?php echo e(request()->routeIs('invoice.handle.*') ? 'active' : ''); ?>">
            <span>Invoice Handle</span>
            <span class="ready-badge">READY</span>
        </a>
        <a href="<?php echo e(route('invoice.stone.index')); ?>" class="<?php echo e(request()->routeIs('invoice.stone.*') ? 'active' : ''); ?>">
            <span>Invoice Stone</span>
            <span class="ready-badge">READY</span>
        </a>
        <a href="<?php echo e(route('invoice.metal.index')); ?>" class="<?php echo e(request()->routeIs('invoice.metal.*') ? 'active' : ''); ?>">
            <span>Invoice Metal</span>
            <span class="ready-badge">READY</span>
        </a>
        <a href="<?php echo e(route('invoice.ukir.index')); ?>" class="<?php echo e(request()->routeIs('invoice.ukir.*') ? 'active' : ''); ?>">
            <span>Invoice Ukir/Bubut</span>
            <span class="ready-badge">READY</span>
        </a>
        <a href="<?php echo e(route('invoice.box.index')); ?>" class="<?php echo e(request()->routeIs('invoice.box.*') ? 'active' : ''); ?>">
            <span>Invoice Box</span>
            <span class="ready-badge">READY</span>
        </a>
    </div>
</div>
            
            <!-- Menu Utama: Product -->
<div class="menu-title">PRODUCT MANAGEMENT</div>
<div class="menu-item">
    <a href="#" class="dropdown-toggle" onclick="toggleSubmenu(event, 'product-submenu')">
        <i class="fas fa-box"></i>
        <span>Product</span>
    </a>
    <div class="submenu" id="product-submenu">
        <a href="<?php echo e(route('product.panel.index')); ?>" class="<?php echo e(request()->routeIs('product.panel.*') ? 'active' : ''); ?>">
            <span>Product Panel</span>
            <span class="ready-badge">READY</span>
        </a>
        <a href="<?php echo e(route('product.solid.index')); ?>" class="<?php echo e(request()->routeIs('product.solid.*') ? 'active' : ''); ?>">
            <span>Product Solid</span>
            <span class="ready-badge">READY</span>
        </a>
        <a href="<?php echo e(route('product.veneer.index')); ?>" class="<?php echo e(request()->routeIs('product.veneer.*') ? 'active' : ''); ?>">
            <span>Product Veneer</span>
            <span class="ready-badge">READY</span>
        </a>
        <a href="<?php echo e(route('product.drawer.index')); ?>" class="<?php echo e(request()->routeIs('product.drawer.*') ? 'active' : ''); ?>">
            <span>Product Drawer</span>
            <span class="ready-badge">READY</span>
        </a>
        <a href="<?php echo e(route('material.solid.index')); ?>" class="<?php echo e(request()->routeIs('material.solid.*') ? 'active' : ''); ?>">
            <span>Material Solid</span>
            <span class="ready-badge">READY</span>
        </a>
        <a href="<?php echo e(route('product.pendukung-box.index')); ?>" class="<?php echo e(request()->routeIs('product.pendukung-box.*') ? 'active' : ''); ?>">
            <span>Product Pendukung Box</span>
            <span class="ready-badge">READY</span>
        </a>
        <a href="#">
            <span>Hardware</span>
            <span class="coming-soon-badge">SOON</span>
        </a>
        <a href="#">
            <span>Fitting</span>
            <span class="coming-soon-badge">SOON</span>
        </a>
        <a href="#">
            <span>Stone</span>
            <span class="coming-soon-badge">SOON</span>
        </a>
    </div>
</div>
            
            <!-- Menu Utama: Logout -->
            <div class="menu-title">ACCOUNT</div>
            <div class="menu-item">
                <a href="#" onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                    <i class="fas fa-sign-out-alt"></i>
                    <span>Logout</span>
                </a>
                <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" style="display: none;">
                    <?php echo csrf_field(); ?>
                </form>
            </div>
        </div>
    </div>
    
    <!-- Main Content -->
    <div class="main-content">
        <!-- Top Navbar -->
        <div class="top-navbar">
            <div>
                <h5 style="margin: 0; color: #2c3e50; font-weight: 600;"><?php echo $__env->yieldContent('page-title', 'Dashboard'); ?></h5>
            </div>
            <div class="navbar-user">
                <div class="user-info">
                    <div class="name"><?php echo e(Auth::user()->name); ?></div>
                    <div class="role">Administrator</div>
                </div>
                <div class="user-avatar">
                    <?php echo e(strtoupper(substr(Auth::user()->name, 0, 1))); ?>

                </div>
            </div>
        </div>
        
        <!-- Content Wrapper -->
        <div class="content-wrapper">
            <!-- Alerts -->
            <?php if(session('success')): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <i class="fas fa-check-circle"></i> <?php echo e(session('success')); ?>

                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
            <?php endif; ?>
            
            <?php if(session('error')): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <i class="fas fa-exclamation-circle"></i> <?php echo e(session('error')); ?>

                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
            <?php endif; ?>
            
            <?php if($errors->any()): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <i class="fas fa-exclamation-triangle"></i>
                <ul style="margin: 10px 0 0 0; padding-left: 20px;">
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
            <?php endif; ?>
            
            <!-- Page Content -->
            <?php echo $__env->yieldContent('content'); ?>
        </div>
    </div>
    <?php endif; ?>
    
    <?php if(auth()->guard()->guest()): ?>
    <?php echo $__env->yieldContent('content'); ?>
    <?php endif; ?>
    
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <script>
        function toggleSubmenu(event, submenuId) {
            event.preventDefault();
            const submenu = document.getElementById(submenuId);
            const toggle = event.currentTarget;
            
            submenu.classList.toggle('show');
            toggle.classList.toggle('active');
        }
        
        // Auto hide alerts after 5 seconds
        setTimeout(() => {
            const alerts = document.querySelectorAll('.alert');
            alerts.forEach(alert => {
                const bsAlert = new bootstrap.Alert(alert);
                bsAlert.close();
            });
        }, 5000);
    </script>
    
    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html><?php /**PATH C:\xampp\htdocs\Cost_Furniture\resources\views/layouts/app.blade.php ENDPATH**/ ?>