@extends('layouts.app')

@section('title', 'Product Veneer - Cost Furniture')

@section('page-title', 'Product Veneer')

@section('content')
<div class="card modern-card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5><i class="fas fa-paint-brush"></i> Data Product Veneer</h5>
        <a href="{{ route('product.veneer.create') }}" class="btn btn-primary">
            <i class="fas fa-plus"></i> Tambah Veneer
        </a>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover" id="veneerTable">
                <thead>
                    <tr>
                        <th width="5%">No</th>
                        <th>Veneer Type</th>
                        <th>Thickness (mm)</th>
                        <th>Price Lurus (per M2)</th>
                        <th>Price Motif (per M2)</th>
                        <th width="15%">Action</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($veneers as $index => $veneer)
                    <tr>
                        <td>{{ $index + 1 }}</td>
                        <td>
                            <span class="badge bg-success">{{ $veneer->veneer_type }}</span>
                        </td>
                        <td>{{ number_format($veneer->thickness, 2) }} mm</td>
                        <td><strong class="text-success">{{ \App\Helpers\CasegoodHelper::formatRupiah($veneer->price_lurus) }}</strong></td>
                        <td><strong class="text-primary">{{ \App\Helpers\CasegoodHelper::formatRupiah($veneer->price_motif) }}</strong></td>
                        <td>
                            <a href="{{ route('product.veneer.edit', $veneer->id) }}" class="btn btn-sm btn-warning">
                                <i class="fas fa-edit"></i> Edit
                            </a>
                            <form action="{{ route('product.veneer.destroy', $veneer->id) }}" method="POST" class="d-inline" onsubmit="return confirm('Yakin ingin menghapus data ini?')">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-sm btn-danger">
                                    <i class="fas fa-trash"></i> Hapus
                                </button>
                            </form>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="6" class="text-center py-4">
                            <i class="fas fa-inbox fa-3x text-muted mb-3"></i>
                            <p class="text-muted">Belum ada data veneer</p>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>

<style>
.modern-card {
    border: none;
    border-radius: 15px;
    box-shadow: 0 5px 20px rgba(0,0,0,0.05);
}

.modern-card .card-header {
    background: #fff;
    border-bottom: 2px solid #f0f0f0;
    padding: 20px 25px;
    border-radius: 15px 15px 0 0;
}

.modern-card .card-header h5 {
    margin: 0;
    font-weight: 700;
    color: #2c3e50;
}

.modern-card .card-body {
    padding: 25px;
}

.table thead th {
    background: #f8f9fa;
    font-weight: 600;
    color: #2c3e50;
    border: none;
    padding: 15px;
}

.table tbody tr {
    transition: all 0.2s ease;
}

.table tbody tr:hover {
    background: #f8f9fa;
}

.table tbody td {
    padding: 15px;
    vertical-align: middle;
}

.btn-sm {
    padding: 5px 12px;
    font-size: 12px;
}
</style>
@endsection