@extends('layouts.app')

@section('title', ($veneer ? 'Edit' : 'Tambah') . ' Product Veneer - Cost Furniture')

@section('page-title', ($veneer ? 'Edit' : 'Tambah') . ' Product Veneer')

@section('content')
<div class="row justify-content-center">
    <div class="col-md-8">
        <div class="card modern-card">
            <div class="card-header">
                <h5>
                    <i class="fas fa-{{ $veneer ? 'edit' : 'plus-circle' }}"></i> 
                    {{ $veneer ? 'Edit' : 'Tambah' }} Product Veneer
                </h5>
            </div>
            <div class="card-body">
                <form action="{{ $veneer ? route('product.veneer.update', $veneer->id) : route('product.veneer.store') }}" method="POST">
                    @csrf
                    @if($veneer)
                        @method('PUT')
                    @endif
                    
                    <div class="mb-3">
                        <label class="form-label">Veneer Type <span class="text-danger">*</span></label>
                        <select name="veneer_type" class="form-select @error('veneer_type') is-invalid @enderror" required>
                            <option value="">-- Pilih Veneer Type --</option>
                            <option value="MAHONI" {{ old('veneer_type', $veneer->veneer_type ?? '') == 'MAHONI' ? 'selected' : '' }}>MAHONI</option>
                            <option value="WHITE BEECH" {{ old('veneer_type', $veneer->veneer_type ?? '') == 'WHITE BEECH' ? 'selected' : '' }}>WHITE BEECH</option>
                            <option value="MAPLE" {{ old('veneer_type', $veneer->veneer_type ?? '') == 'MAPLE' ? 'selected' : '' }}>MAPLE</option>
                            <option value="WHITE ASH" {{ old('veneer_type', $veneer->veneer_type ?? '') == 'WHITE ASH' ? 'selected' : '' }}>WHITE ASH</option>
                            <option value="WHITE OAK" {{ old('veneer_type', $veneer->veneer_type ?? '') == 'WHITE OAK' ? 'selected' : '' }}>WHITE OAK</option>
                            <option value="MAPLE BURL" {{ old('veneer_type', $veneer->veneer_type ?? '') == 'MAPLE BURL' ? 'selected' : '' }}>MAPLE BURL</option>
                            <option value="WALNUT" {{ old('veneer_type', $veneer->veneer_type ?? '') == 'WALNUT' ? 'selected' : '' }}>WALNUT</option>
                            <option value="JATI" {{ old('veneer_type', $veneer->veneer_type ?? '') == 'JATI' ? 'selected' : '' }}>JATI</option>
                            <option value="WHITE ASH BURL" {{ old('veneer_type', $veneer->veneer_type ?? '') == 'WHITE ASH BURL' ? 'selected' : '' }}>WHITE ASH BURL</option>
                            <option value="OLIVE ASH BURL" {{ old('veneer_type', $veneer->veneer_type ?? '') == 'OLIVE ASH BURL' ? 'selected' : '' }}>OLIVE ASH BURL</option>
                            <option value="OAK BURL" {{ old('veneer_type', $veneer->veneer_type ?? '') == 'OAK BURL' ? 'selected' : '' }}>OAK BURL</option>
                            <option value="WALNUT BURL" {{ old('veneer_type', $veneer->veneer_type ?? '') == 'WALNUT BURL' ? 'selected' : '' }}>WALNUT BURL</option>
                            <option value="KHAYA CROTCH" {{ old('veneer_type', $veneer->veneer_type ?? '') == 'KHAYA CROTCH' ? 'selected' : '' }}>KHAYA CROTCH</option>
                        </select>
                        @error('veneer_type')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Thickness (mm) <span class="text-danger">*</span></label>
                        <input type="number" 
                               name="thickness" 
                               class="form-control @error('thickness') is-invalid @enderror" 
                               value="{{ old('thickness', $veneer->thickness ?? '0.5') }}"
                               step="0.01"
                               placeholder="Contoh: 0.5"
                               required>
                        @error('thickness')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Price Lurus (per M2) <span class="text-danger">*</span></label>
                        <input type="number" 
                               name="price_lurus" 
                               class="form-control @error('price_lurus') is-invalid @enderror" 
                               value="{{ old('price_lurus', $veneer->price_lurus ?? '') }}"
                               step="0.01"
                               placeholder="Contoh: 61000"
                               required>
                        @error('price_lurus')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <small class="text-muted">Harga lurus dalam Rupiah per meter persegi</small>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Price Motif (per M2) <span class="text-danger">*</span></label>
                        <input type="number" 
                               name="price_motif" 
                               class="form-control @error('price_motif') is-invalid @enderror" 
                               value="{{ old('price_motif', $veneer->price_motif ?? '') }}"
                               step="0.01"
                               placeholder="Contoh: 149000"
                               required>
                        @error('price_motif')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <small class="text-muted">Harga motif dalam Rupiah per meter persegi</small>
                    </div>
                    
                    <div class="d-flex gap-2">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save"></i> {{ $veneer ? 'Update' : 'Simpan' }}
                        </button>
                        <a href="{{ route('product.veneer.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Kembali
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<style>
.modern-card {
    border: none;
    border-radius: 15px;
    box-shadow: 0 5px 20px rgba(0,0,0,0.05);
}

.modern-card .card-header {
    background: #fff;
    border-bottom: 2px solid #f0f0f0;
    padding: 20px 25px;
    border-radius: 15px 15px 0 0;
}

.modern-card .card-header h5 {
    margin: 0;
    font-weight: 700;
    color: #2c3e50;
}

.modern-card .card-body {
    padding: 25px;
}

.form-label {
    font-weight: 600;
    color: #2c3e50;
    margin-bottom: 8px;
    font-size: 14px;
}

.form-control, .form-select {
    padding: 12px 15px;
    border: 2px solid #e0e0e0;
    border-radius: 10px;
    font-size: 14px;
    transition: all 0.3s ease;
}

.form-control:focus, .form-select:focus {
    border-color: #667eea;
    box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.1);
}
</style>
@endsection