@extends('layouts.app')

@section('title', isset($product) ? 'Edit Product Pendukung Box' : 'Tambah Product Pendukung Box')

@section('page-title', isset($product) ? 'Edit Product Pendukung Box' : 'Tambah Product Pendukung Box')

@section('content')

<!-- Error Messages -->
@if($errors->any())
<div class="alert alert-danger alert-dismissible fade show" role="alert">
    <strong>Error!</strong>
    <ul class="mb-0">
        @foreach($errors->all() as $error)
        <li>{{ $error }}</li>
        @endforeach
    </ul>
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
</div>
@endif

<div class="card modern-card">
    <div class="card-header">
        <h5>
            <i class="fas fa-{{ isset($product) ? 'edit' : 'plus-circle' }} me-2"></i>
            {{ isset($product) ? 'Edit Product Pendukung Box' : 'Tambah Product Pendukung Box' }}
        </h5>
    </div>
    <div class="card-body">
        <form action="{{ isset($product) ? route('product.pendukung-box.update', $product->id) : route('product.pendukung-box.store') }}" 
              method="POST" 
              id="productForm">
            @csrf
            @if(isset($product))
                @method('PUT')
            @endif
            
            <!-- Material Code & Description -->
            <div class="row mb-3">
                <div class="col-md-6">
                    <label class="form-label">Material Code <span class="text-danger">*</span></label>
                    <input type="text" 
                           name="material_code" 
                           class="form-control @error('material_code') is-invalid @enderror" 
                           value="{{ old('material_code', $product->material_code ?? '') }}" 
                           placeholder="VSRFOM00007" 
                           required>
                    @error('material_code')
                    <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                <div class="col-md-6">
                    <label class="form-label">Description <span class="text-danger">*</span></label>
                    <input type="text" 
                           name="description" 
                           class="form-control @error('description') is-invalid @enderror" 
                           value="{{ old('description', $product->description ?? '') }}" 
                           placeholder="STF BLOCK D17 KW1 DMT 500X100X80MM" 
                           required>
                    @error('description')
                    <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </div>
            
            <!-- Pricing Type Selection -->
            <div class="row mb-3">
                <div class="col-md-12">
                    <label class="form-label">Tipe Harga <span class="text-danger">*</span></label>
                    <div class="btn-group w-100" role="group">
                        <input type="radio" 
                               class="btn-check" 
                               name="pricing_type" 
                               id="pricing_type_pcs" 
                               value="pcs" 
                               {{ old('pricing_type', $product->pricing_type ?? 'pcs') === 'pcs' ? 'checked' : '' }} 
                               onchange="togglePricingFields()">
                        <label class="btn btn-outline-success" for="pricing_type_pcs">
                            <i class="fas fa-box me-2"></i>Harga PCS
                        </label>
                        
                        <input type="radio" 
                               class="btn-check" 
                               name="pricing_type" 
                               id="pricing_type_m2" 
                               value="m2" 
                               {{ old('pricing_type', $product->pricing_type ?? '') === 'm2' ? 'checked' : '' }} 
                               onchange="togglePricingFields()">
                        <label class="btn btn-outline-info" for="pricing_type_m2">
                            <i class="fas fa-ruler-combined me-2"></i>Harga M2
                        </label>
                    </div>
                </div>
            </div>
            
            <!-- Harga Asli -->
            <div class="row mb-3">
                <div class="col-md-12">
                    <label class="form-label">Harga Asli <span class="text-danger">*</span></label>
                    <input type="number" 
                           name="harga_asli" 
                           id="harga_asli"
                           class="form-control @error('harga_asli') is-invalid @enderror" 
                           value="{{ old('harga_asli', $product->harga_asli ?? '') }}" 
                           placeholder="3712" 
                           step="0.01"
                           oninput="calculateAll()"
                           required>
                    @error('harga_asli')
                    <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </div>
            
            <!-- Lebar & Panjang (Optional untuk PCS, Required untuk M2) -->
            <div class="row mb-3">
                <div class="col-md-4">
                    <label class="form-label">
                        Lebar (mm) 
                        <span class="text-danger" id="lebar-required" style="display: none;">*</span>
                        <small class="text-muted" id="lebar-optional">(Optional)</small>
                    </label>
                    <input type="number" 
                           name="lebar" 
                           id="lebar"
                           class="form-control @error('lebar') is-invalid @enderror" 
                           value="{{ old('lebar', $product->lebar ?? '') }}" 
                           placeholder="2000"
                           step="0.01"
                           oninput="calculateAll()">
                    @error('lebar')
                    <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                <div class="col-md-4">
                    <label class="form-label">
                        Panjang (mm) 
                        <span class="text-danger" id="panjang-required" style="display: none;">*</span>
                        <small class="text-muted" id="panjang-optional">(Optional)</small>
                    </label>
                    <input type="number" 
                           name="panjang" 
                           id="panjang"
                           class="form-control @error('panjang') is-invalid @enderror" 
                           value="{{ old('panjang', $product->panjang ?? '') }}" 
                           placeholder="1000"
                           step="0.01"
                           oninput="calculateAll()">
                    @error('panjang')
                    <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                <div class="col-md-4">
                    <label class="form-label">M² (Auto)</label>
                    <input type="text" 
                           id="m2_display"
                           class="form-control" 
                           readonly 
                           placeholder="0.00">
                </div>
            </div>
            
            <!-- Results (Auto Calculate) -->
            <div class="row mb-3">
                <div class="col-md-6" id="harga-m2-field" style="display: none;">
                    <label class="form-label">Harga / M² (Auto)</label>
                    <div class="input-group">
                        <span class="input-group-text">Rp</span>
                        <input type="text" 
                               id="harga_m2_display"
                               class="form-control" 
                               readonly 
                               placeholder="0">
                    </div>
                </div>
                <div class="col-md-6">
                    <label class="form-label">Harga Finished (Auto)</label>
                    <div class="input-group">
                        <span class="input-group-text">Rp</span>
                        <input type="text" 
                               id="harga_finished_display"
                               class="form-control fw-bold text-success" 
                               readonly 
                               placeholder="0">
                    </div>
                </div>
            </div>
            
            <!-- Buttons -->
            <div class="d-flex gap-2 justify-content-end">
                <a href="{{ route('product.pendukung-box.index') }}" class="btn btn-secondary">
                    <i class="fas fa-times me-2"></i>Batal
                </a>
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save me-2"></i>Simpan
                </button>
            </div>
        </form>
    </div>
</div>

<style>
.modern-card {
    border: none;
    border-radius: 15px;
    box-shadow: 0 5px 20px rgba(0,0,0,0.05);
}

.modern-card .card-header {
    background: linear-gradient(135deg, #f39c12 0%, #e67e22 100%);
    color: white;
    border-radius: 15px 15px 0 0;
    padding: 20px 25px;
    border: none;
}

.modern-card .card-header h5 {
    margin: 0;
    font-weight: 700;
}

.form-label {
    font-weight: 600;
    color: #2c3e50;
    margin-bottom: 8px;
}

.form-control {
    padding: 12px 15px;
    border: 2px solid #e0e0e0;
    border-radius: 8px;
    transition: all 0.3s ease;
}

.form-control:focus {
    border-color: #f39c12;
    box-shadow: 0 0 0 0.2rem rgba(243, 156, 18, 0.1);
}

.btn-group label {
    padding: 12px 24px;
    font-weight: 600;
}
</style>

<script>
// Initial toggle on page load
document.addEventListener('DOMContentLoaded', function() {
    togglePricingFields();
    calculateAll();
});

// Toggle fields based on pricing type
function togglePricingFields() {
    const pricingType = document.querySelector('input[name="pricing_type"]:checked').value;
    
    const lebarRequired = document.getElementById('lebar-required');
    const lebarOptional = document.getElementById('lebar-optional');
    const panjangRequired = document.getElementById('panjang-required');
    const panjangOptional = document.getElementById('panjang-optional');
    const hargaM2Field = document.getElementById('harga-m2-field');
    
    if (pricingType === 'm2') {
        // M2 - Lebar & Panjang required
        lebarRequired.style.display = 'inline';
        lebarOptional.style.display = 'none';
        panjangRequired.style.display = 'inline';
        panjangOptional.style.display = 'none';
        hargaM2Field.style.display = 'block';
    } else {
        // PCS - Lebar & Panjang optional
        lebarRequired.style.display = 'none';
        lebarOptional.style.display = 'inline';
        panjangRequired.style.display = 'none';
        panjangOptional.style.display = 'inline';
        hargaM2Field.style.display = 'none';
    }
    
    calculateAll();
}

// Calculate all values
function calculateAll() {
    const pricingType = document.querySelector('input[name="pricing_type"]:checked').value;
    const hargaAsli = parseFloat(document.getElementById('harga_asli').value) || 0;
    const lebar = parseFloat(document.getElementById('lebar').value) || 0;
    const panjang = parseFloat(document.getElementById('panjang').value) || 0;
    
    // Calculate M2
    let m2 = 0;
    if (lebar > 0 && panjang > 0) {
        m2 = (lebar * panjang) / 1000000;
        document.getElementById('m2_display').value = m2.toFixed(2);
    } else {
        document.getElementById('m2_display').value = '';
    }
    
    // Calculate based on pricing type
    if (pricingType === 'm2') {
        // M2 Pricing
        if (m2 > 0 && hargaAsli > 0) {
            // Harga M2 = Harga Asli / M2
            const hargaM2 = hargaAsli / m2;
            document.getElementById('harga_m2_display').value = Math.round(hargaM2).toLocaleString('id-ID');
            
            // ✅ RUMUS BENAR: ROUNDUP((Harga M2 / 80%) / 1000, 1) * 1000
            const step1 = hargaM2 / 0.8;
            const step2 = step1 / 1000;
            const step3 = Math.ceil(step2 * 10) / 10; // ROUNDUP to 1 decimal
            const hargaFinished = step3 * 1000;
            
            document.getElementById('harga_finished_display').value = Math.round(hargaFinished).toLocaleString('id-ID');
        } else {
            document.getElementById('harga_m2_display').value = '';
            document.getElementById('harga_finished_display').value = '';
        }
    } else {
        // PCS Pricing
        if (hargaAsli > 0) {
            // ✅ RUMUS BENAR: ROUNDUP((Harga Asli / 60%) / 1000, 1) * 1000
            const step1 = hargaAsli / 0.6;
            const step2 = step1 / 1000;
            const step3 = Math.ceil(step2 * 10) / 10; // ROUNDUP to 1 decimal
            const hargaFinished = step3 * 1000;
            
            document.getElementById('harga_finished_display').value = Math.round(hargaFinished).toLocaleString('id-ID');
        } else {
            document.getElementById('harga_finished_display').value = '';
        }
        
        // Clear Harga M2
        document.getElementById('harga_m2_display').value = '';
    }
}
</script>

@endsection