@extends('layouts.app')

@section('title', 'Product Drawer - Cost Furniture')

@section('page-title', 'Product Drawer')

@section('content')
<div class="card modern-card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5><i class="fas fa-box-open"></i> Data Product Drawer</h5>
        <a href="{{ route('product.drawer.create') }}" class="btn btn-primary">
            <i class="fas fa-plus"></i> Tambah Drawer
        </a>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover" id="drawerTable">
                <thead>
                    <tr>
                        <th width="5%">No</th>
                        <th>Material Type</th>
                        <th>Drawer Type</th>
                        <th>Width (L)</th>
                        <th>Length (P)</th>
                        <th>M2</th>
                        <th>Price</th>
                        <th width="15%">Action</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($drawers as $index => $drawer)
                    <tr>
                        <td>{{ $index + 1 }}</td>
                        <td>
                            <span class="badge bg-warning text-dark">{{ $drawer->material_type }}</span>
                        </td>
                        <td><small>{{ $drawer->drawer_type }}</small></td>
                        <td>{{ number_format($drawer->width, 2) }}</td>
                        <td>{{ number_format($drawer->length, 2) }}</td>
                        <td>{{ number_format($drawer->m2, 6) }}</td>
                        <td><strong class="text-success">{{ \App\Helpers\CasegoodHelper::formatRupiah($drawer->price) }}</strong></td>
                        <td>
                            <a href="{{ route('product.drawer.edit', $drawer->id) }}" class="btn btn-sm btn-warning">
                                <i class="fas fa-edit"></i> Edit
                            </a>
                            <form action="{{ route('product.drawer.destroy', $drawer->id) }}" method="POST" class="d-inline" onsubmit="return confirm('Yakin ingin menghapus data ini?')">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-sm btn-danger">
                                    <i class="fas fa-trash"></i> Hapus
                                </button>
                            </form>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="8" class="text-center py-4">
                            <i class="fas fa-inbox fa-3x text-muted mb-3"></i>
                            <p class="text-muted">Belum ada data drawer</p>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>

<style>
.modern-card {
    border: none;
    border-radius: 15px;
    box-shadow: 0 5px 20px rgba(0,0,0,0.05);
}

.modern-card .card-header {
    background: #fff;
    border-bottom: 2px solid #f0f0f0;
    padding: 20px 25px;
    border-radius: 15px 15px 0 0;
}

.modern-card .card-header h5 {
    margin: 0;
    font-weight: 700;
    color: #2c3e50;
}

.modern-card .card-body {
    padding: 25px;
}

.table thead th {
    background: #f8f9fa;
    font-weight: 600;
    color: #2c3e50;
    border: none;
    padding: 15px;
    font-size: 13px;
}

.table tbody tr {
    transition: all 0.2s ease;
}

.table tbody tr:hover {
    background: #f8f9fa;
}

.table tbody td {
    padding: 15px;
    vertical-align: middle;
    font-size: 13px;
}

.btn-sm {
    padding: 5px 12px;
    font-size: 12px;
}
</style>
@endsection