@extends('layouts.app')

@section('title', ($drawer ? 'Edit' : 'Tambah') . ' Product Drawer - Cost Furniture')

@section('page-title', ($drawer ? 'Edit' : 'Tambah') . ' Product Drawer')

@section('content')
<div class="row justify-content-center">
    <div class="col-md-8">
        <div class="card modern-card">
            <div class="card-header">
                <h5>
                    <i class="fas fa-{{ $drawer ? 'edit' : 'plus-circle' }}"></i> 
                    {{ $drawer ? 'Edit' : 'Tambah' }} Product Drawer
                </h5>
            </div>
            <div class="card-body">
                <form action="{{ $drawer ? route('product.drawer.update', $drawer->id) : route('product.drawer.store') }}" method="POST">
                    @csrf
                    @if($drawer)
                        @method('PUT')
                    @endif
                    
                    <div class="mb-3">
                        <label class="form-label">Material Type <span class="text-danger">*</span></label>
                        <select name="material_type" class="form-select @error('material_type') is-invalid @enderror" required>
                            <option value="">-- Pilih Material Type --</option>
                            <option value="Mahoni" {{ old('material_type', $drawer->material_type ?? '') == 'Mahoni' ? 'selected' : '' }}>Mahoni</option>
                            <option value="White Oak" {{ old('material_type', $drawer->material_type ?? '') == 'White Oak' ? 'selected' : '' }}>White Oak</option>
                        </select>
                        @error('material_type')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Drawer Type <span class="text-danger">*</span></label>
                        <select name="drawer_type" class="form-select @error('drawer_type') is-invalid @enderror" required>
                            <option value="">-- Pilih Drawer Type --</option>
                            <option value="front drawer, back drawer" {{ old('drawer_type', $drawer->drawer_type ?? '') == 'front drawer, back drawer' ? 'selected' : '' }}>Front Drawer, Back Drawer</option>
                            <option value="side drawer" {{ old('drawer_type', $drawer->drawer_type ?? '') == 'side drawer' ? 'selected' : '' }}>Side Drawer</option>
                            <option value="base drawer" {{ old('drawer_type', $drawer->drawer_type ?? '') == 'base drawer' ? 'selected' : '' }}>Base Drawer</option>
                        </select>
                        @error('drawer_type')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Width (L) <span class="text-danger">*</span></label>
                                <input type="number" 
                                       name="width" 
                                       class="form-control @error('width') is-invalid @enderror" 
                                       value="{{ old('width', $drawer->width ?? '') }}"
                                       step="0.01"
                                       placeholder="Contoh: 90"
                                       required>
                                @error('width')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Length (P) <span class="text-danger">*</span></label>
                                <input type="number" 
                                       name="length" 
                                       class="form-control @error('length') is-invalid @enderror" 
                                       value="{{ old('length', $drawer->length ?? '') }}"
                                       step="0.01"
                                       placeholder="Contoh: 450"
                                       required>
                                @error('length')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">M2 <span class="text-danger">*</span></label>
                        <input type="number" 
                               name="m2" 
                               class="form-control @error('m2') is-invalid @enderror" 
                               value="{{ old('m2', $drawer->m2 ?? '') }}"
                               step="0.000001"
                               placeholder="Contoh: 0.0405"
                               required>
                        @error('m2')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <small class="text-muted">M2 = (Width × Length) ÷ 1,000,000</small>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Price <span class="text-danger">*</span></label>
                        <input type="number" 
                               name="price" 
                               class="form-control @error('price') is-invalid @enderror" 
                               value="{{ old('price', $drawer->price ?? '') }}"
                               step="0.01"
                               placeholder="Contoh: 10000"
                               required>
                        @error('price')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <small class="text-muted">Harga dalam Rupiah</small>
                    </div>
                    
                    <div class="d-flex gap-2">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save"></i> {{ $drawer ? 'Update' : 'Simpan' }}
                        </button>
                        <a href="{{ route('product.drawer.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Kembali
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<style>
.modern-card {
    border: none;
    border-radius: 15px;
    box-shadow: 0 5px 20px rgba(0,0,0,0.05);
}

.modern-card .card-header {
    background: #fff;
    border-bottom: 2px solid #f0f0f0;
    padding: 20px 25px;
    border-radius: 15px 15px 0 0;
}

.modern-card .card-header h5 {
    margin: 0;
    font-weight: 700;
    color: #2c3e50;
}

.modern-card .card-body {
    padding: 25px;
}

.form-label {
    font-weight: 600;
    color: #2c3e50;
    margin-bottom: 8px;
    font-size: 14px;
}

.form-control, .form-select {
    padding: 12px 15px;
    border: 2px solid #e0e0e0;
    border-radius: 10px;
    font-size: 14px;
    transition: all 0.3s ease;
}

.form-control:focus, .form-select:focus {
    border-color: #667eea;
    box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.1);
}
</style>
@endsection