@extends('layouts.app')

@section('title', 'Invoice Ukir/Bubut - Cost Furniture')

@section('page-title', 'Invoice Ukir/Bubut')

@section('content')

<div class="d-flex justify-content-between align-items-center mb-4">
    <h4 class="mb-0">🎨 Daftar Invoice Ukir/Bubut</h4>
    <a href="{{ route('invoice.ukir.create') }}" class="btn btn-primary">
        <i class="fas fa-plus me-2"></i>Buat Invoice Ukir/Bubut
    </a>
</div>

@if($invoiceUkirs->isEmpty())
<div class="card modern-card">
    <div class="card-body text-center py-5">
        <i class="fas fa-inbox fa-4x text-muted mb-3"></i>
        <h5 class="text-muted">Belum ada data Invoice Ukir/Bubut</h5>
        <p class="text-muted">Klik tombol "Buat Invoice Ukir/Bubut" untuk menambahkan data baru</p>
        <a href="{{ route('invoice.ukir.create') }}" class="btn btn-primary mt-3">
            <i class="fas fa-plus me-2"></i>Buat Invoice Ukir/Bubut
        </a>
    </div>
</div>
@else
<div class="card modern-card">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th width="5%">No</th>
                        <th width="15%">Invoice BOM</th>
                        <th width="20%">Product Name</th>
                        <th width="15%">Product Code</th>
                        <th width="15%">Grand Total</th>
                        <th width="15%">Tanggal Dibuat</th>
                        <th width="15%" class="text-center">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($invoiceUkirs as $key => $ukir)
                    <tr>
                        <td>{{ $invoiceUkirs->firstItem() + $key }}</td>
                        <td>
                            <span class="badge bg-primary">BOM #{{ $ukir->invoiceBom->id }}</span>
                        </td>
                        <td>{{ $ukir->invoiceBom->product_name }}</td>
                        <td><strong>{{ $ukir->invoiceBom->product_code }}</strong></td>
                        <td>
                            <strong class="text-success">
                                {{ \App\Helpers\CasegoodHelper::formatRupiah($ukir->grand_total) }}
                            </strong>
                        </td>
                        <td>{{ $ukir->created_at->format('d M Y H:i') }}</td>
                        <td class="text-center">
                            <div class="btn-group" role="group">
                                <a href="{{ route('invoice.ukir.show', $ukir->id) }}" 
                                   class="btn btn-sm btn-info" 
                                   title="Lihat Detail">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <a href="{{ route('invoice.ukir.edit', $ukir->id) }}" 
                                   class="btn btn-sm btn-warning" 
                                   title="Edit">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <form action="{{ route('invoice.ukir.destroy', $ukir->id) }}" 
                                      method="POST" 
                                      style="display: inline-block;"
                                      onsubmit="return confirm('Yakin ingin menghapus invoice ukir/bubut ini?')">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" 
                                            class="btn btn-sm btn-danger" 
                                            title="Hapus">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </form>
                            </div>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        
        <!-- Pagination -->
        <div class="mt-4">
            {{ $invoiceUkirs->links() }}
        </div>
    </div>
</div>
@endif

<style>
.modern-card {
    border: none;
    border-radius: 15px;
    box-shadow: 0 5px 20px rgba(0,0,0,0.05);
}

.table {
    margin-bottom: 0;
}

.table thead th {
    background: linear-gradient(135deg, #e67e22 0%, #d35400 100%);
    color: white;
    font-weight: 600;
    border: none;
    padding: 15px;
}

.table tbody tr {
    transition: all 0.3s ease;
}

.table tbody tr:hover {
    background: #f8f9fa;
    transform: scale(1.01);
}

.btn-group .btn {
    margin: 0 2px;
}
</style>

@endsection