@extends('layouts.app')

@section('title', 'Detail Invoice Box - Cost Furniture')

@section('page-title', 'Detail Invoice Box')

@section('content')

<div class="d-flex justify-content-between align-items-center mb-4">
    <h4 class="mb-0">📦 Detail Invoice Box</h4>
    <div class="btn-group">
        <a href="{{ route('invoice.box.print', $invoiceBox->id) }}" class="btn btn-success" target="_blank">
            <i class="fas fa-print me-2"></i>Print Invoice
        </a>
        <a href="{{ route('invoice.box.edit', $invoiceBox->id) }}" class="btn btn-warning">
            <i class="fas fa-edit me-2"></i>Edit
        </a>
        <a href="{{ route('invoice.box.index') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-left me-2"></i>Kembali
        </a>
    </div>
</div>

<!-- Invoice BOM Info -->
<div class="card modern-card mb-4">
    <div class="card-header">
        <h5><i class="fas fa-file-invoice me-2"></i>Informasi Invoice BOM</h5>
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-md-3">
                <strong>Product Name:</strong>
                <div>{{ $invoiceBox->invoiceBom->product_name }}</div>
            </div>
            <div class="col-md-3">
                <strong>Product Code:</strong>
                <div>{{ $invoiceBox->invoiceBom->product_code }}</div>
            </div>
            <div class="col-md-3">
                <strong>Dimensi (P×L×T):</strong>
                <div>{{ $invoiceBox->p }}×{{ $invoiceBox->l }}×{{ $invoiceBox->t }} mm</div>
            </div>
            <div class="col-md-3">
                <strong>Tanggal Dibuat:</strong>
                <div>{{ $invoiceBox->created_at->format('d M Y H:i') }}</div>
            </div>
        </div>
    </div>
</div>

@php
    $boxData = json_decode($invoiceBox->box_data, true);
    $components = $boxData['components'] ?? [];
    $komponenPendukung = $boxData['komponen_pendukung'] ?? [];
    $penunjang = $boxData['penunjang'] ?? null;
    $pallet = $boxData['pallet'] ?? null;
    
    // ✅ SEPARATE SKID FROM KOMPONEN PENDUKUNG
    $skidItems = [];
    $regularKomponenPendukung = [];
    
    foreach ($komponenPendukung as $item) {
        if (isset($item['is_skid']) && $item['is_skid'] === true) {
            $skidItems[] = $item;
        } else {
            $regularKomponenPendukung[] = $item;
        }
    }
    
    // Calculate totals
    $totalComponents = array_sum(array_column($components, 'harga'));
    $totalKomponenPendukung = array_sum(array_column($regularKomponenPendukung, 'total'));
    $totalSkid = array_sum(array_column($skidItems, 'total'));
    $totalPenunjang = ($penunjang && isset($penunjang['enabled']) && $penunjang['enabled']) ? $penunjang['total'] : 0;
    $totalPallet = ($pallet && isset($pallet['enabled']) && $pallet['enabled']) ? $pallet['total'] : 0;
    
    // ✅ TOTAL KOMPONEN PENDUKUNG (Include SKID, Penunjang, Pallet)
    $totalAllKomponenPendukung = $totalKomponenPendukung + $totalSkid + $totalPenunjang + $totalPallet;
@endphp

<!-- Box Components -->
<div class="card modern-card mb-4">
    <div class="card-header">
        <h5><i class="fas fa-box-open me-2"></i>Komponen Box</h5>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-bordered table-hover">
                <thead>
                    <tr>
                        <th width="5%">No</th>
                        <th>Jenis Box</th>
                        <th>Dimensi Box (PJG×LBR×TGI)</th>
                        <th>Ukuran Karton (PJG×LBR)</th>
                        <th>M²</th>
                        <th>Price/M²</th>
                        <th>Price Karton</th>
                        <th>Kebutuhan/Unit</th>
                        <th>Harga</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($components as $index => $component)
                    <tr>
                        <td>{{ $index + 1 }}</td>
                        <td><strong>{{ $component['jenis_box'] }}</strong></td>
                        <td>
                            {{ $component['dimensi_box']['pjg'] }}×{{ $component['dimensi_box']['lbr'] }}×{{ $component['dimensi_box']['tgi'] }} mm
                        </td>
                        <td>
                            {{ $component['ukuran_karton']['pjg'] }}×{{ $component['ukuran_karton']['lbr'] }} mm
                        </td>
                        <td>{{ number_format($component['ukuran_karton']['m2'], 6) }}</td>
                        <td>{{ \App\Helpers\CasegoodHelper::formatRupiah($component['price_m2']) }}</td>
                        <td>{{ \App\Helpers\CasegoodHelper::formatRupiah($component['price_karton']) }}</td>
                        <td class="text-center">{{ $component['kebutuhan_unit'] }}</td>
                        <td><strong class="text-success">{{ \App\Helpers\CasegoodHelper::formatRupiah($component['harga']) }}</strong></td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="9" class="text-center">Tidak ada komponen box</td>
                    </tr>
                    @endforelse
                </tbody>
                <tfoot>
                    <tr class="table-warning">
                        <td colspan="8" class="text-end"><strong>SUBTOTAL KOMPONEN BOX:</strong></td>
                        <td><strong class="text-success fs-6">{{ \App\Helpers\CasegoodHelper::formatRupiah($totalComponents) }}</strong></td>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
</div>

<!-- ✅ KOMPONEN PENDUKUNG (UPDATED - Include All: Regular, SKID, Penunjang, Pallet) -->
@if(count($regularKomponenPendukung) > 0 || count($skidItems) > 0 || $totalPenunjang > 0 || $totalPallet > 0)
<div class="card modern-card mb-4">
    <div class="card-header bg-success">
        <h5 class="text-white">
            <i class="fas fa-boxes me-2"></i>Komponen Pendukung
            <small class="d-block mt-1" style="font-size: 13px; font-weight: normal;">
                (Termasuk: Komponen Reguler, SKID, Penunjang, dan Pallet)
            </small>
        </h5>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-bordered table-hover">
                <thead>
                    <tr>
                        <th width="5%">No</th>
                        <th>Kode Barang</th>
                        <th>Nama</th>
                        <th>Tipe</th>
                        <th>Dimensi</th>
                        <th>M²</th>
                        <th>Qty</th>
                        <th>Harga Finished</th>
                        <th>Total</th>
                    </tr>
                </thead>
                <tbody>
                    @php $kpNo = 1; @endphp
                    
                    <!-- Regular Komponen Pendukung Items -->
                    @foreach($regularKomponenPendukung as $item)
                    <tr>
                        <td>{{ $kpNo++ }}</td>
                        <td>{{ $item['material_code'] }}</td>
                        <td>{{ $item['nama'] }}</td>
                        <td>
                            @if($item['pricing_type'] === 'pcs')
                                <span class="badge bg-success">PCS</span>
                            @else
                                <span class="badge bg-info">M2</span>
                            @endif
                        </td>
                        <td>
                            @if($item['pricing_type'] === 'm2' && $item['pjg'] > 0 && $item['lbr'] > 0)
                                {{ $item['pjg'] }}×{{ $item['lbr'] }}
                                @if($item['tgi'] > 0)
                                    ×{{ $item['tgi'] }}
                                @endif
                                mm
                            @else
                                -
                            @endif
                        </td>
                        <td>
                            @if($item['pricing_type'] === 'm2' && isset($item['m2']))
                                {{ number_format($item['m2'], 4) }}
                            @else
                                -
                            @endif
                        </td>
                        <td class="text-center">{{ $item['qty'] }}</td>
                        <td>{{ \App\Helpers\CasegoodHelper::formatRupiah($item['harga_finished']) }}</td>
                        <td><strong class="text-success">{{ \App\Helpers\CasegoodHelper::formatRupiah($item['total']) }}</strong></td>
                    </tr>
                    @endforeach
                    
                    <!-- ✅ SKID ITEMS -->
                    @foreach($skidItems as $skid)
                    <tr class="bg-skid-row">
                        <td>{{ $kpNo++ }}</td>
                        <td><strong>{{ $skid['material_code'] }}</strong></td>
                        <td><strong>🔷 {{ $skid['nama'] }}</strong></td>
                        <td>
                            <span class="badge" style="background: #2196F3; color: white;">M2 - SKID</span>
                        </td>
                        <td>
                            {{ $skid['pjg'] }}×{{ $skid['lbr'] }}×{{ $skid['tgi'] }} mm
                        </td>
                        <td>{{ number_format($skid['m2'], 6) }}</td>
                        <td class="text-center">{{ $skid['qty'] }}</td>
                        <td>{{ \App\Helpers\CasegoodHelper::formatRupiah($skid['harga_finished']) }}</td>
                        <td><strong class="text-primary">{{ \App\Helpers\CasegoodHelper::formatRupiah($skid['total']) }}</strong></td>
                    </tr>
                    @endforeach
                    
                    <!-- Penunjang (if enabled) -->
                    @if($totalPenunjang > 0)
                    <tr style="background-color: #fff9e6;">
                        <td>{{ $kpNo++ }}</td>
                        <td>-</td>
                        <td><strong>⭐ Penunjang ({{ $penunjang['category'] }})</strong></td>
                        <td>
                            <span class="badge bg-warning text-dark">PCS</span>
                        </td>
                        <td>-</td>
                        <td>-</td>
                        <td class="text-center">{{ $penunjang['qty'] }}</td>
                        <td>{{ \App\Helpers\CasegoodHelper::formatRupiah($penunjang['harga']) }}</td>
                        <td><strong class="text-warning">{{ \App\Helpers\CasegoodHelper::formatRupiah($penunjang['total']) }}</strong></td>
                    </tr>
                    @endif
                    
                    <!-- Pallet (if enabled) -->
                    @if($totalPallet > 0)
                    <tr style="background-color: #e6f7ff;">
                        <td>{{ $kpNo++ }}</td>
                        <td>-</td>
                        <td><strong>🚚 Pallet</strong></td>
                        <td>
                            <span class="badge bg-info">PCS</span>
                        </td>
                        <td>-</td>
                        <td>-</td>
                        <td class="text-center">{{ $pallet['qty'] }}</td>
                        <td>{{ \App\Helpers\CasegoodHelper::formatRupiah($pallet['harga']) }}</td>
                        <td><strong class="text-primary">{{ \App\Helpers\CasegoodHelper::formatRupiah($pallet['total']) }}</strong></td>
                    </tr>
                    @endif
                </tbody>
                <tfoot>
                    <!-- ✅ SUBTOTAL KOMPONEN PENDUKUNG (ALL INCLUDED) -->
                    <tr class="table-success">
                        <td colspan="8" class="text-end">
                            <strong>SUBTOTAL KOMPONEN PENDUKUNG:</strong>
                            <br>
                            <small class="text-muted fw-normal">
                                (Komponen: {{ \App\Helpers\CasegoodHelper::formatRupiah($totalKomponenPendukung) }}
                                @if($totalSkid > 0)
                                    + SKID: {{ \App\Helpers\CasegoodHelper::formatRupiah($totalSkid) }}
                                @endif
                                @if($totalPenunjang > 0)
                                    + Penunjang: {{ \App\Helpers\CasegoodHelper::formatRupiah($totalPenunjang) }}
                                @endif
                                @if($totalPallet > 0)
                                    + Pallet: {{ \App\Helpers\CasegoodHelper::formatRupiah($totalPallet) }}
                                @endif
                                )
                            </small>
                        </td>
                        <td><strong class="text-success fs-6">{{ \App\Helpers\CasegoodHelper::formatRupiah($totalAllKomponenPendukung) }}</strong></td>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
</div>
@endif

<!-- ✅ Grand Total (UPDATED - Simplified) -->
<div class="card modern-card">
    <div class="card-body bg-gradient">
        <div class="row align-items-center">
            <div class="col-md-8">
                <h4 class="text-white mb-2"><strong>GRAND TOTAL BOX PACKING</strong></h4>
                <div class="text-white" style="font-size: 14px;">
                    <div class="mb-1">
                        <i class="fas fa-box me-2"></i>
                        <strong>Komponen Box:</strong> {{ \App\Helpers\CasegoodHelper::formatRupiah($totalComponents) }}
                    </div>
                    <div>
                        <i class="fas fa-boxes me-2"></i>
                        <strong>Komponen Pendukung:</strong> {{ \App\Helpers\CasegoodHelper::formatRupiah($totalAllKomponenPendukung) }}
                        <small class="d-block ms-4 mt-1" style="font-size: 12px; opacity: 0.9;">
                            @if($totalKomponenPendukung > 0)
                                • Komponen Reguler: {{ \App\Helpers\CasegoodHelper::formatRupiah($totalKomponenPendukung) }}
                            @endif
                            @if($totalSkid > 0)
                                <br>• SKID: {{ \App\Helpers\CasegoodHelper::formatRupiah($totalSkid) }}
                            @endif
                            @if($totalPenunjang > 0)
                                <br>• Penunjang: {{ \App\Helpers\CasegoodHelper::formatRupiah($totalPenunjang) }}
                            @endif
                            @if($totalPallet > 0)
                                <br>• Pallet: {{ \App\Helpers\CasegoodHelper::formatRupiah($totalPallet) }}
                            @endif
                        </small>
                    </div>
                </div>
            </div>
            <div class="col-md-4 text-end">
                <h6 class="text-white mb-1">TOTAL KESELURUHAN</h6>
                <h2 class="text-white mb-0 fw-bold">{{ \App\Helpers\CasegoodHelper::formatRupiah($invoiceBox->grand_total) }}</h2>
            </div>
        </div>
    </div>
</div>

<style>
.modern-card {
    border: none;
    border-radius: 15px;
    box-shadow: 0 5px 20px rgba(0,0,0,0.05);
    margin-bottom: 20px;
}

.modern-card .card-header {
    background: linear-gradient(135deg, #f39c12 0%, #e67e22 100%);
    color: white;
    border-radius: 15px 15px 0 0;
    padding: 20px 25px;
    border: none;
}

.modern-card .card-header.bg-success {
    background: linear-gradient(135deg, #28a745 0%, #20c997 100%) !important;
}

.modern-card .card-header.bg-info {
    background: linear-gradient(135deg, #17a2b8 0%, #138496 100%) !important;
}

.modern-card .card-header h5 {
    margin: 0;
    font-weight: 700;
}

.modern-card .card-body {
    padding: 25px;
}

.bg-gradient {
    background: linear-gradient(135deg, #f39c12 0%, #e67e22 100%);
    padding: 30px;
    border-radius: 15px;
}

.table thead th {
    background: #f8f9fa;
    font-weight: 600;
    color: #2c3e50;
    padding: 12px;
    font-size: 13px;
}

.table tbody tr:hover {
    background: #f8f9fa;
}

.table tbody td {
    padding: 12px;
    vertical-align: middle;
    font-size: 13px;
}

/* ✅ SKID ROW STYLING */
.bg-skid-row {
    background-color: #e3f2fd !important;
}

.bg-skid-row:hover {
    background-color: #bbdefb !important;
}

.bg-skid-row td {
    font-weight: 500;
}
</style>

@endsection