@extends('layouts.app')

@section('title', 'Edit Invoice Box - Cost Furniture')

@section('page-title', 'Edit Invoice Box')

@section('content')

<div class="d-flex justify-content-between align-items-center mb-4">
    <h4 class="mb-0">📦 Edit Invoice Box</h4>
    <div class="btn-group">
        <a href="{{ route('invoice.box.show', $invoiceBox->id) }}" class="btn btn-secondary">
            <i class="fas fa-arrow-left me-2"></i>Kembali
        </a>
    </div>
</div>

<div class="card modern-card">
    <div class="card-header">
        <h5><i class="fas fa-box me-2"></i>Form Edit Invoice Box - PACKING PENAWARAN</h5>
    </div>
    <div class="card-body">
        <form id="boxForm">
            @csrf
            @method('PUT')
            
            <input type="hidden" id="invoice_bom_id" name="invoice_bom_id" value="{{ $invoiceBox->invoice_bom_id }}">
            <input type="hidden" id="invoice_box_id" value="{{ $invoiceBox->id }}">
            
            <!-- Step 1: Invoice BOM Info (READ ONLY) -->
            <div class="section-card mb-4">
                <h6 class="section-title"><i class="fas fa-file-invoice me-2"></i>INVOICE BOM (Read Only)</h6>
                
                <div class="info-box">
                    <div class="row">
                        <div class="col-md-3">
                            <strong>Product Name:</strong>
                            <div>{{ $invoiceBox->invoiceBom->product_name }}</div>
                        </div>
                        <div class="col-md-3">
                            <strong>Product Code:</strong>
                            <div>{{ $invoiceBox->invoiceBom->product_code }}</div>
                        </div>
                        <div class="col-md-3">
                            <strong>Product Category:</strong>
                            <div id="product-category-display">{{ $invoiceBox->invoiceBom->product_category }}</div>
                        </div>
                        <div class="col-md-3">
                            <strong>Dimensi (P×L×T):</strong>
                            <div id="dimensi-display">{{ $invoiceBox->p }}×{{ $invoiceBox->l }}×{{ $invoiceBox->t }} mm</div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Dimensi Produk (READ ONLY - Auto dari BOM) -->
            <div class="section-card mb-4">
                <h6 class="section-title"><i class="fas fa-ruler me-2"></i>DIMENSI PRODUK (Auto dari BOM)</h6>
                
                <div class="row">
                    <div class="col-md-4">
                        <label class="form-label">P (Panjang) - mm</label>
                        <input type="number" class="form-control" id="p_value" name="p" value="{{ $invoiceBox->p }}" readonly>
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">L (Lebar) - mm</label>
                        <input type="number" class="form-control" id="l_value" name="l" value="{{ $invoiceBox->l }}" readonly>
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">T (Tinggi) - mm</label>
                        <input type="number" class="form-control" id="t_value" name="t" value="{{ $invoiceBox->t }}" readonly>
                    </div>
                </div>
            </div>
            
            <!-- KOMPONEN BOX (CARD STYLE) + TOMBOL TAMBAH FILLER -->
            <div class="d-flex justify-content-between align-items-center mb-3">
                <h6 class="section-title mb-0"><i class="fas fa-boxes me-2"></i>KOMPONEN BOX (Pilih yang dibutuhkan)</h6>
                <button type="button" class="btn btn-sm btn-info" onclick="openTambahFillerModal()">
                    <i class="fas fa-plus-circle me-2"></i>Tambah Filler
                </button>
            </div>
            
            <div class="row mb-4" id="box-cards-container">
                <!-- Cards will be generated here by JavaScript -->
            </div>
            
            <!-- ✅ SECTION KOMPONEN PENDUKUNG (INCLUDE SKID, PENUNJANG AUTO, PALLET) -->
            <div class="section-card mb-4">
                <h6 class="section-title">
                    <i class="fas fa-layer-group me-2"></i>KOMPONEN PENDUKUNG
                    <small class="text-muted d-block mt-1" style="font-size: 12px; font-weight: normal;">
                        (Termasuk: SKID, Penunjang Otomatis, Komponen Tambahan, dan Pallet)
                    </small>
                </h6>
                
                <!-- ✅ SKID BOX REGULER SECTION -->
                <div id="skid-box-reguler-section" class="mb-4" style="display: none;">
                    <div class="skid-card">
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <div>
                                <div class="form-check">
                                    <input class="form-check-input" 
                                           type="checkbox" 
                                           id="skid-box-reguler-checkbox" 
                                           onchange="toggleSkidBoxReguler()">
                                    <label class="form-check-label fw-bold" for="skid-box-reguler-checkbox">
                                        <i class="fas fa-pallet me-2 text-primary"></i>
                                        SKID PLYWOOD POPLAR - Box Reguler
                                    </label>
                                </div>
                                <small class="text-muted ms-4">Harga: Rp 125.000/M² | TBL: 12mm</small>
                            </div>
                        </div>
                        
                        <div id="skid-box-reguler-detail" style="display: none;">
                            <div class="row g-3">
                                <!-- SKID PJG -->
                                <div class="col-md-6">
                                    <div class="skid-item-card">
                                        <h6 class="skid-item-title">SKID PJG (Box Reguler)</h6>
                                        <div class="row align-items-center">
                                            <div class="col-md-3">
                                                <label class="form-label small mb-1">Qty:</label>
                                                <input type="number" 
                                                       class="form-control form-control-sm" 
                                                       id="skid-box-reguler-pjg-qty" 
                                                       value="2" 
                                                       min="1"
                                                       oninput="calculateSkidBoxRegulerPjg()">
                                            </div>
                                            <div class="col-md-3">
                                                <label class="form-label small mb-1">PJG:</label>
                                                <input type="text" class="form-control form-control-sm" id="skid-box-reguler-pjg-dimensi-pjg" readonly>
                                            </div>
                                            <div class="col-md-3">
                                                <label class="form-label small mb-1">LBR:</label>
                                                <input type="text" class="form-control form-control-sm" value="120" readonly>
                                            </div>
                                            <div class="col-md-3">
                                                <label class="form-label small mb-1">Total:</label>
                                                <input type="text" class="form-control form-control-sm fw-bold text-primary" id="skid-box-reguler-pjg-total" readonly>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- SKID LBR -->
                                <div class="col-md-6">
                                    <div class="skid-item-card">
                                        <h6 class="skid-item-title">SKID LBR (Box Reguler)</h6>
                                        <div class="row align-items-center">
                                            <div class="col-md-3">
                                                <label class="form-label small mb-1">Qty:</label>
                                                <input type="number" 
                                                       class="form-control form-control-sm" 
                                                       id="skid-box-reguler-lbr-qty" 
                                                       value="6" 
                                                       min="1"
                                                       oninput="calculateSkidBoxRegulerLbr()">
                                            </div>
                                            <div class="col-md-3">
                                                <label class="form-label small mb-1">PJG:</label>
                                                <input type="text" class="form-control form-control-sm" id="skid-box-reguler-lbr-dimensi-pjg" readonly>
                                            </div>
                                            <div class="col-md-3">
                                                <label class="form-label small mb-1">LBR:</label>
                                                <input type="text" class="form-control form-control-sm" value="120" readonly>
                                            </div>
                                            <div class="col-md-3">
                                                <label class="form-label small mb-1">Total:</label>
                                                <input type="text" class="form-control form-control-sm fw-bold text-primary" id="skid-box-reguler-lbr-total" readonly>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row mt-3">
                                <div class="col-md-12">
                                    <div class="alert alert-success mb-0">
                                        <div class="d-flex justify-content-between align-items-center">
                                            <span><i class="fas fa-check-circle me-2"></i><strong>Total SKID Box Reguler:</strong></span>
                                            <h5 class="mb-0 text-success" id="skid-box-reguler-grand-total">Rp 0</h5>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- ✅ SKID BOX TUMBU SECTION -->
                <div id="skid-box-tumbu-section" class="mb-4" style="display: none;">
                    <div class="skid-card">
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <div>
                                <div class="form-check">
                                    <input class="form-check-input" 
                                           type="checkbox" 
                                           id="skid-box-tumbu-checkbox" 
                                           onchange="toggleSkidBoxTumbu()">
                                    <label class="form-check-label fw-bold" for="skid-box-tumbu-checkbox">
                                        <i class="fas fa-pallet me-2 text-info"></i>
                                        SKID PLYWOOD POPLAR - Box Tumbu
                                    </label>
                                </div>
                                <small class="text-muted ms-4">Harga: Rp 75.000/M² | TBL: 2.4mm</small>
                            </div>
                        </div>
                        
                        <div id="skid-box-tumbu-detail" style="display: none;">
                            <div class="row g-3">
                                <!-- SKID PJG -->
                                <div class="col-md-6">
                                    <div class="skid-item-card">
                                        <h6 class="skid-item-title">SKID PJG (Box Tumbu)</h6>
                                        <div class="row align-items-center">
                                            <div class="col-md-3">
                                                <label class="form-label small mb-1">Qty:</label>
                                                <input type="number" 
                                                       class="form-control form-control-sm" 
                                                       id="skid-box-tumbu-pjg-qty" 
                                                       value="2" 
                                                       min="1"
                                                       oninput="calculateSkidBoxTumbuPjg()">
                                            </div>
                                            <div class="col-md-3">
                                                <label class="form-label small mb-1">PJG:</label>
                                                <input type="text" class="form-control form-control-sm" id="skid-box-tumbu-pjg-dimensi-pjg" readonly>
                                            </div>
                                            <div class="col-md-3">
                                                <label class="form-label small mb-1">LBR:</label>
                                                <input type="text" class="form-control form-control-sm" id="skid-box-tumbu-pjg-dimensi-lbr" readonly>
                                            </div>
                                            <div class="col-md-3">
                                                <label class="form-label small mb-1">Total:</label>
                                                <input type="text" class="form-control form-control-sm fw-bold text-info" id="skid-box-tumbu-pjg-total" readonly>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- SKID LBR -->
                                <div class="col-md-6">
                                    <div class="skid-item-card">
                                        <h6 class="skid-item-title">SKID LBR (Box Tumbu)</h6>
                                        <div class="row align-items-center">
                                            <div class="col-md-3">
                                                <label class="form-label small mb-1">Qty:</label>
                                                <input type="number" 
                                                       class="form-control form-control-sm" 
                                                       id="skid-box-tumbu-lbr-qty" 
                                                       value="2" 
                                                       min="1"
                                                       oninput="calculateSkidBoxTumbuLbr()">
                                            </div>
                                            <div class="col-md-3">
                                                <label class="form-label small mb-1">PJG:</label>
                                                <input type="text" class="form-control form-control-sm" id="skid-box-tumbu-lbr-dimensi-pjg" readonly>
                                            </div>
                                            <div class="col-md-3">
                                                <label class="form-label small mb-1">LBR:</label>
                                                <input type="text" class="form-control form-control-sm" id="skid-box-tumbu-lbr-dimensi-lbr" readonly>
                                            </div>
                                            <div class="col-md-3">
                                                <label class="form-label small mb-1">Total:</label>
                                                <input type="text" class="form-control form-control-sm fw-bold text-info" id="skid-box-tumbu-lbr-total" readonly>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row mt-3">
                                <div class="col-md-12">
                                    <div class="alert alert-info mb-0">
                                        <div class="d-flex justify-content-between align-items-center">
                                            <span><i class="fas fa-check-circle me-2"></i><strong>Total SKID Box Tumbu:</strong></span>
                                            <h5 class="mb-0 text-info" id="skid-box-tumbu-grand-total">Rp 0</h5>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- ✅ PENUNJANG AUTO-ENABLED (NO CHECKBOX) -->
                <div id="penunjang-section" class="mb-4" style="display: none;">
                    <div class="alert alert-success mb-0">
                        <div class="row align-items-center">
                            <div class="col-md-3">
                                <h6 class="mb-1"><i class="fas fa-check-circle me-2"></i>Penunjang Otomatis</h6>
                                <span class="badge bg-success">AUTO-ENABLED</span>
                            </div>
                            <div class="col-md-3">
                                <label class="form-label small mb-1">Product Category:</label>
                                <input type="text" 
                                       class="form-control form-control-sm" 
                                       id="penunjang-category" 
                                       value="{{ $invoiceBox->invoiceBom->product_category }}"
                                       readonly>
                            </div>
                            <div class="col-md-2">
                                <label class="form-label small mb-1">Harga:</label>
                                <input type="text" 
                                       class="form-control form-control-sm" 
                                       id="penunjang-harga-display" 
                                       readonly>
                            </div>
                            <div class="col-md-2">
                                <label class="form-label small mb-1">Qty:</label>
                                <input type="number" 
                                       class="form-control form-control-sm" 
                                       id="penunjang-qty" 
                                       value="1" 
                                       min="1"
                                       oninput="calculatePenunjangTotal()">
                            </div>
                            <div class="col-md-2">
                                <label class="form-label small mb-1">Total:</label>
                                <input type="text" 
                                       class="form-control form-control-sm fw-bold text-success" 
                                       id="penunjang-total-display" 
                                       readonly>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- ✅ PALLET (WITH CHECKBOX) -->
                <div class="mb-4">
                    <div class="biaya-tambahan-card">
                        <div class="form-check">
                            <input class="form-check-input" 
                                   type="checkbox" 
                                   id="pallet-checkbox" 
                                   onchange="togglePallet()">
                            <label class="form-check-label fw-bold" for="pallet-checkbox">
                                <i class="fas fa-pallet me-2 text-primary"></i>
                                Pallet
                            </label>
                        </div>
                        
                        <div id="pallet-detail" class="mt-3" style="display: none;">
                            <div class="row align-items-center">
                                <div class="col-md-3 offset-md-3">
                                    <label class="form-label small mb-1">Harga:</label>
                                    <div class="input-group input-group-sm">
                                        <span class="input-group-text">Rp</span>
                                        <input type="text" 
                                               class="form-control" 
                                               id="pallet-harga-display" 
                                               value="150.000" 
                                               readonly>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <label class="form-label small mb-1">Qty:</label>
                                    <input type="number" 
                                           class="form-control form-control-sm" 
                                           id="pallet-qty" 
                                           value="1" 
                                           min="1"
                                           oninput="calculatePalletTotal()">
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label small mb-1">Total:</label>
                                    <div class="input-group input-group-sm">
                                        <span class="input-group-text">Rp</span>
                                        <input type="text" 
                                               class="form-control fw-bold text-success" 
                                               id="pallet-total-display" 
                                               readonly>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- ✅ KOMPONEN PENDUKUNG TAMBAHAN -->
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <h6 class="mb-0">
                        <i class="fas fa-boxes me-2"></i>Komponen Pendukung Tambahan
                        <small class="text-muted d-block mt-1" style="font-size: 11px; font-weight: normal;">
                            (Komponen tambahan selain SKID, Penunjang, dan Pallet)
                        </small>
                    </h6>
                    <button type="button" class="btn btn-sm btn-success" onclick="openKomponenPendukungModal()">
                        <i class="fas fa-plus-circle me-2"></i>Tambah Komponen
                    </button>
                </div>
                
                <div id="komponen-pendukung-container">
                    <!-- Komponen pendukung items will be added here -->
                </div>
                
                <div id="no-komponen-pendukung-message" class="text-center py-3" style="display: none;">
                    <i class="fas fa-info-circle text-muted"></i>
                    <small class="text-muted d-block mt-1">Belum ada komponen pendukung tambahan.</small>
                </div>
            </div>
            
            <!-- Grand Total -->
            <div class="section-card bg-gradient">
                <div class="row align-items-center">
                    <div class="col-md-4">
                        <h5 class="mb-0"><i class="fas fa-calculator me-2"></i>GRAND TOTAL BOX</h5>
                        <small class="text-white">Komponen Box</small>
                    </div>
                    <div class="col-md-4 text-center">
                        <h5 class="mb-0 text-white">KOMPONEN PENDUKUNG</h5>
                        <h4 class="mb-0 text-white" id="komponen-pendukung-total-display">Rp 0</h4>
                    </div>
                    <div class="col-md-4 text-end">
                        <h5 class="mb-0 text-white">GRAND TOTAL</h5>
                        <h3 class="mb-0 text-white" id="grand-total-display">Rp 0</h3>
                        <input type="hidden" name="grand_total" id="grand_total" value="0">
                    </div>
                </div>
            </div>
            
            <!-- Action Buttons -->
            <div class="d-flex gap-2 justify-content-end mt-4">
                <a href="{{ route('invoice.box.show', $invoiceBox->id) }}" class="btn btn-secondary">
                    <i class="fas fa-times me-2"></i>Batal
                </a>
                <button type="button" class="btn btn-primary" onclick="updateInvoiceBox()">
                    <i class="fas fa-save me-2"></i>Update Invoice Box
                </button>
            </div>
        </form>
    </div>
</div>

<!-- Loading Overlay -->
<div class="loading-overlay" id="loadingOverlay" style="display: none;">
    <div class="spinner-border text-light" role="status" style="width: 3rem; height: 3rem;">
        <span class="visually-hidden">Loading...</span>
    </div>
    <p class="text-light mt-3 fw-bold">Updating Invoice Box...</p>
</div>

<!-- MODALS - Copy dari create.blade.php (sama persis) -->
<!-- Modal Edit Komponen Box -->
<div class="modal fade" id="editComponentModal" tabindex="-1">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title"><i class="fas fa-edit me-2"></i>Edit <span id="modal-component-name"></span></h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <input type="hidden" id="modal-component-id">
                <div id="modal-component-content"></div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
                <button type="button" class="btn btn-primary" onclick="saveComponentFromModal()">
                    <i class="fas fa-save me-2"></i>Simpan
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Modal Tambah Filler - SAMA seperti create -->
<div class="modal fade" id="tambahFillerModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-info text-white">
                <h5 class="modal-title"><i class="fas fa-plus-circle me-2"></i>Tambah Filler</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <p class="mb-3">Pilih jenis Filler yang ingin ditambahkan:</p>
                <div class="d-grid gap-3">
                    <button type="button" class="btn btn-lg btn-outline-primary" onclick="addFillerBox()">
                        <i class="fas fa-box fa-2x mb-2 d-block"></i>
                        <strong>FILLER BOX</strong>
                        <small class="d-block text-muted">Otomatis membuat Layer Honeycomb 1 & 2</small>
                    </button>
                    <button type="button" class="btn btn-lg btn-outline-success" onclick="addFillerSegitiga()">
                        <i class="fas fa-shapes fa-2x mb-2 d-block"></i>
                        <strong>FILLER SEGITIGA</strong>
                        <small class="d-block text-muted">Independent, tidak ada Layer Honeycomb</small>
                    </button>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
            </div>
        </div>
    </div>
</div>

<!-- Modal Komponen Pendukung - Copy EXACT dari Part 3 yang sudah saya berikan -->
<div class="modal fade" id="komponenPendukungModal" tabindex="-1">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header bg-success text-white">
                <h5 class="modal-title"><i class="fas fa-plus-circle me-2"></i>Tambah Komponen Pendukung</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <input type="hidden" id="komponen-pendukung-edit-index">
                
                <div class="mb-4">
                    <label class="form-label fw-bold">Mode Input <span class="text-danger">*</span></label>
                    <div class="btn-group w-100" role="group">
                        <input type="radio" class="btn-check" name="komponen_input_mode" id="komponen_mode_pilihan" value="pilihan" checked onchange="toggleKomponenInputMode()">
                        <label class="btn btn-outline-primary" for="komponen_mode_pilihan">
                            <i class="fas fa-list me-2"></i>Pilih dari Data Master
                        </label>
                        <input type="radio" class="btn-check" name="komponen_input_mode" id="komponen_mode_manual" value="manual" onchange="toggleKomponenInputMode()">
                        <label class="btn btn-outline-warning" for="komponen_mode_manual">
                            <i class="fas fa-keyboard me-2"></i>Input Manual
                        </label>
                    </div>
                </div>
                
                <hr>
                
                <div id="komponen-mode-pilihan-section">
                    <div class="alert alert-info">
                        <i class="fas fa-info-circle me-2"></i>
                        <strong>Mode Pilihan:</strong> Pilih product dari data master. Harga/M² dan Harga Finished akan otomatis terisi dan tidak bisa diubah.
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Pilih Product Pendukung Box <span class="text-danger">*</span></label>
                        <select class="form-select" id="komponen-pendukung-product-select" onchange="selectProductPendukung()">
                            <option value="">-- Pilih Product --</option>
                            @foreach($komponenPendukungMaster as $product)
                            <option value="{{ $product->id }}" 
                                    data-material-code="{{ $product->material_code }}"
                                    data-description="{{ $product->description }}"
                                    data-pricing-type="{{ $product->pricing_type }}"
                                    data-harga-asli="{{ $product->harga_asli }}"
                                    data-lebar="{{ $product->lebar }}"
                                    data-panjang="{{ $product->panjang }}"
                                    data-m2="{{ $product->m2 }}"
                                    data-harga-m2="{{ $product->harga_m2 }}"
                                    data-harga-finished="{{ $product->harga_finished }}">
                                {{ $product->material_code }} - {{ $product->description }}
                            </option>
                            @endforeach
                        </select>
                    </div>
                </div>
                
                <div id="komponen-mode-manual-section" style="display: none;">
                    <div class="alert alert-warning">
                        <i class="fas fa-exclamation-triangle me-2"></i>
                        <strong>Mode Manual:</strong> Input data komponen baru yang tidak ada di data master.
                    </div>
                </div>
                
                <hr>
                
                <div class="row mb-3">
                    <div class="col-md-6">
                        <label class="form-label">Kode Barang <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="komponen-pendukung-kode" required>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">Nama <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="komponen-pendukung-nama" required>
                    </div>
                </div>
                
                <div class="row mb-3">
                    <div class="col-md-12">
                        <label class="form-label">Tipe Harga <span class="text-danger">*</span></label>
                        <div class="btn-group w-100" role="group">
                            <input type="radio" class="btn-check" name="komponen_pricing_type" id="komponen_pricing_type_pcs" value="pcs" checked onchange="toggleKomponenPricingFields()">
                            <label class="btn btn-outline-success" for="komponen_pricing_type_pcs">
                                <i class="fas fa-box me-2"></i>Harga PCS
                            </label>
                            <input type="radio" class="btn-check" name="komponen_pricing_type" id="komponen_pricing_type_m2" value="m2" onchange="toggleKomponenPricingFields()">
                            <label class="btn btn-outline-info" for="komponen_pricing_type_m2">
                                <i class="fas fa-ruler-combined me-2"></i>Harga M2
                            </label>
                        </div>
                    </div>
                </div>
                
                <div class="row mb-3">
                    <div class="col-md-12">
                        <label class="form-label">Harga Asli <span class="text-danger">*</span></label>
                        <input type="number" class="form-control" id="komponen-pendukung-harga-asli" step="0.01" oninput="calculateKomponenPendukung()" required>
                    </div>
                </div>
                
                <div class="row mb-3" id="komponen-dimensi-row">
                    <div class="col-md-3">
                        <label class="form-label">PJG (mm) <span class="text-danger" id="komponen-pjg-required" style="display: none;">*</span></label>
                        <input type="number" class="form-control" id="komponen-pendukung-pjg" oninput="calculateKomponenPendukung()">
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">LBR (mm) <span class="text-danger" id="komponen-lbr-required" style="display: none;">*</span></label>
                        <input type="number" class="form-control" id="komponen-pendukung-lbr" oninput="calculateKomponenPendukung()">
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">TGI (mm)</label>
                        <input type="number" class="form-control" id="komponen-pendukung-tgi" readonly>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">M² (Auto)</label>
                        <input type="text" class="form-control" id="komponen-pendukung-m2" readonly>
                    </div>
                </div>
                
                <div class="row mb-3" id="komponen-harga-m2-field" style="display: none;">
                    <div class="col-md-12">
                        <label class="form-label">Harga / M² (Auto)</label>
                        <div class="input-group">
                            <span class="input-group-text">Rp</span>
                            <input type="text" class="form-control" id="komponen-pendukung-harga-m2-display" readonly>
                        </div>
                    </div>
                </div>
                
                <div class="row mb-3">
                    <div class="col-md-4">
                        <label class="form-label">Qty <span class="text-danger">*</span></label>
                        <input type="number" class="form-control" id="komponen-pendukung-qty" value="1" min="1" oninput="calculateKomponenPendukungTotal()" required>
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">Harga Finished (Auto)</label>
                        <div class="input-group">
                            <span class="input-group-text">Rp</span>
                            <input type="text" class="form-control fw-bold text-success" id="komponen-pendukung-harga-finished-display" readonly>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">Total (Auto)</label>
                        <div class="input-group">
                            <span class="input-group-text">Rp</span>
                            <input type="text" class="form-control fw-bold text-success" id="komponen-pendukung-total" readonly>
                        </div>
                    </div>
                </div>
                
                <input type="hidden" id="komponen-pendukung-mode" value="pilihan">
                <input type="hidden" id="komponen-pendukung-harga-m2-master" value="0">
                <input type="hidden" id="komponen-pendukung-harga-finished-master" value="0">
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                <button type="button" class="btn btn-success" onclick="saveKomponenPendukung()">
                    <i class="fas fa-save me-2"></i>Simpan
                </button>
            </div>
        </div>
    </div>
</div>

@endsection
@push('styles')
<style>
/* ============================================ */
/* MODERN CARD */
/* ============================================ */

.modern-card {
    border: none;
    border-radius: 15px;
    box-shadow: 0 5px 20px rgba(0,0,0,0.05);
}

.modern-card .card-header {
    background: linear-gradient(135deg, #f39c12 0%, #e67e22 100%);
    color: white;
    border-radius: 15px 15px 0 0;
    padding: 20px 25px;
    border: none;
}

.modern-card .card-header h5 {
    margin: 0;
    font-weight: 700;
    color: white;
}

.modern-card .card-body {
    padding: 30px;
}

/* ============================================ */
/* SECTION CARD */
/* ============================================ */

.section-card {
    background: #fff;
    border: 2px solid #f0f0f0;
    border-radius: 12px;
    padding: 25px;
    margin-bottom: 25px;
}

.section-title {
    font-weight: 700;
    color: #f39c12;
    font-size: 16px;
    margin-bottom: 20px;
}

/* ============================================ */
/* INFO BOX */
/* ============================================ */

.info-box {
    background: linear-gradient(135deg, rgba(243, 156, 18, 0.1) 0%, rgba(230, 126, 34, 0.1) 100%);
    border: 2px solid rgba(243, 156, 18, 0.2);
    border-radius: 10px;
    padding: 20px;
}

.info-box strong {
    color: #666;
    font-size: 12px;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.info-box div:not(strong) {
    color: #2c3e50;
    font-size: 16px;
    font-weight: 600;
    margin-top: 5px;
}

/* ============================================ */
/* BOX COMPONENT CARD */
/* ============================================ */

.box-component-card {
    background: #fff;
    border: 3px solid #e9ecef;
    border-radius: 15px;
    padding: 20px;
    margin-bottom: 20px;
    cursor: pointer;
    transition: all 0.3s ease;
    position: relative;
    min-height: 200px;
}

.box-component-card:hover {
    border-color: #f39c12;
    box-shadow: 0 5px 15px rgba(243, 156, 18, 0.2);
    transform: translateY(-3px);
}

.box-component-card.active {
    border-color: #28a745;
    background: linear-gradient(135deg, rgba(40, 167, 69, 0.05) 0%, rgba(32, 201, 151, 0.05) 100%);
}

.box-component-card.active .card-badge {
    background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
}

/* ============================================ */
/* LAYER HONEYCOMB STYLES */
/* ============================================ */

.box-component-card.layer-auto {
    border-color: #17a2b8 !important;
    background: linear-gradient(135deg, rgba(23, 162, 184, 0.05) 0%, rgba(19, 132, 150, 0.05) 100%);
}

.box-component-card.layer-disabled {
    opacity: 0.5;
    border-color: #6c757d !important;
    background: linear-gradient(135deg, rgba(108, 117, 125, 0.05) 0%, rgba(90, 98, 104, 0.05) 100%);
}

.box-component-card.layer-disabled .card-icon {
    color: #6c757d;
}

.box-component-card.layer-disabled .card-total {
    color: #6c757d !important;
}

.box-component-card.layer-auto .card-badge {
    background: linear-gradient(135deg, #17a2b8 0%, #138496 100%) !important;
}

/* ============================================ */
/* ✅ DISABLED CARD (NEW - FOR BOX REGULER ↔ BOX TUMBU) */
/* ============================================ */

.disabled-card {
    opacity: 0.4;
    pointer-events: none;
    cursor: not-allowed !important;
    border-color: #dc3545 !important;
    background: linear-gradient(135deg, rgba(220, 53, 69, 0.05) 0%, rgba(200, 35, 51, 0.05) 100%);
    position: relative;
}

.disabled-card::before {
    content: "DISABLED";
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%) rotate(-15deg);
    font-size: 32px;
    font-weight: 900;
    color: rgba(220, 53, 69, 0.3);
    z-index: 1;
}

.disabled-card:hover {
    transform: none;
    box-shadow: none;
}

/* ============================================ */
/* CARD ELEMENTS */
/* ============================================ */

.card-badge {
    position: absolute;
    top: 10px;
    right: 10px;
    background: #6c757d;
    color: white;
    padding: 5px 12px;
    border-radius: 20px;
    font-size: 11px;
    font-weight: 600;
    z-index: 2;
}

.card-icon {
    font-size: 40px;
    color: #f39c12;
    margin-bottom: 15px;
}

.box-component-card.active .card-icon {
    color: #28a745;
}

.box-component-card.layer-auto .card-icon {
    color: #17a2b8;
}

.card-title {
    font-size: 16px;
    font-weight: 700;
    color: #2c3e50;
    margin-bottom: 10px;
}

.card-formula {
    font-size: 11px;
    color: #6c757d;
    background: #f8f9fa;
    padding: 8px;
    border-radius: 6px;
    margin-bottom: 10px;
}

.card-total {
    font-size: 18px;
    font-weight: 700;
    color: #28a745;
    margin-top: 10px;
}

/* ============================================ */
/* ✅ CANCEL BUTTON STYLING (NEW) */
/* ============================================ */

.box-component-card .btn-danger {
    background: linear-gradient(135deg, #dc3545 0%, #c82333 100%);
    border: none;
    font-size: 11px;
    padding: 5px 10px;
    box-shadow: 0 2px 5px rgba(220, 53, 69, 0.3);
    transition: all 0.3s ease;
    z-index: 10;
}

.box-component-card .btn-danger:hover {
    background: linear-gradient(135deg, #c82333 0%, #bd2130 100%);
    transform: scale(1.05);
    box-shadow: 0 3px 8px rgba(220, 53, 69, 0.5);
}

.box-component-card .btn-danger:active {
    transform: scale(0.95);
}

/* ============================================ */
/* ✅ SKID CARD STYLES (NEW) */
/* ============================================ */

.skid-card {
    background: linear-gradient(135deg, rgba(33, 150, 243, 0.05) 0%, rgba(30, 136, 229, 0.05) 100%);
    border: 2px solid rgba(33, 150, 243, 0.3);
    border-left: 5px solid #2196F3;
    border-radius: 10px;
    padding: 20px;
    margin-bottom: 20px;
    transition: all 0.3s ease;
}

.skid-card:hover {
    box-shadow: 0 4px 12px rgba(33, 150, 243, 0.2);
}

.skid-item-card {
    background: #fff;
    border: 1px solid #e3f2fd;
    border-radius: 8px;
    padding: 15px;
    transition: all 0.2s ease;
}

.skid-item-card:hover {
    box-shadow: 0 2px 8px rgba(33, 150, 243, 0.15);
}

.skid-item-title {
    font-size: 13px;
    font-weight: 600;
    color: #2196F3;
    margin-bottom: 10px;
    border-bottom: 2px solid #e3f2fd;
    padding-bottom: 8px;
}

/* ============================================ */
/* KOMPONEN PENDUKUNG CARD */
/* ============================================ */

.komponen-pendukung-card {
    background: #fff;
    border: 2px solid #28a745;
    border-left: 4px solid #28a745;
    border-radius: 8px;
    padding: 15px;
    margin-bottom: 10px;
    transition: all 0.2s ease;
}

.komponen-pendukung-card:hover {
    box-shadow: 0 2px 8px rgba(40, 167, 69, 0.2);
    transform: translateY(-1px);
}

.komponen-kode {
    font-size: 11px;
    color: #666;
    font-weight: 600;
    background: #d4edda;
    padding: 2px 6px;
    border-radius: 3px;
    display: inline-block;
    margin-bottom: 5px;
}

.komponen-nama {
    font-size: 13px;
    color: #2c3e50;
    font-weight: 500;
    margin-bottom: 8px;
}

.komponen-dimensi {
    font-size: 11px;
    color: #6c757d;
    background: #f8f9fa;
    padding: 4px 8px;
    border-radius: 4px;
    display: inline-block;
}

/* ============================================ */
/* BIAYA TAMBAHAN CARD */
/* ============================================ */

.biaya-tambahan-card {
    background: #fff;
    border: 2px solid #e9ecef;
    border-left: 4px solid #17a2b8;
    border-radius: 8px;
    padding: 15px;
    transition: all 0.3s ease;
}

.biaya-tambahan-card:hover {
    box-shadow: 0 2px 8px rgba(23, 162, 184, 0.2);
}

.biaya-tambahan-card .form-check-input {
    width: 1.5rem;
    height: 1.5rem;
    margin-top: 0;
    cursor: pointer;
}

.biaya-tambahan-card .form-check-label {
    font-size: 16px;
    margin-left: 10px;
    cursor: pointer;
}

.biaya-tambahan-card .form-check-input:checked ~ .form-check-label {
    color: #28a745;
}

/* ============================================ */
/* GRAND TOTAL */
/* ============================================ */

.bg-gradient {
    background: linear-gradient(135deg, #f39c12 0%, #e67e22 100%);
    color: white;
}

/* ============================================ */
/* FORM CONTROLS */
/* ============================================ */

.form-label {
    font-weight: 600;
    color: #2c3e50;
    margin-bottom: 8px;
    font-size: 14px;
}

.form-control, .form-select {
    padding: 12px 15px;
    border: 2px solid #e0e0e0;
    border-radius: 8px;
    font-size: 14px;
    transition: all 0.3s ease;
}

.form-control:focus, .form-select:focus {
    border-color: #f39c12;
    box-shadow: 0 0 0 0.2rem rgba(243, 156, 18, 0.1);
    outline: none;
}

.form-control:read-only {
    background-color: #f8f9fa;
}

.form-control-sm {
    padding: 6px 10px;
    font-size: 12px;
}

/* ============================================ */
/* BUTTONS */
/* ============================================ */

.btn {
    padding: 12px 24px;
    border-radius: 8px;
    font-weight: 600;
    transition: all 0.3s ease;
}

.btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(0,0,0,0.15);
}

.btn-primary {
    background: linear-gradient(135deg, #f39c12 0%, #e67e22 100%);
    border: none;
}

.btn-primary:hover {
    background: linear-gradient(135deg, #e67e22 0%, #f39c12 100%);
}

.btn-sm {
    padding: 6px 12px;
    font-size: 13px;
}

/* ============================================ */
/* LOADING OVERLAY */
/* ============================================ */

.loading-overlay {
    position: fixed;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: rgba(0, 0, 0, 0.7);
    display: flex;
    flex-direction: column;
    justify-content: center;
    align-items: center;
    z-index: 9999;
}

/* ============================================ */
/* MODAL STYLES */
/* ============================================ */

.modal-header.bg-success {
    background: linear-gradient(135deg, #28a745 0%, #20c997 100%) !important;
}

.modal-header.bg-info {
    background: linear-gradient(135deg, #17a2b8 0%, #138496 100%) !important;
}

/* ============================================ */
/* ALERTS */
/* ============================================ */

.alert-success {
    background: linear-gradient(135deg, rgba(40, 167, 69, 0.1) 0%, rgba(32, 201, 151, 0.1) 100%);
    border: 2px solid rgba(40, 167, 69, 0.3);
    border-left: 4px solid #28a745;
}

.alert-info {
    background: linear-gradient(135deg, rgba(23, 162, 184, 0.1) 0%, rgba(19, 132, 150, 0.1) 100%);
    border: 2px solid rgba(23, 162, 184, 0.3);
    border-left: 4px solid #17a2b8;
}

.alert-warning {
    background: linear-gradient(135deg, rgba(255, 193, 7, 0.1) 0%, rgba(255, 152, 0, 0.1) 100%);
    border: 2px solid rgba(255, 193, 7, 0.3);
    border-left: 4px solid #ffc107;
}

/* ============================================ */
/* BADGES */
/* ============================================ */

.badge {
    padding: 6px 12px;
    font-size: 11px;
    font-weight: 600;
    border-radius: 20px;
}

.badge.bg-success {
    background: linear-gradient(135deg, #28a745 0%, #20c997 100%) !important;
}

/* ============================================ */
/* RESPONSIVE */
/* ============================================ */

@media (max-width: 768px) {
    .modern-card .card-body {
        padding: 15px;
    }
    
    .section-card {
        padding: 15px;
    }
    
    .box-component-card {
        min-height: 150px;
    }
}
</style>
@endpush
@push('scripts')
<script>
// ============================================
// GLOBAL VARIABLES - SAMA PERSIS DENGAN CREATE
// ============================================

let componentsData = {};
let komponenPendukungItems = [];
let P = {{ $invoiceBox->p }};
let L = {{ $invoiceBox->l }};
let T = {{ $invoiceBox->t }};

// Box Reguler dimensions (for dependencies)
let boxRegulerPjg = 0;
let boxRegulerLbr = 0;
let boxRegulerTgi = 0;

// Box Tumbu dimensions (for BOX TUTUP dependency)
let boxTumbuPjg = 0;
let boxTumbuLbr = 0;
let boxTumbuTgi = 0;

// MULTIPLE FILLER BOX - Store all filler box instances
let fillerBoxInstances = {};
let fillerBoxCounter = 0;

// MULTIPLE FILLER SEGITIGA
let fillerSegitigaCounter = 0;

// ============================================
// ✅ SKID DATA (NEW)
// ============================================

let skidBoxRegulerData = {
    enabled: false,
    pjg: {
        qty: 2,
        pjg_dimensi: 0,
        lbr_dimensi: 120,
        tbl_dimensi: 12,
        m2: 0,
        harga: 125000,
        total: 0
    },
    lbr: {
        qty: 6,
        pjg_dimensi: 0,
        lbr_dimensi: 120,
        tbl_dimensi: 12,
        m2: 0,
        harga: 125000,
        total: 0
    },
    total: 0
};

let skidBoxTumbuData = {
    enabled: false,
    pjg: {
        qty: 2,
        pjg_dimensi: 0,
        lbr_dimensi: 0,
        tbl_dimensi: 2.4,
        m2: 0,
        harga: 75000,
        total: 0
    },
    lbr: {
        qty: 2,
        pjg_dimensi: 0,
        lbr_dimensi: 0,
        tbl_dimensi: 2.4,
        m2: 0,
        harga: 75000,
        total: 0
    },
    total: 0
};

// ============================================
// ✅ PENUNJANG & PALLET DATA
// ============================================

const PENUNJANG_PRICES = {
    'Casegoods': 20000,
    'Occasional Table': 20000,
    'Dining Table': 20000,
    'Bed': 20000,
    'Chair': 20000
};

const PALLET_PRICE = 150000;

let penunjangData = {
    enabled: false,
    category: '{{ $invoiceBox->invoiceBom->product_category }}',
    harga: 0,
    qty: 1,
    total: 0
};

let palletData = {
    enabled: false,
    harga: PALLET_PRICE,
    qty: 1,
    total: 0
};

// ============================================
// BOX COMPONENT DEFINITIONS
// ============================================

const boxComponents = [
    {
        id: 'box-reguler',
        name: 'BOX REGULER',
        icon: '📦',
        formula: 'PJG = P + 122 | LBR = L + 122 | TGI = T + 146',
        defaultPrice: 15100,
        type: 'auto',
        allowMultiple: false
    },
    {
        id: 'box-tumbu',
        name: 'BOX TUMBU',
        icon: '📦',
        formula: 'PJG = P + 90 | LBR = L + 90 | TGI = T + 90',
        defaultPrice: 15100,
        type: 'auto',
        allowMultiple: false
    },
    {
        id: 'box-tutup',
        name: 'BOX TUTUP',
        icon: '📦',
        formula: 'Dari BOX TUMBU + 20',
        defaultPrice: 15100,
        type: 'auto',
        allowMultiple: false
    },
    {
        id: 'filler-box',
        name: 'FILLER BOX',
        icon: '📦',
        formula: 'Manual Input (PJG, LBR, TGI)',
        defaultPrice: 10600,
        type: 'manual',
        allowMultiple: true,
        hidden: false
    },
    {
        id: 'layer-honeycomb-1',
        name: 'LAYER HONEYCOMB 1',
        icon: '🔷',
        formula: 'Auto dari Filler Box | TGI = 6',
        defaultPrice: 10600,
        type: 'dependent',
        allowMultiple: false,
        hidden: false
    },
    {
        id: 'layer-honeycomb-2',
        name: 'LAYER HONEYCOMB 2',
        icon: '🔷',
        formula: 'Auto dari Filler Box | TGI = 6',
        defaultPrice: 10600,
        type: 'dependent',
        allowMultiple: false,
        hidden: false
    },
    {
        id: 'filler-segitiga',
        name: 'FILLER SEGITIGA',
        icon: '🔺',
        formula: 'Manual PJG & LBR | TGI = 6',
        defaultPrice: 10600,
        type: 'manual',
        allowMultiple: true,
        hidden: false
    },
    {
        id: 'support-box',
        name: 'SUPPORT BOX',
        icon: '⬜',
        formula: 'Dari Box Reguler | TGI = 50',
        defaultPrice: 10600,
        type: 'dependent',
        allowMultiple: false
    },
    {
        id: 'top-pad',
        name: 'TOP PAD',
        icon: '⬛',
        formula: 'Manual Input (PJG, LBR, TGI)',
        defaultPrice: 10600,
        type: 'manual',
        allowMultiple: false
    }
];

// ============================================
// HELPER FUNCTIONS
// ============================================

function formatRupiah(amount) {
    return 'Rp ' + Math.round(amount).toLocaleString('id-ID');
}

// ============================================
// PAGE LOAD - INITIALIZE
// ============================================

document.addEventListener('DOMContentLoaded', function() {
    console.log('============================================');
    console.log('✅ Invoice Box Edit Page Loaded');
    console.log('============================================');
    console.log('Invoice Box ID:', {{ $invoiceBox->id }});
    console.log('Product:', '{{ $invoiceBox->invoiceBom->product_name }}');
    console.log('Product Category:', '{{ $invoiceBox->invoiceBom->product_category }}');
    console.log('Dimensi:', { P, L, T });
    console.log('============================================');
    
    // ✅ Initialize Penunjang (AUTO-ENABLED)
    initializePenunjangPallet();
    
    // ✅ Load existing data from database
    loadExistingData();
});

// ============================================
// ✅ INITIALIZE PENUNJANG & PALLET
// ============================================

function initializePenunjangPallet() {
    const productCategory = '{{ $invoiceBox->invoiceBom->product_category }}';
    
    // ✅ SET PENUNJANG AUTO-ENABLED
    penunjangData.enabled = true;
    penunjangData.category = productCategory;
    penunjangData.harga = PENUNJANG_PRICES[productCategory] || 20000;
    penunjangData.qty = 1;
    penunjangData.total = penunjangData.harga * 1;
    
    // ✅ SHOW PENUNJANG SECTION
    document.getElementById('penunjang-section').style.display = 'block';
    
    // Update display
    document.getElementById('penunjang-category').value = productCategory;
    document.getElementById('penunjang-harga-display').value = penunjangData.harga.toLocaleString('id-ID');
    document.getElementById('penunjang-qty').value = 1;
    document.getElementById('penunjang-total-display').value = penunjangData.total.toLocaleString('id-ID');
    
    // Pallet setup
    document.getElementById('pallet-harga-display').value = PALLET_PRICE.toLocaleString('id-ID');
    
    console.log('✅ Penunjang AUTO-ENABLED:', {
        category: productCategory,
        harga: penunjangData.harga,
        qty: 1,
        total: penunjangData.total
    });
}

// ============================================
// ✅ SKID BOX REGULER FUNCTIONS
// ============================================

function toggleSkidBoxReguler() {
    const checkbox = document.getElementById('skid-box-reguler-checkbox');
    const detail = document.getElementById('skid-box-reguler-detail');
    
    skidBoxRegulerData.enabled = checkbox.checked;
    
    if (checkbox.checked) {
        if (!componentsData['box-reguler']) {
            alert('⚠️ Aktifkan Box Reguler terlebih dahulu!');
            checkbox.checked = false;
            skidBoxRegulerData.enabled = false;
            return;
        }
        
        detail.style.display = 'block';
        calculateSkidBoxRegulerPjg();
        calculateSkidBoxRegulerLbr();
    } else {
        detail.style.display = 'none';
        skidBoxRegulerData.pjg.total = 0;
        skidBoxRegulerData.lbr.total = 0;
        skidBoxRegulerData.total = 0;
        document.getElementById('skid-box-reguler-grand-total').textContent = 'Rp 0';
        updateGrandTotal();
    }
    
    console.log('✅ SKID Box Reguler toggled:', skidBoxRegulerData.enabled);
}

function calculateSkidBoxRegulerPjg() {
    if (!componentsData['box-reguler']) {
        console.warn('⚠️ Box Reguler not found');
        return;
    }
    
    const boxRegulerPjg = componentsData['box-reguler'].dimensi_box.pjg;
    const pjgDimensi = boxRegulerPjg - 10;
    const lbrDimensi = 120;
    const qty = parseFloat(document.getElementById('skid-box-reguler-pjg-qty').value) || 2;
    const m2 = (pjgDimensi * lbrDimensi) / 1000000;
    const total = qty * skidBoxRegulerData.pjg.harga * m2;
    
    skidBoxRegulerData.pjg.qty = qty;
    skidBoxRegulerData.pjg.pjg_dimensi = pjgDimensi;
    skidBoxRegulerData.pjg.lbr_dimensi = lbrDimensi;
    skidBoxRegulerData.pjg.m2 = m2;
    skidBoxRegulerData.pjg.total = total;
    
    document.getElementById('skid-box-reguler-pjg-dimensi-pjg').value = pjgDimensi;
    document.getElementById('skid-box-reguler-pjg-total').value = formatRupiah(total);
    
    updateSkidBoxRegulerGrandTotal();
    console.log('✅ SKID Box Reguler PJG calculated:', skidBoxRegulerData.pjg);
}

function calculateSkidBoxRegulerLbr() {
    if (!componentsData['box-reguler']) {
        console.warn('⚠️ Box Reguler not found');
        return;
    }
    
    const boxRegulerLbr = componentsData['box-reguler'].dimensi_box.lbr;
    const pjgDimensi = boxRegulerLbr - 10;
    const lbrDimensi = 120;
    const qty = parseFloat(document.getElementById('skid-box-reguler-lbr-qty').value) || 6;
    const m2 = (pjgDimensi * lbrDimensi) / 1000000;
    const total = qty * skidBoxRegulerData.lbr.harga * m2;
    
    skidBoxRegulerData.lbr.qty = qty;
    skidBoxRegulerData.lbr.pjg_dimensi = pjgDimensi;
    skidBoxRegulerData.lbr.lbr_dimensi = lbrDimensi;
    skidBoxRegulerData.lbr.m2 = m2;
    skidBoxRegulerData.lbr.total = total;
    
    document.getElementById('skid-box-reguler-lbr-dimensi-pjg').value = pjgDimensi;
    document.getElementById('skid-box-reguler-lbr-total').value = formatRupiah(total);
    
    updateSkidBoxRegulerGrandTotal();
    console.log('✅ SKID Box Reguler LBR calculated:', skidBoxRegulerData.lbr);
}

function updateSkidBoxRegulerGrandTotal() {
    skidBoxRegulerData.total = skidBoxRegulerData.pjg.total + skidBoxRegulerData.lbr.total;
    document.getElementById('skid-box-reguler-grand-total').textContent = formatRupiah(skidBoxRegulerData.total);
    updateGrandTotal();
}

// ============================================
// ✅ SKID BOX TUMBU FUNCTIONS
// ============================================

function toggleSkidBoxTumbu() {
    const checkbox = document.getElementById('skid-box-tumbu-checkbox');
    const detail = document.getElementById('skid-box-tumbu-detail');
    
    skidBoxTumbuData.enabled = checkbox.checked;
    
    if (checkbox.checked) {
        if (!componentsData['box-tumbu']) {
            alert('⚠️ Aktifkan Box Tumbu terlebih dahulu!');
            checkbox.checked = false;
            skidBoxTumbuData.enabled = false;
            return;
        }
        
        detail.style.display = 'block';
        calculateSkidBoxTumbuPjg();
        calculateSkidBoxTumbuLbr();
    } else {
        detail.style.display = 'none';
        skidBoxTumbuData.pjg.total = 0;
        skidBoxTumbuData.lbr.total = 0;
        skidBoxTumbuData.total = 0;
        document.getElementById('skid-box-tumbu-grand-total').textContent = 'Rp 0';
        updateGrandTotal();
    }
    
    console.log('✅ SKID Box Tumbu toggled:', skidBoxTumbuData.enabled);
}

function calculateSkidBoxTumbuPjg() {
    if (!componentsData['box-tumbu']) {
        console.warn('⚠️ Box Tumbu not found');
        return;
    }
    
    const boxTumbuPjg = componentsData['box-tumbu'].dimensi_box.pjg;
    const boxTumbuTgi = componentsData['box-tumbu'].dimensi_box.tgi;
    
    const pjgDimensi = boxTumbuPjg - 10;
    const lbrDimensi = boxTumbuTgi - 10;
    const qty = parseFloat(document.getElementById('skid-box-tumbu-pjg-qty').value) || 2;
    const m2 = (pjgDimensi * lbrDimensi) / 1000000;
    const total = qty * skidBoxTumbuData.pjg.harga * m2;
    
    skidBoxTumbuData.pjg.qty = qty;
    skidBoxTumbuData.pjg.pjg_dimensi = pjgDimensi;
    skidBoxTumbuData.pjg.lbr_dimensi = lbrDimensi;
    skidBoxTumbuData.pjg.m2 = m2;
    skidBoxTumbuData.pjg.total = total;
    
    document.getElementById('skid-box-tumbu-pjg-dimensi-pjg').value = pjgDimensi;
    document.getElementById('skid-box-tumbu-pjg-dimensi-lbr').value = lbrDimensi;
    document.getElementById('skid-box-tumbu-pjg-total').value = formatRupiah(total);
    
    updateSkidBoxTumbuGrandTotal();
    console.log('✅ SKID Box Tumbu PJG calculated:', skidBoxTumbuData.pjg);
}

function calculateSkidBoxTumbuLbr() {
    if (!componentsData['box-tumbu']) {
        console.warn('⚠️ Box Tumbu not found');
        return;
    }
    
    const boxTumbuLbr = componentsData['box-tumbu'].dimensi_box.lbr;
    const boxTumbuTgi = componentsData['box-tumbu'].dimensi_box.tgi;
    
    const pjgDimensi = boxTumbuLbr - 10;
    const lbrDimensi = boxTumbuTgi - 10;
    const qty = parseFloat(document.getElementById('skid-box-tumbu-lbr-qty').value) || 2;
    const m2 = (pjgDimensi * lbrDimensi) / 1000000;
    const total = qty * skidBoxTumbuData.lbr.harga * m2;
    
    skidBoxTumbuData.lbr.qty = qty;
    skidBoxTumbuData.lbr.pjg_dimensi = pjgDimensi;
    skidBoxTumbuData.lbr.lbr_dimensi = lbrDimensi;
    skidBoxTumbuData.lbr.m2 = m2;
    skidBoxTumbuData.lbr.total = total;
    
    document.getElementById('skid-box-tumbu-lbr-dimensi-pjg').value = pjgDimensi;
    document.getElementById('skid-box-tumbu-lbr-dimensi-lbr').value = lbrDimensi;
    document.getElementById('skid-box-tumbu-lbr-total').value = formatRupiah(total);
    
    updateSkidBoxTumbuGrandTotal();
    console.log('✅ SKID Box Tumbu LBR calculated:', skidBoxTumbuData.lbr);
}

function updateSkidBoxTumbuGrandTotal() {
    skidBoxTumbuData.total = skidBoxTumbuData.pjg.total + skidBoxTumbuData.lbr.total;
    document.getElementById('skid-box-tumbu-grand-total').textContent = formatRupiah(skidBoxTumbuData.total);
    updateGrandTotal();
}

// ============================================
// ✅ SHOW SKID SECTION & RECALCULATE
// ============================================

function showSkidSection(boxType) {
    const skidRegulerSection = document.getElementById('skid-box-reguler-section');
    const skidTumbuSection = document.getElementById('skid-box-tumbu-section');
    
    if (boxType === 'reguler') {
        skidRegulerSection.style.display = 'block';
        skidTumbuSection.style.display = 'none';
        
        document.getElementById('skid-box-tumbu-checkbox').checked = false;
        skidBoxTumbuData.enabled = false;
        skidBoxTumbuData.pjg.total = 0;
        skidBoxTumbuData.lbr.total = 0;
        skidBoxTumbuData.total = 0;
        
        console.log('✅ SKID Section: Showing Box Reguler');
        
    } else if (boxType === 'tumbu') {
        skidTumbuSection.style.display = 'block';
        skidRegulerSection.style.display = 'none';
        
        document.getElementById('skid-box-reguler-checkbox').checked = false;
        skidBoxRegulerData.enabled = false;
        skidBoxRegulerData.pjg.total = 0;
        skidBoxRegulerData.lbr.total = 0;
        skidBoxRegulerData.total = 0;
        
        console.log('✅ SKID Section: Showing Box Tumbu');
    }
}

function recalculateSkidIfEnabled() {
    if (skidBoxRegulerData.enabled && componentsData['box-reguler']) {
        calculateSkidBoxRegulerPjg();
        calculateSkidBoxRegulerLbr();
        console.log('✅ SKID Box Reguler recalculated');
    }
    
    if (skidBoxTumbuData.enabled && componentsData['box-tumbu']) {
        calculateSkidBoxTumbuPjg();
        calculateSkidBoxTumbuLbr();
        console.log('✅ SKID Box Tumbu recalculated');
    }
}

function updateBoxCardsState() {
    renderBoxCards();
    console.log('✅ Box cards state updated');
}

// ============================================
// ✅ PENUNJANG & PALLET FUNCTIONS
// ============================================

function calculatePenunjangTotal() {
    const qty = parseFloat(document.getElementById('penunjang-qty').value) || 1;
    penunjangData.qty = qty;
    penunjangData.total = penunjangData.harga * qty;
    document.getElementById('penunjang-total-display').value = penunjangData.total.toLocaleString('id-ID');
    updateGrandTotal();
    console.log('✅ Penunjang Total Updated:', penunjangData);
}

function togglePallet() {
    const checkbox = document.getElementById('pallet-checkbox');
    const detail = document.getElementById('pallet-detail');
    palletData.enabled = checkbox.checked;
    
    if (checkbox.checked) {
        detail.style.display = 'block';
        calculatePalletTotal();
    } else {
        detail.style.display = 'none';
        palletData.total = 0;
        document.getElementById('pallet-total-display').value = '';
        updateGrandTotal();
    }
    
    console.log('✅ Pallet toggled:', palletData.enabled);
}

function calculatePalletTotal() {
    const qty = parseFloat(document.getElementById('pallet-qty').value) || 1;
    palletData.qty = qty;
    palletData.total = palletData.harga * qty;
    document.getElementById('pallet-total-display').value = palletData.total.toLocaleString('id-ID');
    updateGrandTotal();
}

console.log('============================================');
console.log('✅ Part 3 Loaded: Global Variables + SKID Functions');
console.log('============================================');
// ============================================
// ✅ RENDER BOX CARDS - WITH CANCEL BUTTON & DISABLE LOGIC
// ============================================

function renderBoxCards() {
    const container = document.getElementById('box-cards-container');
    
    // ✅ CHECK WHAT'S ACTIVE
    const hasBoxReguler = componentsData['box-reguler'] !== undefined;
    const hasBoxTumbu = componentsData['box-tumbu'] !== undefined;
    
    let html = '';
    let renderedComponents = new Set();
    
    // ============================================
    // RENDER ACTIVE COMPONENTS
    // ============================================
    
    Object.keys(componentsData).forEach(key => {
        const data = componentsData[key];
        
        let baseComponentId = key;
        let instanceNum = null;
        
        if (key.includes('-')) {
            const match = key.match(/^(filler-box|filler-segitiga|layer-honeycomb-1|layer-honeycomb-2)-(\d+)$/);
            if (match) {
                baseComponentId = match[1];
                instanceNum = parseInt(match[2]);
            }
        }
        
        const component = boxComponents.find(c => c.id === baseComponentId);
        if (!component) return;
        
        const isLayerHoneycomb = key.startsWith('layer-honeycomb-');
        const isLayerEnabled = data.enabled !== undefined ? data.enabled : true;
        
        let displayName = component.name;
        if (instanceNum && instanceNum > 1) {
            displayName = `${component.name} #${instanceNum}`;
        }
        
        // ✅ CHECK IF THIS IS MAIN BOX (should have cancel button)
        const isMainBox = ['box-reguler', 'box-tumbu', 'box-tutup'].includes(key);
        
        html += `
            <div class="col-md-4">
                <div class="box-component-card active ${isLayerHoneycomb ? 'layer-auto' : ''} ${!isLayerEnabled ? 'layer-disabled' : ''}" 
                     onclick="openComponentModal('${key}')" 
                     style="cursor: pointer;">
                    <div class="card-badge ${!isLayerEnabled ? 'bg-secondary' : ''}">${isLayerHoneycomb ? (isLayerEnabled ? 'AUTO-GENERATED' : 'NONAKTIF') : 'AKTIF'}</div>
                    
                    ${isMainBox ? `
                        <button type="button" 
                                class="btn btn-sm btn-danger position-absolute" 
                                style="top: 10px; left: 10px; z-index: 10;"
                                onclick="event.stopPropagation(); cancelBoxComponent('${key}')"
                                title="Batal / Cancel">
                            <i class="fas fa-times me-1"></i>Batal
                        </button>
                    ` : ''}
                    
                    ${component.allowMultiple && !isLayerHoneycomb && !isMainBox ? `
                        <button type="button" 
                                class="btn btn-sm btn-danger position-absolute" 
                                style="top: 10px; left: 10px; z-index: 10;"
                                onclick="event.stopPropagation(); removeComponent('${key}')"
                                title="Hapus">
                            <i class="fas fa-trash"></i>
                        </button>
                    ` : ''}
                    
                    ${isLayerHoneycomb ? `
                        <div class="position-absolute" style="top: 50px; right: 10px; z-index: 10;">
                            <div class="form-check form-switch">
                                <input class="form-check-input" 
                                       type="checkbox" 
                                       id="checkbox-${key}" 
                                       ${isLayerEnabled ? 'checked' : ''}
                                       onchange="toggleLayerHoneycomb('${key}')"
                                       onclick="event.stopPropagation()">
                                <label class="form-check-label small" for="checkbox-${key}">
                                    ${isLayerEnabled ? 'Aktif' : 'Nonaktif'}
                                </label>
                            </div>
                        </div>
                    ` : ''}
                    
                    <div class="card-icon">${component.icon}</div>
                    <div class="card-title">${displayName}</div>
                    <div class="card-formula">${component.formula}</div>
                    <div class="card-total ${!isLayerEnabled ? 'text-muted' : ''}">${formatRupiah(data.harga)}</div>
                    ${isLayerHoneycomb 
                        ? `<small class="text-muted d-block mt-2">
                            <i class="fas fa-${isLayerEnabled ? 'check-circle' : 'times-circle'} me-1"></i>
                            ${isLayerEnabled ? 'Aktif' : 'Nonaktif'} - Klik untuk edit qty
                           </small>` 
                        : `<small class="text-muted d-block mt-2">Klik untuk edit</small>`}
                </div>
            </div>
        `;
        
        renderedComponents.add(baseComponentId);
    });
    
    // ============================================
    // ✅ RENDER NON-ACTIVE COMPONENTS WITH DISABLE LOGIC
    // ============================================
    
    boxComponents.forEach(component => {
        if (renderedComponents.has(component.id) || component.allowMultiple || component.id.startsWith('layer-honeycomb-')) {
            return;
        }
        
        // ✅ DISABLE LOGIC
        let isDisabled = false;
        let disabledReason = '';
        
        if (component.id === 'box-reguler' && hasBoxTumbu) {
            isDisabled = true;
            disabledReason = 'Box Tumbu sudah aktif';
        } else if (component.id === 'box-tumbu' && hasBoxReguler) {
            isDisabled = true;
            disabledReason = 'Box Reguler sudah aktif';
        } else if (component.id === 'box-tutup' && hasBoxReguler) {
            isDisabled = true;
            disabledReason = 'Box Tutup hanya bisa dengan Box Tumbu';
        } else if (component.id === 'box-tutup' && !hasBoxTumbu) {
            isDisabled = true;
            disabledReason = 'Aktifkan Box Tumbu terlebih dahulu';
        }
        
        html += `
            <div class="col-md-4">
                <div class="box-component-card ${isDisabled ? 'disabled-card' : ''}" 
                     onclick="${isDisabled ? 'return false;' : 'openComponentModal(\'' + component.id + '\')'}"
                     ${isDisabled ? 'style="cursor: not-allowed !important;"' : ''}>
                    <div class="card-badge">${isDisabled ? 'DISABLED' : 'NONAKTIF'}</div>
                    <div class="card-icon">${component.icon}</div>
                    <div class="card-title">${component.name}</div>
                    <div class="card-formula">${component.formula}</div>
                    <div class="card-total">Rp 0</div>
                    <small class="text-muted d-block mt-2">
                        ${isDisabled 
                            ? `<i class="fas fa-ban me-1 text-danger"></i>${disabledReason}` 
                            : 'Klik untuk aktifkan'}
                    </small>
                </div>
            </div>
        `;
    });
    
    container.innerHTML = html;
}

// ============================================
// ✅ CANCEL BOX COMPONENT FUNCTION
// ============================================

function cancelBoxComponent(componentId) {
    const component = boxComponents.find(c => c.id === componentId);
    if (!component) return;
    
    const confirmMessage = `⚠️ Yakin ingin MEMBATALKAN ${component.name}?\n\nData ${component.name} akan dihapus dan Anda bisa memilih box lain.`;
    
    if (!confirm(confirmMessage)) {
        return;
    }
    
    delete componentsData[componentId];
    
    if (componentId === 'box-reguler') {
        boxRegulerPjg = 0;
        boxRegulerLbr = 0;
        boxRegulerTgi = 0;
        
        document.getElementById('skid-box-reguler-checkbox').checked = false;
        skidBoxRegulerData.enabled = false;
        skidBoxRegulerData.pjg.total = 0;
        skidBoxRegulerData.lbr.total = 0;
        skidBoxRegulerData.total = 0;
        document.getElementById('skid-box-reguler-section').style.display = 'none';
        
        console.log('✅ Box Reguler CANCELLED - All related data reset');
        
    } else if (componentId === 'box-tumbu') {
        boxTumbuPjg = 0;
        boxTumbuLbr = 0;
        boxTumbuTgi = 0;
        
        document.getElementById('skid-box-tumbu-checkbox').checked = false;
        skidBoxTumbuData.enabled = false;
        skidBoxTumbuData.pjg.total = 0;
        skidBoxTumbuData.lbr.total = 0;
        skidBoxTumbuData.total = 0;
        document.getElementById('skid-box-tumbu-section').style.display = 'none';
        
        if (componentsData['box-tutup']) {
            delete componentsData['box-tutup'];
            console.log('✅ Box Tutup also removed because Box Tumbu was cancelled');
        }
        
        console.log('✅ Box Tumbu CANCELLED - All related data reset');
        
    } else if (componentId === 'box-tutup') {
        console.log('✅ Box Tutup CANCELLED');
    }
    
    updateBoxCardsState();
    updateGrandTotal();
    
    alert(`✅ ${component.name} berhasil dibatalkan!\n\nAnda sekarang bisa memilih box lain.`);
}

// ============================================
// TOGGLE LAYER HONEYCOMB
// ============================================

function toggleLayerHoneycomb(componentId) {
    const checkbox = document.getElementById(`checkbox-${componentId}`);
    const isEnabled = checkbox.checked;
    
    if (componentsData[componentId]) {
        componentsData[componentId].enabled = isEnabled;
        console.log(`✅ Layer Honeycomb ${componentId} ${isEnabled ? 'ENABLED' : 'DISABLED'}`);
        renderBoxCards();
        updateGrandTotal();
    }
}

// ============================================
// REMOVE COMPONENT (FOR FILLER)
// ============================================

function removeComponent(componentId) {
    if (!confirm('⚠️ Yakin ingin menghapus komponen ini?')) {
        return;
    }
    
    delete componentsData[componentId];
    
    if (componentId.startsWith('filler-box-')) {
        const instanceNum = componentId.split('-')[2];
        const layerSuffix = `-${instanceNum}`;
        
        delete componentsData[`layer-honeycomb-1${layerSuffix}`];
        delete componentsData[`layer-honeycomb-2${layerSuffix}`];
        delete fillerBoxInstances[componentId];
        
        console.log(`✅ Removed Filler Box ${instanceNum} and its Layer Honeycombs`);
    }
    
    renderBoxCards();
    updateGrandTotal();
}

// ============================================
// TAMBAH FILLER MODAL & ADD FUNCTIONS
// ============================================

function openTambahFillerModal() {
    const modal = new bootstrap.Modal(document.getElementById('tambahFillerModal'));
    modal.show();
}

function addFillerBox() {
    fillerBoxCounter++;
    const newInstanceId = `filler-box-${fillerBoxCounter}`;
    console.log('✅ Adding new Filler Box:', newInstanceId);
    bootstrap.Modal.getInstance(document.getElementById('tambahFillerModal')).hide();
    openComponentModal(newInstanceId);
}

function addFillerSegitiga() {
    fillerSegitigaCounter++;
    const newInstanceId = `filler-segitiga-${fillerSegitigaCounter}`;
    console.log('✅ Adding new Filler Segitiga:', newInstanceId);
    bootstrap.Modal.getInstance(document.getElementById('tambahFillerModal')).hide();
    openComponentModal(newInstanceId);
}

// ============================================
// ✅ UPDATE GRAND TOTAL
// ============================================

function updateGrandTotal() {
    const totalBox = Object.entries(componentsData).reduce((sum, [key, component]) => {
        const isLayerHoneycomb = key.startsWith('layer-honeycomb-');
        const isEnabled = component.enabled !== undefined ? component.enabled : true;
        
        if (!isLayerHoneycomb || isEnabled) {
            return sum + component.harga;
        }
        return sum;
    }, 0);
    
    const totalKomponenPendukung = komponenPendukungItems.reduce((sum, item) => sum + item.total, 0);
    const totalPenunjang = penunjangData.enabled ? penunjangData.total : 0;
    const totalPallet = palletData.enabled ? palletData.total : 0;
    
    const totalSkidReguler = skidBoxRegulerData.enabled ? skidBoxRegulerData.total : 0;
    const totalSkidTumbu = skidBoxTumbuData.enabled ? skidBoxTumbuData.total : 0;
    const totalSkid = totalSkidReguler + totalSkidTumbu;
    
    const totalAllKomponenPendukung = totalKomponenPendukung + totalSkid + totalPenunjang + totalPallet;
    const grandTotal = totalBox + totalAllKomponenPendukung;
    
    document.getElementById('grand-total-display').textContent = formatRupiah(grandTotal);
    document.getElementById('komponen-pendukung-total-display').textContent = formatRupiah(totalAllKomponenPendukung);
    document.getElementById('grand_total').value = grandTotal;
    
    console.log('💰 Grand Total Updated:', {
        totalBox,
        totalKomponenPendukung,
        totalSkidReguler,
        totalSkidTumbu,
        totalSkid,
        totalPenunjang,
        totalPallet,
        totalAllKomponenPendukung,
        grandTotal
    });
}

console.log('============================================');
console.log('✅ Part 4 Loaded: Render Box Cards + Cancel + Grand Total');
console.log('============================================');
// ============================================
// OPEN COMPONENT MODAL
// ============================================

function openComponentModal(componentId) {
    let baseComponentId = componentId;
    let instanceNum = null;
    
    if (componentId.includes('-')) {
        const match = componentId.match(/^(filler-box|filler-segitiga|layer-honeycomb-1|layer-honeycomb-2)-(\d+)$/);
        if (match) {
            baseComponentId = match[1];
            instanceNum = parseInt(match[2]);
        }
    }
    
    const component = boxComponents.find(c => c.id === baseComponentId);
    if (!component) return;
    
    // ✅ VALIDATION: Check disable conditions
    const hasBoxReguler = componentsData['box-reguler'] !== undefined;
    const hasBoxTumbu = componentsData['box-tumbu'] !== undefined;
    
    if (componentId === 'box-reguler' && hasBoxTumbu) {
        alert('❌ Box Reguler tidak bisa diaktifkan karena Box Tumbu sudah aktif!\n\nBatalkan Box Tumbu terlebih dahulu.');
        return;
    }
    
    if (componentId === 'box-tumbu' && hasBoxReguler) {
        alert('❌ Box Tumbu tidak bisa diaktifkan karena Box Reguler sudah aktif!\n\nBatalkan Box Reguler terlebih dahulu.');
        return;
    }
    
    if (componentId === 'box-tutup' && hasBoxReguler) {
        alert('❌ Box Tutup hanya bisa digunakan dengan Box Tumbu!\n\nBatalkan Box Reguler dan aktifkan Box Tumbu terlebih dahulu.');
        return;
    }
    
    if (componentId === 'box-tutup' && !hasBoxTumbu) {
        alert('❌ Box Tutup membutuhkan Box Tumbu!\n\nAktifkan Box Tumbu terlebih dahulu.');
        return;
    }
    
    let displayName = component.name;
    if (instanceNum && instanceNum > 1) {
        displayName = `${component.name} #${instanceNum}`;
    }
    
    document.getElementById('modal-component-id').value = componentId;
    document.getElementById('modal-component-name').textContent = displayName;
    
    const existingData = componentsData[componentId];
    
    let modalContent = `
        <div class="alert alert-info mb-3">
            <strong>Formula:</strong> ${component.formula}
            ${instanceNum ? `<br><strong>Instance:</strong> #${instanceNum}` : ''}
        </div>
        
        <div class="row mb-3">
            <div class="col-md-6">
                <label class="form-label">Price/M² <span class="text-danger">*</span></label>
                <input type="number" class="form-control" id="modal-price-m2" value="${existingData?.price_m2 || component.defaultPrice}" step="0.01">
            </div>
            <div class="col-md-6">
                <label class="form-label">Kebutuhan/Unit <span class="text-danger">*</span></label>
                <input type="number" class="form-control" id="modal-kebutuhan" value="${existingData?.kebutuhan_unit || 1}" min="1">
            </div>
        </div>
    `;
    
    if (component.type === 'manual') {
        if (baseComponentId === 'filler-box' || baseComponentId === 'top-pad') {
            modalContent += `
                <div class="alert alert-warning mb-3"><strong>Manual Input Required!</strong></div>
                <div class="row mb-3">
                    <div class="col-md-4">
                        <label class="form-label">PJG (mm) <span class="text-danger">*</span></label>
                        <input type="number" class="form-control" id="modal-pjg" value="${existingData?.dimensi_box?.pjg || ''}" placeholder="Masukkan PJG">
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">LBR (mm) <span class="text-danger">*</span></label>
                        <input type="number" class="form-control" id="modal-lbr" value="${existingData?.dimensi_box?.lbr || ''}" placeholder="Masukkan LBR">
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">TGI (mm) <span class="text-danger">*</span></label>
                        <input type="number" class="form-control" id="modal-tgi" value="${existingData?.dimensi_box?.tgi || ''}" placeholder="Masukkan TGI">
                    </div>
                </div>
            `;
        } else if (baseComponentId === 'filler-segitiga') {
            modalContent += `
                <div class="alert alert-warning mb-3"><strong>Manual Input:</strong> TGI otomatis = 6</div>
                <div class="row mb-3">
                    <div class="col-md-4">
                        <label class="form-label">PJG (mm) <span class="text-danger">*</span></label>
                        <input type="number" class="form-control" id="modal-pjg" value="${existingData?.dimensi_box?.pjg || ''}" placeholder="Masukkan PJG">
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">LBR (mm) <span class="text-danger">*</span></label>
                        <input type="number" class="form-control" id="modal-lbr" value="${existingData?.dimensi_box?.lbr || ''}" placeholder="Masukkan LBR">
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">TGI (Auto)</label>
                        <input type="number" class="form-control" id="modal-tgi" value="6" readonly>
                    </div>
                </div>
            `;
        }
    } else if (component.type === 'dependent') {
        if (baseComponentId.includes('layer-honeycomb')) {
            modalContent += `
                <div class="alert alert-info mb-3">
                    <strong>Auto Calculate:</strong> Dimensi dari Filler Box | TGI = 6
                </div>
                <div class="row mb-3">
                    <div class="col-md-4">
                        <label class="form-label">TGI (Auto)</label>
                        <input type="number" class="form-control" id="modal-tgi" value="6" readonly>
                    </div>
                </div>
            `;
        } else if (baseComponentId === 'support-box') {
            modalContent += `
                <div class="alert alert-info mb-3">
                    <strong>Auto Calculate:</strong> Dimensi dari Box Reguler | TGI = 50
                </div>
                <div class="row mb-3">
                    <div class="col-md-4">
                        <label class="form-label">TGI (Auto)</label>
                        <input type="number" class="form-control" id="modal-tgi" value="50" readonly>
                    </div>
                </div>
            `;
        }
    }
    
    modalContent += `
        <hr>
        <div class="row">
            <div class="col-md-4">
                <label class="form-label">M² (Auto)</label>
                <input type="text" class="form-control" id="modal-m2-display" readonly value="${existingData?.ukuran_karton?.m2 ? existingData.ukuran_karton.m2.toFixed(6) : '0.000000'}">
            </div>
            <div class="col-md-4">
                <label class="form-label">Price Karton (Auto)</label>
                <input type="text" class="form-control" id="modal-price-karton-display" readonly value="${existingData?.price_karton ? formatRupiah(existingData.price_karton) : 'Rp 0'}">
            </div>
            <div class="col-md-4">
                <label class="form-label">Harga Total (Auto)</label>
                <input type="text" class="form-control fw-bold text-success" id="modal-harga-display" readonly value="${existingData?.harga ? formatRupiah(existingData.harga) : 'Rp 0'}">
            </div>
        </div>
    `;
    
    document.getElementById('modal-component-content').innerHTML = modalContent;
    
    const inputs = ['modal-price-m2', 'modal-kebutuhan', 'modal-pjg', 'modal-lbr', 'modal-tgi'];
    inputs.forEach(inputId => {
        const input = document.getElementById(inputId);
        if (input) {
            input.addEventListener('input', () => calculateModalComponent(componentId));
        }
    });
    
    calculateModalComponent(componentId);
    
    const modal = new bootstrap.Modal(document.getElementById('editComponentModal'));
    modal.show();
}

// ============================================
// CALCULATE MODAL COMPONENT
// ============================================

function calculateModalComponent(componentId) {
    let result = null;
    let baseComponentId = componentId;
    
    if (componentId.includes('-')) {
        const match = componentId.match(/^(filler-box|filler-segitiga|layer-honeycomb-1|layer-honeycomb-2)-(\d+)$/);
        if (match) {
            baseComponentId = match[1];
        }
    }
    
    switch(baseComponentId) {
        case 'box-reguler':
            result = calculateBoxReguler();
            break;
        case 'box-tumbu':
            result = calculateBoxTumbu();
            break;
        case 'box-tutup':
            result = calculateBoxTutup();
            break;
        case 'filler-box':
            result = calculateFillerBoxModal(componentId);
            break;
        case 'layer-honeycomb-1':
            result = calculateLayerHoneycombModal(1, componentId);
            break;
        case 'layer-honeycomb-2':
            result = calculateLayerHoneycombModal(2, componentId);
            break;
        case 'filler-segitiga':
            result = calculateFillerSegitigaModal(componentId);
            break;
        case 'support-box':
            result = calculateSupportBoxModal();
            break;
        case 'top-pad':
            result = calculateTopPadModal();
            break;
    }
    
    if (result) {
        document.getElementById('modal-m2-display').value = result.ukuran_karton.m2.toFixed(6);
        document.getElementById('modal-price-karton-display').value = formatRupiah(result.price_karton);
        document.getElementById('modal-harga-display').value = formatRupiah(result.harga);
    }
}

// ============================================
// BOX CALCULATIONS
// ============================================

function calculateBoxReguler() {
    const pjg = P + 122;
    const lbr = L + 122;
    const tgi = T + 122 + 24;
    
    boxRegulerPjg = pjg;
    boxRegulerLbr = lbr;
    boxRegulerTgi = tgi;
    
    const pjgKarton = (pjg + lbr + 59) * 2;
    const lbrKarton = (lbr + tgi) + 22;
    const m2 = (pjgKarton * lbrKarton) / 1000000;
    
    const priceM2 = parseFloat(document.getElementById('modal-price-m2').value) || 0;
    const kebutuhan = parseFloat(document.getElementById('modal-kebutuhan').value) || 0;
    
    const priceKarton = priceM2 * m2;
    const harga = kebutuhan * priceKarton;
    
    return {
        jenis_box: 'BOX REGULER',
        dimensi_box: { pjg, lbr, tgi },
        ukuran_karton: { pjg: pjgKarton, lbr: lbrKarton, m2 },
        price_m2: priceM2,
        price_karton: priceKarton,
        kebutuhan_unit: kebutuhan,
        harga: harga
    };
}

function calculateBoxTumbu() {
    const pjg = P + 90;
    const lbr = L + 90;
    const tgi = T + 90;
    
    boxTumbuPjg = pjg;
    boxTumbuLbr = lbr;
    boxTumbuTgi = tgi;
    
    const pjgKarton = pjg + (2 * tgi) + 18;
    const lbrKarton = lbr + (2 * tgi) + 18;
    const m2 = (pjgKarton * lbrKarton) / 1000000;
    
    const priceM2 = parseFloat(document.getElementById('modal-price-m2').value) || 0;
    const kebutuhan = parseFloat(document.getElementById('modal-kebutuhan').value) || 0;
    
    const priceKarton = priceM2 * m2;
    const harga = kebutuhan * priceKarton;
    
    return {
        jenis_box: 'BOX TUMBU',
        dimensi_box: { pjg, lbr, tgi },
        ukuran_karton: { pjg: pjgKarton, lbr: lbrKarton, m2 },
        price_m2: priceM2,
        price_karton: priceKarton,
        kebutuhan_unit: kebutuhan,
        harga: harga
    };
}

function calculateBoxTutup() {
    const pjgTumbu = boxTumbuPjg || (P + 90);
    const lbrTumbu = boxTumbuLbr || (L + 90);
    const tgiTumbu = boxTumbuTgi || (T + 90);
    
    const pjg = pjgTumbu + 20;
    const lbr = lbrTumbu + 20;
    const tgi = tgiTumbu + 20;
    
    const pjgKarton = pjg + (2 * tgi) + 18;
    const lbrKarton = lbr + (2 * tgi) + 18;
    const m2 = (pjgKarton * lbrKarton) / 1000000;
    
    const priceM2 = parseFloat(document.getElementById('modal-price-m2').value) || 0;
    const kebutuhan = parseFloat(document.getElementById('modal-kebutuhan').value) || 0;
    
    const priceKarton = priceM2 * m2;
    const harga = kebutuhan * priceKarton;
    
    return {
        jenis_box: 'BOX TUTUP',
        dimensi_box: { pjg, lbr, tgi },
        ukuran_karton: { pjg: pjgKarton, lbr: lbrKarton, m2 },
        price_m2: priceM2,
        price_karton: priceKarton,
        kebutuhan_unit: kebutuhan,
        harga: harga
    };
}

function calculateFillerBoxModal(componentId) {
    const pjg = parseFloat(document.getElementById('modal-pjg').value) || 0;
    const lbr = parseFloat(document.getElementById('modal-lbr').value) || 0;
    const tgi = parseFloat(document.getElementById('modal-tgi').value) || 0;
    
    if (pjg === 0 || lbr === 0 || tgi === 0) return null;
    
    fillerBoxInstances[componentId] = { pjg, lbr, tgi };
    
    const pjgKarton = (pjg + lbr + 59) * 2;
    const lbrKarton = (lbr + tgi) + 22;
    const m2 = (pjgKarton * lbrKarton) / 1000000;
    
    const priceM2 = parseFloat(document.getElementById('modal-price-m2').value) || 0;
    const kebutuhan = parseFloat(document.getElementById('modal-kebutuhan').value) || 0;
    
    const priceKarton = priceM2 * m2;
    const harga = kebutuhan * priceKarton;
    
    const instanceMatch = componentId.match(/-(\d+)$/);
    const instanceNum = instanceMatch ? parseInt(instanceMatch[1]) : null;
    const displayName = instanceNum ? `FILLER BOX #${instanceNum}` : 'FILLER BOX';
    
    return {
        jenis_box: displayName,
        dimensi_box: { pjg, lbr, tgi },
        ukuran_karton: { pjg: pjgKarton, lbr: lbrKarton, m2 },
        price_m2: priceM2,
        price_karton: priceKarton,
        kebutuhan_unit: kebutuhan,
        harga: harga,
        filler_id: componentId
    };
}

function calculateLayerHoneycombModal(number, componentId) {
    const instanceMatch = componentId.match(/-(\d+)$/);
    const instanceNum = instanceMatch ? parseInt(instanceMatch[1]) : null;
    const fillerBoxId = instanceNum ? `filler-box-${instanceNum}` : 'filler-box';
    const fillerData = fillerBoxInstances[fillerBoxId];
    
    if (!fillerData) {
        alert('⚠️ Aktifkan dan isi Filler Box terlebih dahulu!');
        return null;
    }
    
    let pjg = (number === 1) ? (fillerData.pjg - 10) : (fillerData.lbr - 10);
    const lbr = fillerData.tgi;
    const tgi = 6;
    
    const pjgKarton = pjg;
    const lbrKarton = lbr + 21;
    const m2 = (pjgKarton * lbrKarton) / 1000000;
    
    const priceM2 = parseFloat(document.getElementById('modal-price-m2').value) || 0;
    const kebutuhanInput = document.getElementById('modal-kebutuhan');
    const kebutuhan = kebutuhanInput ? parseFloat(kebutuhanInput.value) || 1 : 1;
    
    const priceKarton = priceM2 * m2;
    const harga = kebutuhan * priceKarton;
    
    const displayName = instanceNum ? `LAYER HONEYCOMB ${number} #${instanceNum}` : `LAYER HONEYCOMB ${number}`;
    
    return {
        jenis_box: displayName,
        dimensi_box: { pjg, lbr, tgi },
        ukuran_karton: { pjg: pjgKarton, lbr: lbrKarton, m2 },
        price_m2: priceM2,
        price_karton: priceKarton,
        kebutuhan_unit: kebutuhan,
        harga: harga,
        parent_filler: fillerBoxId
    };
}

function calculateFillerSegitigaModal(componentId) {
    const pjg = parseFloat(document.getElementById('modal-pjg').value) || 0;
    const lbr = parseFloat(document.getElementById('modal-lbr').value) || 0;
    const tgi = 6;
    
    if (pjg === 0 || lbr === 0) return null;
    
    const pjgKarton = pjg;
    const lbrKarton = lbr + 21;
    const m2 = (pjgKarton * lbrKarton) / 1000000;
    
    const priceM2 = parseFloat(document.getElementById('modal-price-m2').value) || 0;
    const kebutuhan = parseFloat(document.getElementById('modal-kebutuhan').value) || 0;
    
    const priceKarton = priceM2 * m2;
    const harga = kebutuhan * priceKarton;
    
    const instanceMatch = componentId.match(/-(\d+)$/);
    const instanceNum = instanceMatch ? parseInt(instanceMatch[1]) : null;
    const displayName = instanceNum ? `FILLER SEGITIGA #${instanceNum}` : 'FILLER SEGITIGA';
    
    return {
        jenis_box: displayName,
        dimensi_box: { pjg, lbr, tgi },
        ukuran_karton: { pjg: pjgKarton, lbr: lbrKarton, m2 },
        price_m2: priceM2,
        price_karton: priceKarton,
        kebutuhan_unit: kebutuhan,
        harga: harga
    };
}

function calculateSupportBoxModal() {
    if (boxRegulerPjg === 0 || boxRegulerLbr === 0 || boxRegulerTgi === 0) {
        alert('⚠️ Aktifkan dan hitung Box Reguler terlebih dahulu!');
        return null;
    }
    
    const pjg = boxRegulerPjg - 10;
    const lbr = boxRegulerLbr - 10;
    const tgi = 50;
    
    const pjgKarton = ((2 * pjg) + (2 * tgi)) + 15;
    const lbrKarton = (lbr + (2 * tgi)) + 15;
    const m2 = (pjgKarton * lbrKarton) / 1000000;
    
    const priceM2 = parseFloat(document.getElementById('modal-price-m2').value) || 0;
    const kebutuhan = parseFloat(document.getElementById('modal-kebutuhan').value) || 0;
    
    const priceKarton = priceM2 * m2;
    const harga = kebutuhan * priceKarton;
    
    return {
        jenis_box: 'SUPPORT BOX',
        dimensi_box: { pjg, lbr, tgi },
        ukuran_karton: { pjg: pjgKarton, lbr: lbrKarton, m2 },
        price_m2: priceM2,
        price_karton: priceKarton,
        kebutuhan_unit: kebutuhan,
        harga: harga
    };
}

function calculateTopPadModal() {
    const pjg = parseFloat(document.getElementById('modal-pjg').value) || 0;
    const lbr = parseFloat(document.getElementById('modal-lbr').value) || 0;
    const tgi = parseFloat(document.getElementById('modal-tgi').value) || 0;
    
    if (pjg === 0 || lbr === 0 || tgi === 0) return null;
    
    const pjgKarton = (2 * tgi) + pjg + 10;
    const lbrKarton = (2 * lbr) + tgi + 10;
    const m2 = (pjgKarton * lbrKarton) / 1000000;
    
    const priceM2 = parseFloat(document.getElementById('modal-price-m2').value) || 0;
    const kebutuhan = parseFloat(document.getElementById('modal-kebutuhan').value) || 0;
    
    const priceKarton = priceM2 * m2;
    const harga = kebutuhan * priceKarton;
    
    return {
        jenis_box: 'TOP PAD',
        dimensi_box: { pjg, lbr, tgi },
        ukuran_karton: { pjg: pjgKarton, lbr: lbrKarton, m2 },
        price_m2: priceM2,
        price_karton: priceKarton,
        kebutuhan_unit: kebutuhan,
        harga: harga
    };
}

console.log('============================================');
console.log('✅ Part 5 Loaded: Open Modal + Box Calculations');
console.log('============================================');
// ============================================
// SAVE COMPONENT FROM MODAL
// ============================================

function saveComponentFromModal() {
    const componentId = document.getElementById('modal-component-id').value;
    let result = null;
    
    let baseComponentId = componentId;
    if (componentId.includes('-')) {
        const match = componentId.match(/^(filler-box|filler-segitiga|layer-honeycomb-1|layer-honeycomb-2)-(\d+)$/);
        if (match) {
            baseComponentId = match[1];
        }
    }
    
    switch(baseComponentId) {
        case 'box-reguler':
            result = calculateBoxReguler();
            break;
        case 'box-tumbu':
            result = calculateBoxTumbu();
            break;
        case 'box-tutup':
            result = calculateBoxTutup();
            break;
        case 'filler-box':
            result = calculateFillerBoxModal(componentId);
            break;
        case 'layer-honeycomb-1':
            result = calculateLayerHoneycombModal(1, componentId);
            break;
        case 'layer-honeycomb-2':
            result = calculateLayerHoneycombModal(2, componentId);
            break;
        case 'filler-segitiga':
            result = calculateFillerSegitigaModal(componentId);
            break;
        case 'support-box':
            result = calculateSupportBoxModal();
            break;
        case 'top-pad':
            result = calculateTopPadModal();
            break;
    }
    
    if (result && result.harga > 0) {
        componentsData[componentId] = result;
        
        // ✅ Auto-create Layer Honeycombs for Filler Box
        if (baseComponentId === 'filler-box') {
            const priceM2 = parseFloat(document.getElementById('modal-price-m2').value) || 10600;
            const kebutuhan = parseFloat(document.getElementById('modal-kebutuhan').value) || 1;
            autoCreateLayerHoneycombs(componentId, priceM2, kebutuhan);
        }
        
        // ✅ Show SKID Section & Recalculate SKID if Box Reguler/Tumbu saved
        if (componentId === 'box-reguler') {
            showSkidSection('reguler');
            recalculateSkidIfEnabled();
        } else if (componentId === 'box-tumbu') {
            showSkidSection('tumbu');
            recalculateSkidIfEnabled();
        }
        
        // ✅ Update box cards state (for disable logic)
        updateBoxCardsState();
        updateGrandTotal();
        
        bootstrap.Modal.getInstance(document.getElementById('editComponentModal')).hide();
        
        console.log('✅ Component saved:', componentId, result);
    } else {
        alert('❌ Perhitungan tidak valid! Pastikan semua field terisi dengan benar.');
    }
}

// ============================================
// AUTO CREATE LAYER HONEYCOMBS
// ============================================

function autoCreateLayerHoneycombs(fillerId, priceM2, kebutuhan) {
    const fillerData = fillerBoxInstances[fillerId];
    if (!fillerData) {
        console.warn('⚠️ Filler Box data not found for:', fillerId);
        return;
    }
    
    const instanceMatch = fillerId.match(/-(\d+)$/);
    const instanceNum = instanceMatch ? parseInt(instanceMatch[1]) : null;
    const layerSuffix = instanceNum ? `-${instanceNum}` : '';
    
    // ============================================
    // LAYER HONEYCOMB 1
    // ============================================
    const pjg1 = fillerData.pjg - 10;
    const lbr1 = fillerData.tgi;
    const tgi1 = 6;
    
    const pjgKarton1 = pjg1;
    const lbrKarton1 = lbr1 + 21;
    const m2_1 = (pjgKarton1 * lbrKarton1) / 1000000;
    
    const priceKarton1 = priceM2 * m2_1;
    const qty1 = 1;
    const harga1 = qty1 * priceKarton1;
    
    const displayName1 = instanceNum ? `LAYER HONEYCOMB 1 #${instanceNum}` : 'LAYER HONEYCOMB 1';
    const layer1Id = instanceNum ? `layer-honeycomb-1-${instanceNum}` : 'layer-honeycomb-1';
    
    componentsData[layer1Id] = {
        jenis_box: displayName1,
        dimensi_box: { pjg: pjg1, lbr: lbr1, tgi: tgi1 },
        ukuran_karton: { pjg: pjgKarton1, lbr: lbrKarton1, m2: m2_1 },
        price_m2: priceM2,
        price_karton: priceKarton1,
        kebutuhan_unit: qty1,
        harga: harga1,
        parent_filler: fillerId,
        enabled: true
    };
    
    // ============================================
    // LAYER HONEYCOMB 2
    // ============================================
    const pjg2 = fillerData.lbr - 10;
    const lbr2 = fillerData.tgi;
    const tgi2 = 6;
    
    const pjgKarton2 = pjg2;
    const lbrKarton2 = lbr2 + 21;
    const m2_2 = (pjgKarton2 * lbrKarton2) / 1000000;
    
    const priceKarton2 = priceM2 * m2_2;
    const qty2 = 1;
    const harga2 = qty2 * priceKarton2;
    
    const displayName2 = instanceNum ? `LAYER HONEYCOMB 2 #${instanceNum}` : 'LAYER HONEYCOMB 2';
    const layer2Id = instanceNum ? `layer-honeycomb-2-${instanceNum}` : 'layer-honeycomb-2';
    
    componentsData[layer2Id] = {
        jenis_box: displayName2,
        dimensi_box: { pjg: pjg2, lbr: lbr2, tgi: tgi2 },
        ukuran_karton: { pjg: pjgKarton2, lbr: lbrKarton2, m2: m2_2 },
        price_m2: priceM2,
        price_karton: priceKarton2,
        kebutuhan_unit: qty2,
        harga: harga2,
        parent_filler: fillerId,
        enabled: true
    };
    
    console.log(`✅ Auto-created Layer Honeycombs for ${fillerId}`);
}

console.log('============================================');
console.log('✅ Part 6 Loaded: Save Component + Auto Layer Honeycomb');
console.log('============================================');
// ============================================
// KOMPONEN PENDUKUNG FUNCTIONS
// ============================================

function openKomponenPendukungModal() {
    document.getElementById('komponen-pendukung-edit-index').value = '';
    document.getElementById('komponen-pendukung-product-select').value = '';
    document.getElementById('komponen-pendukung-kode').value = '';
    document.getElementById('komponen-pendukung-nama').value = '';
    
    document.getElementById('komponen_mode_pilihan').checked = true;
    document.getElementById('komponen_pricing_type_pcs').checked = true;
    
    document.getElementById('komponen-pendukung-harga-asli').value = '';
    document.getElementById('komponen-pendukung-pjg').value = '';
    document.getElementById('komponen-pendukung-lbr').value = '';
    document.getElementById('komponen-pendukung-tgi').value = '';
    document.getElementById('komponen-pendukung-m2').value = '';
    document.getElementById('komponen-pendukung-harga-m2-display').value = '';
    document.getElementById('komponen-pendukung-qty').value = 1;
    document.getElementById('komponen-pendukung-harga-finished-display').value = '';
    document.getElementById('komponen-pendukung-total').value = '';
    
    document.getElementById('komponen-pendukung-mode').value = 'pilihan';
    document.getElementById('komponen-pendukung-harga-m2-master').value = '0';
    document.getElementById('komponen-pendukung-harga-finished-master').value = '0';
    
    toggleKomponenInputMode();
    toggleKomponenPricingFields();
    resetPricingTypeButtons();
    
    const modal = new bootstrap.Modal(document.getElementById('komponenPendukungModal'));
    modal.show();
}

function toggleKomponenInputMode() {
    const mode = document.querySelector('input[name="komponen_input_mode"]:checked').value;
    
    const pilihanSection = document.getElementById('komponen-mode-pilihan-section');
    const manualSection = document.getElementById('komponen-mode-manual-section');
    
    const kodeInput = document.getElementById('komponen-pendukung-kode');
    const namaInput = document.getElementById('komponen-pendukung-nama');
    const hargaAsliInput = document.getElementById('komponen-pendukung-harga-asli');
    const tgiInput = document.getElementById('komponen-pendukung-tgi');
    const tgiLabel = document.getElementById('komponen-tgi-label');
    
    document.getElementById('komponen-pendukung-mode').value = mode;
    
    if (mode === 'pilihan') {
        pilihanSection.style.display = 'block';
        manualSection.style.display = 'none';
        
        kodeInput.readOnly = true;
        namaInput.readOnly = true;
        hargaAsliInput.readOnly = true;
        tgiInput.readOnly = true;
        
        tgiLabel.textContent = '(Auto dari Product)';
        
        document.getElementById('komponen-pendukung-product-select').value = '';
        
        resetPricingTypeButtons();
        
    } else {
        pilihanSection.style.display = 'none';
        manualSection.style.display = 'block';
        
        kodeInput.readOnly = false;
        namaInput.readOnly = false;
        hargaAsliInput.readOnly = false;
        
        const pricingType = document.querySelector('input[name="komponen_pricing_type"]:checked').value;
        if (pricingType === 'm2') {
            tgiInput.readOnly = false;
            tgiLabel.textContent = '(Optional)';
        }
        
        kodeInput.value = '';
        namaInput.value = '';
        hargaAsliInput.value = '';
        document.getElementById('komponen-pendukung-pjg').value = '';
        document.getElementById('komponen-pendukung-lbr').value = '';
        document.getElementById('komponen-pendukung-tgi').value = '';
        
        document.getElementById('komponen-pendukung-harga-m2-master').value = '0';
        document.getElementById('komponen-pendukung-harga-finished-master').value = '0';
        
        resetPricingTypeButtons();
    }
    
    calculateKomponenPendukung();
}

function resetPricingTypeButtons() {
    const pcsRadio = document.getElementById('komponen_pricing_type_pcs');
    const m2Radio = document.getElementById('komponen_pricing_type_m2');
    const pcsLabel = document.querySelector('label[for="komponen_pricing_type_pcs"]');
    const m2Label = document.querySelector('label[for="komponen_pricing_type_m2"]');
    
    pcsRadio.checked = true;
    m2Radio.checked = false;
    
    pcsRadio.disabled = false;
    m2Radio.disabled = false;
    
    pcsLabel.style.display = 'inline-block';
    m2Label.style.display = 'inline-block';
}

function toggleKomponenPricingFields() {
    const pricingType = document.querySelector('input[name="komponen_pricing_type"]:checked').value;
    const mode = document.getElementById('komponen-pendukung-mode').value;
    
    const pjgInput = document.getElementById('komponen-pendukung-pjg');
    const lbrInput = document.getElementById('komponen-pendukung-lbr');
    const tgiInput = document.getElementById('komponen-pendukung-tgi');
    
    const pjgRequired = document.getElementById('komponen-pjg-required');
    const pjgOptional = document.getElementById('komponen-pjg-optional');
    const lbrRequired = document.getElementById('komponen-lbr-required');
    const lbrOptional = document.getElementById('komponen-lbr-optional');
    const hargaM2Field = document.getElementById('komponen-harga-m2-field');
    const tgiLabel = document.getElementById('komponen-tgi-label');
    
    const hargaM2Info = document.getElementById('komponen-harga-m2-info');
    const hargaFinishedInfo = document.getElementById('komponen-harga-finished-info');
    
    const dimensiRow = document.getElementById('komponen-dimensi-row');
    
    if (pricingType === 'm2') {
        dimensiRow.style.display = 'flex';
        pjgRequired.style.display = 'inline';
        pjgOptional.style.display = 'none';
        lbrRequired.style.display = 'inline';
        lbrOptional.style.display = 'none';
        hargaM2Field.style.display = 'flex';
        
        if (mode === 'pilihan') {
            tgiInput.readOnly = true;
            tgiLabel.textContent = '(Auto dari Product)';
            hargaM2Info.textContent = '(Paten dari Master)';
            hargaFinishedInfo.textContent = '(Paten dari Master)';
        } else {
            tgiInput.readOnly = false;
            tgiLabel.textContent = '(Optional)';
            hargaM2Info.textContent = '(Auto Calculate)';
            hargaFinishedInfo.textContent = '(Auto Calculate)';
        }
        
        pjgInput.readOnly = false;
        lbrInput.readOnly = false;
        
    } else {
        dimensiRow.style.display = 'none';
        hargaM2Field.style.display = 'none';
        
        pjgInput.value = '';
        lbrInput.value = '';
        tgiInput.value = '';
        document.getElementById('komponen-pendukung-m2').value = '';
        
        hargaFinishedInfo.textContent = mode === 'pilihan' ? '(Paten dari Master)' : '(Auto Calculate)';
    }
    
    calculateKomponenPendukung();
}

function selectProductPendukung() {
    const select = document.getElementById('komponen-pendukung-product-select');
    const selectedOption = select.options[select.selectedIndex];
    
    if (select.value) {
        const pricingType = selectedOption.dataset.pricingType;
        const description = selectedOption.dataset.description;
        
        document.getElementById('komponen-pendukung-kode').value = selectedOption.dataset.materialCode;
        document.getElementById('komponen-pendukung-nama').value = description;
        document.getElementById('komponen-pendukung-harga-asli').value = selectedOption.dataset.hargaAsli || '';
        document.getElementById('komponen-pendukung-pjg').value = selectedOption.dataset.panjang || '';
        document.getElementById('komponen-pendukung-lbr').value = selectedOption.dataset.lebar || '';
        
        const tgiMatch = description.match(/X(\d+)MM/i);
        const tgiValue = tgiMatch ? parseInt(tgiMatch[1]) : 0;
        document.getElementById('komponen-pendukung-tgi').value = tgiValue || '';
        
        const hargaM2Master = parseFloat(selectedOption.dataset.hargaM2) || 0;
        const hargaFinishedMaster = parseFloat(selectedOption.dataset.hargaFinished) || 0;
        
        document.getElementById('komponen-pendukung-harga-m2-master').value = hargaM2Master;
        document.getElementById('komponen-pendukung-harga-finished-master').value = hargaFinishedMaster;
        
        const pcsRadio = document.getElementById('komponen_pricing_type_pcs');
        const m2Radio = document.getElementById('komponen_pricing_type_m2');
        const pcsLabel = document.querySelector('label[for="komponen_pricing_type_pcs"]');
        const m2Label = document.querySelector('label[for="komponen_pricing_type_m2"]');
        
        if (pricingType === 'm2') {
            m2Radio.checked = true;
            pcsRadio.checked = false;
            pcsRadio.disabled = true;
            m2Radio.disabled = false;
            pcsLabel.style.display = 'none';
            m2Label.style.display = 'inline-block';
        } else {
            pcsRadio.checked = true;
            m2Radio.checked = false;
            pcsRadio.disabled = false;
            m2Radio.disabled = true;
            pcsLabel.style.display = 'inline-block';
            m2Label.style.display = 'none';
        }
        
        toggleKomponenPricingFields();
        calculateKomponenPendukung();
        
        console.log('✅ Product selected:', {
            kode: selectedOption.dataset.materialCode,
            nama: description,
            pricing_type: pricingType,
            harga_asli: selectedOption.dataset.hargaAsli,
            tgi: tgiValue,
            harga_m2_master: hargaM2Master,
            harga_finished_master: hargaFinishedMaster
        });
    } else {
        resetPricingTypeButtons();
    }
}

function calculateKomponenPendukung() {
    const mode = document.getElementById('komponen-pendukung-mode').value;
    const pricingType = document.querySelector('input[name="komponen_pricing_type"]:checked').value;
    const hargaAsli = parseFloat(document.getElementById('komponen-pendukung-harga-asli').value) || 0;
    const pjg = parseFloat(document.getElementById('komponen-pendukung-pjg').value) || 0;
    const lbr = parseFloat(document.getElementById('komponen-pendukung-lbr').value) || 0;
    
    let m2 = 0;
    if (pjg > 0 && lbr > 0) {
        m2 = (pjg * lbr) / 1000000;
        document.getElementById('komponen-pendukung-m2').value = m2.toFixed(4);
    } else {
        document.getElementById('komponen-pendukung-m2').value = '';
    }
    
    let hargaM2 = 0;
    let hargaFinished = 0;
    
    if (pricingType === 'm2') {
        if (mode === 'pilihan') {
            const hargaM2Master = parseFloat(document.getElementById('komponen-pendukung-harga-m2-master').value) || 0;
            const hargaFinishedMaster = parseFloat(document.getElementById('komponen-pendukung-harga-finished-master').value) || 0;
            
            hargaM2 = hargaM2Master;
            hargaFinished = hargaFinishedMaster;
            
            document.getElementById('komponen-pendukung-harga-m2-display').value = hargaM2 > 0 ? Math.round(hargaM2).toLocaleString('id-ID') : '';
            document.getElementById('komponen-pendukung-harga-finished-display').value = hargaFinished > 0 ? Math.round(hargaFinished).toLocaleString('id-ID') : '';
            
        } else {
            if (m2 > 0 && hargaAsli > 0) {
                hargaM2 = hargaAsli / m2;
                document.getElementById('komponen-pendukung-harga-m2-display').value = Math.round(hargaM2).toLocaleString('id-ID');
                
                const step1 = hargaM2 / 0.8;
                const step2 = step1 / 1000;
                const step3 = Math.ceil(step2 * 10) / 10;
                hargaFinished = step3 * 1000;
                
                document.getElementById('komponen-pendukung-harga-finished-display').value = Math.round(hargaFinished).toLocaleString('id-ID');
            } else {
                document.getElementById('komponen-pendukung-harga-m2-display').value = '';
                document.getElementById('komponen-pendukung-harga-finished-display').value = '';
            }
        }
    } else {
        if (mode === 'pilihan') {
            const hargaFinishedMaster = parseFloat(document.getElementById('komponen-pendukung-harga-finished-master').value) || 0;
            hargaFinished = hargaFinishedMaster;
            
            document.getElementById('komponen-pendukung-harga-finished-display').value = hargaFinished > 0 ? Math.round(hargaFinished).toLocaleString('id-ID') : '';
            
        } else {
            if (hargaAsli > 0) {
                const step1 = hargaAsli / 0.6;
                const step2 = step1 / 1000;
                const step3 = Math.ceil(step2 * 10) / 10;
                hargaFinished = step3 * 1000;
                
                document.getElementById('komponen-pendukung-harga-finished-display').value = Math.round(hargaFinished).toLocaleString('id-ID');
            } else {
                document.getElementById('komponen-pendukung-harga-finished-display').value = '';
            }
        }
        
        document.getElementById('komponen-pendukung-harga-m2-display').value = '';
    }
    
    calculateKomponenPendukungTotal();
}

function calculateKomponenPendukungTotal() {
    const mode = document.getElementById('komponen-pendukung-mode').value;
    const pricingType = document.querySelector('input[name="komponen_pricing_type"]:checked').value;
    const qty = parseFloat(document.getElementById('komponen-pendukung-qty').value) || 0;
    const hargaFinishedText = document.getElementById('komponen-pendukung-harga-finished-display').value.replace(/\./g, '');
    const hargaFinished = parseFloat(hargaFinishedText) || 0;
    
    let total = 0;
    
    if (pricingType === 'm2' && mode === 'pilihan') {
        const m2 = parseFloat(document.getElementById('komponen-pendukung-m2').value) || 0;
        total = m2 * hargaFinished * qty;
    } else {
        total = qty * hargaFinished;
    }
    
    document.getElementById('komponen-pendukung-total').value = total > 0 ? Math.round(total).toLocaleString('id-ID') : '';
}

function saveKomponenPendukung() {
    const kode = document.getElementById('komponen-pendukung-kode').value.trim();
    const nama = document.getElementById('komponen-pendukung-nama').value.trim();
    const mode = document.getElementById('komponen-pendukung-mode').value;
    const pricingType = document.querySelector('input[name="komponen_pricing_type"]:checked').value;
    const hargaAsli = parseFloat(document.getElementById('komponen-pendukung-harga-asli').value) || 0;
    const pjg = parseFloat(document.getElementById('komponen-pendukung-pjg').value) || 0;
    const lbr = parseFloat(document.getElementById('komponen-pendukung-lbr').value) || 0;
    const tgi = parseFloat(document.getElementById('komponen-pendukung-tgi').value) || 0;
    const m2 = parseFloat(document.getElementById('komponen-pendukung-m2').value) || 0;
    const qty = parseFloat(document.getElementById('komponen-pendukung-qty').value) || 0;
    
    const hargaFinishedText = document.getElementById('komponen-pendukung-harga-finished-display').value.replace(/\./g, '');
    const hargaFinished = parseFloat(hargaFinishedText) || 0;
    
    const totalText = document.getElementById('komponen-pendukung-total').value.replace(/\./g, '');
    const total = parseFloat(totalText) || 0;
    
    if (!kode) {
        alert('❌ Kode Barang harus diisi!');
        return;
    }
    
    if (!nama) {
        alert('❌ Nama harus diisi!');
        return;
    }
    
    if (hargaAsli <= 0) {
        alert('❌ Harga Asli harus diisi dan lebih dari 0!');
        return;
    }
    
    if (qty <= 0) {
        alert('❌ Qty harus lebih dari 0!');
        return;
    }
    
    if (pricingType === 'm2') {
        if (pjg <= 0 || lbr <= 0) {
            alert('❌ Untuk tipe M2, PJG dan LBR harus diisi!');
            return;
        }
    }
    
    if (hargaFinished <= 0) {
        alert('❌ Harga Finished tidak valid! Pastikan semua input sudah benar.');
        return;
    }
    
    if (total <= 0) {
        alert('❌ Total harga tidak valid!');
        return;
    }
    
    const editIdx = document.getElementById('komponen-pendukung-edit-index').value;
    
    const itemData = {
        material_code: kode,
        nama: nama,
        pricing_type: pricingType,
        harga_asli: hargaAsli,
        pjg: pjg,
        lbr: lbr,
        tgi: tgi,
        m2: m2,
        qty: qty,
        harga_finished: hargaFinished,
        total: total,
        from_master: mode === 'pilihan'
    };
    
    if (editIdx !== '') {
        const index = parseInt(editIdx);
        komponenPendukungItems[index] = itemData;
    } else {
        komponenPendukungItems.push(itemData);
    }
    
    renderKomponenPendukung();
    updateGrandTotal();
    
    bootstrap.Modal.getInstance(document.getElementById('komponenPendukungModal')).hide();
    
    console.log('✅ Komponen Pendukung saved:', komponenPendukungItems);
}

function renderKomponenPendukung() {
    const container = document.getElementById('komponen-pendukung-container');
    
    if (komponenPendukungItems.length === 0) {
        document.getElementById('no-komponen-pendukung-message').style.display = 'block';
        container.innerHTML = '';
        return;
    }
    
    document.getElementById('no-komponen-pendukung-message').style.display = 'none';
    
    container.innerHTML = komponenPendukungItems.map((item, index) => `
        <div class="komponen-pendukung-card">
            <div class="d-flex align-items-start gap-3">
                <div class="flex-grow-1">
                    <div class="komponen-kode">${item.material_code}</div>
                    <div class="komponen-nama">${item.nama}</div>
                    <div class="mt-2">
                        ${item.pricing_type === 'pcs' 
                            ? '<span class="badge bg-success">Harga PCS</span>' 
                            : '<span class="badge bg-info">Harga M2</span>'}
                        ${item.pricing_type === 'm2' && item.pjg && item.lbr 
                            ? `<span class="komponen-dimensi ms-2">📐 ${item.pjg}×${item.lbr}${item.tgi ? '×' + item.tgi : ''} mm${item.m2 ? ' | ' + item.m2.toFixed(4) + ' m²' : ''}</span>` 
                            : ''}
                    </div>
                </div>
                <div class="text-center" style="min-width: 80px;">
                    <label class="form-label small mb-1">Qty:</label>
                    <div class="fw-bold">${item.qty}</div>
                </div>
                <div class="text-center" style="min-width: 120px;">
                    <label class="form-label small mb-1">Harga Finished:</label>
                    <div class="fw-bold text-success">${formatRupiah(item.harga_finished)}</div>
                </div>
                <div class="text-end" style="min-width: 120px;">
                    <label class="form-label small mb-1">Total:</label>
                    <div class="fw-bold text-success fs-6">${formatRupiah(item.total)}</div>
                </div>
                <div class="d-flex flex-column gap-1">
                    <button type="button" 
                            class="btn btn-sm btn-warning" 
                            onclick="editKomponenPendukung(${index})"
                            title="Edit">
                        <i class="fas fa-edit"></i>
                    </button>
                    <button type="button" 
                            class="btn btn-sm btn-danger" 
                            onclick="removeKomponenPendukung(${index})"
                            title="Hapus">
                        <i class="fas fa-trash"></i>
                    </button>
                </div>
            </div>
        </div>
    `).join('');
}

function editKomponenPendukung(index) {
    const item = komponenPendukungItems[index];
    
    document.getElementById('komponen-pendukung-edit-index').value = index;
    document.getElementById('komponen-pendukung-product-select').value = '';
    document.getElementById('komponen-pendukung-kode').value = item.material_code;
    document.getElementById('komponen-pendukung-nama').value = item.nama;
    
    const pcsRadio = document.getElementById('komponen_pricing_type_pcs');
    const m2Radio = document.getElementById('komponen_pricing_type_m2');
    const pcsLabel = document.querySelector('label[for="komponen_pricing_type_pcs"]');
    const m2Label = document.querySelector('label[for="komponen_pricing_type_m2"]');
    
    if (item.pricing_type === 'm2') {
        m2Radio.checked = true;
        pcsRadio.checked = false;
        
        if (item.from_master) {
            pcsRadio.disabled = true;
            m2Radio.disabled = false;
            pcsLabel.style.display = 'none';
            m2Label.style.display = 'inline-block';
        } else {
            resetPricingTypeButtons();
        }
    } else {
        pcsRadio.checked = true;
        m2Radio.checked = false;
        
        if (item.from_master) {
            pcsRadio.disabled = false;
            m2Radio.disabled = true;
            pcsLabel.style.display = 'inline-block';
            m2Label.style.display = 'none';
        } else {
            resetPricingTypeButtons();
        }
    }
    
    document.getElementById('komponen-pendukung-harga-asli').value = item.harga_asli || '';
    document.getElementById('komponen-pendukung-pjg').value = item.pjg || '';
    document.getElementById('komponen-pendukung-lbr').value = item.lbr || '';
    document.getElementById('komponen-pendukung-tgi').value = item.tgi || '';
    document.getElementById('komponen-pendukung-qty').value = item.qty;
    
    toggleKomponenPricingFields();
    calculateKomponenPendukung();
    
    const modal = new bootstrap.Modal(document.getElementById('komponenPendukungModal'));
    modal.show();
}

function removeKomponenPendukung(index) {
    if (!confirm('Yakin ingin menghapus komponen pendukung ini?')) return;
    
    komponenPendukungItems.splice(index, 1);
    renderKomponenPendukung();
    updateGrandTotal();
}

console.log('============================================');
console.log('✅ Part 7 Loaded: Komponen Pendukung Functions (COMPLETE)');
console.log('============================================');
// ============================================
// ✅ LOAD EXISTING DATA FROM DATABASE (WITH SKID)
// ============================================

function loadExistingData() {
    const boxDataRaw = @json($invoiceBox->box_data);
    
    console.log('============================================');
    console.log('📦 Loading existing box data...');
    console.log('============================================');
    
    if (!boxDataRaw) {
        console.warn('⚠️ No box data found');
        return;
    }
    
    let boxData;
    if (typeof boxDataRaw === 'string') {
        boxData = JSON.parse(boxDataRaw);
    } else {
        boxData = boxDataRaw;
    }
    
    console.log('Raw Box Data:', boxData);
    
    // ============================================
    // LOAD COMPONENTS
    // ============================================
    
    if (boxData.components && Array.isArray(boxData.components)) {
        console.log('📦 Loading components:', boxData.components.length);
        
        boxData.components.forEach((component, index) => {
            console.log(`Component ${index}:`, component);
            
            let key;
            if (component.filler_id) {
                key = component.filler_id;
            } else {
                const jenisLower = component.jenis_box.toLowerCase();
                
                if (jenisLower.includes('filler box')) {
                    const match = component.jenis_box.match(/#(\d+)/);
                    key = match ? `filler-box-${match[1]}` : 'filler-box-1';
                } else if (jenisLower.includes('filler segitiga')) {
                    const match = component.jenis_box.match(/#(\d+)/);
                    key = match ? `filler-segitiga-${match[1]}` : 'filler-segitiga-1';
                } else if (jenisLower.includes('layer honeycomb 1')) {
                    const match = component.jenis_box.match(/#(\d+)/);
                    key = match ? `layer-honeycomb-1-${match[1]}` : 'layer-honeycomb-1';
                } else if (jenisLower.includes('layer honeycomb 2')) {
                    const match = component.jenis_box.match(/#(\d+)/);
                    key = match ? `layer-honeycomb-2-${match[1]}` : 'layer-honeycomb-2';
                } else {
                    key = jenisLower.replace(/ /g, '-');
                }
            }
            
            console.log(`Generated key: ${key}`);
            componentsData[key] = component;
            
            if (component.jenis_box && component.jenis_box.includes('FILLER BOX')) {
                const match = component.jenis_box.match(/#(\d+)/);
                if (match) {
                    const num = parseInt(match[1]);
                    fillerBoxCounter = Math.max(fillerBoxCounter, num);
                    fillerBoxInstances[`filler-box-${num}`] = component.dimensi_box;
                } else if (!component.jenis_box.includes('#')) {
                    fillerBoxCounter = Math.max(fillerBoxCounter, 1);
                    fillerBoxInstances['filler-box-1'] = component.dimensi_box;
                }
            }
            
            if (component.jenis_box && component.jenis_box.includes('FILLER SEGITIGA')) {
                const match = component.jenis_box.match(/#(\d+)/);
                if (match) {
                    const num = parseInt(match[1]);
                    fillerSegitigaCounter = Math.max(fillerSegitigaCounter, num);
                } else if (!component.jenis_box.includes('#')) {
                    fillerSegitigaCounter = Math.max(fillerSegitigaCounter, 1);
                }
            }
            
            if (component.jenis_box === 'BOX REGULER') {
                boxRegulerPjg = component.dimensi_box.pjg;
                boxRegulerLbr = component.dimensi_box.lbr;
                boxRegulerTgi = component.dimensi_box.tgi;
                document.getElementById('skid-box-reguler-section').style.display = 'block';
            }
            
            if (component.jenis_box === 'BOX TUMBU') {
                boxTumbuPjg = component.dimensi_box.pjg;
                boxTumbuLbr = component.dimensi_box.lbr;
                boxTumbuTgi = component.dimensi_box.tgi;
                document.getElementById('skid-box-tumbu-section').style.display = 'block';
            }
        });
        
        console.log('✅ componentsData loaded:', componentsData);
        console.log('✅ Filler counters:', { fillerBox: fillerBoxCounter, fillerSegitiga: fillerSegitigaCounter });
    }
    
    // ============================================
    // ✅ LOAD KOMPONEN PENDUKUNG (SEPARATE SKID FROM REGULAR)
    // ============================================
    
    if (boxData.komponen_pendukung && Array.isArray(boxData.komponen_pendukung)) {
        console.log('📦 Loading komponen pendukung:', boxData.komponen_pendukung.length);
        
        boxData.komponen_pendukung.forEach(item => {
            if (item.is_skid === true) {
                const skidType = item.skid_type;
                
                if (skidType === 'box_reguler_pjg') {
                    skidBoxRegulerData.pjg.qty = item.qty || 2;
                    skidBoxRegulerData.pjg.pjg_dimensi = item.pjg || 0;
                    skidBoxRegulerData.pjg.lbr_dimensi = item.lbr || 120;
                    skidBoxRegulerData.pjg.tbl_dimensi = item.tgi || 12;
                    skidBoxRegulerData.pjg.m2 = item.m2 || 0;
                    skidBoxRegulerData.pjg.total = item.total || 0;
                    skidBoxRegulerData.enabled = true;
                } else if (skidType === 'box_reguler_lbr') {
                    skidBoxRegulerData.lbr.qty = item.qty || 6;
                    skidBoxRegulerData.lbr.pjg_dimensi = item.pjg || 0;
                    skidBoxRegulerData.lbr.lbr_dimensi = item.lbr || 120;
                    skidBoxRegulerData.lbr.tbl_dimensi = item.tgi || 12;
                    skidBoxRegulerData.lbr.m2 = item.m2 || 0;
                    skidBoxRegulerData.lbr.total = item.total || 0;
                    skidBoxRegulerData.enabled = true;
                } else if (skidType === 'box_tumbu_pjg') {
                    skidBoxTumbuData.pjg.qty = item.qty || 2;
                    skidBoxTumbuData.pjg.pjg_dimensi = item.pjg || 0;
                    skidBoxTumbuData.pjg.lbr_dimensi = item.lbr || 0;
                    skidBoxTumbuData.pjg.tbl_dimensi = item.tgi || 2.4;
                    skidBoxTumbuData.pjg.m2 = item.m2 || 0;
                    skidBoxTumbuData.pjg.total = item.total || 0;
                    skidBoxTumbuData.enabled = true;
                } else if (skidType === 'box_tumbu_lbr') {
                    skidBoxTumbuData.lbr.qty = item.qty || 2;
                    skidBoxTumbuData.lbr.pjg_dimensi = item.pjg || 0;
                    skidBoxTumbuData.lbr.lbr_dimensi = item.lbr || 0;
                    skidBoxTumbuData.lbr.tbl_dimensi = item.tgi || 2.4;
                    skidBoxTumbuData.lbr.m2 = item.m2 || 0;
                    skidBoxTumbuData.lbr.total = item.total || 0;
                    skidBoxTumbuData.enabled = true;
                }
            } else {
                komponenPendukungItems.push({
                    material_code: item.material_code,
                    nama: item.nama,
                    pricing_type: item.pricing_type || 'pcs',
                    harga_asli: item.harga_asli || 0,
                    pjg: item.pjg || 0,
                    lbr: item.lbr || 0,
                    tgi: item.tgi || 0,
                    m2: item.m2 || 0,
                    qty: item.qty,
                    harga_finished: item.harga_finished || 0,
                    total: item.total,
                    from_master: item.from_master || false
                });
            }
        });
        
        if (skidBoxRegulerData.enabled) {
            document.getElementById('skid-box-reguler-checkbox').checked = true;
            document.getElementById('skid-box-reguler-detail').style.display = 'block';
            
            document.getElementById('skid-box-reguler-pjg-qty').value = skidBoxRegulerData.pjg.qty;
            document.getElementById('skid-box-reguler-pjg-dimensi-pjg').value = skidBoxRegulerData.pjg.pjg_dimensi;
            document.getElementById('skid-box-reguler-pjg-total').value = formatRupiah(skidBoxRegulerData.pjg.total);
            
            document.getElementById('skid-box-reguler-lbr-qty').value = skidBoxRegulerData.lbr.qty;
            document.getElementById('skid-box-reguler-lbr-dimensi-pjg').value = skidBoxRegulerData.lbr.pjg_dimensi;
            document.getElementById('skid-box-reguler-lbr-total').value = formatRupiah(skidBoxRegulerData.lbr.total);
            
            skidBoxRegulerData.total = skidBoxRegulerData.pjg.total + skidBoxRegulerData.lbr.total;
            document.getElementById('skid-box-reguler-grand-total').textContent = formatRupiah(skidBoxRegulerData.total);
            
            console.log('✅ SKID Box Reguler loaded:', skidBoxRegulerData);
        }
        
        if (skidBoxTumbuData.enabled) {
            document.getElementById('skid-box-tumbu-checkbox').checked = true;
            document.getElementById('skid-box-tumbu-detail').style.display = 'block';
            
            document.getElementById('skid-box-tumbu-pjg-qty').value = skidBoxTumbuData.pjg.qty;
            document.getElementById('skid-box-tumbu-pjg-dimensi-pjg').value = skidBoxTumbuData.pjg.pjg_dimensi;
            document.getElementById('skid-box-tumbu-pjg-dimensi-lbr').value = skidBoxTumbuData.pjg.lbr_dimensi;
            document.getElementById('skid-box-tumbu-pjg-total').value = formatRupiah(skidBoxTumbuData.pjg.total);
            
            document.getElementById('skid-box-tumbu-lbr-qty').value = skidBoxTumbuData.lbr.qty;
            document.getElementById('skid-box-tumbu-lbr-dimensi-pjg').value = skidBoxTumbuData.lbr.pjg_dimensi;
            document.getElementById('skid-box-tumbu-lbr-dimensi-lbr').value = skidBoxTumbuData.lbr.lbr_dimensi;
            document.getElementById('skid-box-tumbu-lbr-total').value = formatRupiah(skidBoxTumbuData.lbr.total);
            
            skidBoxTumbuData.total = skidBoxTumbuData.pjg.total + skidBoxTumbuData.lbr.total;
            document.getElementById('skid-box-tumbu-grand-total').textContent = formatRupiah(skidBoxTumbuData.total);
            
            console.log('✅ SKID Box Tumbu loaded:', skidBoxTumbuData);
        }
        
        console.log('✅ komponenPendukungItems loaded:', komponenPendukungItems);
    }
    
    // ============================================
    // ✅ LOAD PENUNJANG (UPDATE QTY IF EXISTS)
    // ============================================
    
    if (boxData.penunjang && boxData.penunjang.enabled) {
        penunjangData.qty = boxData.penunjang.qty || 1;
        penunjangData.total = boxData.penunjang.total || penunjangData.harga;
        
        document.getElementById('penunjang-qty').value = penunjangData.qty;
        document.getElementById('penunjang-total-display').value = penunjangData.total.toLocaleString('id-ID');
        
        console.log('✅ Penunjang loaded (qty updated):', penunjangData);
    }
    
    // ============================================
    // LOAD PALLET
    // ============================================
    
    if (boxData.pallet && boxData.pallet.enabled) {
        palletData = boxData.pallet;
        document.getElementById('pallet-checkbox').checked = true;
        document.getElementById('pallet-detail').style.display = 'block';
        document.getElementById('pallet-qty').value = palletData.qty;
        document.getElementById('pallet-total-display').value = palletData.total.toLocaleString('id-ID');
        console.log('✅ Pallet loaded:', palletData);
    }
    
    // ============================================
    // RENDER ALL
    // ============================================
    
    console.log('🎨 Rendering box cards...');
    renderBoxCards();
    
    console.log('🎨 Rendering komponen pendukung...');
    renderKomponenPendukung();
    
    console.log('💰 Updating grand total...');
    updateGrandTotal();
    
    console.log('============================================');
    console.log('✅ Data loaded successfully:', {
        components: Object.keys(componentsData).length,
        komponenPendukung: komponenPendukungItems.length,
        skidReguler: skidBoxRegulerData.enabled,
        skidTumbu: skidBoxTumbuData.enabled,
        penunjang: penunjangData.enabled,
        pallet: palletData.enabled
    });
    console.log('============================================');
}

// ============================================
// ✅ UPDATE INVOICE BOX - AJAX SUBMIT (WITH SKID)
// ============================================

function updateInvoiceBox() {
    if (Object.keys(componentsData).length === 0 && komponenPendukungItems.length === 0) {
        alert('❌ Minimal harus ada 1 komponen box atau komponen pendukung!');
        return;
    }
    
    for (let i = 0; i < komponenPendukungItems.length; i++) {
        const item = komponenPendukungItems[i];
        
        if (item.harga_finished <= 0 || item.total <= 0) {
            alert(`❌ Komponen Pendukung "${item.nama}" memiliki harga tidak valid! Silakan edit ulang.`);
            return;
        }
        
        if (item.pricing_type === 'm2' && (!item.pjg || !item.lbr || item.m2 <= 0)) {
            alert(`❌ Komponen Pendukung "${item.nama}" dengan tipe M2 harus memiliki dimensi PJG dan LBR!`);
            return;
        }
    }
    
    // ✅ PREPARE SKID DATA FOR SAVE
    const skidDataToSave = [];
    
    if (skidBoxRegulerData.enabled) {
        skidDataToSave.push({
            material_code: 'SKID-REGULER-PJG',
            nama: 'SKID PLYWOOD POPLAR PJG',
            pricing_type: 'm2',
            harga_asli: skidBoxRegulerData.pjg.harga,
            pjg: skidBoxRegulerData.pjg.pjg_dimensi,
            lbr: skidBoxRegulerData.pjg.lbr_dimensi,
            tgi: skidBoxRegulerData.pjg.tbl_dimensi,
            m2: skidBoxRegulerData.pjg.m2,
            qty: skidBoxRegulerData.pjg.qty,
            harga_finished: skidBoxRegulerData.pjg.harga,
            total: skidBoxRegulerData.pjg.total,
            from_master: false,
            is_skid: true,
            skid_type: 'box_reguler_pjg'
        });
        
        skidDataToSave.push({
            material_code: 'SKID-REGULER-LBR',
            nama: 'SKID PLYWOOD POPLAR LBR',
            pricing_type: 'm2',
            harga_asli: skidBoxRegulerData.lbr.harga,
            pjg: skidBoxRegulerData.lbr.pjg_dimensi,
            lbr: skidBoxRegulerData.lbr.lbr_dimensi,
            tgi: skidBoxRegulerData.lbr.tbl_dimensi,
            m2: skidBoxRegulerData.lbr.m2,
            qty: skidBoxRegulerData.lbr.qty,
            harga_finished: skidBoxRegulerData.lbr.harga,
            total: skidBoxRegulerData.lbr.total,
            from_master: false,
            is_skid: true,
            skid_type: 'box_reguler_lbr'
        });
    }
    
    if (skidBoxTumbuData.enabled) {
        skidDataToSave.push({
            material_code: 'SKID-TUMBU-PJG',
            nama: 'SKID PLYWOOD POPLAR PJG',
            pricing_type: 'm2',
            harga_asli: skidBoxTumbuData.pjg.harga,
            pjg: skidBoxTumbuData.pjg.pjg_dimensi,
            lbr: skidBoxTumbuData.pjg.lbr_dimensi,
            tgi: skidBoxTumbuData.pjg.tbl_dimensi,
            m2: skidBoxTumbuData.pjg.m2,
            qty: skidBoxTumbuData.pjg.qty,
            harga_finished: skidBoxTumbuData.pjg.harga,
            total: skidBoxTumbuData.pjg.total,
            from_master: false,
            is_skid: true,
            skid_type: 'box_tumbu_pjg'
        });
        
        skidDataToSave.push({
            material_code: 'SKID-TUMBU-LBR',
            nama: 'SKID PLYWOOD POPLAR LBR',
            pricing_type: 'm2',
            harga_asli: skidBoxTumbuData.lbr.harga,
            pjg: skidBoxTumbuData.lbr.pjg_dimensi,
            lbr: skidBoxTumbuData.lbr.lbr_dimensi,
            tgi: skidBoxTumbuData.lbr.tbl_dimensi,
            m2: skidBoxTumbuData.lbr.m2,
            qty: skidBoxTumbuData.lbr.qty,
            harga_finished: skidBoxTumbuData.lbr.harga,
            total: skidBoxTumbuData.lbr.total,
            from_master: false,
            is_skid: true,
            skid_type: 'box_tumbu_lbr'
        });
    }
    
    // ✅ MERGE SKID DATA WITH KOMPONEN PENDUKUNG
    const allKomponenPendukung = [...komponenPendukungItems, ...skidDataToSave];
    
    const boxDataToSave = {
        components: Object.values(componentsData),
        komponen_pendukung: allKomponenPendukung,
        penunjang: penunjangData.enabled ? penunjangData : null,
        pallet: palletData.enabled ? palletData : null,
        grand_total: parseFloat(document.getElementById('grand_total').value)
    };
    
    console.log('============================================');
    console.log('📤 Submitting Update Box Data');
    console.log('============================================');
    console.log('Components:', boxDataToSave.components.length);
    console.log('Komponen Pendukung (Regular):', komponenPendukungItems.length);
    console.log('SKID Data:', skidDataToSave.length);
    console.log('Penunjang:', penunjangData);
    console.log('Pallet:', palletData);
    console.log('Grand Total:', boxDataToSave.grand_total);
    console.log('============================================');
    
    const invoiceBoxId = document.getElementById('invoice_box_id').value;
    const invoiceBomId = document.getElementById('invoice_bom_id').value;
    const p = parseFloat(document.getElementById('p_value').value);
    const l = parseFloat(document.getElementById('l_value').value);
    const t = parseFloat(document.getElementById('t_value').value);
    
    document.getElementById('loadingOverlay').style.display = 'flex';
    
    fetch(`/invoice/box/${invoiceBoxId}`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '{{ csrf_token() }}',
            'Accept': 'application/json'
        },
        body: JSON.stringify({
            _method: 'PUT',
            invoice_bom_id: invoiceBomId,
            p: p,
            l: l,
            t: t,
            box_data: JSON.stringify(boxDataToSave),
            grand_total: boxDataToSave.grand_total
        })
    })
    .then(response => {
        if (!response.ok) {
            return response.json().then(err => {
                throw new Error(err.message || 'Update failed');
            });
        }
        return response.json();
    })
    .then(data => {
        console.log('✅ Server Response:', data);
        
        if (data.success) {
            alert('✅ Invoice Box berhasil diupdate!');
            window.location.href = `/invoice/box/${invoiceBoxId}`;
        } else {
            throw new Error(data.message || 'Failed to update invoice box');
        }
    })
    .catch(error => {
        console.error('❌ Error:', error);
        alert('❌ Terjadi kesalahan: ' + error.message);
    })
    .finally(() => {
        document.getElementById('loadingOverlay').style.display = 'none';
    });
}

console.log('============================================');
console.log('✅ Part 8 Loaded: Load Existing Data + Update Submit');
console.log('============================================');
console.log('🎉 EDIT.BLADE.PHP FULLY LOADED - ALL 8 PARTS COMPLETE!');
console.log('============================================');
</script>
@endpush
