<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>HPP Print - {{ $invoice->product_code }}</title>
    <style>
        @page {
            size: A4 landscape;
            margin: 8mm;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: Arial, sans-serif;
            font-size: 9px;
            line-height: 1.2;
            padding: 10px;
        }
        
        .no-print {
            margin-bottom: 10px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .no-print .left-section {
            display: flex;
            gap: 10px;
            align-items: center;
        }
        
        .no-print .right-section {
            display: flex;
            gap: 5px;
        }
        
        .no-print button {
            padding: 8px 16px;
            cursor: pointer;
            border: none;
            border-radius: 5px;
            font-weight: bold;
            font-size: 12px;
        }
        
        .no-print select {
            padding: 8px 12px;
            border: 2px solid #667eea;
            border-radius: 5px;
            font-weight: bold;
            font-size: 12px;
            background: white;
            cursor: pointer;
        }
        
        .no-print label {
            font-weight: bold;
            font-size: 12px;
        }
        
        .btn-print {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
        }
        
        .btn-close {
            background: #e74c3c;
            color: white;
        }
        
        h3 {
            text-align: center;
            margin-bottom: 8px;
            font-size: 13px;
            font-weight: bold;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
        }
        
        th, td {
            border: 1px solid #000;
            padding: 4px;
            text-align: center;
            vertical-align: middle;
        }
        
        th {
            background-color: #f0f0f0;
            font-weight: bold;
            font-size: 8px;
        }
        
        td {
            font-size: 8px;
            background-color: #fff;
        }
        
        .text-left {
            text-align: left;
        }
        
        .text-right {
            text-align: right;
        }
        
        /* ✅ PRICE WRAPPER - SEJAJAR RP/$ DENGAN ANGKA */
        .price-wrapper {
            display: flex;
            justify-content: flex-end;
            align-items: center;
            gap: 4px;
        }
        
        .currency-symbol {
            font-weight: normal;
        }
        
        /* ✅ WARNA HEADER CUSTOM */
        .bg-sky-blue {
            background-color: #87CEEB !important; /* Sky Blue */
            font-weight: bold;
            -webkit-print-color-adjust: exact !important;
            print-color-adjust: exact !important;
            color-adjust: exact !important;
        }
        
        .bg-pink {
            background-color: #FFB6C1 !important; /* Light Pink */
            font-weight: bold;
            -webkit-print-color-adjust: exact !important;
            print-color-adjust: exact !important;
            color-adjust: exact !important;
        }
        
        .bg-lavender {
    background-color: #D8BFD8 !important; /* Thistle - ungu muda soft seperti gambar */
    font-weight: bold;
    -webkit-print-color-adjust: exact !important;
    print-color-adjust: exact !important;
    color-adjust: exact !important;
}
        
        .bg-yellow {
            background-color: #FFFF00 !important;
            font-weight: bold;
            -webkit-print-color-adjust: exact !important;
            print-color-adjust: exact !important;
            color-adjust: exact !important;
        }
        
        .bg-orange {
            background-color: #FFD700 !important;
            font-weight: bold;
            -webkit-print-color-adjust: exact !important;
            print-color-adjust: exact !important;
            color-adjust: exact !important;
        }
        
        .bg-blue {
            background-color: #ADD8E6 !important;
            font-weight: bold;
            -webkit-print-color-adjust: exact !important;
            print-color-adjust: exact !important;
            color-adjust: exact !important;
        }
        
        .bg-green {
            background-color: #90EE90 !important;
            font-weight: bold;
            -webkit-print-color-adjust: exact !important;
            print-color-adjust: exact !important;
            color-adjust: exact !important;
        }
        
        .product-image {
            max-width: 80px;
            max-height: 80px;
            object-fit: contain;
        }
        
        /* Column widths */
        .col-no { width: 30px; }
        .col-image { width: 90px; }
        .col-dimensi { width: 70px; }
        .col-kode { width: 60px; }
        .col-item { width: 100px; }
        .col-jenis { width: 60px; }
        .col-veneer { width: 60px; }
        .col-price { width: 75px; }
        
        @media print {
            .no-print {
                display: none;
            }
            
            body {
                padding: 0;
            }
            
            /* ✅ FORCE BACKGROUND COLORS IN PRINT */
            * {
                -webkit-print-color-adjust: exact !important;
                print-color-adjust: exact !important;
                color-adjust: exact !important;
            }
            
            table {
                page-break-inside: avoid;
            }
            
            th, td {
                page-break-inside: avoid;
            }
        }
    </style>
</head>
<body>
    <!-- Print Button & Exchange Rate Selector -->
    <div class="no-print">
        <div class="left-section">
            <label for="exchangeRate">Kurs USD:</label>
            <select id="exchangeRate" onchange="updateExchangeRate()">
                <option value="13500" selected>Rp 13.500</option>
                <option value="14000">Rp 14.000</option>
                <option value="14500">Rp 14.500</option>
                <option value="15000">Rp 15.000</option>
                <option value="15500">Rp 15.500</option>
                <option value="16000">Rp 16.000</option>
                <option value="16500">Rp 16.500</option>
            </select>
        </div>
        <div class="right-section">
            <button class="btn-print" onclick="window.print()">
                🖨️ Print HPP
            </button>
            <button class="btn-close" onclick="window.close()">
                ❌ Close
            </button>
        </div>
    </div>

    <!-- Header -->
    <h3>
        HPP PRODUCT {{ strtoupper($invoice->product_category) }} - {{ strtoupper($invoice->product_name) }}
    </h3>
    
    @php
        // ============================================
        // ✅ RECALCULATE HPP WITH CORRECTED FORMULAS
        // ============================================
        
        // GET BIAYA PRODUKSI (M³) dan M³ Total
        $biayaProduksi = $invoice->biaya_produksi ?? 0;
        $totalM3 = $invoice->total_m3 ?? 0;
        $hargaPerM3 = $invoice->harga_per_m3 ?? 6000000;
        
        // ✅ HPP UNFINISHED BASE (tanpa Material Painting & Biaya Produksi Painting)
        $hppUnfinishedBase = 0;
        $hppUnfinishedBase += $hppData['material_wood_panel'] ?? 0;
        $hppUnfinishedBase += $hppData['hardware'] ?? 0;
        $hppUnfinishedBase += $hppData['fitting'] ?? 0;
        $hppUnfinishedBase += $hppData['handle'] ?? 0;
        $hppUnfinishedBase += $hppData['stone'] ?? 0;
        $hppUnfinishedBase += $hppData['metal'] ?? 0;
        $hppUnfinishedBase += $hppData['ukir_bubut'] ?? 0;
        $hppUnfinishedBase += $hppData['box'] ?? 0;
        $hppUnfinishedBase += $biayaProduksi; // ✅ Biaya Produksi M³
        
        // ✅ TOTAL HPP UNFINISHED = Base × 1.12
        $totalHppUnfinished = $hppUnfinishedBase * 1.12;
        
        // ✅ HPP FINISHED BASE = HPP Unfinished Base + Material Painting + Biaya Produksi Painting
        $hppFinishedBase = $hppUnfinishedBase;
        $hppFinishedBase += $hppData['material_painting'] ?? 0;
        $hppFinishedBase += $hppData['biaya_produksi_painting'] ?? 0;
        
        // ✅ TOTAL HPP FINISHED = (HPP Finished Base × 1.12) + Biaya Produksi Packing
        $totalHppFinished = ($hppFinishedBase * 1.12) + ($hppData['biaya_produksi_packing'] ?? 0);
        
        // ============================================
        // COUNT FILLED COLUMNS (EXCLUDE YANG KOSONG)
        // ============================================
        
        // HPP UNFINISHED COLUMNS
        $unfinishedColumnsCount = 0;
        $unfinishedColumns = [];
        
        // ✅ M³ Column (Display Only - PALING KIRI, ALWAYS SHOW if M³ > 0)
        if ($totalM3 > 0) {
            $unfinishedColumns[] = 'm3_display';
            $unfinishedColumnsCount++;
        }
        
        if (($hppData['material_wood_panel'] ?? 0) > 0) {
            $unfinishedColumns[] = 'material_wood_panel';
            $unfinishedColumnsCount++;
        }
        if (($hppData['hardware'] ?? 0) > 0) {
            $unfinishedColumns[] = 'hardware';
            $unfinishedColumnsCount++;
        }
        if (($hppData['fitting'] ?? 0) > 0) {
            $unfinishedColumns[] = 'fitting';
            $unfinishedColumnsCount++;
        }
        if (($hppData['handle'] ?? 0) > 0) {
            $unfinishedColumns[] = 'handle';
            $unfinishedColumnsCount++;
        }
        if (($hppData['stone'] ?? 0) > 0) {
            $unfinishedColumns[] = 'stone';
            $unfinishedColumnsCount++;
        }
        if (($hppData['metal'] ?? 0) > 0) {
            $unfinishedColumns[] = 'metal';
            $unfinishedColumnsCount++;
        }
        if (($hppData['ukir_bubut'] ?? 0) > 0) {
            $unfinishedColumns[] = 'ukir_bubut';
            $unfinishedColumnsCount++;
        }
        if (($hppData['box'] ?? 0) > 0) {
            $unfinishedColumns[] = 'box';
            $unfinishedColumnsCount++;
        }
        
        // ✅ Biaya Produksi (M³) Column (PALING KANAN, ALWAYS SHOW if > 0)
        if ($biayaProduksi > 0) {
            $unfinishedColumns[] = 'biaya_produksi_m3';
            $unfinishedColumnsCount++;
        }
        
        // ============================================
        // HPP INCLUDE FINISHING COLUMNS (3 KOLOM)
        // ============================================
        $finishedColumnsCount = 0;
        $finishedColumns = [];
        
        if (($hppData['material_painting'] ?? 0) > 0) {
            $finishedColumns[] = 'material_painting';
            $finishedColumnsCount++;
        }
        
        if (($hppData['biaya_produksi_painting'] ?? 0) > 0) {
            $finishedColumns[] = 'biaya_produksi_painting';
            $finishedColumnsCount++;
        }
        
        if (($hppData['biaya_produksi_packing'] ?? 0) > 0) {
            $finishedColumns[] = 'biaya_produksi_packing';
            $finishedColumnsCount++;
        }
        
        // Exchange Rate (Default)
        $exchangeRateDefault = 13500;
    @endphp
    
    <!-- HPP Table -->
    <table>
        <thead>
            <!-- HEADER ROW 1 -->
            <tr>
                <th rowspan="3" class="col-no bg-sky-blue">No.</th>
                <th rowspan="3" class="col-image bg-sky-blue">Image</th>
                <th rowspan="3" class="col-dimensi bg-sky-blue">Dimensi<br>(mm)</th>
                <th rowspan="3" class="col-kode bg-sky-blue">Kode</th>
                <th rowspan="3" class="col-item bg-sky-blue">Item</th>
                <th rowspan="3" class="col-jenis bg-sky-blue">Jenis<br>Kayu</th>
                <th rowspan="3" class="col-veneer bg-sky-blue">Veneer</th>
                
                @if($unfinishedColumnsCount > 0)
    <th colspan="{{ $unfinishedColumnsCount + 2 }}" class="bg-pink">HPP UNFINISHED</th>
@endif
                
                @if($finishedColumnsCount > 0)
    <th colspan="{{ $finishedColumnsCount + 2 }}" class="bg-lavender">HPP Include Finishing</th>
@endif
            </tr>
            
            <!-- HEADER ROW 2 -->
            <tr>
                <!-- HPP UNFINISHED COLUMNS -->
                
                <!-- ✅ M³ Display Column - PALING KIRI -->
                @if(in_array('m3_display', $unfinishedColumns))
                    <th rowspan="2" class="col-price bg-sky-blue">M³<br>(Component)</th>
                @endif
                
                @if(in_array('material_wood_panel', $unfinishedColumns))
                    <th rowspan="2" class="col-price bg-sky-blue">Total Material<br>Wood & Panel</th>
                @endif
                @if(in_array('hardware', $unfinishedColumns))
                    <th rowspan="2" class="col-price bg-sky-blue">Hardware</th>
                @endif
                @if(in_array('fitting', $unfinishedColumns))
                    <th rowspan="2" class="col-price bg-sky-blue">Fitting</th>
                @endif
                @if(in_array('handle', $unfinishedColumns))
                    <th rowspan="2" class="col-price bg-sky-blue">Handle</th>
                @endif
                @if(in_array('stone', $unfinishedColumns))
                    <th rowspan="2" class="col-price bg-sky-blue">Stone</th>
                @endif
                @if(in_array('metal', $unfinishedColumns))
                    <th rowspan="2" class="col-price bg-sky-blue">Metal</th>
                @endif
                @if(in_array('ukir_bubut', $unfinishedColumns))
                    <th rowspan="2" class="col-price bg-sky-blue">Ukir/Bubut</th>
                @endif
                @if(in_array('box', $unfinishedColumns))
                    <th rowspan="2" class="col-price bg-sky-blue">Box Packing</th>
                @endif
                
                <!-- ✅ Biaya Produksi (M³) Column - PALING KANAN -->
                @if(in_array('biaya_produksi_m3', $unfinishedColumns))
                    <th rowspan="2" class="col-price bg-sky-blue">Biaya Produksi<br>(M³)</th>
                @endif
                
                @if($unfinishedColumnsCount > 0)
                    <th colspan="2" class="bg-pink">TOTAL HPP UNFINISHED<br><small style="font-size: 6px;"></small></th>
                @endif
                
                <!-- HPP INCLUDE FINISHING COLUMNS -->
                @if(in_array('material_painting', $finishedColumns))
                    <th rowspan="2" class="col-price bg-sky-blue">Material<br>Painting</th>
                @endif
                @if(in_array('biaya_produksi_painting', $finishedColumns))
                    <th rowspan="2" class="col-price bg-sky-blue">Biaya Produksi<br>Painting</th>
                @endif
                @if(in_array('biaya_produksi_packing', $finishedColumns))
                    <th rowspan="2" class="col-price bg-sky-blue">Biaya Produksi<br>Packing</th>
                @endif
                
                @if($finishedColumnsCount > 0)
                    <th colspan="2" class="bg-lavender">TOTAL HPP FINISHED<br><small style="font-size: 6px;"></small></th>
                @endif
            </tr>
            
            <!-- HEADER ROW 3 (Currency) -->
            <tr>
                @if($unfinishedColumnsCount > 0)
                    <th style="width: 50px;" class="bg-pink">Rp</th>
                    <th style="width: 50px;" class="bg-pink">$</th>
                @endif
                
                @if($finishedColumnsCount > 0)
                    <th style="width: 50px;" class="bg-lavender">Rp</th>
                    <th style="width: 50px;" class="bg-lavender">$</th>
                @endif
            </tr>
        </thead>
        <tbody>
            <tr>
                <td>1</td>
                <td>
                    @if($invoice->image_path)
                        <img src="{{ asset($invoice->image_path) }}" alt="Product" class="product-image">
                    @else
                        <div style="width: 80px; height: 80px; border: 1px solid #ccc; display: flex; align-items: center; justify-content: center; background: #f5f5f5; margin: 0 auto;">
                            <span style="color: #999; font-size: 7px;">No Image</span>
                        </div>
                    @endif
                </td>
                <td>{{ $invoice->size }}</td>
                <td>{{ $invoice->product_code }}</td>
                <td class="text-left">{{ $invoice->product_type }}</td>
                <td>{{ $invoice->panel_type }}</td>
                <td>{{ $invoice->veneer_face_type }}</td>
                
                <!-- ============================================ -->
                <!-- HPP UNFINISHED DATA COLUMNS -->
                <!-- ============================================ -->
                
                <!-- ✅ M³ Display Column (Display Only) - PALING KIRI -->
                @if(in_array('m3_display', $unfinishedColumns))
                    <td class="text-right" style="background-color: #f0f0f0;">
                        {{ number_format($totalM3, 6) }}
                    </td>
                @endif
                
                @if(in_array('material_wood_panel', $unfinishedColumns))
                    <td>
                        <div class="price-wrapper">
                            <span class="currency-symbol">Rp</span>
                            <span>{{ number_format($hppData['material_wood_panel'], 0, ',', '.') }}</span>
                        </div>
                    </td>
                @endif
                
                @if(in_array('hardware', $unfinishedColumns))
                    <td>
                        <div class="price-wrapper">
                            <span class="currency-symbol">Rp</span>
                            <span>{{ number_format($hppData['hardware'], 0, ',', '.') }}</span>
                        </div>
                    </td>
                @endif
                
                @if(in_array('fitting', $unfinishedColumns))
                    <td>
                        <div class="price-wrapper">
                            <span class="currency-symbol">Rp</span>
                            <span>{{ number_format($hppData['fitting'], 0, ',', '.') }}</span>
                        </div>
                    </td>
                @endif
                
                @if(in_array('handle', $unfinishedColumns))
                    <td>
                        <div class="price-wrapper">
                            <span class="currency-symbol">Rp</span>
                            <span>{{ number_format($hppData['handle'], 0, ',', '.') }}</span>
                        </div>
                    </td>
                @endif
                
                @if(in_array('stone', $unfinishedColumns))
                    <td>
                        <div class="price-wrapper">
                            <span class="currency-symbol">Rp</span>
                            <span>{{ number_format($hppData['stone'], 0, ',', '.') }}</span>
                        </div>
                    </td>
                @endif
                
                @if(in_array('metal', $unfinishedColumns))
                    <td>
                        <div class="price-wrapper">
                            <span class="currency-symbol">Rp</span>
                            <span>{{ number_format($hppData['metal'], 0, ',', '.') }}</span>
                        </div>
                    </td>
                @endif
                
                @if(in_array('ukir_bubut', $unfinishedColumns))
                    <td>
                        <div class="price-wrapper">
                            <span class="currency-symbol">Rp</span>
                            <span>{{ number_format($hppData['ukir_bubut'], 0, ',', '.') }}</span>
                        </div>
                    </td>
                @endif
                
                <!-- ✅ BOX PACKING WITH DETAILED BREAKDOWN (UPDATED WITH SKID) -->
                @if(in_array('box', $unfinishedColumns))
                    <td>
                        <div class="price-wrapper">
                            <span class="currency-symbol">Rp</span>
                            <span>{{ number_format($hppData['box'], 0, ',', '.') }}</span>
                        </div>
                        @if($hppData['box'] > 0)
                            <small style="font-size: 6px; color: #666; display: block; text-align: right; margin-top: 2px;">
                                @php
                                    $boxData = json_decode($invoiceBox->box_data ?? '{}', true);
                                    $breakdown = [];
                                    
                                    // ✅ COMPONENTS
                                    if (!empty($boxData['components'])) {
                                        $compTotal = array_sum(array_column($boxData['components'], 'harga'));
                                        if ($compTotal > 0) {
                                            $breakdown[] = 'Components: Rp ' . number_format($compTotal, 0, ',', '.');
                                        }
                                    }
                                    
                                    // ✅ KOMPONEN PENDUKUNG (Separate Regular & SKID)
                                    if (!empty($boxData['komponen_pendukung'])) {
                                        $regularKP = [];
                                        $skidItems = [];
                                        
                                        foreach ($boxData['komponen_pendukung'] as $item) {
                                            if (isset($item['is_skid']) && $item['is_skid'] === true) {
                                                $skidItems[] = $item;
                                            } else {
                                                $regularKP[] = $item;
                                            }
                                        }
                                        
                                        // Regular KP
                                        if (!empty($regularKP)) {
                                            $kpTotal = array_sum(array_column($regularKP, 'total'));
                                            if ($kpTotal > 0) {
                                                $breakdown[] = 'KP: Rp ' . number_format($kpTotal, 0, ',', '.');
                                            }
                                        }
                                        
                                        // ✅ SKID (NEW - Separated from KP)
                                        if (!empty($skidItems)) {
                                            $skidTotal = array_sum(array_column($skidItems, 'total'));
                                            if ($skidTotal > 0) {
                                                $breakdown[] = 'SKID: Rp ' . number_format($skidTotal, 0, ',', '.');
                                            }
                                        }
                                    }
                                    
                                    // ✅ PENUNJANG
                                    if (!empty($boxData['penunjang']['enabled'])) {
                                        $penunjangTotal = $boxData['penunjang']['total'] ?? 0;
                                        if ($penunjangTotal > 0) {
                                            $breakdown[] = 'Penunjang: Rp ' . number_format($penunjangTotal, 0, ',', '.');
                                        }
                                    }
                                    
                                    // ✅ PALLET
                                    if (!empty($boxData['pallet']['enabled'])) {
                                        $palletTotal = $boxData['pallet']['total'] ?? 0;
                                        if ($palletTotal > 0) {
                                            $breakdown[] = 'Pallet: Rp ' . number_format($palletTotal, 0, ',', '.');
                                        }
                                    }
                                    
                                    echo implode('<br>', $breakdown);
                                @endphp
                            </small>
                        @endif
                    </td>
                @endif
                
                <!-- ✅ Biaya Produksi (M³) Column - PALING KANAN -->
                @if(in_array('biaya_produksi_m3', $unfinishedColumns))
                    <td>
                        <div class="price-wrapper">
                            <span class="currency-symbol">Rp</span>
                            <span>{{ number_format($biayaProduksi, 0, ',', '.') }}</span>
                        </div>
                    </td>
                @endif
                
                @if($unfinishedColumnsCount > 0)
                    <!-- ✅ TOTAL HPP UNFINISHED - Rp (BASE + 12%) -->
                    <td class="bg-pink" id="total-unfinished-rp">
                    <div class="price-wrapper" style="font-weight: bold;">
                            <span class="currency-symbol" style="font-weight: bold;">Rp</span>
                            <span>{{ number_format($totalHppUnfinished, 0, ',', '.') }}</span>
                        </div>
                    </td>
                    
                    <!-- ✅ TOTAL HPP UNFINISHED - $ (USD) -->
                    <td class="bg-pink" id="total-unfinished-usd" data-value="{{ $totalHppUnfinished }}">
                        <div class="price-wrapper">
                            <span class="currency-symbol" style="font-weight: bold;">$</span>
                            <span>
                                @php
                                    $totalUnfinishedUSD = $totalHppUnfinished / $exchangeRateDefault;
                                @endphp
                                {{ number_format($totalUnfinishedUSD, 2, '.', ',') }}
                            </span>
                        </div>
                    </td>
                @endif
                
                <!-- ============================================ -->
                <!-- HPP INCLUDE FINISHING DATA COLUMNS -->
                <!-- ============================================ -->
                @if(in_array('material_painting', $finishedColumns))
                    <td>
                        <div class="price-wrapper">
                            <span class="currency-symbol">Rp</span>
                            <span>{{ number_format($hppData['material_painting'], 0, ',', '.') }}</span>
                        </div>
                    </td>
                @endif
                
                @if(in_array('biaya_produksi_painting', $finishedColumns))
                    <td>
                        <div class="price-wrapper">
                            <span class="currency-symbol">Rp</span>
                            <span>{{ number_format($hppData['biaya_produksi_painting'], 0, ',', '.') }}</span>
                        </div>
                    </td>
                @endif
                
                @if(in_array('biaya_produksi_packing', $finishedColumns))
                    <td>
                        <div class="price-wrapper">
                            <span class="currency-symbol">Rp</span>
                            <span>{{ number_format($hppData['biaya_produksi_packing'], 0, ',', '.') }}</span>
                        </div>
                    </td>
                @endif
                
                @if($finishedColumnsCount > 0)
                    <!-- ✅ TOTAL HPP FINISHED - Rp -->
                    <td class="bg-lavender" id="total-finished-rp">
                        <div class="price-wrapper" style="font-weight: bold;">
                            <span class="currency-symbol" style="font-weight: bold;">Rp</span>
                            <span>{{ number_format($totalHppFinished, 0, ',', '.') }}</span>
                        </div>
                    </td>
                    
                    <!-- ✅ TOTAL HPP FINISHED - $ (USD) -->
                    <td class="bg-lavender" id="total-finished-usd" data-value="{{ $totalHppFinished }}">
                        <div class="price-wrapper">
                            <span class="currency-symbol" style="font-weight: bold;">$</span>
                            <span>
                                @php
                                    $totalFinishedUSD = $totalHppFinished / $exchangeRateDefault;
                                @endphp
                                {{ number_format($totalFinishedUSD, 2, '.', ',') }}
                            </span>
                        </div>
                    </td>
                @endif
            </tr>
        </tbody>
    </table>

    <script>
        // ============================================
        // UPDATE EXCHANGE RATE DYNAMICALLY
        // ============================================
        
        function updateExchangeRate() {
            const exchangeRate = parseFloat(document.getElementById('exchangeRate').value);
            
            // Get IDR values
            const totalUnfinishedRp = parseFloat(document.getElementById('total-unfinished-usd').dataset.value);
            const totalFinishedRp = parseFloat(document.getElementById('total-finished-usd').dataset.value);
            
            // Calculate USD
            const totalUnfinishedUSD = totalUnfinishedRp / exchangeRate;
            const totalFinishedUSD = totalFinishedRp / exchangeRate;
            
            // Update display - hanya angkanya saja (span kedua dalam price-wrapper)
            document.getElementById('total-unfinished-usd').querySelector('span:last-child').textContent = 
                totalUnfinishedUSD.toLocaleString('en-US', {
                    minimumFractionDigits: 2,
                    maximumFractionDigits: 2
                });
            
            document.getElementById('total-finished-usd').querySelector('span:last-child').textContent = 
                totalFinishedUSD.toLocaleString('en-US', {
                    minimumFractionDigits: 2,
                    maximumFractionDigits: 2
                });
            
            console.log('Exchange Rate Updated:', exchangeRate);
            console.log('Total Unfinished USD:', totalUnfinishedUSD);
            console.log('Total Finished USD:', totalFinishedUSD);
        }
        
        // ============================================
        // PAGE LOAD
        // ============================================
        
        document.addEventListener('DOMContentLoaded', function() {
            console.log('============================================');
            console.log('HPP Print Page Loaded');
            console.log('============================================');
            console.log('Invoice ID:', {{ $invoice->id }});
            console.log('Product Code:', '{{ $invoice->product_code }}');
            console.log('');
            console.log('--- HPP UNFINISHED ---');
            console.log('M³ Total:', {{ $totalM3 }});
            console.log('Total Material Wood & Panel:', {{ $hppData['material_wood_panel'] ?? 0 }});
            console.log('Hardware Total:', {{ $hppData['hardware'] ?? 0 }});
            console.log('Fitting Total:', {{ $hppData['fitting'] ?? 0 }});
            console.log('Handle Total:', {{ $hppData['handle'] ?? 0 }});
            console.log('Stone Total:', {{ $hppData['stone'] ?? 0 }});
            console.log('Metal Total:', {{ $hppData['metal'] ?? 0 }});
            console.log('Ukir/Bubut Total:', {{ $hppData['ukir_bubut'] ?? 0 }});
            console.log('Box Packing Total:', {{ $hppData['box'] ?? 0 }});
            console.log('Biaya Produksi (M³):', {{ $biayaProduksi }});
            console.log('HPP Unfinished Base:', {{ $hppUnfinishedBase }});
            console.log('Total HPP Unfinished (Base × 1.12):', {{ $totalHppUnfinished }});
            console.log('');
            console.log('--- HPP INCLUDE FINISHING ---');
            console.log('Material Painting:', {{ $hppData['material_painting'] ?? 0 }});
            console.log('Biaya Produksi Painting:', {{ $hppData['biaya_produksi_painting'] ?? 0 }});
            console.log('Biaya Produksi Packing:', {{ $hppData['biaya_produksi_packing'] ?? 0 }});
            console.log('HPP Finished Base:', {{ $hppFinishedBase }});
            console.log('Total HPP Finished ((Base × 1.12) + BP.Packing):', {{ $totalHppFinished }});
            console.log('============================================');
            console.log('');
            console.log('✅ FORMULA:');
            console.log('HPP Unfinished = (Wood+Hardware+...+Box+BP.M³) × 1.12');
            console.log('HPP Finished = (Wood+Hardware+...+Box+BP.M³+Mat.Paint+BP.Paint) × 1.12 + BP.Packing');
            console.log('============================================');
            console.log('');
            console.log('📦 BOX PACKING BREAKDOWN:');
            
            @php
                $boxData = json_decode($invoiceBox->box_data ?? '{}', true);
                
                if (!empty($boxData['components'])) {
                    $compTotal = array_sum(array_column($boxData['components'], 'harga'));
                    echo "console.log('  Components: Rp " . number_format($compTotal, 0, ',', '.') . "');";
                }
                
                if (!empty($boxData['komponen_pendukung'])) {
                    $regularKP = [];
                    $skidItems = [];
                    
                    foreach ($boxData['komponen_pendukung'] as $item) {
                        if (isset($item['is_skid']) && $item['is_skid'] === true) {
                            $skidItems[] = $item;
                        } else {
                            $regularKP[] = $item;
                        }
                    }
                    
                    if (!empty($regularKP)) {
                        $kpTotal = array_sum(array_column($regularKP, 'total'));
                        echo "console.log('  KP (Regular): Rp " . number_format($kpTotal, 0, ',', '.') . "');";
                    }
                    
                    if (!empty($skidItems)) {
                        $skidTotal = array_sum(array_column($skidItems, 'total'));
                        echo "console.log('  SKID: Rp " . number_format($skidTotal, 0, ',', '.') . "');";
                    }
                }
                
                if (!empty($boxData['penunjang']['enabled'])) {
                    echo "console.log('  Penunjang: Rp " . number_format($boxData['penunjang']['total'], 0, ',', '.') . "');";
                }
                
                if (!empty($boxData['pallet']['enabled'])) {
                    echo "console.log('  Pallet: Rp " . number_format($boxData['pallet']['total'], 0, ',', '.') . "');";
                }
            @endphp
            
            console.log('============================================');
        });
    </script>
</body>
</html>