<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('product_pendukung_boxes', function (Blueprint $table) {
            $table->id();
            $table->string('material_code')->unique();
            $table->text('description');
            
            // Pilihan: PCS atau M2
            $table->enum('pricing_type', ['pcs', 'm2'])->default('pcs');
            
            // Harga Asli (wajib)
            $table->decimal('harga_asli', 15, 2);
            
            // Dimensi (optional untuk PCS, wajib untuk M2)
            $table->decimal('lebar', 10, 2)->nullable();
            $table->decimal('panjang', 10, 2)->nullable();
            $table->decimal('m2', 10, 6)->nullable();
            
            // Harga M2 (hanya untuk pricing_type = m2)
            $table->decimal('harga_m2', 15, 2)->nullable();
            
            // Harga Finished
            $table->decimal('harga_finished', 15, 2);
            
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('product_pendukung_boxes');
    }
};