<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('invoice_hardware', function (Blueprint $table) {
            $table->id();
            $table->foreignId('invoice_bom_id')->constrained('invoice_boms')->onDelete('cascade');
            $table->json('hardware_data'); // JSON structure with groups
            $table->decimal('grand_total', 15, 2);
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('invoice_hardware');
    }
};