<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('fitting', function (Blueprint $table) {
            $table->id();
            $table->string('material_code')->nullable(); // RHSSLR00046 (some don't have code)
            $table->string('fitting_type'); // FITTING RAIL, FITTING HINGE, FITTING RUBBER, etc.
            $table->string('material_description'); // RAIL TNDM 561H2601B TA L FULL EXT 260
            $table->decimal('price', 15, 2); // Harga per unit
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('fitting');
    }
};